
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/MetaBalls/SceneMetaBalls');
require('./assets/MetaBalls/Shader/MetaBalls/MetaBallsAssembler');
require('./assets/MetaBalls/Shader/MetaBalls/MetaBallsRenderer');
require('./assets/Shader/GTAssembler2D');
require('./assets/Shader/GTAutoFitSpriteAssembler2D');
require('./assets/Shader/GTSimpleSpriteAssembler2D');
require('./assets/TypeScript2/PhysicsPolygonColliderEx');
require('./assets/TypeScript2/test4');
require('./assets/extend/extend1/polybool');
require('./assets/script/PhysicsCollider');
require('./assets/script/render');
require('./assets/script/test');
require('./assets/script/test2');
require('./assets/script/water');
require('./assets/script/waterCube');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Shader/GTAssembler2D.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '2177f2mlZhMmaFQsJ/uSd17', 'GTAssembler2D');
// shader/GTAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-13 02:44:17
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:43
*/
// 自定义渲染
// https://docs.cocos.com/creator/manual/zh/advanced-topics/custom-render.html#%E8%87%AA%E5%AE%9A%E4%B9%89-assembler
var GTAssembler2D = /** @class */ (function (_super) {
    __extends(GTAssembler2D, _super);
    function GTAssembler2D() {
        // 每个2d渲染单元里的有:
        // 4个顶点属性数据
        // 6个顶点索引 -> 三角剖分成2个三角形
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 每个顶点属性由5个32位数据组成
        // 顶点属性声明:
        // var vfmtPosUvColor = new gfx.VertexFormat([
        //     { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },       // 4个uint8
        // ]);
        // 顶点属性数据排列，每一格是32位 (float32/uint32)
        // x|y|u|v|color|x|y|u|v|color|...
        // 其中uv在一组数据中的偏移是2，color的偏移是4
        _this.verticesCount = 4;
        _this.indicesCount = 6;
        _this.floatsPerVert = 5;
        // vdata offset info
        _this.uvOffset = 2;
        _this.colorOffset = 4;
        _this._renderData = null;
        _this._local = null; // 中间结果。[l,b,r,t]。node对象左下、右上顶点的本地坐标，即相对于锚点的偏移
        return _this;
    }
    GTAssembler2D.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        // cc.Assembler2D的初始化放在constructor里
        // 此处把初始化放在init里，以便成员变量能够有机会修改
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
        this.initLocal();
        this.initData();
    };
    Object.defineProperty(GTAssembler2D.prototype, "verticesFloats", {
        get: function () {
            return this.verticesCount * this.floatsPerVert;
        },
        enumerable: false,
        configurable: true
    });
    GTAssembler2D.prototype.initData = function () {
        var data = this._renderData;
        data.createQuadData(0, this.verticesFloats, this.indicesCount);
        // createQuadData内部会调用initQuadIndices初始化索引信息
        // 如果是用用flexbuffer创建则需要自己初始化
    };
    GTAssembler2D.prototype.initLocal = function () {
        this._local = [];
        this._local.length = 4;
    };
    GTAssembler2D.prototype.updateColor = function (comp, color) {
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的color部分
        var uintVerts = this._renderData.uintVDatas[0];
        if (!uintVerts)
            return;
        color = color != null ? color : comp.node.color._val;
        var floatsPerVert = this.floatsPerVert;
        var colorOffset = this.colorOffset;
        for (var i = colorOffset, l = uintVerts.length; i < l; i += floatsPerVert) {
            uintVerts[i] = color;
        }
    };
    GTAssembler2D.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle._meshBuffer;
    };
    GTAssembler2D.prototype.updateWorldVerts = function (comp) {
        if (CC_NATIVERENDERER) {
            this.updateWorldVertsNative(comp);
        }
        else {
            this.updateWorldVertsWebGL(comp);
        }
    };
    GTAssembler2D.prototype.updateWorldVertsWebGL = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var matrix = comp.node._worldMatrix;
        var matrixm = matrix.m, a = matrixm[0], b = matrixm[1], c = matrixm[4], d = matrixm[5], tx = matrixm[12], ty = matrixm[13];
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        /*
        m00 = 1, m01 = 0, m02 = 0, m03 = 0,
        m04 = 0, m05 = 1, m06 = 0, m07 = 0,
        m08 = 0, m09 = 0, m10 = 1, m11 = 0,
        m12 = 0, m13 = 0, m14 = 0, m15 = 1
        */
        // [a,b,c,d] = _worldMatrix[1,2,4,5] == [1,0,0,1]
        // _worldMatrix[12,13]是xy的平移量
        // 即世界矩阵的左上角2x2是单元矩阵，说明在2D场景内没有出现旋转或者缩放
        var justTranslate = a === 1 && b === 0 && c === 0 && d === 1;
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的xy部分
        var index = 0;
        var floatsPerVert = this.floatsPerVert;
        if (justTranslate) {
            // left bottom
            verts[index] = vl + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = vr + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // left top
            verts[index] = vl + tx;
            verts[index + 1] = vt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = vr + tx;
            verts[index + 1] = vt + ty;
        }
        else {
            // 4对xy分别乘以 [2,2]仿射矩阵，然后+平移量
            var al = a * vl, ar = a * vr, bl = b * vl, br = b * vr, cb = c * vb, ct = c * vt, db = d * vb, dt = d * vt;
            // left bottom
            // newx = vl * a + vb * c + tx
            // newy = vl * b + vb * d + ty
            verts[index] = al + cb + tx;
            verts[index + 1] = bl + db + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = ar + cb + tx;
            verts[index + 1] = br + db + ty;
            index += floatsPerVert;
            // left top
            verts[index] = al + ct + tx;
            verts[index + 1] = bl + dt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = ar + ct + tx;
            verts[index + 1] = br + dt + ty;
        }
    };
    // native场景下使用的updateWorldVerts
    // copy from \jsb-adapter-master\engine\assemblers\assembler-2d.js
    GTAssembler2D.prototype.updateWorldVertsNative = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var floatsPerVert = this.floatsPerVert;
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        var index = 0;
        // left bottom
        verts[index] = vl;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // right bottom
        verts[index] = vr;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // left top
        verts[index] = vl;
        verts[index + 1] = vt;
        index += floatsPerVert;
        // right top
        verts[index] = vr;
        verts[index + 1] = vt;
    };
    // 将准备好的顶点数据填充进 VertexBuffer 和 IndiceBuffer
    GTAssembler2D.prototype.fillBuffers = function (comp, renderer) {
        if (renderer.worldMatDirty) {
            this.updateWorldVerts(comp);
        }
        var renderData = this._renderData;
        var vData = renderData.vDatas[0];
        var iData = renderData.iDatas[0];
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(this.verticesCount, this.indicesCount);
        // buffer data may be realloc, need get reference after request.
        // fill vertices
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        if (vData.length + vertexOffset > vbuf.length) {
            vbuf.set(vData.subarray(0, vbuf.length - vertexOffset), vertexOffset);
        }
        else {
            vbuf.set(vData, vertexOffset);
        }
        // fill indices
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0, l = iData.length; i < l; i++) {
            ibuf[indiceOffset++] = vertexId + iData[i];
        }
    };
    GTAssembler2D.prototype.packToDynamicAtlas = function (comp, frame) {
        if (CC_TEST)
            return;
        if (!frame._original && cc.dynamicAtlasManager && frame._texture.packable) {
            var packedFrame = cc.dynamicAtlasManager.insertSpriteFrame(frame);
            //@ts-ignore
            if (packedFrame) {
                frame._setDynamicAtlasFrame(packedFrame);
            }
        }
        var material = comp._materials[0];
        if (!material)
            return;
        if (material.getProperty('texture') !== frame._texture) {
            // texture was packed to dynamic atlas, should update uvs
            comp._vertsDirty = true;
            comp._updateMaterial();
        }
    };
    GTAssembler2D.prototype.updateUVs = function (comp) {
        // 4个顶点的uv坐标，对应左下、右下、左上、右上
        // 如果是cc.Sprite组件，这里取sprite._spriteFrame.uv;
        var uv = [0, 0, 1, 0, 0, 1, 1, 1];
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的uv部分
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    GTAssembler2D.prototype.updateVerts = function (comp) {
        var node = comp.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        l = -appx;
        b = -appy;
        r = cw - appx;
        t = ch - appy;
        var local = this._local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(comp);
    };
    GTAssembler2D.prototype.updateRenderData = function (comp) {
        if (comp._vertsDirty) {
            this.updateUVs(comp);
            this.updateVerts(comp);
            comp._vertsDirty = false;
        }
    };
    return GTAssembler2D;
}(cc.Assembler));
exports.default = GTAssembler2D;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/TypeScript2/PhysicsPolygonColliderEx.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0e7bcbZcTlDpq0EVxPZXBR0', 'PhysicsPolygonColliderEx');
// TypeScript2/PhysicsPolygonColliderEx.ts

Object.defineProperty(exports, "__esModule", { value: true });
var THICK = 100;
var gfx = cc['gfx'];
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu, requireComponent = _a.requireComponent;
var PhysicsPolygonColliderEx = /** @class */ (function (_super) {
    __extends(PhysicsPolygonColliderEx, _super);
    function PhysicsPolygonColliderEx() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.meshRenderer = null;
        _this._polys = [];
        _this._physicsPolygonColliders = [];
        _this._commands = [];
        return _this;
    }
    Object.defineProperty(PhysicsPolygonColliderEx.prototype, "polys", {
        get: function () {
            var _this = this;
            return this._polys.map(function (v) { return _this._convertClipperPathToVecArray(v); });
        },
        enumerable: false,
        configurable: true
    });
    PhysicsPolygonColliderEx.prototype.init = function (polys) {
        var _this = this;
        this._polys = polys.map(function (v) { return _this._convertVecArrayToClipperPath(v); });
        this._commands = [];
    };
    PhysicsPolygonColliderEx.prototype.pushCommand = function (name, params) {
        this._commands.push({ name: name, params: params });
    };
    PhysicsPolygonColliderEx.prototype.polyDifference = function (poly, ctx) {
        // if (poly.length < 3) return;
        var _this = this;
        // 计算新的多边形
        var cpr = new ClipperLib.Clipper(ClipperLib.Clipper.ioStrictlySimple); //ClipperLib.Clipper.ioStrictlySimple | ClipperLib.Clipper.ioPreserveCollinear
        // cpr.PreserveCollinear = true;
        var subj_paths = this._polys;
        var clip_paths = [this._convertVecArrayToClipperPath(poly)];
        cpr.AddPaths(subj_paths, ClipperLib.PolyType.ptSubject, true);
        cpr.AddPaths(clip_paths, ClipperLib.PolyType.ptClip, true);
        var subject_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var clip_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var solution_polytree = new ClipperLib.PolyTree();
        cpr.Execute(ClipperLib.ClipType.ctDifference, solution_polytree, subject_fillType, clip_fillType);
        var solution_expolygons = ClipperLib.JS.PolyTreeToExPolygons(solution_polytree);
        this._polys = ClipperLib.Clipper.PolyTreeToPaths(solution_polytree);
        // cc.log(solution_expolygons);
        // 将多边形分割成三角形 并绘制出来
        ctx && ctx.clear(true);
        var _physicsPolygonColliders_count = 0;
        var _loop_1 = function (expolygon) {
            // const outers = ClipperLib.Clipper.SimplifyPolygon(expolygon.outer,ClipperLib.PolyFillType.pftEvenOdd);
            // cc.log(outer,"outer",expolygon.outer)
            var countor = this_1._convertClipperPathToPoly2triPoint(expolygon.outer);
            if (countor.length < 2)
                return "continue";
            var swctx = new poly2tri.SweepContext(countor, { cloneArrays: true });
            // const exclude = countor;
            var holes = expolygon.holes.map(function (h) { return _this._convertClipperPathToPoly2triPoint(h, countor); });
            try {
                // 防止 addhole 失败 使用try
                swctx.addHoles(holes);
                swctx.triangulate();
                var triangles = swctx.getTriangles();
                // cc.log('triangles', triangles);
                for (var _i = 0, triangles_1 = triangles; _i < triangles_1.length; _i++) {
                    var tri = triangles_1[_i];
                    // 逐一处理三角形
                    var c = this_1._physicsPolygonColliders[_physicsPolygonColliders_count];
                    if (!c) {
                        c = this_1.addComponent(cc.PhysicsPolygonCollider);
                        c.friction = 0;
                        c.restitution = 0;
                        this_1._physicsPolygonColliders[_physicsPolygonColliders_count] = c;
                    }
                    c.points = tri.getPoints().map(function (v, i) {
                        if (ctx) {
                            if (i === 0)
                                ctx.moveTo(v.x, v.y);
                            else
                                ctx.lineTo(v.x, v.y);
                        }
                        return cc.v2(v.x, v.y);
                    });
                    c.apply();
                    _physicsPolygonColliders_count++;
                    if (ctx) {
                        ctx.close();
                        ctx.fill();
                    }
                }
            }
            catch (e) {
                console.error('polyDifference poly2tri error', _physicsPolygonColliders_count, expolygon);
                console.error(e);
                return "continue";
            }
        };
        var this_1 = this;
        for (var _i = 0, solution_expolygons_1 = solution_expolygons; _i < solution_expolygons_1.length; _i++) {
            var expolygon = solution_expolygons_1[_i];
            _loop_1(expolygon);
        }
        this._physicsPolygonColliders.slice(_physicsPolygonColliders_count).forEach((function (v) {
            if (v.points.length) {
                v.points.length = 0;
                v.apply();
            }
        }));
        // 绘制底层 mesh
        var arr2 = this._polys.map(function (v) { return _this._convertClipperPathToVecArray(v); });
        var poly_tri_arr = [];
        var c_count = arr2.length;
        for (var k = 0; k < c_count; k++) {
            var tmpArr = arr2[k];
            var tmpArr2 = [];
            for (var k2 = 0; k2 < tmpArr.length; k2++) {
                var aa = tmpArr[k2];
                tmpArr2.push([aa.x, aa.y]);
            }
            poly_tri_arr.push(tmpArr2);
        }
        this.addMesh(poly_tri_arr);
    };
    PhysicsPolygonColliderEx.prototype.addMesh = function (tri) {
        var allPoints = [];
        var indexArr = [];
        var uvIndexArr = [];
        var uvType = 0;
        var uvupTypeArr = [cc.v2(0, 0), cc.v2(0, 1), cc.v2(1, 0), cc.v2(1, 1)];
        var uvDownTypeArr = [cc.v2(1, 1), cc.v2(0, 0), cc.v2(0, 1), cc.v2(1, 0)];
        var colorIndex = [];
        // console.log("****2this._regions.length:"+tri.length);
        for (var i = 0; i < tri.length; i++) {
            var singleParr = [].concat(tri[i]);
            indexArr[i] = [];
            var length = singleParr.length;
            for (var j = 0; j < length; j++) {
                if (singleParr[j]) {
                    allPoints.push(cc.v3(singleParr[j][0], singleParr[j][1], 0));
                    indexArr[i].push(allPoints.length - 1);
                    uvIndexArr.push(uvupTypeArr[uvType]);
                    uvType = uvType >= 3 ? 0 : uvType + 1;
                    colorIndex.push(cc.Color.WHITE);
                }
            }
        }
        uvType = 0;
        var iLength = allPoints.length;
        for (var i = 0; i < iLength; i++) {
            allPoints[i + iLength] = cc.v3(allPoints[i].x, allPoints[i].y, -THICK);
            uvIndexArr.push(uvDownTypeArr[uvType]);
            uvType = uvType >= 3 ? 0 : uvType + 1;
            colorIndex.push(cc.Color.WHITE);
        }
        var vfmtPosColor = new gfx.VertexFormat([
            { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 3 },
            { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
            { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
        ]);
        var mesh = new cc.Mesh();
        mesh.init(vfmtPosColor, allPoints.length, true);
        this.meshRenderer.mesh = mesh;
        mesh.setVertices(gfx.ATTR_POSITION, allPoints);
        mesh.setVertices(gfx.ATTR_COLOR, colorIndex);
        mesh.setVertices(gfx.ATTR_UV0, uvIndexArr);
        var indices = this.conmuteIndices(indexArr, iLength);
        mesh.setIndices(indices);
    };
    PhysicsPolygonColliderEx.prototype.conmuteIndices = function (indexArr, length) {
        var indicesarr = [];
        for (var i = 0; i < indexArr.length; i++) {
            var arr = indexArr[i];
            for (var j = 0; j < arr.length; j++) {
                var p1 = void 0, p2 = void 0, p3 = void 0, p4 = void 0;
                if (j < arr.length - 1) {
                    p1 = arr[j];
                    p2 = arr[j + 1];
                    p3 = arr[j] + length;
                    p4 = arr[j + 1] + length;
                }
                else {
                    p1 = arr[j];
                    p2 = arr[0];
                    p3 = arr[j] + length;
                    p4 = arr[0] + length;
                }
                indicesarr.push(p1, p2, p4, p3, p4, p1);
            }
        }
        return indicesarr;
    };
    PhysicsPolygonColliderEx.prototype.lateUpdate = function (dt) {
        if (this._commands.length) {
            // 每帧执行命令队列
            for (var index = 0; index < Math.ceil(this._commands.length / 2 + 0.5); index++) {
                var cmd = this._commands.shift();
                if (cmd)
                    this[cmd.name].apply(this, cmd.params);
                else
                    break;
            }
        }
    };
    PhysicsPolygonColliderEx.prototype._convertVecArrayToClipperPath = function (poly) {
        return poly.map(function (p) { return { X: p.x, Y: p.y }; });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToVecArray = function (poly) {
        return poly.map(function (p) { return cc.v2(p.X, p.Y); });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToPoly2triPoint = function (poly, exclude) {
        if (exclude === void 0) { exclude = []; }
        // return poly.map((p) => { return new poly2tri.Point(p.X, p.Y) });
        var newPos = [];
        poly.forEach(function (p, i) {
            var p_now = new poly2tri.Point(p.X, p.Y);
            var isIn = exclude.some(function (e_p) {
                if (e_p.equals(p_now)) {
                    return true;
                }
            });
            if (!isIn) {
                newPos.push(p_now);
                exclude.push(p_now);
            }
        });
        if (newPos.length > 2)
            return newPos;
        else
            return [];
    };
    __decorate([
        property(cc.MeshRenderer)
    ], PhysicsPolygonColliderEx.prototype, "meshRenderer", void 0);
    PhysicsPolygonColliderEx = __decorate([
        ccclass,
        menu("i18n:MAIN_MENU.component.physics/Collider/PolygonEX-lamyoung.com"),
        requireComponent(cc.RigidBody)
    ], PhysicsPolygonColliderEx);
    return PhysicsPolygonColliderEx;
}(cc.Component));
exports.default = PhysicsPolygonColliderEx;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/SceneMetaBalls.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b17b60sLRdNO7vhwJqbQ+NX', 'SceneMetaBalls');
// MetaBalls/SceneMetaBalls.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-13 02:44:16
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:01:57
*/
var MetaBallsRenderer_1 = require("./Shader/MetaBalls/MetaBallsRenderer");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var SceneMetaBalls = /** @class */ (function (_super) {
    __extends(SceneMetaBalls, _super);
    function SceneMetaBalls() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.waterRendererCamera = null;
        _this.waterRenderer = null;
        _this.waterRendererPass2 = null;
        _this.metaBallsRenderer = null;
        _this.particleBox = null;
        _this._world = null;
        _this._particles = null;
        _this._particleGroup = null;
        return _this;
    }
    SceneMetaBalls.prototype.onLoad = function () {
        //如果不是用编辑器打开项目
        if (!CC_EDITOR) {
            this.SetupWorld();
        }
        //渲染一张与水通道大小相同的图片
        var texture = new cc.RenderTexture();
        var size = this.waterRendererPass2.node.getContentSize();
        texture.initWithSize(size.width, size.height);
        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        //同简单摄像水渲染
        this.waterRendererCamera.targetTexture = texture;
        this.waterRendererPass2.spriteFrame = spriteFrame;
    };
    SceneMetaBalls.prototype.SetupWorld = function () {
        // enable physics manager
        var physicsManager = cc.director.getPhysicsManager();
        physicsManager.enabled = true;
        var world = this._world = physicsManager._world; // new b2.World(new b2.Vec2(0, -15.0));
        //粒子设置
        var psd = new b2.ParticleSystemDef();
        //半径
        psd.radius = 0.35;
        //阻尼
        // psd.dampingStrength = 1.5;
        //粘性力
        psd.viscousStrength = 0;
        //创建box2d粒子系统
        this._particles = world.CreateParticleSystem(psd);
    };
    SceneMetaBalls.prototype.CreateParticlesGroup = function () {
        //单位转换
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        //获得需要创建粒子盒子的的大小与位置
        var boxSize = this.particleBox.getContentSize();
        var boxPos = this.particleBox.getPosition();
        var size = cc.winSize;
        var box = new b2.PolygonShape();
        // https://google.github.io/liquidfun/API-Ref/html/classb2_polygon_shape.html#a890690250115483da6c7d69829be087e
        // Build vertices to represent an oriented box.
        // box的大小影响粒子的数量
        //设置一盒子粒子
        box.SetAsBox(boxSize.width / 2 / PTM_RATIO, boxSize.height / 2 / PTM_RATIO);
        //创建粒子组
        var particleGroupDef = new b2.ParticleGroupDef();
        particleGroupDef.shape = box;
        //选择流体粒子
        particleGroupDef.flags = b2.waterParticle;
        //设置位置
        particleGroupDef.position.Set((boxPos.x + size.width / 2) / PTM_RATIO, (boxPos.y + size.height / 2) / PTM_RATIO);
        //用粒子系统创建粒子组
        this._particleGroup = this._particles.CreateParticleGroup(particleGroupDef);
        //调用metaBallRenderer的方法设置渲染粒子组
        this.metaBallsRenderer.SetParticles(this._particles);
        //调用获得粒子组数量方法并将结果输出
        var vertsCount = this._particles.GetParticleCount();
        console.log(vertsCount);
    };
    //产生水
    SceneMetaBalls.prototype.GenerateWater = function () {
        //重置水
        this.ResetParticleGroup();
        // re-create particles in next tick
        // otherwise old particle system is not correctly released
        // this is a non-repeat schedule
        var that = this;
        cc.director.getScheduler().schedule(function () {
            that.CreateParticlesGroup();
        }, this.node, 0, 0, 0, false);
    };
    SceneMetaBalls.prototype.ResetParticleGroup = function () {
        if (this._particleGroup != null) {
            this._particleGroup.DestroyParticles(false);
            this._particles.DestroyParticleGroup(this._particleGroup);
            this._particleGroup = null;
        }
    };
    __decorate([
        property(cc.Camera)
    ], SceneMetaBalls.prototype, "waterRendererCamera", void 0);
    __decorate([
        property(cc.Node)
    ], SceneMetaBalls.prototype, "waterRenderer", void 0);
    __decorate([
        property(cc.Sprite)
    ], SceneMetaBalls.prototype, "waterRendererPass2", void 0);
    __decorate([
        property(MetaBallsRenderer_1.default)
    ], SceneMetaBalls.prototype, "metaBallsRenderer", void 0);
    __decorate([
        property(cc.Node)
    ], SceneMetaBalls.prototype, "particleBox", void 0);
    SceneMetaBalls = __decorate([
        ccclass
    ], SceneMetaBalls);
    return SceneMetaBalls;
}(cc.Component));
exports.default = SceneMetaBalls;
//???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????
var enableLowLevelOptimize = true;
if (enableLowLevelOptimize) {
    cc.game.once(cc.game.EVENT_ENGINE_INITED, function () {
        // b2ParticleSystem.prototype.FindContacts_Reference = function (contacts) {
        //@ts-ignore
        b2.ParticleSystem.prototype.FindContacts_Reference = function (contacts) {
            if (!this.m_flagsBuffer.data) {
                throw new Error();
            }
            if (!this.m_positionBuffer.data) {
                throw new Error();
            }
            var pos_data = this.m_positionBuffer.data;
            var squaredDiameter = this.m_squaredDiameter;
            var inverseDiameter = this.m_inverseDiameter;
            // DEBUG: b2Assert(contacts === this.m_contactBuffer);
            var beginProxy = 0;
            var endProxy = this.m_proxyBuffer.count;
            this.m_contactBuffer.count = 0;
            // let contactBuffer = this.m_contactBuffer;
            var proxyData = this.m_proxyBuffer.data;
            //@ts-ignore
            var computeRelativeTag = b2.ParticleSystem.computeRelativeTag;
            // var AddContact = this.AddContact2.bind(this);
            var dataA;
            var tagA = 0;
            var indexA = 0;
            var rightTag = 0;
            var dataB;
            var pos_data = this.m_positionBuffer.data;
            var flagBufferData = this.m_flagsBuffer.data;
            var flagBufferDataA;
            var indexB = 0;
            var pos_dataA;
            var pos_dataB;
            var ax = 0, ay = 0, bx = 0, by = 0, dx = 0, dy = 0;
            var distBtParticlesSq = 0;
            var bottomLeftTag = 0;
            var bottomRightTag = 0;
            var isFin = isFinite;
            for (var a = beginProxy, c = beginProxy; a < endProxy; ++a) {
                dataA = proxyData[a];
                tagA = dataA.tag;
                indexA = dataA.index;
                pos_dataA = pos_data[indexA];
                flagBufferDataA = flagBufferData[indexA];
                rightTag = computeRelativeTag(tagA, 1, 0);
                for (var b = a + 1; b < endProxy; ++b) {
                    dataB = proxyData[b];
                    if (rightTag < dataB.tag) {
                        break;
                    }
                    // ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                    indexB = dataB.index;
                    // pos_dataA = pos_data[indexA];
                    pos_dataB = pos_data[indexB];
                    // DEBUG: b2Assert(contacts === this.m_contactBuffer);
                    ///b2Vec2 d = m_positionBuffer.data[b] - m_positionBuffer.data[a];
                    bx = pos_dataB.x;
                    by = pos_dataB.y;
                    ax = pos_dataA.x;
                    ay = pos_dataA.y;
                    dx = bx - ax;
                    dy = by - ay;
                    // var d = b2.Vec2.SubVV(pos_data[b], pos_data[a], s_d);
                    distBtParticlesSq = dx * dx + dy * dy;
                    // var distBtParticlesSq = b2.Vec2.DotVV(d, d);
                    if (distBtParticlesSq < squaredDiameter) {
                        var invD = 1 / Math.sqrt(distBtParticlesSq);
                        // var invD = b2.InvSqrt(distBtParticlesSq);
                        if (!isFin(invD)) {
                            invD = 1.98177537e+019;
                        }
                        ///b2ParticleContact& contact = contacts.Append();
                        var contact = this.m_contactBuffer.data[this.m_contactBuffer.Append()];
                        contact.indexA = indexA;
                        contact.indexB = indexB;
                        contact.flags = flagBufferDataA | flagBufferData[indexB];
                        contact.weight = 1 - distBtParticlesSq * invD * inverseDiameter;
                        ///contact.SetNormal(invD * d);
                        contact.normal.x = invD * dx;
                        contact.normal.y = invD * dy;
                        // b2.Vec2.MulSV(invD, d, contact.normal);
                    }
                    // end ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                }
                bottomLeftTag = computeRelativeTag(tagA, -1, 1);
                for (; c < endProxy; ++c) {
                    if (bottomLeftTag <= proxyData[c].tag) {
                        break;
                    }
                }
                bottomRightTag = computeRelativeTag(tagA, 1, 1);
                for (var b = c; b < endProxy; ++b) {
                    dataB = proxyData[b];
                    if (bottomRightTag < dataB.tag) {
                        break;
                    }
                    // ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                    indexB = dataB.index;
                    // pos_dataA = pos_data[indexA];
                    pos_dataB = pos_data[indexB];
                    // DEBUG: b2Assert(contacts === this.m_contactBuffer);
                    ///b2Vec2 d = m_positionBuffer.data[b] - m_positionBuffer.data[a];
                    bx = pos_dataB.x;
                    by = pos_dataB.y;
                    ax = pos_dataA.x;
                    ay = pos_dataA.y;
                    dx = bx - ax;
                    dy = by - ay;
                    // var d = b2.Vec2.SubVV(pos_data[b], pos_data[a], s_d);
                    distBtParticlesSq = dx * dx + dy * dy;
                    // var distBtParticlesSq = b2.Vec2.DotVV(d, d);
                    if (distBtParticlesSq < squaredDiameter) {
                        var invD = 1 / Math.sqrt(distBtParticlesSq);
                        // var invD = b2.InvSqrt(distBtParticlesSq);
                        if (!isFin(invD)) {
                            invD = 1.98177537e+019;
                        }
                        ///b2ParticleContact& contact = contacts.Append();
                        var contact = this.m_contactBuffer.data[this.m_contactBuffer.Append()];
                        contact.indexA = indexA;
                        contact.indexB = indexB;
                        contact.flags = flagBufferDataA | flagBufferData[indexB];
                        contact.weight = 1 - distBtParticlesSq * invD * inverseDiameter;
                        ///contact.SetNormal(invD * d);
                        contact.normal.x = invD * dx;
                        contact.normal.y = invD * dy;
                        // b2.Vec2.MulSV(invD, d, contact.normal);
                    }
                    // end ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                }
            }
        };
    });
}

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Shader/GTSimpleSpriteAssembler2D.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'a3292KgyPBJ4alKmQMtfFjM', 'GTSimpleSpriteAssembler2D');
// shader/GTSimpleSpriteAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-21 16:23:10
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:52
*/
var GTAssembler2D_1 = require("./GTAssembler2D");
var GTSimpleSpriteAssembler2D = /** @class */ (function (_super) {
    __extends(GTSimpleSpriteAssembler2D, _super);
    function GTSimpleSpriteAssembler2D() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // 这部分使用SimpleSpriteAssembler的内容
    GTSimpleSpriteAssembler2D.prototype.updateRenderData = function (sprite) {
        this.packToDynamicAtlas(sprite, sprite._spriteFrame);
        _super.prototype.updateRenderData.call(this, sprite);
    };
    GTSimpleSpriteAssembler2D.prototype.updateUVs = function (sprite) {
        var uv = sprite._spriteFrame.uv;
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    GTSimpleSpriteAssembler2D.prototype.updateVerts = function (sprite) {
        var node = sprite.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        if (sprite.trim) {
            l = -appx;
            b = -appy;
            r = cw - appx;
            t = ch - appy;
        }
        else {
            var frame = sprite.spriteFrame, ow = frame._originalSize.width, oh = frame._originalSize.height, rw = frame._rect.width, rh = frame._rect.height, offset = frame._offset, scaleX = cw / ow, scaleY = ch / oh;
            var trimLeft = offset.x + (ow - rw) / 2;
            var trimRight = offset.x - (ow - rw) / 2;
            var trimBottom = offset.y + (oh - rh) / 2;
            var trimTop = offset.y - (oh - rh) / 2;
            l = trimLeft * scaleX - appx;
            b = trimBottom * scaleY - appy;
            r = cw + trimRight * scaleX - appx;
            t = ch + trimTop * scaleY - appy;
        }
        var local = this._local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(sprite);
    };
    return GTSimpleSpriteAssembler2D;
}(GTAssembler2D_1.default));
exports.default = GTSimpleSpriteAssembler2D;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/test.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b966cllGNNEA7loFRhDfuaQ', 'test');
// script/test.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    water: cc.Prefab,
    waterLayer: cc.Node,
    ground: cc.Node,
    graphics: cc.Graphics
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this.DIG_RADIUS = 50;
    this.DIG_FRAGMENT = 12; //

    this.DIG_OPTIMIZE_SIZE = 1; //

    cc.macro.ENABLE_MULTI_TOUCH = false;
    var manager = cc.director.getPhysicsManager();
    manager.enabled = true; // cc.director.getPhysicsManager().debugDrawFlags = true;

    manager.enabledAccumulator = true;
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
    manager.VELOCITY_ITERATIONS = 8;
    manager.POSITION_ITERATIONS = 8; //

    for (var index = 0; index < 100; index++) {
      c = this.ground.addComponent(cc.PhysicsChainCollider);
      c.loop = true;
      c.enabled = false;
    } // this.node.on("touchstart", this.creatWater, this);

  },
  start: function start() {
    //
    this.ground.on(cc.Node.EventType.TOUCH_START, this._touchMove, this);
    this.ground.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this); //

    this.reset(); //

    this.schedule(this.creatWater, 0.5);
  },
  _optimizePoint: function _optimizePoint(point) {
    return [Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE];
  },
  _optimizeRegions: function _optimizeRegions() {
    var _this = this;

    var regions = [];

    var _loop = function _loop(index) {
      var pos = _this._regions[index];
      var newPos = [];
      pos.forEach(function (p, i) {
        p = _this._optimizePoint(p);

        var p_pre = _this._optimizePoint(pos[(i - 1 + pos.length) % pos.length]);

        var p_next = _this._optimizePoint(pos[(i + 1) % pos.length]);

        var vec1 = cc.v2(p[0] - p_pre[0], p[1] - p_pre[1]);
        var vec2 = cc.v2(p_next[0] - p[0], p_next[1] - p[1]);

        if (vec1.lengthSqr() != 0 && vec2.lengthSqr() != 0 && vec1.cross(vec2) != 0) {
          newPos.push(p);
        }
      });

      if (newPos.length > 2) {
        regions.push(newPos);
      }
    };

    for (var index = 0; index < this._regions.length; index++) {
      _loop(index);
    }

    this._regions = regions;
  },
  reset: function reset() {
    this._regions = [[[-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]]];
    this.draw();
  },
  draw: function draw() {
    var _this2 = this;

    var chains = this.ground.getComponents(cc.PhysicsChainCollider);
    chains.forEach(function (c) {
      c.enabled = false;
    });
    var enabled_chains_points = [[]];

    for (var index = 0; index < this._regions.length; index++) {
      var pos = this._regions[index];
      var poly = chains[index];

      if (!poly) {
        poly = this.ground.addComponent(cc.PhysicsChainCollider);
        poly.loop = true;
      }

      poly.points.length = 0;
      poly.points = pos.map(function (v, i) {
        var v2 = cc.v2(v[0], v[1]);
        return v2;
      });
      poly.enabled = true;
      enabled_chains_points[index] = poly.points;
    } //


    this.graphics.clear(true);
    var enabled_chains_points_sort = enabled_chains_points.map(function (curPoly, curPoly_i) {
      var count = enabled_chains_points.reduce(function (pre, nextPoly, nextPoly_i) {
        if (curPoly_i != nextPoly_i) {
          var length = curPoly.length;

          for (var i = 0; i < length; ++i) {
            var p0 = curPoly[i];
            if (!cc.Intersection.pointInPolygon(p0, nextPoly)) return pre;
          }

          return pre + 1;
        }

        return pre;
      }, 0);
      return {
        curPoly: curPoly,
        count: count
      };
    }).sort(function (a, b) {
      return a.count - b.count;
    });
    enabled_chains_points_sort.forEach(function (_ref) {
      var curPoly = _ref.curPoly,
          count = _ref.count;
      _this2.graphics.fillColor = count % 2 === 0 ? cc.Color.ORANGE : cc.Color.BLACK;

      _this2._drawPoly(_this2.graphics, curPoly);

      _this2.graphics.fill();
    });
  },
  _touchMove: function _touchMove(touch) {
    // let regions = [[]];
    // let pos = this.ground.convertToNodeSpaceAR(touch.getLocation());
    // let count = this.DIG_FRAGMENT;
    // for (let index = 0; index < count; index++) {
    //     let r = 2 * Math.PI * index / count;
    //     let x = pos.x + this.DIG_RADIUS * Math.cos(r);
    //     let y = pos.y + this.DIG_RADIUS * Math.sin(r);
    //     regions[0].push([x, y]);
    // }
    var regions = [[]];
    var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
    var delta = touch.getDelta();
    var count = this.DIG_FRAGMENT;

    if (delta.lengthSqr() < 5) {
      for (var index = 0; index < count; index++) {
        var r = 2 * Math.PI * index / count;
        var x = pos.x + this.DIG_RADIUS * Math.cos(r);
        var y = pos.y + this.DIG_RADIUS * Math.sin(r);
        regions[0].push(this._optimizePoint([x, y]));
      }
    } else {
      var startPos = pos.sub(delta);

      for (var _index = 0; _index < count; _index++) {
        var _r = 2 * Math.PI * _index / count;

        var vec_x = this.DIG_RADIUS * Math.cos(_r);
        var vec_y = this.DIG_RADIUS * Math.sin(_r);

        var _x = void 0,
            _y = void 0;

        if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
          _x = pos.x + vec_x;
          _y = pos.y + vec_y;
        } else {
          _x = startPos.x + vec_x;
          _y = startPos.y + vec_y;
        }

        regions[0].push(this._optimizePoint([_x, _y]));
      }
    } // let result = PolyBool.difference({
    //     regions: this._regions,
    //     inverted: false
    // }, {
    //     regions,
    //     inverted: false
    // });


    var seg1 = PolyBool.segments({
      regions: this._regions,
      inverted: false
    });
    var seg2 = PolyBool.segments({
      regions: regions,
      inverted: false
    });
    var comb = PolyBool.combine(seg1, seg2);
    var result = PolyBool.polygon(PolyBool.selectDifference(comb)); //

    this._regions = result.regions;

    this._optimizeRegions();

    this.draw();
  },
  _drawPoly: function _drawPoly(ctx, poly) {
    poly.forEach(function (pos, i) {
      if (i === 0) ctx.moveTo(pos.x, pos.y);else ctx.lineTo(pos.x, pos.y);
      ctx.close();
    });
  },
  creatWater: function creatWater() {
    var waterNum = 1;

    for (var i = 0; i < waterNum; i++) {
      var waterPre = cc.instantiate(this.water);
      waterPre.x = 0;
      waterPre.y = cc.winSize.height;
      this.waterLayer.addChild(waterPre);
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/Shader/MetaBalls/MetaBallsAssembler.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '2de294hRf5H146xfV0OKHOA', 'MetaBallsAssembler');
// MetaBalls/Shader/MetaBalls/MetaBallsAssembler.ts

/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-ignore
var gfx = cc.gfx;
var vfmtPosCenterWeb = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var vfmtPosCenterNative = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_corner", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var MetaBallsAssembler = /** @class */ (function (_super) {
    __extends(MetaBallsAssembler, _super);
    function MetaBallsAssembler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.verticesCount = 0;
        _this.indicesCount = 0;
        _this.floatsPerVert = CC_NATIVERENDERER ? 6 : 4;
        _this._renderData = null;
        _this._prevVerticesCount = 0;
        return _this;
    }
    MetaBallsAssembler.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
    };
    // initData() {
    //     // do nothing
    // }
    MetaBallsAssembler.prototype.updateColor = function (comp, color) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateUVs = function (comp) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateVerts = function (comp) {
        if (!CC_NATIVERENDERER) {
            // web模式直接在fillbuffer里做所有操作，不经过RenderData缓存
            return;
        }
        var particles = this.particles;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        var particleCount = this.particles.GetParticleCount();
        var verts = this._renderData.vDatas[0];
        var xoffset = comp.node.width * comp.node.anchorX;
        var yoffset = comp.node.height * comp.node.anchorY;
        // fill vertices
        // 暂时不考虑buffer满的情况
        var vertexOffset = 0;
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO - xoffset;
            var y = posBuff[i].y * PTM_RATIO - yoffset;
            // left-bottom
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-bottom
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // left-top
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-top
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
        }
    };
    MetaBallsAssembler.prototype.updateRenderData = function (comp) {
        var _a;
        if (!CC_NATIVERENDERER) {
            return;
        }
        var particleCount = (_a = this.particles) === null || _a === void 0 ? void 0 : _a.GetParticleCount();
        if (!particleCount)
            return;
        if (this._prevVerticesCount != particleCount) {
            this._prevVerticesCount = particleCount;
            // rebuild render data
            this.verticesCount = particleCount * 4;
            this.indicesCount = particleCount * 6;
            var data = this._renderData;
            data.createFlexData(0, this.verticesCount, this.indicesCount, this.getVfmt());
            var indices = data.iDatas[0];
            var count = indices.length / 6;
            for (var i = 0, idx = 0; i < count; i++) {
                var vertextID = i * 4;
                indices[idx++] = vertextID;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 2;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 3;
                indices[idx++] = vertextID + 2;
            }
        }
        if (comp._vertsDirty) {
            this.updateVerts(comp);
            comp._vertsDirty = false;
        }
    };
    MetaBallsAssembler.prototype.getVfmt = function () {
        if (CC_NATIVERENDERER)
            return vfmtPosCenterNative;
        return vfmtPosCenterWeb;
    };
    MetaBallsAssembler.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
    };
    MetaBallsAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (CC_NATIVERENDERER) {
            // 仅对web实现
            // native由于fillBuffer实现在了C++层，需要使用RenderData做缓存
            return;
        }
        var particles = this.particles;
        var particleCount = particles === null || particles === void 0 ? void 0 : particles.GetParticleCount();
        if (!particleCount)
            return;
        // TODO: 简化为按照三角形渲染
        var verticesCount = particleCount * 4;
        var indicesCount = particleCount * 6;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        //@ts-ignore
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(verticesCount, indicesCount);
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        // fill vertices
        // 暂时不考虑buffer满的情况
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO;
            var y = posBuff[i].y * PTM_RATIO;
            // left-bottom
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-bottom
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // left-top
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-top
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
        }
        // 仅当顶点索引发生变化时计算? 
        // vertexOffset是动态的，每一帧都有可能有差异，无法批量拷贝
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0; i < particleCount; ++i) {
            ibuf[indiceOffset++] = vertexId;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 2;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 3;
            ibuf[indiceOffset++] = vertexId + 2;
            vertexId += 4;
        }
    };
    return MetaBallsAssembler;
}(cc.Assembler));
exports.default = MetaBallsAssembler;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/test2.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '44caf0qqERN1Ko2SyGE8G5z', 'test2');
// script/test2.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    water: cc.Prefab,
    waterLayer: cc.Node,
    ground: cc.Node
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this._touchStartPos = cc.Vec2;
    this.polyEx = this.ground.getComponent("PhysicsCollider"); //

    this.DIG_RADIUS = 50;
    this.DIG_FRAGMENT = 12; //

    this.DIG_OPTIMIZE_SIZE = 1; //
    //调节物理系统

    cc.macro.ENABLE_MULTI_TOUCH = false;
    var manager = cc.director.getPhysicsManager();
    manager.enabled = true;
    cc.director.getPhysicsManager().debugDrawFlags = true;
    manager.enabledAccumulator = true;
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
    manager.VELOCITY_ITERATIONS = 8;
    manager.POSITION_ITERATIONS = 8; //

    this.registerEvent(); //

    this.graphics = this.ground.getComponent(cc.Mask)['_graphics']; //
    // this.node.on("touchstart", this.creatWater, this);
  },
  start: function start() {
    var _this = this;

    //
    this.scheduleOnce(function () {
      _this.reset();
    }, 0.01); // this.schedule(this.creatWater, 0.5);
    // this.reset();
  },
  registerEvent: function registerEvent() {
    this.ground.on("touchstart", this._touchStart, this);
    this.ground.on("touchmove", this._touchMove, this);
    this.ground.on("touchend", this._touchEnd, this);
    this.ground.on("touchcancel", this._touchEnd, this);
  },
  reset: function reset() {
    this.polyEx.init([[-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]]);
    this.polyEx.polyDifference([], this.graphics);
  },
  _touchMove: function _touchMove(touch) {
    var regions = [];
    var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
    var count = this.DIG_FRAGMENT;

    if (!this._touchStartPos) {
      for (var index = 0; index < count; index++) {
        var r = 2 * Math.PI * index / count;
        var x = pos.x + this.DIG_RADIUS * Math.cos(r);
        var y = pos.y + this.DIG_RADIUS * Math.sin(r);
        regions.push(this._optimizePoint([x, y]));
      }

      this._touchStartPos = pos;
    } else {
      var delta = pos.sub(this._touchStartPos); // 手指移动的距离太小的话忽略

      if (delta.lengthSqr() > 25) {
        var startPos = this._touchStartPos;

        for (var _index = 0; _index < count; _index++) {
          var _r = 2 * Math.PI * _index / count;

          var vec_x = this.DIG_RADIUS * Math.cos(_r);
          var vec_y = this.DIG_RADIUS * Math.sin(_r);

          var _x = void 0,
              _y = void 0;

          if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
            _x = pos.x + vec_x;
            _y = pos.y + vec_y;
          } else {
            _x = startPos.x + vec_x;
            _y = startPos.y + vec_y;
          }

          regions.push(this._optimizePoint([_x, _y]));
        }

        this._touchStartPos = pos;
      }
    }

    if (regions.length) this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
  },
  _touchStart: function _touchStart(touch) {
    this._touchStartPos = undefined;

    this._touchMove(touch);
  },
  _touchEnd: function _touchEnd() {
    this._touchStartPos = undefined;
  },
  _optimizePoint: function _optimizePoint(point) {
    return cc.v2(Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE);
  },
  debug: function debug() {
    cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
    cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
  },
  creatWater: function creatWater(event) {
    var waterNum = 5;

    for (var i = 0; i < waterNum; i++) {
      var waterPre = cc.instantiate(this.water);
      waterPre.x = Math.random() * (cc.winSize.width - waterPre.width) + (-cc.winSize.width / 2 + waterPre.width / 2);
      waterPre.y = Math.random();
      this.waterLayer.addChild(waterPre);
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0XFx0ZXN0Mi5qcyJdLCJuYW1lcyI6WyJjYyIsIkNsYXNzIiwiQ29tcG9uZW50IiwicHJvcGVydGllcyIsIndhdGVyIiwiUHJlZmFiIiwid2F0ZXJMYXllciIsIk5vZGUiLCJncm91bmQiLCJvbkxvYWQiLCJfdG91Y2hTdGFydFBvcyIsIlZlYzIiLCJwb2x5RXgiLCJnZXRDb21wb25lbnQiLCJESUdfUkFESVVTIiwiRElHX0ZSQUdNRU5UIiwiRElHX09QVElNSVpFX1NJWkUiLCJtYWNybyIsIkVOQUJMRV9NVUxUSV9UT1VDSCIsIm1hbmFnZXIiLCJkaXJlY3RvciIsImdldFBoeXNpY3NNYW5hZ2VyIiwiZW5hYmxlZCIsImRlYnVnRHJhd0ZsYWdzIiwiZW5hYmxlZEFjY3VtdWxhdG9yIiwiUGh5c2ljc01hbmFnZXIiLCJGSVhFRF9USU1FX1NURVAiLCJWRUxPQ0lUWV9JVEVSQVRJT05TIiwiUE9TSVRJT05fSVRFUkFUSU9OUyIsInJlZ2lzdGVyRXZlbnQiLCJncmFwaGljcyIsIk1hc2siLCJzdGFydCIsInNjaGVkdWxlT25jZSIsInJlc2V0Iiwib24iLCJfdG91Y2hTdGFydCIsIl90b3VjaE1vdmUiLCJfdG91Y2hFbmQiLCJpbml0Iiwid2luU2l6ZSIsIndpZHRoIiwicG9seURpZmZlcmVuY2UiLCJ0b3VjaCIsInJlZ2lvbnMiLCJwb3MiLCJub2RlIiwiY29udmVydFRvTm9kZVNwYWNlQVIiLCJnZXRMb2NhdGlvbiIsImNvdW50IiwiaW5kZXgiLCJyIiwiTWF0aCIsIlBJIiwieCIsImNvcyIsInkiLCJzaW4iLCJwdXNoIiwiX29wdGltaXplUG9pbnQiLCJkZWx0YSIsInN1YiIsImxlbmd0aFNxciIsInN0YXJ0UG9zIiwidmVjX3giLCJ2ZWNfeSIsImRvdCIsInYyIiwibGVuZ3RoIiwicHVzaENvbW1hbmQiLCJ1bmRlZmluZWQiLCJwb2ludCIsImZsb29yIiwiZGVidWciLCJzZXREaXNwbGF5U3RhdHMiLCJpc0Rpc3BsYXlTdGF0cyIsImNyZWF0V2F0ZXIiLCJldmVudCIsIndhdGVyTnVtIiwiaSIsIndhdGVyUHJlIiwiaW5zdGFudGlhdGUiLCJyYW5kb20iLCJhZGRDaGlsZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFDQUEsRUFBRSxDQUFDQyxLQUFILENBQVM7QUFDTCxhQUFTRCxFQUFFLENBQUNFLFNBRFA7QUFHTEMsRUFBQUEsVUFBVSxFQUFFO0FBQ1JDLElBQUFBLEtBQUssRUFBRUosRUFBRSxDQUFDSyxNQURGO0FBRVJDLElBQUFBLFVBQVUsRUFBRU4sRUFBRSxDQUFDTyxJQUZQO0FBR1JDLElBQUFBLE1BQU0sRUFBRVIsRUFBRSxDQUFDTztBQUhILEdBSFA7QUFVTDtBQUVBRSxFQUFBQSxNQVpLLG9CQVlJO0FBQ0w7QUFDQSxTQUFLQyxjQUFMLEdBQXNCVixFQUFFLENBQUNXLElBQXpCO0FBQ0EsU0FBS0MsTUFBTCxHQUFjLEtBQUtKLE1BQUwsQ0FBWUssWUFBWixDQUF5QixpQkFBekIsQ0FBZCxDQUhLLENBSUw7O0FBQ0EsU0FBS0MsVUFBTCxHQUFrQixFQUFsQjtBQUNBLFNBQUtDLFlBQUwsR0FBb0IsRUFBcEIsQ0FOSyxDQU9MOztBQUNBLFNBQUtDLGlCQUFMLEdBQXlCLENBQXpCLENBUkssQ0FTTDtBQUNBOztBQUNBaEIsSUFBQUEsRUFBRSxDQUFDaUIsS0FBSCxDQUFTQyxrQkFBVCxHQUE4QixLQUE5QjtBQUNBLFFBQUlDLE9BQU8sR0FBR25CLEVBQUUsQ0FBQ29CLFFBQUgsQ0FBWUMsaUJBQVosRUFBZDtBQUNBRixJQUFBQSxPQUFPLENBQUNHLE9BQVIsR0FBa0IsSUFBbEI7QUFDQXRCLElBQUFBLEVBQUUsQ0FBQ29CLFFBQUgsQ0FBWUMsaUJBQVosR0FBZ0NFLGNBQWhDLEdBQWlELElBQWpEO0FBQ0FKLElBQUFBLE9BQU8sQ0FBQ0ssa0JBQVIsR0FBNkIsSUFBN0I7QUFDQXhCLElBQUFBLEVBQUUsQ0FBQ3lCLGNBQUgsQ0FBa0JDLGVBQWxCLEdBQW9DLElBQUksRUFBeEM7QUFDQVAsSUFBQUEsT0FBTyxDQUFDUSxtQkFBUixHQUE4QixDQUE5QjtBQUNBUixJQUFBQSxPQUFPLENBQUNTLG1CQUFSLEdBQThCLENBQTlCLENBbEJLLENBbUJMOztBQUNBLFNBQUtDLGFBQUwsR0FwQkssQ0FxQkw7O0FBQ0EsU0FBS0MsUUFBTCxHQUFnQixLQUFLdEIsTUFBTCxDQUFZSyxZQUFaLENBQXlCYixFQUFFLENBQUMrQixJQUE1QixFQUFrQyxXQUFsQyxDQUFoQixDQXRCSyxDQXVCTDtBQUNBO0FBQ0gsR0FyQ0k7QUFzQ0xDLEVBQUFBLEtBdENLLG1CQXNDRztBQUFBOztBQUNKO0FBRUEsU0FBS0MsWUFBTCxDQUFrQixZQUFNO0FBQ3BCLE1BQUEsS0FBSSxDQUFDQyxLQUFMO0FBQ0gsS0FGRCxFQUVHLElBRkgsRUFISSxDQU1KO0FBQ0E7QUFDSCxHQTlDSTtBQStDTEwsRUFBQUEsYUEvQ0ssMkJBK0NXO0FBQ1osU0FBS3JCLE1BQUwsQ0FBWTJCLEVBQVosQ0FBZSxZQUFmLEVBQTZCLEtBQUtDLFdBQWxDLEVBQStDLElBQS9DO0FBQ0EsU0FBSzVCLE1BQUwsQ0FBWTJCLEVBQVosQ0FBZSxXQUFmLEVBQTRCLEtBQUtFLFVBQWpDLEVBQTZDLElBQTdDO0FBQ0EsU0FBSzdCLE1BQUwsQ0FBWTJCLEVBQVosQ0FBZSxVQUFmLEVBQTJCLEtBQUtHLFNBQWhDLEVBQTJDLElBQTNDO0FBQ0EsU0FBSzlCLE1BQUwsQ0FBWTJCLEVBQVosQ0FBZSxhQUFmLEVBQThCLEtBQUtHLFNBQW5DLEVBQThDLElBQTlDO0FBQ0gsR0FwREk7QUFxRExKLEVBQUFBLEtBckRLLG1CQXFERztBQUNKLFNBQUt0QixNQUFMLENBQVkyQixJQUFaLENBQWlCLENBQ2IsQ0FBQyxDQUFDdkMsRUFBRSxDQUFDd0MsT0FBSCxDQUFXQyxLQUFaLEdBQW9CLENBQXJCLEVBQXdCLENBQUMsR0FBekIsQ0FEYSxFQUNrQixDQUFDLENBQUN6QyxFQUFFLENBQUN3QyxPQUFILENBQVdDLEtBQVosR0FBb0IsQ0FBckIsRUFBd0IsR0FBeEIsQ0FEbEIsRUFDZ0QsQ0FBQ3pDLEVBQUUsQ0FBQ3dDLE9BQUgsQ0FBV0MsS0FBWCxHQUFtQixDQUFwQixFQUF1QixHQUF2QixDQURoRCxFQUM2RSxDQUFDekMsRUFBRSxDQUFDd0MsT0FBSCxDQUFXQyxLQUFYLEdBQW1CLENBQXBCLEVBQXVCLENBQUMsR0FBeEIsQ0FEN0UsQ0FBakI7QUFHQSxTQUFLN0IsTUFBTCxDQUFZOEIsY0FBWixDQUEyQixFQUEzQixFQUErQixLQUFLWixRQUFwQztBQUNILEdBMURJO0FBMkRMTyxFQUFBQSxVQTNESyxzQkEyRE1NLEtBM0ROLEVBMkRhO0FBQ2QsUUFBSUMsT0FBTyxHQUFHLEVBQWQ7QUFDQSxRQUFJQyxHQUFHLEdBQUcsS0FBS2YsUUFBTCxDQUFjZ0IsSUFBZCxDQUFtQkMsb0JBQW5CLENBQXdDSixLQUFLLENBQUNLLFdBQU4sRUFBeEMsQ0FBVjtBQUVBLFFBQUlDLEtBQUssR0FBRyxLQUFLbEMsWUFBakI7O0FBQ0EsUUFBSSxDQUFDLEtBQUtMLGNBQVYsRUFBMEI7QUFDdEIsV0FBSyxJQUFJd0MsS0FBSyxHQUFHLENBQWpCLEVBQW9CQSxLQUFLLEdBQUdELEtBQTVCLEVBQW1DQyxLQUFLLEVBQXhDLEVBQTRDO0FBQ3hDLFlBQUlDLENBQUMsR0FBRyxJQUFJQyxJQUFJLENBQUNDLEVBQVQsR0FBY0gsS0FBZCxHQUFzQkQsS0FBOUI7QUFDQSxZQUFJSyxDQUFDLEdBQUdULEdBQUcsQ0FBQ1MsQ0FBSixHQUFRLEtBQUt4QyxVQUFMLEdBQWtCc0MsSUFBSSxDQUFDRyxHQUFMLENBQVNKLENBQVQsQ0FBbEM7QUFDQSxZQUFJSyxDQUFDLEdBQUdYLEdBQUcsQ0FBQ1csQ0FBSixHQUFRLEtBQUsxQyxVQUFMLEdBQWtCc0MsSUFBSSxDQUFDSyxHQUFMLENBQVNOLENBQVQsQ0FBbEM7QUFDQVAsUUFBQUEsT0FBTyxDQUFDYyxJQUFSLENBQWEsS0FBS0MsY0FBTCxDQUFvQixDQUFDTCxDQUFELEVBQUlFLENBQUosQ0FBcEIsQ0FBYjtBQUNIOztBQUNELFdBQUs5QyxjQUFMLEdBQXNCbUMsR0FBdEI7QUFDSCxLQVJELE1BUU87QUFDSCxVQUFJZSxLQUFLLEdBQUdmLEdBQUcsQ0FBQ2dCLEdBQUosQ0FBUSxLQUFLbkQsY0FBYixDQUFaLENBREcsQ0FFSDs7QUFDQSxVQUFJa0QsS0FBSyxDQUFDRSxTQUFOLEtBQW9CLEVBQXhCLEVBQTRCO0FBRXhCLFlBQUlDLFFBQVEsR0FBRyxLQUFLckQsY0FBcEI7O0FBQ0EsYUFBSyxJQUFJd0MsTUFBSyxHQUFHLENBQWpCLEVBQW9CQSxNQUFLLEdBQUdELEtBQTVCLEVBQW1DQyxNQUFLLEVBQXhDLEVBQTRDO0FBQ3hDLGNBQUlDLEVBQUMsR0FBRyxJQUFJQyxJQUFJLENBQUNDLEVBQVQsR0FBY0gsTUFBZCxHQUFzQkQsS0FBOUI7O0FBQ0EsY0FBSWUsS0FBSyxHQUFHLEtBQUtsRCxVQUFMLEdBQWtCc0MsSUFBSSxDQUFDRyxHQUFMLENBQVNKLEVBQVQsQ0FBOUI7QUFDQSxjQUFJYyxLQUFLLEdBQUcsS0FBS25ELFVBQUwsR0FBa0JzQyxJQUFJLENBQUNLLEdBQUwsQ0FBU04sRUFBVCxDQUE5Qjs7QUFDQSxjQUFJRyxFQUFDLFNBQUw7QUFBQSxjQUFPRSxFQUFDLFNBQVI7O0FBQ0EsY0FBSUksS0FBSyxDQUFDTSxHQUFOLENBQVVsRSxFQUFFLENBQUNtRSxFQUFILENBQU1ILEtBQU4sRUFBYUMsS0FBYixDQUFWLElBQWlDLENBQXJDLEVBQXdDO0FBQ3BDWCxZQUFBQSxFQUFDLEdBQUdULEdBQUcsQ0FBQ1MsQ0FBSixHQUFRVSxLQUFaO0FBQ0FSLFlBQUFBLEVBQUMsR0FBR1gsR0FBRyxDQUFDVyxDQUFKLEdBQVFTLEtBQVo7QUFDSCxXQUhELE1BR087QUFDSFgsWUFBQUEsRUFBQyxHQUFHUyxRQUFRLENBQUNULENBQVQsR0FBYVUsS0FBakI7QUFDQVIsWUFBQUEsRUFBQyxHQUFHTyxRQUFRLENBQUNQLENBQVQsR0FBYVMsS0FBakI7QUFDSDs7QUFDRHJCLFVBQUFBLE9BQU8sQ0FBQ2MsSUFBUixDQUFhLEtBQUtDLGNBQUwsQ0FBb0IsQ0FBQ0wsRUFBRCxFQUFJRSxFQUFKLENBQXBCLENBQWI7QUFDSDs7QUFDRCxhQUFLOUMsY0FBTCxHQUFzQm1DLEdBQXRCO0FBQ0g7QUFDSjs7QUFFRCxRQUFJRCxPQUFPLENBQUN3QixNQUFaLEVBQ0ksS0FBS3hELE1BQUwsQ0FBWXlELFdBQVosQ0FBd0IsZ0JBQXhCLEVBQTBDLENBQUN6QixPQUFELEVBQVUsS0FBS2QsUUFBZixDQUExQztBQUNQLEdBbEdJO0FBbUdMTSxFQUFBQSxXQW5HSyx1QkFtR09PLEtBbkdQLEVBbUdjO0FBQ2YsU0FBS2pDLGNBQUwsR0FBc0I0RCxTQUF0Qjs7QUFDQSxTQUFLakMsVUFBTCxDQUFnQk0sS0FBaEI7QUFDSCxHQXRHSTtBQXdHTEwsRUFBQUEsU0F4R0ssdUJBd0dPO0FBQ1IsU0FBSzVCLGNBQUwsR0FBc0I0RCxTQUF0QjtBQUNILEdBMUdJO0FBNEdMWCxFQUFBQSxjQTVHSywwQkE0R1VZLEtBNUdWLEVBNEdpQjtBQUNsQixXQUFPdkUsRUFBRSxDQUFDbUUsRUFBSCxDQUFNZixJQUFJLENBQUNvQixLQUFMLENBQVdELEtBQUssQ0FBQyxDQUFELENBQUwsR0FBVyxLQUFLdkQsaUJBQTNCLElBQWdELEtBQUtBLGlCQUEzRCxFQUE4RW9DLElBQUksQ0FBQ29CLEtBQUwsQ0FBV0QsS0FBSyxDQUFDLENBQUQsQ0FBTCxHQUFXLEtBQUt2RCxpQkFBM0IsSUFBZ0QsS0FBS0EsaUJBQW5JLENBQVA7QUFDSCxHQTlHSTtBQStHTHlELEVBQUFBLEtBL0dLLG1CQStHRztBQUNKekUsSUFBQUEsRUFBRSxDQUFDeUUsS0FBSCxDQUFTQyxlQUFULENBQXlCLENBQUMxRSxFQUFFLENBQUN5RSxLQUFILENBQVNFLGNBQVQsRUFBMUI7QUFDQTNFLElBQUFBLEVBQUUsQ0FBQ29CLFFBQUgsQ0FBWUMsaUJBQVosR0FBZ0NFLGNBQWhDLEdBQWlEdkIsRUFBRSxDQUFDeUUsS0FBSCxDQUFTRSxjQUFULEtBQTRCLENBQTVCLEdBQWdDLENBQWpGO0FBQ0gsR0FsSEk7QUFtSExDLEVBQUFBLFVBbkhLLHNCQW1ITUMsS0FuSE4sRUFtSGE7QUFDZCxRQUFJQyxRQUFRLEdBQUcsQ0FBZjs7QUFDQSxTQUFLLElBQUlDLENBQUMsR0FBRyxDQUFiLEVBQWdCQSxDQUFDLEdBQUdELFFBQXBCLEVBQThCQyxDQUFDLEVBQS9CLEVBQW1DO0FBQy9CLFVBQUlDLFFBQVEsR0FBR2hGLEVBQUUsQ0FBQ2lGLFdBQUgsQ0FBZSxLQUFLN0UsS0FBcEIsQ0FBZjtBQUNBNEUsTUFBQUEsUUFBUSxDQUFDMUIsQ0FBVCxHQUFhRixJQUFJLENBQUM4QixNQUFMLE1BQWlCbEYsRUFBRSxDQUFDd0MsT0FBSCxDQUFXQyxLQUFYLEdBQW1CdUMsUUFBUSxDQUFDdkMsS0FBN0MsS0FBdUQsQ0FBQ3pDLEVBQUUsQ0FBQ3dDLE9BQUgsQ0FBV0MsS0FBWixHQUFvQixDQUFwQixHQUF3QnVDLFFBQVEsQ0FBQ3ZDLEtBQVQsR0FBaUIsQ0FBaEcsQ0FBYjtBQUNBdUMsTUFBQUEsUUFBUSxDQUFDeEIsQ0FBVCxHQUFhSixJQUFJLENBQUM4QixNQUFMLEVBQWI7QUFDQSxXQUFLNUUsVUFBTCxDQUFnQjZFLFFBQWhCLENBQXlCSCxRQUF6QjtBQUNIO0FBQ0osR0EzSEksQ0E4SEw7O0FBOUhLLENBQVQiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIlxyXG5jYy5DbGFzcyh7XHJcbiAgICBleHRlbmRzOiBjYy5Db21wb25lbnQsXHJcblxyXG4gICAgcHJvcGVydGllczoge1xyXG4gICAgICAgIHdhdGVyOiBjYy5QcmVmYWIsXHJcbiAgICAgICAgd2F0ZXJMYXllcjogY2MuTm9kZSxcclxuICAgICAgICBncm91bmQ6IGNjLk5vZGUsXHJcblxyXG4gICAgfSxcclxuXHJcbiAgICAvLyBMSUZFLUNZQ0xFIENBTExCQUNLUzpcclxuXHJcbiAgICBvbkxvYWQoKSB7XHJcbiAgICAgICAgLy9cclxuICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gY2MuVmVjMjtcclxuICAgICAgICB0aGlzLnBvbHlFeCA9IHRoaXMuZ3JvdW5kLmdldENvbXBvbmVudChcIlBoeXNpY3NDb2xsaWRlclwiKTtcclxuICAgICAgICAvL1xyXG4gICAgICAgIHRoaXMuRElHX1JBRElVUyA9IDUwO1xyXG4gICAgICAgIHRoaXMuRElHX0ZSQUdNRU5UID0gMTI7XHJcbiAgICAgICAgLy9cclxuICAgICAgICB0aGlzLkRJR19PUFRJTUlaRV9TSVpFID0gMTtcclxuICAgICAgICAvL1xyXG4gICAgICAgIC8v6LCD6IqC54mp55CG57O757ufXHJcbiAgICAgICAgY2MubWFjcm8uRU5BQkxFX01VTFRJX1RPVUNIID0gZmFsc2U7XHJcbiAgICAgICAgbGV0IG1hbmFnZXIgPSBjYy5kaXJlY3Rvci5nZXRQaHlzaWNzTWFuYWdlcigpO1xyXG4gICAgICAgIG1hbmFnZXIuZW5hYmxlZCA9IHRydWU7XHJcbiAgICAgICAgY2MuZGlyZWN0b3IuZ2V0UGh5c2ljc01hbmFnZXIoKS5kZWJ1Z0RyYXdGbGFncyA9IHRydWU7XHJcbiAgICAgICAgbWFuYWdlci5lbmFibGVkQWNjdW11bGF0b3IgPSB0cnVlO1xyXG4gICAgICAgIGNjLlBoeXNpY3NNYW5hZ2VyLkZJWEVEX1RJTUVfU1RFUCA9IDEgLyAzMDtcclxuICAgICAgICBtYW5hZ2VyLlZFTE9DSVRZX0lURVJBVElPTlMgPSA4O1xyXG4gICAgICAgIG1hbmFnZXIuUE9TSVRJT05fSVRFUkFUSU9OUyA9IDg7XHJcbiAgICAgICAgLy9cclxuICAgICAgICB0aGlzLnJlZ2lzdGVyRXZlbnQoKTtcclxuICAgICAgICAvL1xyXG4gICAgICAgIHRoaXMuZ3JhcGhpY3MgPSB0aGlzLmdyb3VuZC5nZXRDb21wb25lbnQoY2MuTWFzaylbJ19ncmFwaGljcyddO1xyXG4gICAgICAgIC8vXHJcbiAgICAgICAgLy8gdGhpcy5ub2RlLm9uKFwidG91Y2hzdGFydFwiLCB0aGlzLmNyZWF0V2F0ZXIsIHRoaXMpO1xyXG4gICAgfSxcclxuICAgIHN0YXJ0KCkge1xyXG4gICAgICAgIC8vXHJcblxyXG4gICAgICAgIHRoaXMuc2NoZWR1bGVPbmNlKCgpID0+IHtcclxuICAgICAgICAgICAgdGhpcy5yZXNldCgpO1xyXG4gICAgICAgIH0sIDAuMDEpXHJcbiAgICAgICAgLy8gdGhpcy5zY2hlZHVsZSh0aGlzLmNyZWF0V2F0ZXIsIDAuNSk7XHJcbiAgICAgICAgLy8gdGhpcy5yZXNldCgpO1xyXG4gICAgfSxcclxuICAgIHJlZ2lzdGVyRXZlbnQoKSB7XHJcbiAgICAgICAgdGhpcy5ncm91bmQub24oXCJ0b3VjaHN0YXJ0XCIsIHRoaXMuX3RvdWNoU3RhcnQsIHRoaXMpO1xyXG4gICAgICAgIHRoaXMuZ3JvdW5kLm9uKFwidG91Y2htb3ZlXCIsIHRoaXMuX3RvdWNoTW92ZSwgdGhpcyk7XHJcbiAgICAgICAgdGhpcy5ncm91bmQub24oXCJ0b3VjaGVuZFwiLCB0aGlzLl90b3VjaEVuZCwgdGhpcyk7XHJcbiAgICAgICAgdGhpcy5ncm91bmQub24oXCJ0b3VjaGNhbmNlbFwiLCB0aGlzLl90b3VjaEVuZCwgdGhpcyk7XHJcbiAgICB9LFxyXG4gICAgcmVzZXQoKSB7XHJcbiAgICAgICAgdGhpcy5wb2x5RXguaW5pdChbXHJcbiAgICAgICAgICAgIFstY2Mud2luU2l6ZS53aWR0aCAvIDIsIC0zMjBdLCBbLWNjLndpblNpemUud2lkdGggLyAyLCAyNTBdLCBbY2Mud2luU2l6ZS53aWR0aCAvIDIsIDI1MF0sIFtjYy53aW5TaXplLndpZHRoIC8gMiwgLTMyMF1cclxuICAgICAgICBdKTtcclxuICAgICAgICB0aGlzLnBvbHlFeC5wb2x5RGlmZmVyZW5jZShbXSwgdGhpcy5ncmFwaGljcyk7XHJcbiAgICB9LFxyXG4gICAgX3RvdWNoTW92ZSh0b3VjaCkge1xyXG4gICAgICAgIGxldCByZWdpb25zID0gW107XHJcbiAgICAgICAgbGV0IHBvcyA9IHRoaXMuZ3JhcGhpY3Mubm9kZS5jb252ZXJ0VG9Ob2RlU3BhY2VBUih0b3VjaC5nZXRMb2NhdGlvbigpKTtcclxuXHJcbiAgICAgICAgbGV0IGNvdW50ID0gdGhpcy5ESUdfRlJBR01FTlQ7XHJcbiAgICAgICAgaWYgKCF0aGlzLl90b3VjaFN0YXJ0UG9zKSB7XHJcbiAgICAgICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCBjb3VudDsgaW5kZXgrKykge1xyXG4gICAgICAgICAgICAgICAgbGV0IHIgPSAyICogTWF0aC5QSSAqIGluZGV4IC8gY291bnQ7XHJcbiAgICAgICAgICAgICAgICBsZXQgeCA9IHBvcy54ICsgdGhpcy5ESUdfUkFESVVTICogTWF0aC5jb3Mocik7XHJcbiAgICAgICAgICAgICAgICBsZXQgeSA9IHBvcy55ICsgdGhpcy5ESUdfUkFESVVTICogTWF0aC5zaW4ocik7XHJcbiAgICAgICAgICAgICAgICByZWdpb25zLnB1c2godGhpcy5fb3B0aW1pemVQb2ludChbeCwgeV0pKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gcG9zO1xyXG4gICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICAgIGxldCBkZWx0YSA9IHBvcy5zdWIodGhpcy5fdG91Y2hTdGFydFBvcyk7XHJcbiAgICAgICAgICAgIC8vIOaJi+aMh+enu+WKqOeahOi3neemu+WkquWwj+eahOivneW/veeVpVxyXG4gICAgICAgICAgICBpZiAoZGVsdGEubGVuZ3RoU3FyKCkgPiAyNSkge1xyXG5cclxuICAgICAgICAgICAgICAgIGxldCBzdGFydFBvcyA9IHRoaXMuX3RvdWNoU3RhcnRQb3M7XHJcbiAgICAgICAgICAgICAgICBmb3IgKGxldCBpbmRleCA9IDA7IGluZGV4IDwgY291bnQ7IGluZGV4KyspIHtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgciA9IDIgKiBNYXRoLlBJICogaW5kZXggLyBjb3VudDtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgdmVjX3ggPSB0aGlzLkRJR19SQURJVVMgKiBNYXRoLmNvcyhyKTtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgdmVjX3kgPSB0aGlzLkRJR19SQURJVVMgKiBNYXRoLnNpbihyKTtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgeCwgeTtcclxuICAgICAgICAgICAgICAgICAgICBpZiAoZGVsdGEuZG90KGNjLnYyKHZlY194LCB2ZWNfeSkpID4gMCkge1xyXG4gICAgICAgICAgICAgICAgICAgICAgICB4ID0gcG9zLnggKyB2ZWNfeDtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeSA9IHBvcy55ICsgdmVjX3k7XHJcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeCA9IHN0YXJ0UG9zLnggKyB2ZWNfeDtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeSA9IHN0YXJ0UG9zLnkgKyB2ZWNfeTtcclxuICAgICAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICAgICAgcmVnaW9ucy5wdXNoKHRoaXMuX29wdGltaXplUG9pbnQoW3gsIHldKSk7XHJcbiAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gcG9zO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgfVxyXG5cclxuICAgICAgICBpZiAocmVnaW9ucy5sZW5ndGgpXHJcbiAgICAgICAgICAgIHRoaXMucG9seUV4LnB1c2hDb21tYW5kKCdwb2x5RGlmZmVyZW5jZScsIFtyZWdpb25zLCB0aGlzLmdyYXBoaWNzXSk7XHJcbiAgICB9LFxyXG4gICAgX3RvdWNoU3RhcnQodG91Y2gpIHtcclxuICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gdW5kZWZpbmVkO1xyXG4gICAgICAgIHRoaXMuX3RvdWNoTW92ZSh0b3VjaCk7XHJcbiAgICB9LFxyXG5cclxuICAgIF90b3VjaEVuZCgpIHtcclxuICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gdW5kZWZpbmVkO1xyXG4gICAgfSxcclxuXHJcbiAgICBfb3B0aW1pemVQb2ludChwb2ludCkge1xyXG4gICAgICAgIHJldHVybiBjYy52MihNYXRoLmZsb29yKHBvaW50WzBdICogdGhpcy5ESUdfT1BUSU1JWkVfU0laRSkgLyB0aGlzLkRJR19PUFRJTUlaRV9TSVpFLCBNYXRoLmZsb29yKHBvaW50WzFdICogdGhpcy5ESUdfT1BUSU1JWkVfU0laRSkgLyB0aGlzLkRJR19PUFRJTUlaRV9TSVpFKTtcclxuICAgIH0sXHJcbiAgICBkZWJ1ZygpIHtcclxuICAgICAgICBjYy5kZWJ1Zy5zZXREaXNwbGF5U3RhdHMoIWNjLmRlYnVnLmlzRGlzcGxheVN0YXRzKCkpO1xyXG4gICAgICAgIGNjLmRpcmVjdG9yLmdldFBoeXNpY3NNYW5hZ2VyKCkuZGVidWdEcmF3RmxhZ3MgPSBjYy5kZWJ1Zy5pc0Rpc3BsYXlTdGF0cygpID8gMSA6IDA7XHJcbiAgICB9LFxyXG4gICAgY3JlYXRXYXRlcihldmVudCkge1xyXG4gICAgICAgIGxldCB3YXRlck51bSA9IDU7XHJcbiAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCB3YXRlck51bTsgaSsrKSB7XHJcbiAgICAgICAgICAgIGxldCB3YXRlclByZSA9IGNjLmluc3RhbnRpYXRlKHRoaXMud2F0ZXIpO1xyXG4gICAgICAgICAgICB3YXRlclByZS54ID0gTWF0aC5yYW5kb20oKSAqIChjYy53aW5TaXplLndpZHRoIC0gd2F0ZXJQcmUud2lkdGgpICsgKC1jYy53aW5TaXplLndpZHRoIC8gMiArIHdhdGVyUHJlLndpZHRoIC8gMik7XHJcbiAgICAgICAgICAgIHdhdGVyUHJlLnkgPSBNYXRoLnJhbmRvbSgpXHJcbiAgICAgICAgICAgIHRoaXMud2F0ZXJMYXllci5hZGRDaGlsZCh3YXRlclByZSk7XHJcbiAgICAgICAgfVxyXG4gICAgfSxcclxuXHJcblxyXG4gICAgLy8gdXBkYXRlIChkdCkge30sXHJcbn0pO1xyXG4iXX0=
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Shader/GTAutoFitSpriteAssembler2D.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1a39ak3NZdFtYMMs/stiMBC', 'GTAutoFitSpriteAssembler2D');
// shader/GTAutoFitSpriteAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-21 16:23:10
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:52
*/
var GTSimpleSpriteAssembler2D_1 = require("./GTSimpleSpriteAssembler2D");
var GTAutoFitSpriteAssembler2D = /** @class */ (function (_super) {
    __extends(GTAutoFitSpriteAssembler2D, _super);
    function GTAutoFitSpriteAssembler2D() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._uv = [];
        return _this;
    }
    GTAutoFitSpriteAssembler2D.prototype.updateUVs = function (sprite) {
        var rect = sprite._spriteFrame.getRect();
        var node = sprite.node;
        if (!rect.width || !rect.height || !node.width || !node.height) {
            _super.prototype.updateUVs.call(this, sprite);
            return;
        }
        Object.assign(this._uv, sprite._spriteFrame.uv);
        var uv = this._uv;
        var wscale = rect.width / node.width;
        var hscale = rect.height / node.height;
        var ratio = 1.0;
        var isRotated = sprite._spriteFrame.isRotated();
        var l = uv[0], r = uv[2], b = uv[1], t = uv[5];
        if (isRotated) {
            // cc图集里的旋转总是顺时针旋转90度，以原左下角为中心。（旋转后左下角变为左上角）
            l = uv[1];
            r = uv[3];
            b = uv[0];
            t = uv[4];
        }
        // 图片在等比缩放的前提下自适应容器大小
        if (wscale > hscale) {
            // fit height
            ratio = hscale / wscale;
            var ro = isRotated ? 1 : 0;
            var c = (l + r) * 0.5;
            var half = (r - l) * 0.5 * ratio;
            l = uv[0 + ro] = uv[4 + ro] = c - half;
            r = uv[2 + ro] = uv[6 + ro] = c + half;
        }
        else {
            // fit width
            ratio = wscale / hscale;
            var ro = isRotated ? -1 : 0;
            var c = (b + t) * 0.5;
            var half = (b - t) * 0.5 * ratio;
            b = uv[1 + ro] = uv[3 + ro] = c + half;
            t = uv[5 + ro] = uv[7 + ro] = c - half;
        }
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    return GTAutoFitSpriteAssembler2D;
}(GTSimpleSpriteAssembler2D_1.default));
exports.default = GTAutoFitSpriteAssembler2D;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/render.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7f52aFishRJs421a8+VMNpA', 'render');
// script/render.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {},
  // LIFE-CYCLE CALLBACKS:
  // onLoad () {},
  start: function start() {} // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0XFxyZW5kZXIuanMiXSwibmFtZXMiOlsiY2MiLCJDbGFzcyIsIkNvbXBvbmVudCIsInByb3BlcnRpZXMiLCJzdGFydCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFDQUEsRUFBRSxDQUFDQyxLQUFILENBQVM7QUFDTCxhQUFTRCxFQUFFLENBQUNFLFNBRFA7QUFHTEMsRUFBQUEsVUFBVSxFQUFFLEVBSFA7QUFPTDtBQUVBO0FBRUFDLEVBQUFBLEtBWEssbUJBV0csQ0FFUCxDQWJJLENBZUw7O0FBZkssQ0FBVCIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiXHJcbmNjLkNsYXNzKHtcclxuICAgIGV4dGVuZHM6IGNjLkNvbXBvbmVudCxcclxuXHJcbiAgICBwcm9wZXJ0aWVzOiB7XHJcblxyXG4gICAgfSxcclxuXHJcbiAgICAvLyBMSUZFLUNZQ0xFIENBTExCQUNLUzpcclxuXHJcbiAgICAvLyBvbkxvYWQgKCkge30sXHJcblxyXG4gICAgc3RhcnQoKSB7XHJcblxyXG4gICAgfSxcclxuXHJcbiAgICAvLyB1cGRhdGUgKGR0KSB7fSxcclxufSk7XHJcbiJdfQ==
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/waterCube.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '95645q6J0VGBrNh+xu4ej+P', 'waterCube');
// script/waterCube.js

"use strict";

var _require = require("constants"),
    SSL_OP_NETSCAPE_CHALLENGE_BUG = _require.SSL_OP_NETSCAPE_CHALLENGE_BUG;

cc.Class({
  "extends": cc.Component,
  editor: CC_EDITOR && {
    executeInEditMode: true
  },
  properties: {
    spriteFrame: cc.SpriteFrame
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    this.radius = 50;
    this.vertCount = 12; // this.openStreak = false;
    //

    var renderer = this.node.getComponent(cc.MeshRenderer);

    if (!renderer) {
      renderer = this.node.addComponent(cc.MeshRenderer);
    }

    renderer.mesh = null;
    this.renderer = renderer;

    this._updateMaterial();

    cc.log(1);

    this._updateMesh();

    cc.log(2);

    this._applySpriteFrame();

    cc.log(3);

    this._applyVertexes();

    cc.log(4); // this.node.on('size-changed', () => {
    //     this._updateMesh();
    //     this._applyVertexes();
    // }, this);
  },
  start: function start() {// this.schedule(this.streakShader, 0.1);
    // this.schedule(this.streak, 0.1);
  },
  streakShader: function streakShader() {
    var material = this.getMaterial(0);
    var velocity = this.node.getComponent(cc.RigidBody).velocity;
    material.setProperty("velocity", velocity);
  },
  _updateMesh: function _updateMesh() {
    //确定顶点坐标
    this._vertexes = [];
    var pos = this.node.position; //放入原点

    this._vertexes.push(pos); //画圆放点


    var rotateVec2 = cc.v2(0, this.radius);
    var angle = 2 * Math.PI / this.vertCount;

    for (var i = 0; i < this.vertCount; i++) {
      this._vertexes.push(cc.v2(pos.add(rotateVec2)));

      rotateVec2.rotateSelf(angle);
    }

    ; //绑定

    var gfx = cc.gfx;
    var mesh = new cc.Mesh();
    mesh.init(new gfx.VertexFormat([{
      name: gfx.ATTR_POSITION,
      type: gfx.ATTR_TYPE_FLOAT32,
      num: 2
    }, {
      name: gfx.ATTR_UV0,
      type: gfx.ATTR_TYPE_FLOAT32,
      num: 2
    }]), this._vertexes.length, true);
    this.mesh = mesh;

    this._updateMaterial();
  },
  _applySpriteFrame: function _applySpriteFrame() {
    if (this.spriteFrame) {
      var texture = this.spriteFrame.getTexture();
      this.texture = texture;

      this._updateMaterial();
    }
  },
  _updateMaterial: function _updateMaterial() {
    var material = this.renderer._materials[0];

    if (material) {
      if (this.texture) {// material.define("USE_TEXTURE", true);
        // material.setProperty('texture', this.texture);
      }
    } //设置uniform参数
    // material.setProperty()

  },
  _applyVertexes: function _applyVertexes() {
    var _this = this;

    var mesh = this.mesh;
    var gfx = cc.gfx;
    mesh.setVertices(gfx.ATTR_POSITION, this._vertexes);

    if (this.texture) {
      var uvs = [];

      this._vertexes.forEach(function (element) {
        var u = element.x / _this.texture.width; //+ this.offset.x

        var v = 1.0 - element.y / _this.texture.height; // + this.offset.y

        uvs.push(cc.v2(u, v));
      });

      mesh.setVertices(gfx.ATTR_UV0, uvs); //计算顶点索引

      if (this._vertexes.length >= 3) {
        var ids = [];

        for (var i = 0; i, this.vertCount; i++) {
          ids.push(this.vertCount[i], this.vertCount[i + 1], this.vertCount[0]);
        }

        ;
        mesh.setIndices(ids);

        if (this.renderer.mesh != mesh) {
          this.renderer.mesh = mesh;
        }
      }
    }
  } // onBeginContact(contact, selfCollider, otherCollider) {
  //     if (otherCollider.node.group == "water") {
  //         // this.node.children[0].active = false;
  //     }
  // },
  // streak() {
  //     // cc.log(this.node.getComponent(cc.RigidBody).linearVelocity.mag())
  //     if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() > 600 && !this.openStreak) {
  //         this.openStreak = true;
  //         this.node.children[0].active = true;
  //         cc.log(true)
  //     }
  //     else if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() <= 200 && this.openStreak) {
  //         this.node.children[0].getComponent(cc.MotionStreak).fadeTime *= 0.95;
  //         if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() < 10) {
  //             this.openStreak = false;
  //             this.node.children[0].active = false;
  //         }
  //     }
  // },
  // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/water.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'e7324A1989GLrPTV7C8Xrqz', 'water');
// script/water.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    sp_water_show: cc.Sprite,
    camera_water: cc.Camera
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    var texture = new cc.RenderTexture();
    texture.initWithSize(this.sp_water_show.node.width, this.sp_water_show.node.height);
    var spriteFrame = new cc.SpriteFrame();
    spriteFrame.setTexture(texture);
    spriteFrame.setFlipY(true);
    this.camera_water.targetTexture = texture;
    this.sp_water_show.spriteFrame = spriteFrame;
  },
  start: function start() {} // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/PhysicsCollider.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'eab4fE4ObRBBYbAUGehBobl', 'PhysicsCollider');
// script/PhysicsCollider.js

"use strict";

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

cc.Class({
  "extends": cc.Component,
  properties: {// polys: {
    //     get: () => {
    //         return this._polys.map((v) => { return this._convertClipperPathToVecArray(v) });
    //     }
    // }
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this.DIG_OPTIMIZE_SIZE = 1; //

    this._commands = [];
    this._physicsPolygonColliders = [];
    this._polys = [[]];
  },
  // get polys() {
  //     return this._polys.map((v) => { return this._convertClipperPathToVecArray(v) });
  // },
  start: function start() {},
  _convertClipperPathToVecArray: function _convertClipperPathToVecArray(poly) {
    return poly.map(function (p) {
      return cc.v2(p.X, p.Y);
    });
  },
  _convertVecArrayToClipperPath: function _convertVecArrayToClipperPath(poly) {
    return poly.map(function (p) {
      return {
        X: p.x,
        Y: p.y
      };
    });
  },
  _convertClipperPathToPoly2triPoint: function _convertClipperPathToPoly2triPoint(poly, exclude) {
    // return poly.map((p) => { return new poly2tri.Point(p.X, p.Y) });
    var newPos = [];
    poly.forEach(function (p, i) {
      var p_now = new poly2tri.Point(p.X, p.Y);
      var isIn = exclude.some(function (e_p) {
        if (e_p.equals(p_now)) {
          return true;
        }
      });

      if (!isIn) {
        newPos.push(p_now);
        exclude.push(p_now);
      }
    });
    if (newPos.length > 2) return newPos;else return [];
  },
  init: function init(polys) {
    var _this = this;

    this._polys = polys.map(function (v) {
      return _this._convertVecArrayToClipperPath(v);
    });
    this._commands = [];
  },
  polyDifference: function polyDifference(poly, ctx) {
    var _this2 = this;

    if (!ctx) {
      cc.error("no ctx");
    }

    var cpr = new ClipperLib.Clipper();
    var subj_paths = this._polys;
    var clip_paths = [this._convertVecArrayToClipperPath(poly)];
    cpr.AddPaths(subj_paths, ClipperLib.PolyType.ptSubject, true);
    cpr.AddPaths(clip_paths, ClipperLib.PolyType.ptClip, true);
    var subject_fillType = ClipperLib.PolyFillType.pftEvenOdd;
    var clip_fillType = ClipperLib.PolyFillType.pftEvenOdd;
    var solution_polytree = new ClipperLib.PolyTree();
    cpr.Execute(ClipperLib.ClipType.ctDifference, solution_polytree, subject_fillType, clip_fillType);
    var solution_expolygons = ClipperLib.JS.PolyTreeToExPolygons(solution_polytree);
    this._polys = ClipperLib.Clipper.PolyTreeToPaths(solution_polytree); //

    ctx && ctx.clear(true);
    var _physicsPolygonColliders_count = 0;

    var _loop = function _loop() {
      var expolygon = _step.value;

      // let outers = ClipperLib.Clipper.SimplifyPolygon(expolygon.outer,ClipperLib.PolyFillType.pftEvenOdd);
      // cc.log(outer,"outer",expolygon.outer)
      var countor = _this2._convertClipperPathToPoly2triPoint(expolygon.outer);

      if (countor.length < 2) return "continue";
      var swctx = new poly2tri.SweepContext(countor, {
        cloneArrays: true
      }); // let exclude = countor;

      var holes = expolygon.holes.map(function (h) {
        return _this2._convertClipperPathToPoly2triPoint(h, countor);
      });

      try {
        // 防止 addhole 失败 使用try
        swctx.addHoles(holes);
        swctx.triangulate();
        var triangles = swctx.getTriangles();

        for (var _iterator2 = _createForOfIteratorHelperLoose(triangles), _step2; !(_step2 = _iterator2()).done;) {
          var tri = _step2.value;
          // 逐一处理三角形
          var c = _this2._physicsPolygonColliders[_physicsPolygonColliders_count];

          if (!c) {
            c = _this2.addComponent(cc.PhysicsPolygonCollider);
            c.friction = 0;
            c.restitution = 0;
            _this2._physicsPolygonColliders[_physicsPolygonColliders_count] = c;
          }

          c.points = tri.getPoints().map(function (v, i) {
            if (ctx) {
              if (i === 0) ctx.moveTo(v.x, v.y);else ctx.lineTo(v.x, v.y);
            }

            return cc.v2(v.x, v.y);
          });
          c.apply();
          _physicsPolygonColliders_count++;

          if (ctx) {
            ctx.close();
            ctx.fill();
          }
        }
      } catch (e) {
        console.error('polyDifference poly2tri error', _physicsPolygonColliders_count, expolygon);
        console.error(e);
        return "continue";
      }
    };

    for (var _iterator = _createForOfIteratorHelperLoose(solution_expolygons), _step; !(_step = _iterator()).done;) {
      var _ret = _loop();

      if (_ret === "continue") continue;
    }

    this._physicsPolygonColliders.slice(_physicsPolygonColliders_count).forEach(function (v) {
      if (v.points.length) {
        v.points.length = 0;
        v.apply();
      }
    });
  },
  pushCommand: function pushCommand(name, params) {
    this._commands.push({
      name: name,
      params: params
    });
  },
  lateUpdate: function lateUpdate(dt) {
    if (this._commands.length) {
      // 每帧执行命令队列
      for (var index = 0; index < 2; index++) {
        var cmd = this._commands.shift();

        if (cmd) this[cmd.name].apply(this, cmd.params);else break;
      }
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/TypeScript2/test4.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '86805m1LvpOlJlxkovVgNuY', 'test4');
// TypeScript2/test4.ts

Object.defineProperty(exports, "__esModule", { value: true });
var PhysicsPolygonColliderEx_1 = require("./PhysicsPolygonColliderEx");
// 挖洞圆半径
var DIG_RADIUS = 50;
// 圆的边的数量
var DIG_FRAGMENT = 12;
// 归一到单位化
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main_poly = /** @class */ (function (_super) {
    __extends(Main_poly, _super);
    function Main_poly() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.node_dirty = null;
        _this.polyEx = null;
        _this.water = null;
        return _this;
    }
    Main_poly.prototype.onLoad = function () {
        cc.macro.SHOW_MESH_WIREFRAME = true;
        cc.macro.ENABLE_MULTI_TOUCH = false;
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().enabledAccumulator = true;
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        cc.PhysicsManager.POSITION_ITERATIONS = 8;
        this.node_dirty.on(cc.Node.EventType.TOUCH_START, this._touchStart, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_END, this._touchEnd, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_CANCEL, this._touchEnd, this);
        this.graphics = this.node_dirty.getComponent(cc.Mask)['_graphics'];
    };
    Main_poly.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            _this.reset();
        }, 0.01);
        this.schedule(this.creatWater, 0.5);
    };
    Main_poly.prototype.creatWater = function () {
        var water = cc.instantiate(this.water);
        water.y = cc.winSize.height / 2;
        cc.find("Canvas/waterLayer").addChild(water);
    };
    Main_poly.prototype._optimizePoint = function (point) {
        var x = Math.floor(point[0] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        var y = Math.floor(point[1] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        return cc.v2(x, y);
    };
    Main_poly.prototype._touchStart = function (touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    };
    Main_poly.prototype._touchMove = function (touch) {
        var regions = [];
        var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
        var count = DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (var index = 0; index < count; index++) {
                var r = 2 * Math.PI * index / count;
                var x = pos.x + DIG_RADIUS * Math.cos(r);
                var y = pos.y + DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        }
        else {
            var delta = pos.sub(this._touchStartPos);
            if (delta.lengthSqr() > 25) {
                var startPos = this._touchStartPos;
                for (var index = 0; index < count; index++) {
                    var r = 2 * Math.PI * index / count;
                    var vec_x = DIG_RADIUS * Math.cos(r);
                    var vec_y = DIG_RADIUS * Math.sin(r);
                    var x = void 0, y = void 0;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    }
                    else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }
        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    };
    Main_poly.prototype._touchEnd = function (touch) {
        this._touchStartPos = undefined;
    };
    Main_poly.prototype.reset = function () {
        var ww = this.node_dirty.width;
        var hh = this.node_dirty.height;
        // this.polyEx.init([
        //     [cc.v2(-ww / 2, -hh / 2), cc.v2(-ww / 2, hh / 2), cc.v2(ww / 2, hh / 2), cc.v2(ww / 2, -hh / 2)]
        // ]);
        this.polyEx.init([
            [cc.v2(-200, 200), cc.v2(200, 200), cc.v2(200, 0), cc.v2(0, -100), cc.v2(-200, 0)]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    };
    Main_poly.prototype.debug = function () {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    };
    __decorate([
        property(cc.Node)
    ], Main_poly.prototype, "node_dirty", void 0);
    __decorate([
        property(PhysicsPolygonColliderEx_1.default)
    ], Main_poly.prototype, "polyEx", void 0);
    __decorate([
        property(cc.Prefab)
    ], Main_poly.prototype, "water", void 0);
    Main_poly = __decorate([
        ccclass
    ], Main_poly);
    return Main_poly;
}(cc.Component));
exports.default = Main_poly;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/Shader/MetaBalls/MetaBallsRenderer.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6ea46IR6IRP/Z1ps3HwpFZl', 'MetaBallsRenderer');
// MetaBalls/Shader/MetaBalls/MetaBallsRenderer.ts

Object.defineProperty(exports, "__esModule", { value: true });
/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
//关键
var MetaBallsAssembler_1 = require("./MetaBallsAssembler");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
//继承cc.Sprite
var MetaBallsRenderer = /** @class */ (function (_super) {
    __extends(MetaBallsRenderer, _super);
    function MetaBallsRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.materialWeb = null;
        _this.materialNative = null;
        return _this;
    }
    MetaBallsRenderer.prototype.onLoad = function () {
        //根据是否是客户端渲染选择设置web端材质或native材质
        if (CC_NATIVERENDERER) {
            this.materialNative && this.setMaterial(0, this.materialNative);
        }
        else {
            this.materialWeb && this.setMaterial(0, this.materialWeb);
        }
    };
    MetaBallsRenderer.prototype.SetParticles = function (particles) {
        //@ts-ignore
        //???
        this._assembler.particles = particles;
        //获得材质
        var material = this.getMaterial(0);
        if (particles && material) {
            var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
            if (CC_NATIVERENDERER) {
                // native渲染时以节点anchor为世界空间原点
                material.setProperty("offset", [0.5, 0.5]);
            }
            else {
                // web默认以左下为世界空间原点。两个平台内shader内通过offset实现坐标统一
                material.setProperty("offset", [0.0, 0.0]);
            }
            // particles.GetRadius() * PTM_RATIO 是相对于场景(世界空间)的大小
            // particles.GetRadius() * PTM_RATIO / this.node.width 是相对于纹理的大小(纹理和屏幕同宽)，范围[0, 1]
            material.setProperty("radius", particles.GetRadius() * PTM_RATIO / this.node.width);
            material.setProperty("yratio", this.node.height / this.node.width);
            material.setProperty("reverseRes", [1.0 / this.node.width, 1.0 / this.node.height]);
        }
        this.setVertsDirty();
    };
    MetaBallsRenderer.prototype._resetAssembler = function () {
        this.setVertsDirty();
        var assembler = this._assembler = new MetaBallsAssembler_1.default();
        assembler.init(this);
    };
    MetaBallsRenderer.prototype.update = function () {
        this.setVertsDirty();
    };
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialWeb", void 0);
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialNative", void 0);
    MetaBallsRenderer = __decorate([
        ccclass
    ], MetaBallsRenderer);
    return MetaBallsRenderer;
}(cc.Sprite));
exports.default = MetaBallsRenderer;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/extend/extend1/polybool.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '215c4mH5gxCwp9Osx4SrCDD', 'polybool');
// extend/extend1/polybool.js

"use strict";

(function e(t, n, r) {
  function s(o, u) {
    if (!n[o]) {
      if (!t[o]) {
        var a = typeof require == "function" && require;
        if (!u && a) return a(o, !0);
        if (i) return i(o, !0);
        var f = new Error("Cannot find module '" + o + "'");
        throw f.code = "MODULE_NOT_FOUND", f;
      }

      var l = n[o] = {
        exports: {}
      };
      t[o][0].call(l.exports, function (e) {
        var n = t[o][1][e];
        return s(n ? n : e);
      }, l, l.exports, e, t, n, r);
    }

    return n[o].exports;
  }

  var i = typeof require == "function" && require;

  for (var o = 0; o < r.length; o++) {
    s(r[o]);
  }

  return s;
})({
  1: [function (require, module, exports) {
    /*
     * @copyright 2016 Sean Connelly (@voidqk), http://syntheti.cc
     * @license MIT
     * @preserve Project Home: https://github.com/voidqk/polybooljs
     */
    var BuildLog = require('./lib/build-log');

    var Epsilon = require('./lib/epsilon');

    var Intersecter = require('./lib/intersecter');

    var SegmentChainer = require('./lib/segment-chainer');

    var SegmentSelector = require('./lib/segment-selector');

    var GeoJSON = require('./lib/geojson');

    var _buildLog = false;

    var _epsilon = Epsilon();

    var PolyBool;
    PolyBool = {
      // getter/setter for buildLog
      buildLog: function buildLog(bl) {
        if (bl === true) _buildLog = BuildLog();else if (bl === false) _buildLog = false;
        return _buildLog === false ? false : _buildLog.list;
      },
      // getter/setter for epsilon
      epsilon: function epsilon(v) {
        return _epsilon.epsilon(v);
      },
      // core API
      segments: function segments(poly) {
        var i = Intersecter(true, _epsilon, _buildLog);
        poly.regions.forEach(i.addRegion);
        return {
          segments: i.calculate(poly.inverted),
          inverted: poly.inverted
        };
      },
      combine: function combine(segments1, segments2) {
        var i3 = Intersecter(false, _epsilon, _buildLog);
        return {
          combined: i3.calculate(segments1.segments, segments1.inverted, segments2.segments, segments2.inverted),
          inverted1: segments1.inverted,
          inverted2: segments2.inverted
        };
      },
      selectUnion: function selectUnion(combined) {
        return {
          segments: SegmentSelector.union(combined.combined, _buildLog),
          inverted: combined.inverted1 || combined.inverted2
        };
      },
      selectIntersect: function selectIntersect(combined) {
        return {
          segments: SegmentSelector.intersect(combined.combined, _buildLog),
          inverted: combined.inverted1 && combined.inverted2
        };
      },
      selectDifference: function selectDifference(combined) {
        return {
          segments: SegmentSelector.difference(combined.combined, _buildLog),
          inverted: combined.inverted1 && !combined.inverted2
        };
      },
      selectDifferenceRev: function selectDifferenceRev(combined) {
        return {
          segments: SegmentSelector.differenceRev(combined.combined, _buildLog),
          inverted: !combined.inverted1 && combined.inverted2
        };
      },
      selectXor: function selectXor(combined) {
        return {
          segments: SegmentSelector.xor(combined.combined, _buildLog),
          inverted: combined.inverted1 !== combined.inverted2
        };
      },
      polygon: function polygon(segments) {
        return {
          regions: SegmentChainer(segments.segments, _epsilon, _buildLog),
          inverted: segments.inverted
        };
      },
      // GeoJSON converters
      polygonFromGeoJSON: function polygonFromGeoJSON(geojson) {
        return GeoJSON.toPolygon(PolyBool, geojson);
      },
      polygonToGeoJSON: function polygonToGeoJSON(poly) {
        return GeoJSON.fromPolygon(PolyBool, _epsilon, poly);
      },
      // helper functions for common operations
      union: function union(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectUnion);
      },
      intersect: function intersect(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectIntersect);
      },
      difference: function difference(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectDifference);
      },
      differenceRev: function differenceRev(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectDifferenceRev);
      },
      xor: function xor(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectXor);
      }
    };

    function operate(poly1, poly2, selector) {
      var seg1 = PolyBool.segments(poly1);
      var seg2 = PolyBool.segments(poly2);
      var comb = PolyBool.combine(seg1, seg2);
      var seg3 = selector(comb);
      return PolyBool.polygon(seg3);
    }

    if (typeof window === 'object') window.PolyBool = PolyBool;
    module.exports = PolyBool;
  }, {
    "./lib/build-log": 2,
    "./lib/epsilon": 3,
    "./lib/geojson": 4,
    "./lib/intersecter": 5,
    "./lib/segment-chainer": 7,
    "./lib/segment-selector": 8
  }],
  2: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // used strictly for logging the processing of the algorithm... only useful if you intend on
    // looking under the covers (for pretty UI's or debugging)
    //
    function BuildLog() {
      var my;
      var nextSegmentId = 0;
      var curVert = false;

      function push(type, data) {
        my.list.push({
          type: type,
          data: data ? JSON.parse(JSON.stringify(data)) : void 0
        });
        return my;
      }

      my = {
        list: [],
        segmentId: function segmentId() {
          return nextSegmentId++;
        },
        checkIntersection: function checkIntersection(seg1, seg2) {
          return push('check', {
            seg1: seg1,
            seg2: seg2
          });
        },
        segmentChop: function segmentChop(seg, end) {
          push('div_seg', {
            seg: seg,
            pt: end
          });
          return push('chop', {
            seg: seg,
            pt: end
          });
        },
        statusRemove: function statusRemove(seg) {
          return push('pop_seg', {
            seg: seg
          });
        },
        segmentUpdate: function segmentUpdate(seg) {
          return push('seg_update', {
            seg: seg
          });
        },
        segmentNew: function segmentNew(seg, primary) {
          return push('new_seg', {
            seg: seg,
            primary: primary
          });
        },
        segmentRemove: function segmentRemove(seg) {
          return push('rem_seg', {
            seg: seg
          });
        },
        tempStatus: function tempStatus(seg, above, below) {
          return push('temp_status', {
            seg: seg,
            above: above,
            below: below
          });
        },
        rewind: function rewind(seg) {
          return push('rewind', {
            seg: seg
          });
        },
        status: function status(seg, above, below) {
          return push('status', {
            seg: seg,
            above: above,
            below: below
          });
        },
        vert: function vert(x) {
          if (x === curVert) return my;
          curVert = x;
          return push('vert', {
            x: x
          });
        },
        log: function log(data) {
          if (typeof data !== 'string') data = JSON.stringify(data, false, '  ');
          return push('log', {
            txt: data
          });
        },
        reset: function reset() {
          return push('reset');
        },
        selected: function selected(segs) {
          return push('selected', {
            segs: segs
          });
        },
        chainStart: function chainStart(seg) {
          return push('chain_start', {
            seg: seg
          });
        },
        chainRemoveHead: function chainRemoveHead(index, pt) {
          return push('chain_rem_head', {
            index: index,
            pt: pt
          });
        },
        chainRemoveTail: function chainRemoveTail(index, pt) {
          return push('chain_rem_tail', {
            index: index,
            pt: pt
          });
        },
        chainNew: function chainNew(pt1, pt2) {
          return push('chain_new', {
            pt1: pt1,
            pt2: pt2
          });
        },
        chainMatch: function chainMatch(index) {
          return push('chain_match', {
            index: index
          });
        },
        chainClose: function chainClose(index) {
          return push('chain_close', {
            index: index
          });
        },
        chainAddHead: function chainAddHead(index, pt) {
          return push('chain_add_head', {
            index: index,
            pt: pt
          });
        },
        chainAddTail: function chainAddTail(index, pt) {
          return push('chain_add_tail', {
            index: index,
            pt: pt
          });
        },
        chainConnect: function chainConnect(index1, index2) {
          return push('chain_con', {
            index1: index1,
            index2: index2
          });
        },
        chainReverse: function chainReverse(index) {
          return push('chain_rev', {
            index: index
          });
        },
        chainJoin: function chainJoin(index1, index2) {
          return push('chain_join', {
            index1: index1,
            index2: index2
          });
        },
        done: function done() {
          return push('done');
        }
      };
      return my;
    }

    module.exports = BuildLog;
  }, {}],
  3: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // provides the raw computation functions that takes epsilon into account
    //
    // zero is defined to be between (-epsilon, epsilon) exclusive
    //
    function Epsilon(eps) {
      if (typeof eps !== 'number') eps = 0.0000000001; // sane default? sure why not

      var my = {
        epsilon: function epsilon(v) {
          if (typeof v === 'number') eps = v;
          return eps;
        },
        pointAboveOrOnLine: function pointAboveOrOnLine(pt, left, right) {
          var Ax = left[0];
          var Ay = left[1];
          var Bx = right[0];
          var By = right[1];
          var Cx = pt[0];
          var Cy = pt[1];
          return (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) >= -eps;
        },
        pointBetween: function pointBetween(p, left, right) {
          // p must be collinear with left->right
          // returns false if p == left, p == right, or left == right
          var d_py_ly = p[1] - left[1];
          var d_rx_lx = right[0] - left[0];
          var d_px_lx = p[0] - left[0];
          var d_ry_ly = right[1] - left[1];
          var dot = d_px_lx * d_rx_lx + d_py_ly * d_ry_ly; // if `dot` is 0, then `p` == `left` or `left` == `right` (reject)
          // if `dot` is less than 0, then `p` is to the left of `left` (reject)

          if (dot < eps) return false;
          var sqlen = d_rx_lx * d_rx_lx + d_ry_ly * d_ry_ly; // if `dot` > `sqlen`, then `p` is to the right of `right` (reject)
          // therefore, if `dot - sqlen` is greater than 0, then `p` is to the right of `right` (reject)

          if (dot - sqlen > -eps) return false;
          return true;
        },
        pointsSameX: function pointsSameX(p1, p2) {
          return Math.abs(p1[0] - p2[0]) < eps;
        },
        pointsSameY: function pointsSameY(p1, p2) {
          return Math.abs(p1[1] - p2[1]) < eps;
        },
        pointsSame: function pointsSame(p1, p2) {
          return my.pointsSameX(p1, p2) && my.pointsSameY(p1, p2);
        },
        pointsCompare: function pointsCompare(p1, p2) {
          // returns -1 if p1 is smaller, 1 if p2 is smaller, 0 if equal
          if (my.pointsSameX(p1, p2)) return my.pointsSameY(p1, p2) ? 0 : p1[1] < p2[1] ? -1 : 1;
          return p1[0] < p2[0] ? -1 : 1;
        },
        pointsCollinear: function pointsCollinear(pt1, pt2, pt3) {
          // does pt1->pt2->pt3 make a straight line?
          // essentially this is just checking to see if the slope(pt1->pt2) === slope(pt2->pt3)
          // if slopes are equal, then they must be collinear, because they share pt2
          var dx1 = pt1[0] - pt2[0];
          var dy1 = pt1[1] - pt2[1];
          var dx2 = pt2[0] - pt3[0];
          var dy2 = pt2[1] - pt3[1];
          return Math.abs(dx1 * dy2 - dx2 * dy1) < eps;
        },
        linesIntersect: function linesIntersect(a0, a1, b0, b1) {
          // returns false if the lines are coincident (e.g., parallel or on top of each other)
          //
          // returns an object if the lines intersect:
          //   {
          //     pt: [x, y],    where the intersection point is at
          //     alongA: where intersection point is along A,
          //     alongB: where intersection point is along B
          //   }
          //
          //  alongA and alongB will each be one of: -2, -1, 0, 1, 2
          //
          //  with the following meaning:
          //
          //    -2   intersection point is before segment's first point
          //    -1   intersection point is directly on segment's first point
          //     0   intersection point is between segment's first and second points (exclusive)
          //     1   intersection point is directly on segment's second point
          //     2   intersection point is after segment's second point
          var adx = a1[0] - a0[0];
          var ady = a1[1] - a0[1];
          var bdx = b1[0] - b0[0];
          var bdy = b1[1] - b0[1];
          var axb = adx * bdy - ady * bdx;
          if (Math.abs(axb) < eps) return false; // lines are coincident

          var dx = a0[0] - b0[0];
          var dy = a0[1] - b0[1];
          var A = (bdx * dy - bdy * dx) / axb;
          var B = (adx * dy - ady * dx) / axb;
          var ret = {
            alongA: 0,
            alongB: 0,
            pt: [a0[0] + A * adx, a0[1] + A * ady]
          }; // categorize where intersection point is along A and B

          if (A <= -eps) ret.alongA = -2;else if (A < eps) ret.alongA = -1;else if (A - 1 <= -eps) ret.alongA = 0;else if (A - 1 < eps) ret.alongA = 1;else ret.alongA = 2;
          if (B <= -eps) ret.alongB = -2;else if (B < eps) ret.alongB = -1;else if (B - 1 <= -eps) ret.alongB = 0;else if (B - 1 < eps) ret.alongB = 1;else ret.alongB = 2;
          return ret;
        },
        pointInsideRegion: function pointInsideRegion(pt, region) {
          var x = pt[0];
          var y = pt[1];
          var last_x = region[region.length - 1][0];
          var last_y = region[region.length - 1][1];
          var inside = false;

          for (var i = 0; i < region.length; i++) {
            var curr_x = region[i][0];
            var curr_y = region[i][1]; // if y is between curr_y and last_y, and
            // x is to the right of the boundary created by the line

            if (curr_y - y > eps != last_y - y > eps && (last_x - curr_x) * (y - curr_y) / (last_y - curr_y) + curr_x - x > eps) inside = !inside;
            last_x = curr_x;
            last_y = curr_y;
          }

          return inside;
        }
      };
      return my;
    }

    module.exports = Epsilon;
  }, {}],
  4: [function (require, module, exports) {
    // (c) Copyright 2017, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // convert between PolyBool polygon format and GeoJSON formats (Polygon and MultiPolygon)
    //
    var GeoJSON = {
      // convert a GeoJSON object to a PolyBool polygon
      toPolygon: function toPolygon(PolyBool, geojson) {
        // converts list of LineString's to segments
        function GeoPoly(coords) {
          // check for empty coords
          if (coords.length <= 0) return PolyBool.segments({
            inverted: false,
            regions: []
          }); // convert LineString to segments

          function LineString(ls) {
            // remove tail which should be the same as head
            var reg = ls.slice(0, ls.length - 1);
            return PolyBool.segments({
              inverted: false,
              regions: [reg]
            });
          } // the first LineString is considered the outside


          var out = LineString(coords[0]); // the rest of the LineStrings are considered interior holes, so subtract them from the
          // current result

          for (var i = 1; i < coords.length; i++) {
            out = PolyBool.selectDifference(PolyBool.combine(out, LineString(coords[i])));
          }

          return out;
        }

        if (geojson.type === 'Polygon') {
          // single polygon, so just convert it and we're done
          return PolyBool.polygon(GeoPoly(geojson.coordinates));
        } else if (geojson.type === 'MultiPolygon') {
          // multiple polygons, so union all the polygons together
          var out = PolyBool.segments({
            inverted: false,
            regions: []
          });

          for (var i = 0; i < geojson.coordinates.length; i++) {
            out = PolyBool.selectUnion(PolyBool.combine(out, GeoPoly(geojson.coordinates[i])));
          }

          return PolyBool.polygon(out);
        }

        throw new Error('PolyBool: Cannot convert GeoJSON object to PolyBool polygon');
      },
      // convert a PolyBool polygon to a GeoJSON object
      fromPolygon: function fromPolygon(PolyBool, eps, poly) {
        // make sure out polygon is clean
        poly = PolyBool.polygon(PolyBool.segments(poly)); // test if r1 is inside r2

        function regionInsideRegion(r1, r2) {
          // we're guaranteed no lines intersect (because the polygon is clean), but a vertex
          // could be on the edge -- so we just average pt[0] and pt[1] to produce a point on the
          // edge of the first line, which cannot be on an edge
          return eps.pointInsideRegion([(r1[0][0] + r1[1][0]) * 0.5, (r1[0][1] + r1[1][1]) * 0.5], r2);
        } // calculate inside heirarchy
        //
        //  _____________________   _______    roots -> A       -> F
        // |          A          | |   F   |            |          |
        // |  _______   _______  | |  ___  |            +-- B      +-- G
        // | |   B   | |   C   | | | |   | |            |   |
        // | |  ___  | |  ___  | | | |   | |            |   +-- D
        // | | | D | | | | E | | | | | G | |            |
        // | | |___| | | |___| | | | |   | |            +-- C
        // | |_______| |_______| | | |___| |                |
        // |_____________________| |_______|                +-- E


        function newNode(region) {
          return {
            region: region,
            children: []
          };
        }

        var roots = newNode(null);

        function addChild(root, region) {
          // first check if we're inside any children
          for (var i = 0; i < root.children.length; i++) {
            var child = root.children[i];

            if (regionInsideRegion(region, child.region)) {
              // we are, so insert inside them instead
              addChild(child, region);
              return;
            }
          } // not inside any children, so check to see if any children are inside us


          var node = newNode(region);

          for (var i = 0; i < root.children.length; i++) {
            var child = root.children[i];

            if (regionInsideRegion(child.region, region)) {
              // oops... move the child beneath us, and remove them from root
              node.children.push(child);
              root.children.splice(i, 1);
              i--;
            }
          } // now we can add ourselves


          root.children.push(node);
        } // add all regions to the root


        for (var i = 0; i < poly.regions.length; i++) {
          var region = poly.regions[i];
          if (region.length < 3) // regions must have at least 3 points (sanity check)
            continue;
          addChild(roots, region);
        } // with our heirarchy, we can distinguish between exterior borders, and interior holes
        // the root nodes are exterior, children are interior, children's children are exterior,
        // children's children's children are interior, etc
        // while we're at it, exteriors are counter-clockwise, and interiors are clockwise


        function forceWinding(region, clockwise) {
          // first, see if we're clockwise or counter-clockwise
          // https://en.wikipedia.org/wiki/Shoelace_formula
          var winding = 0;
          var last_x = region[region.length - 1][0];
          var last_y = region[region.length - 1][1];
          var copy = [];

          for (var i = 0; i < region.length; i++) {
            var curr_x = region[i][0];
            var curr_y = region[i][1];
            copy.push([curr_x, curr_y]); // create a copy while we're at it

            winding += curr_y * last_x - curr_x * last_y;
            last_x = curr_x;
            last_y = curr_y;
          } // this assumes Cartesian coordinates (Y is positive going up)


          var isclockwise = winding < 0;
          if (isclockwise !== clockwise) copy.reverse(); // while we're here, the last point must be the first point...

          copy.push([copy[0][0], copy[0][1]]);
          return copy;
        }

        var geopolys = [];

        function addExterior(node) {
          var poly = [forceWinding(node.region, false)];
          geopolys.push(poly); // children of exteriors are interior

          for (var i = 0; i < node.children.length; i++) {
            poly.push(getInterior(node.children[i]));
          }
        }

        function getInterior(node) {
          // children of interiors are exterior
          for (var i = 0; i < node.children.length; i++) {
            addExterior(node.children[i]);
          } // return the clockwise interior


          return forceWinding(node.region, true);
        } // root nodes are exterior


        for (var i = 0; i < roots.children.length; i++) {
          addExterior(roots.children[i]);
        } // lastly, construct the approrpriate GeoJSON object


        if (geopolys.length <= 0) // empty GeoJSON Polygon
          return {
            type: 'Polygon',
            coordinates: []
          };
        if (geopolys.length == 1) // use a GeoJSON Polygon
          return {
            type: 'Polygon',
            coordinates: geopolys[0]
          };
        return {
          // otherwise, use a GeoJSON MultiPolygon
          type: 'MultiPolygon',
          coordinates: geopolys
        };
      }
    };
    module.exports = GeoJSON;
  }, {}],
  5: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // this is the core work-horse
    //
    var LinkedList = require('./linked-list');

    function Intersecter(selfIntersection, eps, buildLog) {
      // selfIntersection is true/false depending on the phase of the overall algorithm
      //
      // segment creation
      //
      function segmentNew(start, end) {
        return {
          id: buildLog ? buildLog.segmentId() : -1,
          start: start,
          end: end,
          myFill: {
            above: null,
            // is there fill above us?
            below: null // is there fill below us?

          },
          otherFill: null
        };
      }

      function segmentCopy(start, end, seg) {
        return {
          id: buildLog ? buildLog.segmentId() : -1,
          start: start,
          end: end,
          myFill: {
            above: seg.myFill.above,
            below: seg.myFill.below
          },
          otherFill: null
        };
      } //
      // event logic
      //


      var event_root = LinkedList.create();

      function eventCompare(p1_isStart, p1_1, p1_2, p2_isStart, p2_1, p2_2) {
        // compare the selected points first
        var comp = eps.pointsCompare(p1_1, p2_1);
        if (comp !== 0) return comp; // the selected points are the same

        if (eps.pointsSame(p1_2, p2_2)) // if the non-selected points are the same too...
          return 0; // then the segments are equal

        if (p1_isStart !== p2_isStart) // if one is a start and the other isn't...
          return p1_isStart ? 1 : -1; // favor the one that isn't the start
        // otherwise, we'll have to calculate which one is below the other manually

        return eps.pointAboveOrOnLine(p1_2, p2_isStart ? p2_1 : p2_2, // order matters
        p2_isStart ? p2_2 : p2_1) ? 1 : -1;
      }

      function eventAdd(ev, other_pt) {
        event_root.insertBefore(ev, function (here) {
          // should ev be inserted before here?
          var comp = eventCompare(ev.isStart, ev.pt, other_pt, here.isStart, here.pt, here.other.pt);
          return comp < 0;
        });
      }

      function eventAddSegmentStart(seg, primary) {
        var ev_start = LinkedList.node({
          isStart: true,
          pt: seg.start,
          seg: seg,
          primary: primary,
          other: null,
          status: null
        });
        eventAdd(ev_start, seg.end);
        return ev_start;
      }

      function eventAddSegmentEnd(ev_start, seg, primary) {
        var ev_end = LinkedList.node({
          isStart: false,
          pt: seg.end,
          seg: seg,
          primary: primary,
          other: ev_start,
          status: null
        });
        ev_start.other = ev_end;
        eventAdd(ev_end, ev_start.pt);
      }

      function eventAddSegment(seg, primary) {
        var ev_start = eventAddSegmentStart(seg, primary);
        eventAddSegmentEnd(ev_start, seg, primary);
        return ev_start;
      }

      function eventUpdateEnd(ev, end) {
        // slides an end backwards
        //   (start)------------(end)    to:
        //   (start)---(end)
        if (buildLog) buildLog.segmentChop(ev.seg, end);
        ev.other.remove();
        ev.seg.end = end;
        ev.other.pt = end;
        eventAdd(ev.other, ev.pt);
      }

      function eventDivide(ev, pt) {
        var ns = segmentCopy(pt, ev.seg.end, ev.seg);
        eventUpdateEnd(ev, pt);
        return eventAddSegment(ns, ev.primary);
      }

      function _calculate(primaryPolyInverted, secondaryPolyInverted) {
        // if selfIntersection is true then there is no secondary polygon, so that isn't used
        //
        // status logic
        //
        var status_root = LinkedList.create();

        function statusCompare(ev1, ev2) {
          var a1 = ev1.seg.start;
          var a2 = ev1.seg.end;
          var b1 = ev2.seg.start;
          var b2 = ev2.seg.end;

          if (eps.pointsCollinear(a1, b1, b2)) {
            if (eps.pointsCollinear(a2, b1, b2)) return 1; //eventCompare(true, a1, a2, true, b1, b2);

            return eps.pointAboveOrOnLine(a2, b1, b2) ? 1 : -1;
          }

          return eps.pointAboveOrOnLine(a1, b1, b2) ? 1 : -1;
        }

        function statusFindSurrounding(ev) {
          return status_root.findTransition(function (here) {
            var comp = statusCompare(ev, here.ev);
            return comp > 0;
          });
        }

        function checkIntersection(ev1, ev2) {
          // returns the segment equal to ev1, or false if nothing equal
          var seg1 = ev1.seg;
          var seg2 = ev2.seg;
          var a1 = seg1.start;
          var a2 = seg1.end;
          var b1 = seg2.start;
          var b2 = seg2.end;
          if (buildLog) buildLog.checkIntersection(seg1, seg2);
          var i = eps.linesIntersect(a1, a2, b1, b2);

          if (i === false) {
            // segments are parallel or coincident
            // if points aren't collinear, then the segments are parallel, so no intersections
            if (!eps.pointsCollinear(a1, a2, b1)) return false; // otherwise, segments are on top of each other somehow (aka coincident)

            if (eps.pointsSame(a1, b2) || eps.pointsSame(a2, b1)) return false; // segments touch at endpoints... no intersection

            var a1_equ_b1 = eps.pointsSame(a1, b1);
            var a2_equ_b2 = eps.pointsSame(a2, b2);
            if (a1_equ_b1 && a2_equ_b2) return ev2; // segments are exactly equal

            var a1_between = !a1_equ_b1 && eps.pointBetween(a1, b1, b2);
            var a2_between = !a2_equ_b2 && eps.pointBetween(a2, b1, b2); // handy for debugging:
            // buildLog.log({
            //	a1_equ_b1: a1_equ_b1,
            //	a2_equ_b2: a2_equ_b2,
            //	a1_between: a1_between,
            //	a2_between: a2_between
            // });

            if (a1_equ_b1) {
              if (a2_between) {
                //  (a1)---(a2)
                //  (b1)----------(b2)
                eventDivide(ev2, a2);
              } else {
                //  (a1)----------(a2)
                //  (b1)---(b2)
                eventDivide(ev1, b2);
              }

              return ev2;
            } else if (a1_between) {
              if (!a2_equ_b2) {
                // make a2 equal to b2
                if (a2_between) {
                  //         (a1)---(a2)
                  //  (b1)-----------------(b2)
                  eventDivide(ev2, a2);
                } else {
                  //         (a1)----------(a2)
                  //  (b1)----------(b2)
                  eventDivide(ev1, b2);
                }
              } //         (a1)---(a2)
              //  (b1)----------(b2)


              eventDivide(ev2, a1);
            }
          } else {
            // otherwise, lines intersect at i.pt, which may or may not be between the endpoints
            // is A divided between its endpoints? (exclusive)
            if (i.alongA === 0) {
              if (i.alongB === -1) // yes, at exactly b1
                eventDivide(ev1, b1);else if (i.alongB === 0) // yes, somewhere between B's endpoints
                eventDivide(ev1, i.pt);else if (i.alongB === 1) // yes, at exactly b2
                eventDivide(ev1, b2);
            } // is B divided between its endpoints? (exclusive)


            if (i.alongB === 0) {
              if (i.alongA === -1) // yes, at exactly a1
                eventDivide(ev2, a1);else if (i.alongA === 0) // yes, somewhere between A's endpoints (exclusive)
                eventDivide(ev2, i.pt);else if (i.alongA === 1) // yes, at exactly a2
                eventDivide(ev2, a2);
            }
          }

          return false;
        } //
        // main event loop
        //


        var segments = [];

        while (!event_root.isEmpty()) {
          var ev = event_root.getHead();
          if (buildLog) buildLog.vert(ev.pt[0]);

          if (ev.isStart) {
            var checkBothIntersections = function checkBothIntersections() {
              if (above) {
                var eve = checkIntersection(ev, above);
                if (eve) return eve;
              }

              if (below) return checkIntersection(ev, below);
              return false;
            };

            if (buildLog) buildLog.segmentNew(ev.seg, ev.primary);
            var surrounding = statusFindSurrounding(ev);
            var above = surrounding.before ? surrounding.before.ev : null;
            var below = surrounding.after ? surrounding.after.ev : null;

            if (buildLog) {
              buildLog.tempStatus(ev.seg, above ? above.seg : false, below ? below.seg : false);
            }

            var eve = checkBothIntersections();

            if (eve) {
              // ev and eve are equal
              // we'll keep eve and throw away ev
              // merge ev.seg's fill information into eve.seg
              if (selfIntersection) {
                var toggle; // are we a toggling edge?

                if (ev.seg.myFill.below === null) toggle = true;else toggle = ev.seg.myFill.above !== ev.seg.myFill.below; // merge two segments that belong to the same polygon
                // think of this as sandwiching two segments together, where `eve.seg` is
                // the bottom -- this will cause the above fill flag to toggle

                if (toggle) eve.seg.myFill.above = !eve.seg.myFill.above;
              } else {
                // merge two segments that belong to different polygons
                // each segment has distinct knowledge, so no special logic is needed
                // note that this can only happen once per segment in this phase, because we
                // are guaranteed that all self-intersections are gone
                eve.seg.otherFill = ev.seg.myFill;
              }

              if (buildLog) buildLog.segmentUpdate(eve.seg);
              ev.other.remove();
              ev.remove();
            }

            if (event_root.getHead() !== ev) {
              // something was inserted before us in the event queue, so loop back around and
              // process it before continuing
              if (buildLog) buildLog.rewind(ev.seg);
              continue;
            } //
            // calculate fill flags
            //


            if (selfIntersection) {
              var toggle; // are we a toggling edge?

              if (ev.seg.myFill.below === null) // if we are a new segment...
                toggle = true; // then we toggle
              else // we are a segment that has previous knowledge from a division
                toggle = ev.seg.myFill.above !== ev.seg.myFill.below; // calculate toggle
              // next, calculate whether we are filled below us

              if (!below) {
                // if nothing is below us...
                // we are filled below us if the polygon is inverted
                ev.seg.myFill.below = primaryPolyInverted;
              } else {
                // otherwise, we know the answer -- it's the same if whatever is below
                // us is filled above it
                ev.seg.myFill.below = below.seg.myFill.above;
              } // since now we know if we're filled below us, we can calculate whether
              // we're filled above us by applying toggle to whatever is below us


              if (toggle) ev.seg.myFill.above = !ev.seg.myFill.below;else ev.seg.myFill.above = ev.seg.myFill.below;
            } else {
              // now we fill in any missing transition information, since we are all-knowing
              // at this point
              if (ev.seg.otherFill === null) {
                // if we don't have other information, then we need to figure out if we're
                // inside the other polygon
                var inside;

                if (!below) {
                  // if nothing is below us, then we're inside if the other polygon is
                  // inverted
                  inside = ev.primary ? secondaryPolyInverted : primaryPolyInverted;
                } else {
                  // otherwise, something is below us
                  // so copy the below segment's other polygon's above
                  if (ev.primary === below.primary) inside = below.seg.otherFill.above;else inside = below.seg.myFill.above;
                }

                ev.seg.otherFill = {
                  above: inside,
                  below: inside
                };
              }
            }

            if (buildLog) {
              buildLog.status(ev.seg, above ? above.seg : false, below ? below.seg : false);
            } // insert the status and remember it for later removal


            ev.other.status = surrounding.insert(LinkedList.node({
              ev: ev
            }));
          } else {
            var st = ev.status;

            if (st === null) {
              throw new Error('PolyBool: Zero-length segment detected; your epsilon is ' + 'probably too small or too large');
            } // removing the status will create two new adjacent edges, so we'll need to check
            // for those


            if (status_root.exists(st.prev) && status_root.exists(st.next)) checkIntersection(st.prev.ev, st.next.ev);
            if (buildLog) buildLog.statusRemove(st.ev.seg); // remove the status

            st.remove(); // if we've reached this point, we've calculated everything there is to know, so
            // save the segment for reporting

            if (!ev.primary) {
              // make sure `seg.myFill` actually points to the primary polygon though
              var s = ev.seg.myFill;
              ev.seg.myFill = ev.seg.otherFill;
              ev.seg.otherFill = s;
            }

            segments.push(ev.seg);
          } // remove the event and continue


          event_root.getHead().remove();
        }

        if (buildLog) buildLog.done();
        return segments;
      } // return the appropriate API depending on what we're doing


      if (!selfIntersection) {
        // performing combination of polygons, so only deal with already-processed segments
        return {
          calculate: function calculate(segments1, inverted1, segments2, inverted2) {
            // segmentsX come from the self-intersection API, or this API
            // invertedX is whether we treat that list of segments as an inverted polygon or not
            // returns segments that can be used for further operations
            segments1.forEach(function (seg) {
              eventAddSegment(segmentCopy(seg.start, seg.end, seg), true);
            });
            segments2.forEach(function (seg) {
              eventAddSegment(segmentCopy(seg.start, seg.end, seg), false);
            });
            return _calculate(inverted1, inverted2);
          }
        };
      } // otherwise, performing self-intersection, so deal with regions


      return {
        addRegion: function addRegion(region) {
          // regions are a list of points:
          //  [ [0, 0], [100, 0], [50, 100] ]
          // you can add multiple regions before running calculate
          var pt1;
          var pt2 = region[region.length - 1];

          for (var i = 0; i < region.length; i++) {
            pt1 = pt2;
            pt2 = region[i];
            var forward = eps.pointsCompare(pt1, pt2);
            if (forward === 0) // points are equal, so we have a zero-length segment
              continue; // just skip it

            eventAddSegment(segmentNew(forward < 0 ? pt1 : pt2, forward < 0 ? pt2 : pt1), true);
          }
        },
        calculate: function calculate(inverted) {
          // is the polygon inverted?
          // returns segments
          return _calculate(inverted, false);
        }
      };
    }

    module.exports = Intersecter;
  }, {
    "./linked-list": 6
  }],
  6: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // simple linked list implementation that allows you to traverse down nodes and save positions
    //
    var LinkedList = {
      create: function create() {
        var my = {
          root: {
            root: true,
            next: null
          },
          exists: function exists(node) {
            if (node === null || node === my.root) return false;
            return true;
          },
          isEmpty: function isEmpty() {
            return my.root.next === null;
          },
          getHead: function getHead() {
            return my.root.next;
          },
          insertBefore: function insertBefore(node, check) {
            var last = my.root;
            var here = my.root.next;

            while (here !== null) {
              if (check(here)) {
                node.prev = here.prev;
                node.next = here;
                here.prev.next = node;
                here.prev = node;
                return;
              }

              last = here;
              here = here.next;
            }

            last.next = node;
            node.prev = last;
            node.next = null;
          },
          findTransition: function findTransition(check) {
            var prev = my.root;
            var here = my.root.next;

            while (here !== null) {
              if (check(here)) break;
              prev = here;
              here = here.next;
            }

            return {
              before: prev === my.root ? null : prev,
              after: here,
              insert: function insert(node) {
                node.prev = prev;
                node.next = here;
                prev.next = node;
                if (here !== null) here.prev = node;
                return node;
              }
            };
          }
        };
        return my;
      },
      node: function node(data) {
        data.prev = null;
        data.next = null;

        data.remove = function () {
          data.prev.next = data.next;
          if (data.next) data.next.prev = data.prev;
          data.prev = null;
          data.next = null;
        };

        return data;
      }
    };
    module.exports = LinkedList;
  }, {}],
  7: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // converts a list of segments into a list of regions, while also removing unnecessary verticies
    //
    function SegmentChainer(segments, eps, buildLog) {
      var chains = [];
      var regions = [];
      segments.forEach(function (seg) {
        var pt1 = seg.start;
        var pt2 = seg.end;

        if (eps.pointsSame(pt1, pt2)) {
          console.warn('PolyBool: Warning: Zero-length segment detected; your epsilon is ' + 'probably too small or too large');
          return;
        }

        if (buildLog) buildLog.chainStart(seg); // search for two chains that this segment matches

        var first_match = {
          index: 0,
          matches_head: false,
          matches_pt1: false
        };
        var second_match = {
          index: 0,
          matches_head: false,
          matches_pt1: false
        };
        var next_match = first_match;

        function setMatch(index, matches_head, matches_pt1) {
          // return true if we've matched twice
          next_match.index = index;
          next_match.matches_head = matches_head;
          next_match.matches_pt1 = matches_pt1;

          if (next_match === first_match) {
            next_match = second_match;
            return false;
          }

          next_match = null;
          return true; // we've matched twice, we're done here
        }

        for (var i = 0; i < chains.length; i++) {
          var chain = chains[i];
          var head = chain[0];
          var head2 = chain[1];
          var tail = chain[chain.length - 1];
          var tail2 = chain[chain.length - 2];

          if (eps.pointsSame(head, pt1)) {
            if (setMatch(i, true, true)) break;
          } else if (eps.pointsSame(head, pt2)) {
            if (setMatch(i, true, false)) break;
          } else if (eps.pointsSame(tail, pt1)) {
            if (setMatch(i, false, true)) break;
          } else if (eps.pointsSame(tail, pt2)) {
            if (setMatch(i, false, false)) break;
          }
        }

        if (next_match === first_match) {
          // we didn't match anything, so create a new chain
          chains.push([pt1, pt2]);
          if (buildLog) buildLog.chainNew(pt1, pt2);
          return;
        }

        if (next_match === second_match) {
          // we matched a single chain
          if (buildLog) buildLog.chainMatch(first_match.index); // add the other point to the apporpriate end, and check to see if we've closed the
          // chain into a loop

          var index = first_match.index;
          var pt = first_match.matches_pt1 ? pt2 : pt1; // if we matched pt1, then we add pt2, etc

          var addToHead = first_match.matches_head; // if we matched at head, then add to the head

          var chain = chains[index];
          var grow = addToHead ? chain[0] : chain[chain.length - 1];
          var grow2 = addToHead ? chain[1] : chain[chain.length - 2];
          var oppo = addToHead ? chain[chain.length - 1] : chain[0];
          var oppo2 = addToHead ? chain[chain.length - 2] : chain[1];

          if (eps.pointsCollinear(grow2, grow, pt)) {
            // grow isn't needed because it's directly between grow2 and pt:
            // grow2 ---grow---> pt
            if (addToHead) {
              if (buildLog) buildLog.chainRemoveHead(first_match.index, pt);
              chain.shift();
            } else {
              if (buildLog) buildLog.chainRemoveTail(first_match.index, pt);
              chain.pop();
            }

            grow = grow2; // old grow is gone... new grow is what grow2 was
          }

          if (eps.pointsSame(oppo, pt)) {
            // we're closing the loop, so remove chain from chains
            chains.splice(index, 1);

            if (eps.pointsCollinear(oppo2, oppo, grow)) {
              // oppo isn't needed because it's directly between oppo2 and grow:
              // oppo2 ---oppo--->grow
              if (addToHead) {
                if (buildLog) buildLog.chainRemoveTail(first_match.index, grow);
                chain.pop();
              } else {
                if (buildLog) buildLog.chainRemoveHead(first_match.index, grow);
                chain.shift();
              }
            }

            if (buildLog) buildLog.chainClose(first_match.index); // we have a closed chain!

            regions.push(chain);
            return;
          } // not closing a loop, so just add it to the apporpriate side


          if (addToHead) {
            if (buildLog) buildLog.chainAddHead(first_match.index, pt);
            chain.unshift(pt);
          } else {
            if (buildLog) buildLog.chainAddTail(first_match.index, pt);
            chain.push(pt);
          }

          return;
        } // otherwise, we matched two chains, so we need to combine those chains together


        function reverseChain(index) {
          if (buildLog) buildLog.chainReverse(index);
          chains[index].reverse(); // gee, that's easy
        }

        function appendChain(index1, index2) {
          // index1 gets index2 appended to it, and index2 is removed
          var chain1 = chains[index1];
          var chain2 = chains[index2];
          var tail = chain1[chain1.length - 1];
          var tail2 = chain1[chain1.length - 2];
          var head = chain2[0];
          var head2 = chain2[1];

          if (eps.pointsCollinear(tail2, tail, head)) {
            // tail isn't needed because it's directly between tail2 and head
            // tail2 ---tail---> head
            if (buildLog) buildLog.chainRemoveTail(index1, tail);
            chain1.pop();
            tail = tail2; // old tail is gone... new tail is what tail2 was
          }

          if (eps.pointsCollinear(tail, head, head2)) {
            // head isn't needed because it's directly between tail and head2
            // tail ---head---> head2
            if (buildLog) buildLog.chainRemoveHead(index2, head);
            chain2.shift();
          }

          if (buildLog) buildLog.chainJoin(index1, index2);
          chains[index1] = chain1.concat(chain2);
          chains.splice(index2, 1);
        }

        var F = first_match.index;
        var S = second_match.index;
        if (buildLog) buildLog.chainConnect(F, S);
        var reverseF = chains[F].length < chains[S].length; // reverse the shorter chain, if needed

        if (first_match.matches_head) {
          if (second_match.matches_head) {
            if (reverseF) {
              // <<<< F <<<< --- >>>> S >>>>
              reverseChain(F); // >>>> F >>>> --- >>>> S >>>>

              appendChain(F, S);
            } else {
              // <<<< F <<<< --- >>>> S >>>>
              reverseChain(S); // <<<< F <<<< --- <<<< S <<<<   logically same as:
              // >>>> S >>>> --- >>>> F >>>>

              appendChain(S, F);
            }
          } else {
            // <<<< F <<<< --- <<<< S <<<<   logically same as:
            // >>>> S >>>> --- >>>> F >>>>
            appendChain(S, F);
          }
        } else {
          if (second_match.matches_head) {
            // >>>> F >>>> --- >>>> S >>>>
            appendChain(F, S);
          } else {
            if (reverseF) {
              // >>>> F >>>> --- <<<< S <<<<
              reverseChain(F); // <<<< F <<<< --- <<<< S <<<<   logically same as:
              // >>>> S >>>> --- >>>> F >>>>

              appendChain(S, F);
            } else {
              // >>>> F >>>> --- <<<< S <<<<
              reverseChain(S); // >>>> F >>>> --- >>>> S >>>>

              appendChain(F, S);
            }
          }
        }
      });
      return regions;
    }

    module.exports = SegmentChainer;
  }, {}],
  8: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // filter a list of segments based on boolean operations
    //
    function select(segments, selection, buildLog) {
      var result = [];
      segments.forEach(function (seg) {
        var index = (seg.myFill.above ? 8 : 0) + (seg.myFill.below ? 4 : 0) + (seg.otherFill && seg.otherFill.above ? 2 : 0) + (seg.otherFill && seg.otherFill.below ? 1 : 0);

        if (selection[index] !== 0) {
          // copy the segment to the results, while also calculating the fill status
          result.push({
            id: buildLog ? buildLog.segmentId() : -1,
            start: seg.start,
            end: seg.end,
            myFill: {
              above: selection[index] === 1,
              // 1 if filled above
              below: selection[index] === 2 // 2 if filled below

            },
            otherFill: null
          });
        }
      });
      if (buildLog) buildLog.selected(result);
      return result;
    }

    var SegmentSelector = {
      union: function union(segments, buildLog) {
        // primary | secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   yes filled below    2
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   no                  0
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   yes filled above    1
        //    1      0      1      1   =>   no                  0
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   no                  0
        //    1      1      1      0   =>   no                  0
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 2, 2, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0], buildLog);
      },
      intersect: function intersect(segments, buildLog) {
        // primary & secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   no                  0
        //    0      0      1      0   =>   no                  0
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   no                  0
        //    0      1      0      1   =>   yes filled below    2
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   yes filled below    2
        //    1      0      0      0   =>   no                  0
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   yes filled above    1
        //    1      0      1      1   =>   yes filled above    1
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled below    2
        //    1      1      1      0   =>   yes filled above    1
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 1, 1, 0, 2, 1, 0], buildLog);
      },
      difference: function difference(segments, buildLog) {
        // primary - secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   no                  0
        //    0      0      1      0   =>   no                  0
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   yes filled below    2
        //    0      1      1      1   =>   no                  0
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   yes filled above    1
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   no                  0
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled above    1
        //    1      1      1      0   =>   yes filled below    2
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 0, 0, 0, 2, 0, 2, 0, 1, 1, 0, 0, 0, 1, 2, 0], buildLog);
      },
      differenceRev: function differenceRev(segments, buildLog) {
        // secondary - primary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   no                  0
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   yes filled above    1
        //    0      1      1      1   =>   yes filled above    1
        //    1      0      0      0   =>   no                  0
        //    1      0      0      1   =>   yes filled below    2
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   yes filled below    2
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   no                  0
        //    1      1      1      0   =>   no                  0
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 0, 0, 1, 1, 0, 2, 0, 2, 0, 0, 0, 0], buildLog);
      },
      xor: function xor(segments, buildLog) {
        // primary ^ secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   yes filled above    1
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   yes filled below    2
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled above    1
        //    1      1      1      0   =>   yes filled below    2
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 2, 0, 0, 1, 1, 0, 0, 2, 0, 1, 2, 0], buildLog);
      }
    };
    module.exports = SegmentSelector;
  }, {}]
}, {}, [1]);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__node_modules/constants-browserify/constants.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}module.exports = {
  "O_RDONLY": 0,
  "O_WRONLY": 1,
  "O_RDWR": 2,
  "S_IFMT": 61440,
  "S_IFREG": 32768,
  "S_IFDIR": 16384,
  "S_IFCHR": 8192,
  "S_IFBLK": 24576,
  "S_IFIFO": 4096,
  "S_IFLNK": 40960,
  "S_IFSOCK": 49152,
  "O_CREAT": 512,
  "O_EXCL": 2048,
  "O_NOCTTY": 131072,
  "O_TRUNC": 1024,
  "O_APPEND": 8,
  "O_DIRECTORY": 1048576,
  "O_NOFOLLOW": 256,
  "O_SYNC": 128,
  "O_SYMLINK": 2097152,
  "O_NONBLOCK": 4,
  "S_IRWXU": 448,
  "S_IRUSR": 256,
  "S_IWUSR": 128,
  "S_IXUSR": 64,
  "S_IRWXG": 56,
  "S_IRGRP": 32,
  "S_IWGRP": 16,
  "S_IXGRP": 8,
  "S_IRWXO": 7,
  "S_IROTH": 4,
  "S_IWOTH": 2,
  "S_IXOTH": 1,
  "E2BIG": 7,
  "EACCES": 13,
  "EADDRINUSE": 48,
  "EADDRNOTAVAIL": 49,
  "EAFNOSUPPORT": 47,
  "EAGAIN": 35,
  "EALREADY": 37,
  "EBADF": 9,
  "EBADMSG": 94,
  "EBUSY": 16,
  "ECANCELED": 89,
  "ECHILD": 10,
  "ECONNABORTED": 53,
  "ECONNREFUSED": 61,
  "ECONNRESET": 54,
  "EDEADLK": 11,
  "EDESTADDRREQ": 39,
  "EDOM": 33,
  "EDQUOT": 69,
  "EEXIST": 17,
  "EFAULT": 14,
  "EFBIG": 27,
  "EHOSTUNREACH": 65,
  "EIDRM": 90,
  "EILSEQ": 92,
  "EINPROGRESS": 36,
  "EINTR": 4,
  "EINVAL": 22,
  "EIO": 5,
  "EISCONN": 56,
  "EISDIR": 21,
  "ELOOP": 62,
  "EMFILE": 24,
  "EMLINK": 31,
  "EMSGSIZE": 40,
  "EMULTIHOP": 95,
  "ENAMETOOLONG": 63,
  "ENETDOWN": 50,
  "ENETRESET": 52,
  "ENETUNREACH": 51,
  "ENFILE": 23,
  "ENOBUFS": 55,
  "ENODATA": 96,
  "ENODEV": 19,
  "ENOENT": 2,
  "ENOEXEC": 8,
  "ENOLCK": 77,
  "ENOLINK": 97,
  "ENOMEM": 12,
  "ENOMSG": 91,
  "ENOPROTOOPT": 42,
  "ENOSPC": 28,
  "ENOSR": 98,
  "ENOSTR": 99,
  "ENOSYS": 78,
  "ENOTCONN": 57,
  "ENOTDIR": 20,
  "ENOTEMPTY": 66,
  "ENOTSOCK": 38,
  "ENOTSUP": 45,
  "ENOTTY": 25,
  "ENXIO": 6,
  "EOPNOTSUPP": 102,
  "EOVERFLOW": 84,
  "EPERM": 1,
  "EPIPE": 32,
  "EPROTO": 100,
  "EPROTONOSUPPORT": 43,
  "EPROTOTYPE": 41,
  "ERANGE": 34,
  "EROFS": 30,
  "ESPIPE": 29,
  "ESRCH": 3,
  "ESTALE": 70,
  "ETIME": 101,
  "ETIMEDOUT": 60,
  "ETXTBSY": 26,
  "EWOULDBLOCK": 35,
  "EXDEV": 18,
  "SIGHUP": 1,
  "SIGINT": 2,
  "SIGQUIT": 3,
  "SIGILL": 4,
  "SIGTRAP": 5,
  "SIGABRT": 6,
  "SIGIOT": 6,
  "SIGBUS": 10,
  "SIGFPE": 8,
  "SIGKILL": 9,
  "SIGUSR1": 30,
  "SIGSEGV": 11,
  "SIGUSR2": 31,
  "SIGPIPE": 13,
  "SIGALRM": 14,
  "SIGTERM": 15,
  "SIGCHLD": 20,
  "SIGCONT": 19,
  "SIGSTOP": 17,
  "SIGTSTP": 18,
  "SIGTTIN": 21,
  "SIGTTOU": 22,
  "SIGURG": 16,
  "SIGXCPU": 24,
  "SIGXFSZ": 25,
  "SIGVTALRM": 26,
  "SIGPROF": 27,
  "SIGWINCH": 28,
  "SIGIO": 23,
  "SIGSYS": 12,
  "SSL_OP_ALL": 2147486719,
  "SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION": 262144,
  "SSL_OP_CIPHER_SERVER_PREFERENCE": 4194304,
  "SSL_OP_CISCO_ANYCONNECT": 32768,
  "SSL_OP_COOKIE_EXCHANGE": 8192,
  "SSL_OP_CRYPTOPRO_TLSEXT_BUG": 2147483648,
  "SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS": 2048,
  "SSL_OP_EPHEMERAL_RSA": 0,
  "SSL_OP_LEGACY_SERVER_CONNECT": 4,
  "SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER": 32,
  "SSL_OP_MICROSOFT_SESS_ID_BUG": 1,
  "SSL_OP_MSIE_SSLV2_RSA_PADDING": 0,
  "SSL_OP_NETSCAPE_CA_DN_BUG": 536870912,
  "SSL_OP_NETSCAPE_CHALLENGE_BUG": 2,
  "SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG": 1073741824,
  "SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG": 8,
  "SSL_OP_NO_COMPRESSION": 131072,
  "SSL_OP_NO_QUERY_MTU": 4096,
  "SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION": 65536,
  "SSL_OP_NO_SSLv2": 16777216,
  "SSL_OP_NO_SSLv3": 33554432,
  "SSL_OP_NO_TICKET": 16384,
  "SSL_OP_NO_TLSv1": 67108864,
  "SSL_OP_NO_TLSv1_1": 268435456,
  "SSL_OP_NO_TLSv1_2": 134217728,
  "SSL_OP_PKCS1_CHECK_1": 0,
  "SSL_OP_PKCS1_CHECK_2": 0,
  "SSL_OP_SINGLE_DH_USE": 1048576,
  "SSL_OP_SINGLE_ECDH_USE": 524288,
  "SSL_OP_SSLEAY_080_CLIENT_DH_BUG": 128,
  "SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG": 0,
  "SSL_OP_TLS_BLOCK_PADDING_BUG": 512,
  "SSL_OP_TLS_D5_BUG": 256,
  "SSL_OP_TLS_ROLLBACK_BUG": 8388608,
  "ENGINE_METHOD_DSA": 2,
  "ENGINE_METHOD_DH": 4,
  "ENGINE_METHOD_RAND": 8,
  "ENGINE_METHOD_ECDH": 16,
  "ENGINE_METHOD_ECDSA": 32,
  "ENGINE_METHOD_CIPHERS": 64,
  "ENGINE_METHOD_DIGESTS": 128,
  "ENGINE_METHOD_STORE": 256,
  "ENGINE_METHOD_PKEY_METHS": 512,
  "ENGINE_METHOD_PKEY_ASN1_METHS": 1024,
  "ENGINE_METHOD_ALL": 65535,
  "ENGINE_METHOD_NONE": 0,
  "DH_CHECK_P_NOT_SAFE_PRIME": 2,
  "DH_CHECK_P_NOT_PRIME": 1,
  "DH_UNABLE_TO_CHECK_GENERATOR": 4,
  "DH_NOT_SUITABLE_GENERATOR": 8,
  "NPN_ENABLED": 1,
  "RSA_PKCS1_PADDING": 1,
  "RSA_SSLV23_PADDING": 2,
  "RSA_NO_PADDING": 3,
  "RSA_PKCS1_OAEP_PADDING": 4,
  "RSA_X931_PADDING": 5,
  "RSA_PKCS1_PSS_PADDING": 6,
  "POINT_CONVERSION_COMPRESSED": 2,
  "POINT_CONVERSION_UNCOMPRESSED": 4,
  "POINT_CONVERSION_HYBRID": 6,
  "F_OK": 0,
  "R_OK": 4,
  "W_OK": 2,
  "X_OK": 1,
  "UV_UDP_REUSEADDR": 4
}

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------
