
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/SceneMetaBalls.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b17b60sLRdNO7vhwJqbQ+NX', 'SceneMetaBalls');
// MetaBalls/SceneMetaBalls.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-13 02:44:16
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:01:57
*/
var MetaBallsRenderer_1 = require("./Shader/MetaBalls/MetaBallsRenderer");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var SceneMetaBalls = /** @class */ (function (_super) {
    __extends(SceneMetaBalls, _super);
    function SceneMetaBalls() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.waterRendererCamera = null;
        _this.waterRenderer = null;
        _this.waterRendererPass2 = null;
        _this.metaBallsRenderer = null;
        _this.particleBox = null;
        _this._world = null;
        _this._particles = null;
        _this._particleGroup = null;
        return _this;
    }
    SceneMetaBalls.prototype.onLoad = function () {
        //如果不是用编辑器打开项目
        if (!CC_EDITOR) {
            this.SetupWorld();
        }
        //渲染一张与水通道大小相同的图片
        var texture = new cc.RenderTexture();
        var size = this.waterRendererPass2.node.getContentSize();
        texture.initWithSize(size.width, size.height);
        var spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        //同简单摄像水渲染
        this.waterRendererCamera.targetTexture = texture;
        this.waterRendererPass2.spriteFrame = spriteFrame;
    };
    SceneMetaBalls.prototype.SetupWorld = function () {
        // enable physics manager
        var physicsManager = cc.director.getPhysicsManager();
        physicsManager.enabled = true;
        var world = this._world = physicsManager._world; // new b2.World(new b2.Vec2(0, -15.0));
        //粒子设置
        var psd = new b2.ParticleSystemDef();
        //半径
        psd.radius = 0.35;
        //阻尼
        // psd.dampingStrength = 1.5;
        //粘性力
        psd.viscousStrength = 0;
        //创建box2d粒子系统
        this._particles = world.CreateParticleSystem(psd);
    };
    SceneMetaBalls.prototype.CreateParticlesGroup = function () {
        //单位转换
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        //获得需要创建粒子盒子的的大小与位置
        var boxSize = this.particleBox.getContentSize();
        var boxPos = this.particleBox.getPosition();
        var size = cc.winSize;
        var box = new b2.PolygonShape();
        // https://google.github.io/liquidfun/API-Ref/html/classb2_polygon_shape.html#a890690250115483da6c7d69829be087e
        // Build vertices to represent an oriented box.
        // box的大小影响粒子的数量
        //设置一盒子粒子
        box.SetAsBox(boxSize.width / 2 / PTM_RATIO, boxSize.height / 2 / PTM_RATIO);
        //创建粒子组
        var particleGroupDef = new b2.ParticleGroupDef();
        particleGroupDef.shape = box;
        //选择流体粒子
        particleGroupDef.flags = b2.waterParticle;
        //设置位置
        particleGroupDef.position.Set((boxPos.x + size.width / 2) / PTM_RATIO, (boxPos.y + size.height / 2) / PTM_RATIO);
        //用粒子系统创建粒子组
        this._particleGroup = this._particles.CreateParticleGroup(particleGroupDef);
        //调用metaBallRenderer的方法设置渲染粒子组
        this.metaBallsRenderer.SetParticles(this._particles);
        //调用获得粒子组数量方法并将结果输出
        var vertsCount = this._particles.GetParticleCount();
        console.log(vertsCount);
    };
    //产生水
    SceneMetaBalls.prototype.GenerateWater = function () {
        //重置水
        this.ResetParticleGroup();
        // re-create particles in next tick
        // otherwise old particle system is not correctly released
        // this is a non-repeat schedule
        var that = this;
        cc.director.getScheduler().schedule(function () {
            that.CreateParticlesGroup();
        }, this.node, 0, 0, 0, false);
    };
    SceneMetaBalls.prototype.ResetParticleGroup = function () {
        if (this._particleGroup != null) {
            this._particleGroup.DestroyParticles(false);
            this._particles.DestroyParticleGroup(this._particleGroup);
            this._particleGroup = null;
        }
    };
    __decorate([
        property(cc.Camera)
    ], SceneMetaBalls.prototype, "waterRendererCamera", void 0);
    __decorate([
        property(cc.Node)
    ], SceneMetaBalls.prototype, "waterRenderer", void 0);
    __decorate([
        property(cc.Sprite)
    ], SceneMetaBalls.prototype, "waterRendererPass2", void 0);
    __decorate([
        property(MetaBallsRenderer_1.default)
    ], SceneMetaBalls.prototype, "metaBallsRenderer", void 0);
    __decorate([
        property(cc.Node)
    ], SceneMetaBalls.prototype, "particleBox", void 0);
    SceneMetaBalls = __decorate([
        ccclass
    ], SceneMetaBalls);
    return SceneMetaBalls;
}(cc.Component));
exports.default = SceneMetaBalls;
//???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????
var enableLowLevelOptimize = true;
if (enableLowLevelOptimize) {
    cc.game.once(cc.game.EVENT_ENGINE_INITED, function () {
        // b2ParticleSystem.prototype.FindContacts_Reference = function (contacts) {
        //@ts-ignore
        b2.ParticleSystem.prototype.FindContacts_Reference = function (contacts) {
            if (!this.m_flagsBuffer.data) {
                throw new Error();
            }
            if (!this.m_positionBuffer.data) {
                throw new Error();
            }
            var pos_data = this.m_positionBuffer.data;
            var squaredDiameter = this.m_squaredDiameter;
            var inverseDiameter = this.m_inverseDiameter;
            // DEBUG: b2Assert(contacts === this.m_contactBuffer);
            var beginProxy = 0;
            var endProxy = this.m_proxyBuffer.count;
            this.m_contactBuffer.count = 0;
            // let contactBuffer = this.m_contactBuffer;
            var proxyData = this.m_proxyBuffer.data;
            //@ts-ignore
            var computeRelativeTag = b2.ParticleSystem.computeRelativeTag;
            // var AddContact = this.AddContact2.bind(this);
            var dataA;
            var tagA = 0;
            var indexA = 0;
            var rightTag = 0;
            var dataB;
            var pos_data = this.m_positionBuffer.data;
            var flagBufferData = this.m_flagsBuffer.data;
            var flagBufferDataA;
            var indexB = 0;
            var pos_dataA;
            var pos_dataB;
            var ax = 0, ay = 0, bx = 0, by = 0, dx = 0, dy = 0;
            var distBtParticlesSq = 0;
            var bottomLeftTag = 0;
            var bottomRightTag = 0;
            var isFin = isFinite;
            for (var a = beginProxy, c = beginProxy; a < endProxy; ++a) {
                dataA = proxyData[a];
                tagA = dataA.tag;
                indexA = dataA.index;
                pos_dataA = pos_data[indexA];
                flagBufferDataA = flagBufferData[indexA];
                rightTag = computeRelativeTag(tagA, 1, 0);
                for (var b = a + 1; b < endProxy; ++b) {
                    dataB = proxyData[b];
                    if (rightTag < dataB.tag) {
                        break;
                    }
                    // ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                    indexB = dataB.index;
                    // pos_dataA = pos_data[indexA];
                    pos_dataB = pos_data[indexB];
                    // DEBUG: b2Assert(contacts === this.m_contactBuffer);
                    ///b2Vec2 d = m_positionBuffer.data[b] - m_positionBuffer.data[a];
                    bx = pos_dataB.x;
                    by = pos_dataB.y;
                    ax = pos_dataA.x;
                    ay = pos_dataA.y;
                    dx = bx - ax;
                    dy = by - ay;
                    // var d = b2.Vec2.SubVV(pos_data[b], pos_data[a], s_d);
                    distBtParticlesSq = dx * dx + dy * dy;
                    // var distBtParticlesSq = b2.Vec2.DotVV(d, d);
                    if (distBtParticlesSq < squaredDiameter) {
                        var invD = 1 / Math.sqrt(distBtParticlesSq);
                        // var invD = b2.InvSqrt(distBtParticlesSq);
                        if (!isFin(invD)) {
                            invD = 1.98177537e+019;
                        }
                        ///b2ParticleContact& contact = contacts.Append();
                        var contact = this.m_contactBuffer.data[this.m_contactBuffer.Append()];
                        contact.indexA = indexA;
                        contact.indexB = indexB;
                        contact.flags = flagBufferDataA | flagBufferData[indexB];
                        contact.weight = 1 - distBtParticlesSq * invD * inverseDiameter;
                        ///contact.SetNormal(invD * d);
                        contact.normal.x = invD * dx;
                        contact.normal.y = invD * dy;
                        // b2.Vec2.MulSV(invD, d, contact.normal);
                    }
                    // end ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                }
                bottomLeftTag = computeRelativeTag(tagA, -1, 1);
                for (; c < endProxy; ++c) {
                    if (bottomLeftTag <= proxyData[c].tag) {
                        break;
                    }
                }
                bottomRightTag = computeRelativeTag(tagA, 1, 1);
                for (var b = c; b < endProxy; ++b) {
                    dataB = proxyData[b];
                    if (bottomRightTag < dataB.tag) {
                        break;
                    }
                    // ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                    indexB = dataB.index;
                    // pos_dataA = pos_data[indexA];
                    pos_dataB = pos_data[indexB];
                    // DEBUG: b2Assert(contacts === this.m_contactBuffer);
                    ///b2Vec2 d = m_positionBuffer.data[b] - m_positionBuffer.data[a];
                    bx = pos_dataB.x;
                    by = pos_dataB.y;
                    ax = pos_dataA.x;
                    ay = pos_dataA.y;
                    dx = bx - ax;
                    dy = by - ay;
                    // var d = b2.Vec2.SubVV(pos_data[b], pos_data[a], s_d);
                    distBtParticlesSq = dx * dx + dy * dy;
                    // var distBtParticlesSq = b2.Vec2.DotVV(d, d);
                    if (distBtParticlesSq < squaredDiameter) {
                        var invD = 1 / Math.sqrt(distBtParticlesSq);
                        // var invD = b2.InvSqrt(distBtParticlesSq);
                        if (!isFin(invD)) {
                            invD = 1.98177537e+019;
                        }
                        ///b2ParticleContact& contact = contacts.Append();
                        var contact = this.m_contactBuffer.data[this.m_contactBuffer.Append()];
                        contact.indexA = indexA;
                        contact.indexB = indexB;
                        contact.flags = flagBufferDataA | flagBufferData[indexB];
                        contact.weight = 1 - distBtParticlesSq * invD * inverseDiameter;
                        ///contact.SetNormal(invD * d);
                        contact.normal.x = invD * dx;
                        contact.normal.y = invD * dy;
                        // b2.Vec2.MulSV(invD, d, contact.normal);
                    }
                    // end ------- AddContact(indexA, proxyData[b].index, contactBuffer);
                }
            }
        };
    });
}

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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