
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/Shader/MetaBalls/MetaBallsAssembler.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '2de294hRf5H146xfV0OKHOA', 'MetaBallsAssembler');
// MetaBalls/Shader/MetaBalls/MetaBallsAssembler.ts

/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-ignore
var gfx = cc.gfx;
var vfmtPosCenterWeb = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var vfmtPosCenterNative = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_corner", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var MetaBallsAssembler = /** @class */ (function (_super) {
    __extends(MetaBallsAssembler, _super);
    function MetaBallsAssembler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.verticesCount = 0;
        _this.indicesCount = 0;
        _this.floatsPerVert = CC_NATIVERENDERER ? 6 : 4;
        _this._renderData = null;
        _this._prevVerticesCount = 0;
        return _this;
    }
    MetaBallsAssembler.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
    };
    // initData() {
    //     // do nothing
    // }
    MetaBallsAssembler.prototype.updateColor = function (comp, color) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateUVs = function (comp) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateVerts = function (comp) {
        if (!CC_NATIVERENDERER) {
            // web模式直接在fillbuffer里做所有操作，不经过RenderData缓存
            return;
        }
        var particles = this.particles;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        var particleCount = this.particles.GetParticleCount();
        var verts = this._renderData.vDatas[0];
        var xoffset = comp.node.width * comp.node.anchorX;
        var yoffset = comp.node.height * comp.node.anchorY;
        // fill vertices
        // 暂时不考虑buffer满的情况
        var vertexOffset = 0;
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO - xoffset;
            var y = posBuff[i].y * PTM_RATIO - yoffset;
            // left-bottom
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-bottom
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // left-top
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-top
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
        }
    };
    MetaBallsAssembler.prototype.updateRenderData = function (comp) {
        var _a;
        if (!CC_NATIVERENDERER) {
            return;
        }
        var particleCount = (_a = this.particles) === null || _a === void 0 ? void 0 : _a.GetParticleCount();
        if (!particleCount)
            return;
        if (this._prevVerticesCount != particleCount) {
            this._prevVerticesCount = particleCount;
            // rebuild render data
            this.verticesCount = particleCount * 4;
            this.indicesCount = particleCount * 6;
            var data = this._renderData;
            data.createFlexData(0, this.verticesCount, this.indicesCount, this.getVfmt());
            var indices = data.iDatas[0];
            var count = indices.length / 6;
            for (var i = 0, idx = 0; i < count; i++) {
                var vertextID = i * 4;
                indices[idx++] = vertextID;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 2;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 3;
                indices[idx++] = vertextID + 2;
            }
        }
        if (comp._vertsDirty) {
            this.updateVerts(comp);
            comp._vertsDirty = false;
        }
    };
    MetaBallsAssembler.prototype.getVfmt = function () {
        if (CC_NATIVERENDERER)
            return vfmtPosCenterNative;
        return vfmtPosCenterWeb;
    };
    MetaBallsAssembler.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
    };
    MetaBallsAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (CC_NATIVERENDERER) {
            // 仅对web实现
            // native由于fillBuffer实现在了C++层，需要使用RenderData做缓存
            return;
        }
        var particles = this.particles;
        var particleCount = particles === null || particles === void 0 ? void 0 : particles.GetParticleCount();
        if (!particleCount)
            return;
        // TODO: 简化为按照三角形渲染
        var verticesCount = particleCount * 4;
        var indicesCount = particleCount * 6;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        //@ts-ignore
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(verticesCount, indicesCount);
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        // fill vertices
        // 暂时不考虑buffer满的情况
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO;
            var y = posBuff[i].y * PTM_RATIO;
            // left-bottom
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-bottom
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // left-top
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-top
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
        }
        // 仅当顶点索引发生变化时计算? 
        // vertexOffset是动态的，每一帧都有可能有差异，无法批量拷贝
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0; i < particleCount; ++i) {
            ibuf[indiceOffset++] = vertexId;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 2;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 3;
            ibuf[indiceOffset++] = vertexId + 2;
            vertexId += 4;
        }
    };
    return MetaBallsAssembler;
}(cc.Assembler));
exports.default = MetaBallsAssembler;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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