
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/MetaBalls/Shader/MetaBalls/MetaBallsRenderer.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6ea46IR6IRP/Z1ps3HwpFZl', 'MetaBallsRenderer');
// MetaBalls/Shader/MetaBalls/MetaBallsRenderer.ts

Object.defineProperty(exports, "__esModule", { value: true });
/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
//关键
var MetaBallsAssembler_1 = require("./MetaBallsAssembler");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
//继承cc.Sprite
var MetaBallsRenderer = /** @class */ (function (_super) {
    __extends(MetaBallsRenderer, _super);
    function MetaBallsRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.materialWeb = null;
        _this.materialNative = null;
        return _this;
    }
    MetaBallsRenderer.prototype.onLoad = function () {
        //根据是否是客户端渲染选择设置web端材质或native材质
        if (CC_NATIVERENDERER) {
            this.materialNative && this.setMaterial(0, this.materialNative);
        }
        else {
            this.materialWeb && this.setMaterial(0, this.materialWeb);
        }
    };
    MetaBallsRenderer.prototype.SetParticles = function (particles) {
        //@ts-ignore
        //???
        this._assembler.particles = particles;
        //获得材质
        var material = this.getMaterial(0);
        if (particles && material) {
            var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
            if (CC_NATIVERENDERER) {
                // native渲染时以节点anchor为世界空间原点
                material.setProperty("offset", [0.5, 0.5]);
            }
            else {
                // web默认以左下为世界空间原点。两个平台内shader内通过offset实现坐标统一
                material.setProperty("offset", [0.0, 0.0]);
            }
            // particles.GetRadius() * PTM_RATIO 是相对于场景(世界空间)的大小
            // particles.GetRadius() * PTM_RATIO / this.node.width 是相对于纹理的大小(纹理和屏幕同宽)，范围[0, 1]
            material.setProperty("radius", particles.GetRadius() * PTM_RATIO / this.node.width);
            material.setProperty("yratio", this.node.height / this.node.width);
            material.setProperty("reverseRes", [1.0 / this.node.width, 1.0 / this.node.height]);
        }
        this.setVertsDirty();
    };
    MetaBallsRenderer.prototype._resetAssembler = function () {
        this.setVertsDirty();
        var assembler = this._assembler = new MetaBallsAssembler_1.default();
        assembler.init(this);
    };
    MetaBallsRenderer.prototype.update = function () {
        this.setVertsDirty();
    };
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialWeb", void 0);
    __decorate([
        property(cc.Material)
    ], MetaBallsRenderer.prototype, "materialNative", void 0);
    MetaBallsRenderer = __decorate([
        ccclass
    ], MetaBallsRenderer);
    return MetaBallsRenderer;
}(cc.Sprite));
exports.default = MetaBallsRenderer;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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