
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Shader/GTAssembler2D.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '2177f2mlZhMmaFQsJ/uSd17', 'GTAssembler2D');
// shader/GTAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-13 02:44:17
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:43
*/
// 自定义渲染
// https://docs.cocos.com/creator/manual/zh/advanced-topics/custom-render.html#%E8%87%AA%E5%AE%9A%E4%B9%89-assembler
var GTAssembler2D = /** @class */ (function (_super) {
    __extends(GTAssembler2D, _super);
    function GTAssembler2D() {
        // 每个2d渲染单元里的有:
        // 4个顶点属性数据
        // 6个顶点索引 -> 三角剖分成2个三角形
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 每个顶点属性由5个32位数据组成
        // 顶点属性声明:
        // var vfmtPosUvColor = new gfx.VertexFormat([
        //     { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
        //     { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },       // 4个uint8
        // ]);
        // 顶点属性数据排列，每一格是32位 (float32/uint32)
        // x|y|u|v|color|x|y|u|v|color|...
        // 其中uv在一组数据中的偏移是2，color的偏移是4
        _this.verticesCount = 4;
        _this.indicesCount = 6;
        _this.floatsPerVert = 5;
        // vdata offset info
        _this.uvOffset = 2;
        _this.colorOffset = 4;
        _this._renderData = null;
        _this._local = null; // 中间结果。[l,b,r,t]。node对象左下、右上顶点的本地坐标，即相对于锚点的偏移
        return _this;
    }
    GTAssembler2D.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        // cc.Assembler2D的初始化放在constructor里
        // 此处把初始化放在init里，以便成员变量能够有机会修改
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
        this.initLocal();
        this.initData();
    };
    Object.defineProperty(GTAssembler2D.prototype, "verticesFloats", {
        get: function () {
            return this.verticesCount * this.floatsPerVert;
        },
        enumerable: false,
        configurable: true
    });
    GTAssembler2D.prototype.initData = function () {
        var data = this._renderData;
        data.createQuadData(0, this.verticesFloats, this.indicesCount);
        // createQuadData内部会调用initQuadIndices初始化索引信息
        // 如果是用用flexbuffer创建则需要自己初始化
    };
    GTAssembler2D.prototype.initLocal = function () {
        this._local = [];
        this._local.length = 4;
    };
    GTAssembler2D.prototype.updateColor = function (comp, color) {
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的color部分
        var uintVerts = this._renderData.uintVDatas[0];
        if (!uintVerts)
            return;
        color = color != null ? color : comp.node.color._val;
        var floatsPerVert = this.floatsPerVert;
        var colorOffset = this.colorOffset;
        for (var i = colorOffset, l = uintVerts.length; i < l; i += floatsPerVert) {
            uintVerts[i] = color;
        }
    };
    GTAssembler2D.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle._meshBuffer;
    };
    GTAssembler2D.prototype.updateWorldVerts = function (comp) {
        if (CC_NATIVERENDERER) {
            this.updateWorldVertsNative(comp);
        }
        else {
            this.updateWorldVertsWebGL(comp);
        }
    };
    GTAssembler2D.prototype.updateWorldVertsWebGL = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var matrix = comp.node._worldMatrix;
        var matrixm = matrix.m, a = matrixm[0], b = matrixm[1], c = matrixm[4], d = matrixm[5], tx = matrixm[12], ty = matrixm[13];
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        /*
        m00 = 1, m01 = 0, m02 = 0, m03 = 0,
        m04 = 0, m05 = 1, m06 = 0, m07 = 0,
        m08 = 0, m09 = 0, m10 = 1, m11 = 0,
        m12 = 0, m13 = 0, m14 = 0, m15 = 1
        */
        // [a,b,c,d] = _worldMatrix[1,2,4,5] == [1,0,0,1]
        // _worldMatrix[12,13]是xy的平移量
        // 即世界矩阵的左上角2x2是单元矩阵，说明在2D场景内没有出现旋转或者缩放
        var justTranslate = a === 1 && b === 0 && c === 0 && d === 1;
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的xy部分
        var index = 0;
        var floatsPerVert = this.floatsPerVert;
        if (justTranslate) {
            // left bottom
            verts[index] = vl + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = vr + tx;
            verts[index + 1] = vb + ty;
            index += floatsPerVert;
            // left top
            verts[index] = vl + tx;
            verts[index + 1] = vt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = vr + tx;
            verts[index + 1] = vt + ty;
        }
        else {
            // 4对xy分别乘以 [2,2]仿射矩阵，然后+平移量
            var al = a * vl, ar = a * vr, bl = b * vl, br = b * vr, cb = c * vb, ct = c * vt, db = d * vb, dt = d * vt;
            // left bottom
            // newx = vl * a + vb * c + tx
            // newy = vl * b + vb * d + ty
            verts[index] = al + cb + tx;
            verts[index + 1] = bl + db + ty;
            index += floatsPerVert;
            // right bottom
            verts[index] = ar + cb + tx;
            verts[index + 1] = br + db + ty;
            index += floatsPerVert;
            // left top
            verts[index] = al + ct + tx;
            verts[index + 1] = bl + dt + ty;
            index += floatsPerVert;
            // right top
            verts[index] = ar + ct + tx;
            verts[index + 1] = br + dt + ty;
        }
    };
    // native场景下使用的updateWorldVerts
    // copy from \jsb-adapter-master\engine\assemblers\assembler-2d.js
    GTAssembler2D.prototype.updateWorldVertsNative = function (comp) {
        var local = this._local;
        var verts = this._renderData.vDatas[0];
        var floatsPerVert = this.floatsPerVert;
        var vl = local[0], vr = local[2], vb = local[1], vt = local[3];
        var index = 0;
        // left bottom
        verts[index] = vl;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // right bottom
        verts[index] = vr;
        verts[index + 1] = vb;
        index += floatsPerVert;
        // left top
        verts[index] = vl;
        verts[index + 1] = vt;
        index += floatsPerVert;
        // right top
        verts[index] = vr;
        verts[index + 1] = vt;
    };
    // 将准备好的顶点数据填充进 VertexBuffer 和 IndiceBuffer
    GTAssembler2D.prototype.fillBuffers = function (comp, renderer) {
        if (renderer.worldMatDirty) {
            this.updateWorldVerts(comp);
        }
        var renderData = this._renderData;
        var vData = renderData.vDatas[0];
        var iData = renderData.iDatas[0];
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(this.verticesCount, this.indicesCount);
        // buffer data may be realloc, need get reference after request.
        // fill vertices
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        if (vData.length + vertexOffset > vbuf.length) {
            vbuf.set(vData.subarray(0, vbuf.length - vertexOffset), vertexOffset);
        }
        else {
            vbuf.set(vData, vertexOffset);
        }
        // fill indices
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0, l = iData.length; i < l; i++) {
            ibuf[indiceOffset++] = vertexId + iData[i];
        }
    };
    GTAssembler2D.prototype.packToDynamicAtlas = function (comp, frame) {
        if (CC_TEST)
            return;
        if (!frame._original && cc.dynamicAtlasManager && frame._texture.packable) {
            var packedFrame = cc.dynamicAtlasManager.insertSpriteFrame(frame);
            //@ts-ignore
            if (packedFrame) {
                frame._setDynamicAtlasFrame(packedFrame);
            }
        }
        var material = comp._materials[0];
        if (!material)
            return;
        if (material.getProperty('texture') !== frame._texture) {
            // texture was packed to dynamic atlas, should update uvs
            comp._vertsDirty = true;
            comp._updateMaterial();
        }
    };
    GTAssembler2D.prototype.updateUVs = function (comp) {
        // 4个顶点的uv坐标，对应左下、右下、左上、右上
        // 如果是cc.Sprite组件，这里取sprite._spriteFrame.uv;
        var uv = [0, 0, 1, 0, 0, 1, 1, 1];
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        // render data = verts = x|y|u|v|color|x|y|u|v|color|...
        // 填充render data中4个顶点的uv部分
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    GTAssembler2D.prototype.updateVerts = function (comp) {
        var node = comp.node, cw = node.width, ch = node.height, appx = node.anchorX * cw, appy = node.anchorY * ch, l, b, r, t;
        l = -appx;
        b = -appy;
        r = cw - appx;
        t = ch - appy;
        var local = this._local;
        local[0] = l;
        local[1] = b;
        local[2] = r;
        local[3] = t;
        this.updateWorldVerts(comp);
    };
    GTAssembler2D.prototype.updateRenderData = function (comp) {
        if (comp._vertsDirty) {
            this.updateUVs(comp);
            this.updateVerts(comp);
            comp._vertsDirty = false;
        }
    };
    return GTAssembler2D;
}(cc.Assembler));
exports.default = GTAssembler2D;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2hhZGVyXFxHVEFzc2VtYmxlcjJELnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7OztBQUFBLGdEQUFnRDtBQUNoRCw0QkFBNEI7QUFDNUIsK0NBQStDO0FBQy9DLGdFQUFnRTs7QUFFaEU7Ozs7RUFJRTtBQUVGLFFBQVE7QUFDUixvSEFBb0g7QUFDcEg7SUFBMkMsaUNBQVk7SUFBdkQ7UUFDSSxlQUFlO1FBQ2YsV0FBVztRQUNYLHVCQUF1QjtRQUgzQixxRUEyUkM7UUF0UkcsbUJBQW1CO1FBQ25CLFVBQVU7UUFDViw4Q0FBOEM7UUFDOUMsd0VBQXdFO1FBQ3hFLG1FQUFtRTtRQUNuRSxxR0FBcUc7UUFDckcsTUFBTTtRQUNOLG9DQUFvQztRQUNwQyxrQ0FBa0M7UUFDbEMsNkJBQTZCO1FBQzdCLG1CQUFhLEdBQUcsQ0FBQyxDQUFDO1FBQ2xCLGtCQUFZLEdBQUcsQ0FBQyxDQUFDO1FBQ2pCLG1CQUFhLEdBQUcsQ0FBQyxDQUFDO1FBRWxCLG9CQUFvQjtRQUNwQixjQUFRLEdBQUcsQ0FBQyxDQUFDO1FBQ2IsaUJBQVcsR0FBRyxDQUFDLENBQUM7UUFFTixpQkFBVyxHQUFrQixJQUFJLENBQUM7UUFDbEMsWUFBTSxHQUFRLElBQUksQ0FBQyxDQUFVLDhDQUE4Qzs7SUFtUXpGLENBQUM7SUFqUUcsNEJBQUksR0FBSixVQUFLLElBQXdCO1FBQ3pCLGlCQUFNLElBQUksWUFBQyxJQUFJLENBQUMsQ0FBQztRQUVqQixtQ0FBbUM7UUFDbkMsOEJBQThCO1FBQzlCLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxFQUFFLENBQUMsVUFBVSxFQUFFLENBQUM7UUFDdkMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFNUIsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUNwQixDQUFDO0lBRUQsc0JBQUkseUNBQWM7YUFBbEI7WUFDSSxPQUFPLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUNuRCxDQUFDOzs7T0FBQTtJQUVELGdDQUFRLEdBQVI7UUFDSSxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQzVCLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQy9ELDRDQUE0QztRQUM1Qyw0QkFBNEI7SUFDaEMsQ0FBQztJQUVELGlDQUFTLEdBQVQ7UUFDSSxJQUFJLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQztRQUNqQixJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUVELG1DQUFXLEdBQVgsVUFBWSxJQUFJLEVBQUUsS0FBSztRQUNuQix3REFBd0Q7UUFDeEQsNkJBQTZCO1FBQzdCLElBQUksU0FBUyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxTQUFTO1lBQUUsT0FBTztRQUN2QixLQUFLLEdBQUcsS0FBSyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDckQsSUFBSSxhQUFhLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN2QyxJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ25DLEtBQUssSUFBSSxDQUFDLEdBQUcsV0FBVyxFQUFFLENBQUMsR0FBRyxTQUFTLENBQUMsTUFBTSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxJQUFJLGFBQWEsRUFBRTtZQUN2RSxTQUFTLENBQUMsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDO1NBQ3hCO0lBQ0wsQ0FBQztJQUVELGlDQUFTLEdBQVQ7UUFDSSxZQUFZO1FBQ1osT0FBTyxFQUFFLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUM7SUFDM0MsQ0FBQztJQUVELHdDQUFnQixHQUFoQixVQUFpQixJQUFJO1FBQ2pCLElBQUksaUJBQWlCLEVBQUU7WUFDbkIsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ3JDO2FBQU07WUFDSCxJQUFJLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDcEM7SUFDTCxDQUFDO0lBRUQsNkNBQXFCLEdBQXJCLFVBQXNCLElBQUk7UUFDdEIsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUN4QixJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUV2QyxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUNwQyxJQUFJLE9BQU8sR0FBRyxNQUFNLENBQUMsQ0FBQyxFQUNsQixDQUFDLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsR0FBRyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEdBQUcsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUM5RCxFQUFFLEdBQUcsT0FBTyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsR0FBRyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7UUFFdkMsSUFBSSxFQUFFLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQzVCLEVBQUUsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUVqQzs7Ozs7VUFLRTtRQUNGLGlEQUFpRDtRQUNqRCw2QkFBNkI7UUFDN0IsdUNBQXVDO1FBQ3ZDLElBQUksYUFBYSxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFN0Qsd0RBQXdEO1FBQ3hELDBCQUEwQjtRQUMxQixJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDZCxJQUFJLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3ZDLElBQUksYUFBYSxFQUFFO1lBQ2YsY0FBYztZQUNkLEtBQUssQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQ3ZCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQztZQUN6QixLQUFLLElBQUksYUFBYSxDQUFDO1lBQ3ZCLGVBQWU7WUFDZixLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQztZQUN2QixLQUFLLENBQUMsS0FBSyxHQUFDLENBQUMsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDekIsS0FBSyxJQUFJLGFBQWEsQ0FBQztZQUN2QixXQUFXO1lBQ1gsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDdkIsS0FBSyxDQUFDLEtBQUssR0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQ3pCLEtBQUssSUFBSSxhQUFhLENBQUM7WUFDdkIsWUFBWTtZQUNaLEtBQUssQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQ3ZCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQztTQUM1QjthQUFNO1lBQ0gsNEJBQTRCO1lBQzVCLElBQUksRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLEVBQzVCLEVBQUUsR0FBRyxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLEdBQUcsRUFBRSxFQUN4QixFQUFFLEdBQUcsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsQ0FBQyxHQUFHLEVBQUUsRUFDeEIsRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7WUFFekIsY0FBYztZQUNkLDhCQUE4QjtZQUM5Qiw4QkFBOEI7WUFDOUIsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQzVCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDOUIsS0FBSyxJQUFJLGFBQWEsQ0FBQztZQUN2QixlQUFlO1lBQ2YsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQzVCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDOUIsS0FBSyxJQUFJLGFBQWEsQ0FBQztZQUN2QixXQUFXO1lBQ1gsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQzVCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7WUFDOUIsS0FBSyxJQUFJLGFBQWEsQ0FBQztZQUN2QixZQUFZO1lBQ1osS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDO1lBQzVCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUM7U0FDakM7SUFDTCxDQUFDO0lBRUQsK0JBQStCO0lBQy9CLGtFQUFrRTtJQUNsRSw4Q0FBc0IsR0FBdEIsVUFBdUIsSUFBSTtRQUN2QixJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQ3hCLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3ZDLElBQUksYUFBYSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFFdkMsSUFBSSxFQUFFLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUNiLEVBQUUsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQ2IsRUFBRSxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFDYixFQUFFLEdBQUcsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRWxCLElBQUksS0FBSyxHQUFXLENBQUMsQ0FBQztRQUN0QixjQUFjO1FBQ2QsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUNsQixLQUFLLENBQUMsS0FBSyxHQUFDLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUNwQixLQUFLLElBQUksYUFBYSxDQUFDO1FBQ3ZCLGVBQWU7UUFDZixLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ2xCLEtBQUssQ0FBQyxLQUFLLEdBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQ3BCLEtBQUssSUFBSSxhQUFhLENBQUM7UUFDdkIsV0FBVztRQUNYLEtBQUssQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLENBQUM7UUFDbEIsS0FBSyxDQUFDLEtBQUssR0FBQyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUM7UUFDcEIsS0FBSyxJQUFJLGFBQWEsQ0FBQztRQUN2QixZQUFZO1FBQ1osS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUNsQixLQUFLLENBQUMsS0FBSyxHQUFDLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQztJQUN4QixDQUFDO0lBRUQsMkNBQTJDO0lBQzNDLG1DQUFXLEdBQVgsVUFBWSxJQUFJLEVBQUUsUUFBUTtRQUN0QixJQUFJLFFBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDeEIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDO1NBQy9CO1FBRUQsSUFBSSxVQUFVLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUNsQyxJQUFJLEtBQUssR0FBRyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2pDLElBQUksS0FBSyxHQUFHLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFFakMsSUFBSSxNQUFNLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBQyxZQUFZLENBQUMsQ0FBQztRQUMxQyxJQUFJLFVBQVUsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBRXZFLGdFQUFnRTtRQUVoRSxnQkFBZ0I7UUFDaEIsSUFBSSxZQUFZLEdBQUcsVUFBVSxDQUFDLFVBQVUsSUFBSSxDQUFDLEVBQ3pDLElBQUksR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBRXpCLElBQUksS0FBSyxDQUFDLE1BQU0sR0FBRyxZQUFZLEdBQUcsSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUMzQyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxNQUFNLEdBQUcsWUFBWSxDQUFDLEVBQUUsWUFBWSxDQUFDLENBQUM7U0FDekU7YUFBTTtZQUNILElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLFlBQVksQ0FBQyxDQUFDO1NBQ2pDO1FBRUQsZUFBZTtRQUNmLElBQUksSUFBSSxHQUFHLE1BQU0sQ0FBQyxNQUFNLEVBQ3BCLFlBQVksR0FBRyxVQUFVLENBQUMsWUFBWSxFQUN0QyxRQUFRLEdBQUcsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFhLHNDQUFzQztRQUMxRixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFO1lBQzFDLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQyxHQUFHLFFBQVEsR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDOUM7SUFDTCxDQUFDO0lBRUQsMENBQWtCLEdBQWxCLFVBQW1CLElBQUksRUFBRSxLQUFLO1FBQzFCLElBQUksT0FBTztZQUFFLE9BQU87UUFFcEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLElBQUksRUFBRSxDQUFDLG1CQUFtQixJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsUUFBUSxFQUFFO1lBQ3ZFLElBQUksV0FBVyxHQUFHLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNsRSxZQUFZO1lBQ1osSUFBSSxXQUFXLEVBQUU7Z0JBQ2IsS0FBSyxDQUFDLHFCQUFxQixDQUFDLFdBQVcsQ0FBQyxDQUFDO2FBQzVDO1NBQ0o7UUFDRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxRQUFRO1lBQUUsT0FBTztRQUV0QixJQUFJLFFBQVEsQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLEtBQUssS0FBSyxDQUFDLFFBQVEsRUFBRTtZQUNwRCx5REFBeUQ7WUFDekQsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1NBQzFCO0lBQ0wsQ0FBQztJQUVTLGlDQUFTLEdBQW5CLFVBQW9CLElBQXdCO1FBQ3hDLDBCQUEwQjtRQUMxQiw0Q0FBNEM7UUFDNUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDbEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUM3QixJQUFJLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3ZDLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBRXZDLHdEQUF3RDtRQUN4RCwwQkFBMEI7UUFDMUIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUN4QixJQUFJLFNBQVMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3RCLElBQUksU0FBUyxHQUFHLGFBQWEsR0FBRyxDQUFDLEdBQUcsUUFBUSxDQUFDO1lBQzdDLEtBQUssQ0FBQyxTQUFTLENBQUMsR0FBRyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDakMsS0FBSyxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQyxDQUFDO1NBQzVDO0lBQ0wsQ0FBQztJQUVTLG1DQUFXLEdBQXJCLFVBQXNCLElBQXdCO1FBQzFDLElBQUksSUFBSSxHQUFZLElBQUksQ0FBQyxJQUFJLEVBQ3pCLEVBQUUsR0FBVyxJQUFJLENBQUMsS0FBSyxFQUN2QixFQUFFLEdBQVcsSUFBSSxDQUFDLE1BQU0sRUFDeEIsSUFBSSxHQUFXLElBQUksQ0FBQyxPQUFPLEdBQUcsRUFBRSxFQUNoQyxJQUFJLEdBQVcsSUFBSSxDQUFDLE9BQU8sR0FBRyxFQUFFLEVBQ2hDLENBQVMsRUFDVCxDQUFTLEVBQ1QsQ0FBUyxFQUNULENBQVMsQ0FBQztRQUVkLENBQUMsR0FBRyxDQUFFLElBQUksQ0FBQztRQUNYLENBQUMsR0FBRyxDQUFFLElBQUksQ0FBQztRQUNYLENBQUMsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDO1FBQ2QsQ0FBQyxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFFZCxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQ3hCLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDYixLQUFLLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ2IsS0FBSyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUNiLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDYixJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVTLHdDQUFnQixHQUExQixVQUEyQixJQUF3QjtRQUMvQyxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDbEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNyQixJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1NBQzVCO0lBQ0wsQ0FBQztJQUNMLG9CQUFDO0FBQUQsQ0EzUkEsQUEyUkMsQ0EzUjBDLEVBQUUsQ0FBQyxTQUFTLEdBMlJ0RCIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDIwIENhbyBHYW90aW5nPGNhb2d0YWFAZ21haWwuY29tPlxuLy8gaHR0cHM6Ly9jYW9ndGFhLmdpdGh1Yi5pb1xuLy8gVGhpcyBmaWxlIGlzIGxpY2Vuc2VkIHVuZGVyIHRoZSBNSVQgTGljZW5zZS5cbi8vIExpY2Vuc2UgdGV4dCBhdmFpbGFibGUgYXQgaHR0cHM6Ly9vcGVuc291cmNlLm9yZy9saWNlbnNlcy9NSVRcblxuLypcbiAqIERhdGU6IDIwMjAtMDctMTMgMDI6NDQ6MTdcbiAqIExhc3RFZGl0b3JzOiBHVDxjYW9ndGFhQGdtYWlsLmNvbT5cbiAqIExhc3RFZGl0VGltZTogMjAyMC0wNy0yMiAxNDowNDo0M1xuKi8gXG5cbi8vIOiHquWumuS5iea4suafk1xuLy8gaHR0cHM6Ly9kb2NzLmNvY29zLmNvbS9jcmVhdG9yL21hbnVhbC96aC9hZHZhbmNlZC10b3BpY3MvY3VzdG9tLXJlbmRlci5odG1sIyVFOCU4NyVBQSVFNSVBRSU5QSVFNCVCOSU4OS1hc3NlbWJsZXJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdUQXNzZW1ibGVyMkQgZXh0ZW5kcyBjYy5Bc3NlbWJsZXIge1xuICAgIC8vIOavj+S4qjJk5riy5p+T5Y2V5YWD6YeM55qE5pyJOlxuICAgIC8vIDTkuKrpobbngrnlsZ7mgKfmlbDmja5cbiAgICAvLyA25Liq6aG254K557Si5byVIC0+IOS4ieinkuWJluWIhuaIkDLkuKrkuInop5LlvaJcblxuICAgIC8vIOavj+S4qumhtueCueWxnuaAp+eUsTXkuKozMuS9jeaVsOaNrue7hOaIkFxuICAgIC8vIOmhtueCueWxnuaAp+WjsOaYjjpcbiAgICAvLyB2YXIgdmZtdFBvc1V2Q29sb3IgPSBuZXcgZ2Z4LlZlcnRleEZvcm1hdChbXG4gICAgLy8gICAgIHsgbmFtZTogZ2Z4LkFUVFJfUE9TSVRJT04sIHR5cGU6IGdmeC5BVFRSX1RZUEVfRkxPQVQzMiwgbnVtOiAyIH0sXG4gICAgLy8gICAgIHsgbmFtZTogZ2Z4LkFUVFJfVVYwLCB0eXBlOiBnZnguQVRUUl9UWVBFX0ZMT0FUMzIsIG51bTogMiB9LFxuICAgIC8vICAgICB7IG5hbWU6IGdmeC5BVFRSX0NPTE9SLCB0eXBlOiBnZnguQVRUUl9UWVBFX1VJTlQ4LCBudW06IDQsIG5vcm1hbGl6ZTogdHJ1ZSB9LCAgICAgICAvLyA05LiqdWludDhcbiAgICAvLyBdKTtcbiAgICAvLyDpobbngrnlsZ7mgKfmlbDmja7mjpLliJfvvIzmr4/kuIDmoLzmmK8zMuS9jSAoZmxvYXQzMi91aW50MzIpXG4gICAgLy8geHx5fHV8dnxjb2xvcnx4fHl8dXx2fGNvbG9yfC4uLlxuICAgIC8vIOWFtuS4rXV25Zyo5LiA57uE5pWw5o2u5Lit55qE5YGP56e75pivMu+8jGNvbG9y55qE5YGP56e75pivNFxuICAgIHZlcnRpY2VzQ291bnQgPSA0O1xuICAgIGluZGljZXNDb3VudCA9IDY7XG4gICAgZmxvYXRzUGVyVmVydCA9IDU7XG5cbiAgICAvLyB2ZGF0YSBvZmZzZXQgaW5mb1xuICAgIHV2T2Zmc2V0ID0gMjtcbiAgICBjb2xvck9mZnNldCA9IDQ7XG4gICAgXG4gICAgcHJvdGVjdGVkIF9yZW5kZXJEYXRhOiBjYy5SZW5kZXJEYXRhID0gbnVsbDtcbiAgICBwcm90ZWN0ZWQgX2xvY2FsOiBhbnkgPSBudWxsOyAgICAgICAgICAvLyDkuK3pl7Tnu5PmnpzjgIJbbCxiLHIsdF3jgIJub2Rl5a+56LGh5bem5LiL44CB5Y+z5LiK6aG254K555qE5pys5Zyw5Z2Q5qCH77yM5Y2z55u45a+55LqO6ZSa54K555qE5YGP56e7XG5cbiAgICBpbml0KGNvbXA6IGNjLlJlbmRlckNvbXBvbmVudCkge1xuICAgICAgICBzdXBlci5pbml0KGNvbXApO1xuXG4gICAgICAgIC8vIGNjLkFzc2VtYmxlcjJE55qE5Yid5aeL5YyW5pS+5ZyoY29uc3RydWN0b3Lph4xcbiAgICAgICAgLy8g5q2k5aSE5oqK5Yid5aeL5YyW5pS+5ZyoaW5pdOmHjO+8jOS7peS+v+aIkOWRmOWPmOmHj+iDveWkn+acieacuuS8muS/ruaUuVxuICAgICAgICB0aGlzLl9yZW5kZXJEYXRhID0gbmV3IGNjLlJlbmRlckRhdGEoKTtcbiAgICAgICAgdGhpcy5fcmVuZGVyRGF0YS5pbml0KHRoaXMpO1xuXG4gICAgICAgIHRoaXMuaW5pdExvY2FsKCk7XG4gICAgICAgIHRoaXMuaW5pdERhdGEoKTtcbiAgICB9XG5cbiAgICBnZXQgdmVydGljZXNGbG9hdHMoKSB7XG4gICAgICAgIHJldHVybiB0aGlzLnZlcnRpY2VzQ291bnQgKiB0aGlzLmZsb2F0c1BlclZlcnQ7XG4gICAgfVxuXG4gICAgaW5pdERhdGEoKSB7XG4gICAgICAgIGxldCBkYXRhID0gdGhpcy5fcmVuZGVyRGF0YTtcbiAgICAgICAgZGF0YS5jcmVhdGVRdWFkRGF0YSgwLCB0aGlzLnZlcnRpY2VzRmxvYXRzLCB0aGlzLmluZGljZXNDb3VudCk7XG4gICAgICAgIC8vIGNyZWF0ZVF1YWREYXRh5YaF6YOo5Lya6LCD55SoaW5pdFF1YWRJbmRpY2Vz5Yid5aeL5YyW57Si5byV5L+h5oGvXG4gICAgICAgIC8vIOWmguaenOaYr+eUqOeUqGZsZXhidWZmZXLliJvlu7rliJnpnIDopoHoh6rlt7HliJ3lp4vljJZcbiAgICB9XG5cbiAgICBpbml0TG9jYWwoKSB7XG4gICAgICAgIHRoaXMuX2xvY2FsID0gW107XG4gICAgICAgIHRoaXMuX2xvY2FsLmxlbmd0aCA9IDQ7XG4gICAgfVxuXG4gICAgdXBkYXRlQ29sb3IoY29tcCwgY29sb3IpIHtcbiAgICAgICAgLy8gcmVuZGVyIGRhdGEgPSB2ZXJ0cyA9IHh8eXx1fHZ8Y29sb3J8eHx5fHV8dnxjb2xvcnwuLi5cbiAgICAgICAgLy8g5aGr5YWFcmVuZGVyIGRhdGHkuK005Liq6aG254K555qEY29sb3Lpg6jliIZcbiAgICAgICAgbGV0IHVpbnRWZXJ0cyA9IHRoaXMuX3JlbmRlckRhdGEudWludFZEYXRhc1swXTtcbiAgICAgICAgaWYgKCF1aW50VmVydHMpIHJldHVybjtcbiAgICAgICAgY29sb3IgPSBjb2xvciAhPSBudWxsID8gY29sb3IgOiBjb21wLm5vZGUuY29sb3IuX3ZhbDtcbiAgICAgICAgbGV0IGZsb2F0c1BlclZlcnQgPSB0aGlzLmZsb2F0c1BlclZlcnQ7XG4gICAgICAgIGxldCBjb2xvck9mZnNldCA9IHRoaXMuY29sb3JPZmZzZXQ7XG4gICAgICAgIGZvciAobGV0IGkgPSBjb2xvck9mZnNldCwgbCA9IHVpbnRWZXJ0cy5sZW5ndGg7IGkgPCBsOyBpICs9IGZsb2F0c1BlclZlcnQpIHtcbiAgICAgICAgICAgIHVpbnRWZXJ0c1tpXSA9IGNvbG9yO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgZ2V0QnVmZmVyKCkge1xuICAgICAgICAvL0B0cy1pZ25vcmVcbiAgICAgICAgcmV0dXJuIGNjLnJlbmRlcmVyLl9oYW5kbGUuX21lc2hCdWZmZXI7XG4gICAgfVxuXG4gICAgdXBkYXRlV29ybGRWZXJ0cyhjb21wKSB7XG4gICAgICAgIGlmIChDQ19OQVRJVkVSRU5ERVJFUikge1xuICAgICAgICAgICAgdGhpcy51cGRhdGVXb3JsZFZlcnRzTmF0aXZlKGNvbXApO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgdGhpcy51cGRhdGVXb3JsZFZlcnRzV2ViR0woY29tcCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICB1cGRhdGVXb3JsZFZlcnRzV2ViR0woY29tcCkge1xuICAgICAgICBsZXQgbG9jYWwgPSB0aGlzLl9sb2NhbDtcbiAgICAgICAgbGV0IHZlcnRzID0gdGhpcy5fcmVuZGVyRGF0YS52RGF0YXNbMF07XG5cbiAgICAgICAgbGV0IG1hdHJpeCA9IGNvbXAubm9kZS5fd29ybGRNYXRyaXg7XG4gICAgICAgIGxldCBtYXRyaXhtID0gbWF0cml4Lm0sXG4gICAgICAgICAgICBhID0gbWF0cml4bVswXSwgYiA9IG1hdHJpeG1bMV0sIGMgPSBtYXRyaXhtWzRdLCBkID0gbWF0cml4bVs1XSxcbiAgICAgICAgICAgIHR4ID0gbWF0cml4bVsxMl0sIHR5ID0gbWF0cml4bVsxM107XG5cbiAgICAgICAgbGV0IHZsID0gbG9jYWxbMF0sIHZyID0gbG9jYWxbMl0sXG4gICAgICAgICAgICB2YiA9IGxvY2FsWzFdLCB2dCA9IGxvY2FsWzNdO1xuICAgICAgICBcbiAgICAgICAgLypcbiAgICAgICAgbTAwID0gMSwgbTAxID0gMCwgbTAyID0gMCwgbTAzID0gMCxcbiAgICAgICAgbTA0ID0gMCwgbTA1ID0gMSwgbTA2ID0gMCwgbTA3ID0gMCxcbiAgICAgICAgbTA4ID0gMCwgbTA5ID0gMCwgbTEwID0gMSwgbTExID0gMCxcbiAgICAgICAgbTEyID0gMCwgbTEzID0gMCwgbTE0ID0gMCwgbTE1ID0gMVxuICAgICAgICAqL1xuICAgICAgICAvLyBbYSxiLGMsZF0gPSBfd29ybGRNYXRyaXhbMSwyLDQsNV0gPT0gWzEsMCwwLDFdXG4gICAgICAgIC8vIF93b3JsZE1hdHJpeFsxMiwxM13mmK94eeeahOW5s+enu+mHj1xuICAgICAgICAvLyDljbPkuJbnlYznn6npmLXnmoTlt6bkuIrop5IyeDLmmK/ljZXlhYPnn6npmLXvvIzor7TmmI7lnKgyROWcuuaZr+WGheayoeacieWHuueOsOaXi+i9rOaIluiAhee8qeaUvlxuICAgICAgICBsZXQganVzdFRyYW5zbGF0ZSA9IGEgPT09IDEgJiYgYiA9PT0gMCAmJiBjID09PSAwICYmIGQgPT09IDE7XG5cbiAgICAgICAgLy8gcmVuZGVyIGRhdGEgPSB2ZXJ0cyA9IHh8eXx1fHZ8Y29sb3J8eHx5fHV8dnxjb2xvcnwuLi5cbiAgICAgICAgLy8g5aGr5YWFcmVuZGVyIGRhdGHkuK005Liq6aG254K555qEeHnpg6jliIZcbiAgICAgICAgbGV0IGluZGV4ID0gMDtcbiAgICAgICAgbGV0IGZsb2F0c1BlclZlcnQgPSB0aGlzLmZsb2F0c1BlclZlcnQ7XG4gICAgICAgIGlmIChqdXN0VHJhbnNsYXRlKSB7XG4gICAgICAgICAgICAvLyBsZWZ0IGJvdHRvbVxuICAgICAgICAgICAgdmVydHNbaW5kZXhdID0gdmwgKyB0eDtcbiAgICAgICAgICAgIHZlcnRzW2luZGV4KzFdID0gdmIgKyB0eTtcbiAgICAgICAgICAgIGluZGV4ICs9IGZsb2F0c1BlclZlcnQ7XG4gICAgICAgICAgICAvLyByaWdodCBib3R0b21cbiAgICAgICAgICAgIHZlcnRzW2luZGV4XSA9IHZyICsgdHg7XG4gICAgICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IHZiICsgdHk7XG4gICAgICAgICAgICBpbmRleCArPSBmbG9hdHNQZXJWZXJ0O1xuICAgICAgICAgICAgLy8gbGVmdCB0b3BcbiAgICAgICAgICAgIHZlcnRzW2luZGV4XSA9IHZsICsgdHg7XG4gICAgICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IHZ0ICsgdHk7XG4gICAgICAgICAgICBpbmRleCArPSBmbG9hdHNQZXJWZXJ0O1xuICAgICAgICAgICAgLy8gcmlnaHQgdG9wXG4gICAgICAgICAgICB2ZXJ0c1tpbmRleF0gPSB2ciArIHR4O1xuICAgICAgICAgICAgdmVydHNbaW5kZXgrMV0gPSB2dCArIHR5O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgLy8gNOWvuXh55YiG5Yir5LmY5LulIFsyLDJd5Lu/5bCE55+p6Zi177yM54S25ZCOK+W5s+enu+mHj1xuICAgICAgICAgICAgbGV0IGFsID0gYSAqIHZsLCBhciA9IGEgKiB2cixcbiAgICAgICAgICAgIGJsID0gYiAqIHZsLCBiciA9IGIgKiB2cixcbiAgICAgICAgICAgIGNiID0gYyAqIHZiLCBjdCA9IGMgKiB2dCxcbiAgICAgICAgICAgIGRiID0gZCAqIHZiLCBkdCA9IGQgKiB2dDtcblxuICAgICAgICAgICAgLy8gbGVmdCBib3R0b21cbiAgICAgICAgICAgIC8vIG5ld3ggPSB2bCAqIGEgKyB2YiAqIGMgKyB0eFxuICAgICAgICAgICAgLy8gbmV3eSA9IHZsICogYiArIHZiICogZCArIHR5XG4gICAgICAgICAgICB2ZXJ0c1tpbmRleF0gPSBhbCArIGNiICsgdHg7XG4gICAgICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IGJsICsgZGIgKyB0eTtcbiAgICAgICAgICAgIGluZGV4ICs9IGZsb2F0c1BlclZlcnQ7XG4gICAgICAgICAgICAvLyByaWdodCBib3R0b21cbiAgICAgICAgICAgIHZlcnRzW2luZGV4XSA9IGFyICsgY2IgKyB0eDtcbiAgICAgICAgICAgIHZlcnRzW2luZGV4KzFdID0gYnIgKyBkYiArIHR5O1xuICAgICAgICAgICAgaW5kZXggKz0gZmxvYXRzUGVyVmVydDtcbiAgICAgICAgICAgIC8vIGxlZnQgdG9wXG4gICAgICAgICAgICB2ZXJ0c1tpbmRleF0gPSBhbCArIGN0ICsgdHg7XG4gICAgICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IGJsICsgZHQgKyB0eTtcbiAgICAgICAgICAgIGluZGV4ICs9IGZsb2F0c1BlclZlcnQ7XG4gICAgICAgICAgICAvLyByaWdodCB0b3BcbiAgICAgICAgICAgIHZlcnRzW2luZGV4XSA9IGFyICsgY3QgKyB0eDtcbiAgICAgICAgICAgIHZlcnRzW2luZGV4KzFdID0gYnIgKyBkdCArIHR5O1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgLy8gbmF0aXZl5Zy65pmv5LiL5L2/55So55qEdXBkYXRlV29ybGRWZXJ0c1xuICAgIC8vIGNvcHkgZnJvbSBcXGpzYi1hZGFwdGVyLW1hc3RlclxcZW5naW5lXFxhc3NlbWJsZXJzXFxhc3NlbWJsZXItMmQuanNcbiAgICB1cGRhdGVXb3JsZFZlcnRzTmF0aXZlKGNvbXApIHtcbiAgICAgICAgbGV0IGxvY2FsID0gdGhpcy5fbG9jYWw7XG4gICAgICAgIGxldCB2ZXJ0cyA9IHRoaXMuX3JlbmRlckRhdGEudkRhdGFzWzBdO1xuICAgICAgICBsZXQgZmxvYXRzUGVyVmVydCA9IHRoaXMuZmxvYXRzUGVyVmVydDtcbiAgICAgIFxuICAgICAgICBsZXQgdmwgPSBsb2NhbFswXSxcbiAgICAgICAgICAgIHZyID0gbG9jYWxbMl0sXG4gICAgICAgICAgICB2YiA9IGxvY2FsWzFdLFxuICAgICAgICAgICAgdnQgPSBsb2NhbFszXTtcbiAgICAgIFxuICAgICAgICBsZXQgaW5kZXg6IG51bWJlciA9IDA7XG4gICAgICAgIC8vIGxlZnQgYm90dG9tXG4gICAgICAgIHZlcnRzW2luZGV4XSA9IHZsO1xuICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IHZiO1xuICAgICAgICBpbmRleCArPSBmbG9hdHNQZXJWZXJ0O1xuICAgICAgICAvLyByaWdodCBib3R0b21cbiAgICAgICAgdmVydHNbaW5kZXhdID0gdnI7XG4gICAgICAgIHZlcnRzW2luZGV4KzFdID0gdmI7XG4gICAgICAgIGluZGV4ICs9IGZsb2F0c1BlclZlcnQ7XG4gICAgICAgIC8vIGxlZnQgdG9wXG4gICAgICAgIHZlcnRzW2luZGV4XSA9IHZsO1xuICAgICAgICB2ZXJ0c1tpbmRleCsxXSA9IHZ0O1xuICAgICAgICBpbmRleCArPSBmbG9hdHNQZXJWZXJ0O1xuICAgICAgICAvLyByaWdodCB0b3BcbiAgICAgICAgdmVydHNbaW5kZXhdID0gdnI7XG4gICAgICAgIHZlcnRzW2luZGV4KzFdID0gdnQ7XG4gICAgfVxuXG4gICAgLy8g5bCG5YeG5aSH5aW955qE6aG254K55pWw5o2u5aGr5YWF6L+bIFZlcnRleEJ1ZmZlciDlkowgSW5kaWNlQnVmZmVyXG4gICAgZmlsbEJ1ZmZlcnMoY29tcCwgcmVuZGVyZXIpIHtcbiAgICAgICAgaWYgKHJlbmRlcmVyLndvcmxkTWF0RGlydHkpIHtcbiAgICAgICAgICAgIHRoaXMudXBkYXRlV29ybGRWZXJ0cyhjb21wKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCByZW5kZXJEYXRhID0gdGhpcy5fcmVuZGVyRGF0YTtcbiAgICAgICAgbGV0IHZEYXRhID0gcmVuZGVyRGF0YS52RGF0YXNbMF07XG4gICAgICAgIGxldCBpRGF0YSA9IHJlbmRlckRhdGEuaURhdGFzWzBdO1xuXG4gICAgICAgIGxldCBidWZmZXIgPSB0aGlzLmdldEJ1ZmZlcigvKnJlbmRlcmVyKi8pO1xuICAgICAgICBsZXQgb2Zmc2V0SW5mbyA9IGJ1ZmZlci5yZXF1ZXN0KHRoaXMudmVydGljZXNDb3VudCwgdGhpcy5pbmRpY2VzQ291bnQpO1xuXG4gICAgICAgIC8vIGJ1ZmZlciBkYXRhIG1heSBiZSByZWFsbG9jLCBuZWVkIGdldCByZWZlcmVuY2UgYWZ0ZXIgcmVxdWVzdC5cblxuICAgICAgICAvLyBmaWxsIHZlcnRpY2VzXG4gICAgICAgIGxldCB2ZXJ0ZXhPZmZzZXQgPSBvZmZzZXRJbmZvLmJ5dGVPZmZzZXQgPj4gMixcbiAgICAgICAgICAgIHZidWYgPSBidWZmZXIuX3ZEYXRhO1xuXG4gICAgICAgIGlmICh2RGF0YS5sZW5ndGggKyB2ZXJ0ZXhPZmZzZXQgPiB2YnVmLmxlbmd0aCkge1xuICAgICAgICAgICAgdmJ1Zi5zZXQodkRhdGEuc3ViYXJyYXkoMCwgdmJ1Zi5sZW5ndGggLSB2ZXJ0ZXhPZmZzZXQpLCB2ZXJ0ZXhPZmZzZXQpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgdmJ1Zi5zZXQodkRhdGEsIHZlcnRleE9mZnNldCk7XG4gICAgICAgIH1cblxuICAgICAgICAvLyBmaWxsIGluZGljZXNcbiAgICAgICAgbGV0IGlidWYgPSBidWZmZXIuX2lEYXRhLFxuICAgICAgICAgICAgaW5kaWNlT2Zmc2V0ID0gb2Zmc2V0SW5mby5pbmRpY2VPZmZzZXQsXG4gICAgICAgICAgICB2ZXJ0ZXhJZCA9IG9mZnNldEluZm8udmVydGV4T2Zmc2V0OyAgICAgICAgICAgICAvLyB2ZXJ0ZXhJZOaYr+W3sue7j+WcqGJ1ZmZlcumHjOeahOmhtueCueaVsO+8jOS5n+aYr+W9k+WJjemhtueCueW6j+WPt+eahOWfuuaVsFxuICAgICAgICBmb3IgKGxldCBpID0gMCwgbCA9IGlEYXRhLmxlbmd0aDsgaSA8IGw7IGkrKykge1xuICAgICAgICAgICAgaWJ1ZltpbmRpY2VPZmZzZXQrK10gPSB2ZXJ0ZXhJZCArIGlEYXRhW2ldO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgcGFja1RvRHluYW1pY0F0bGFzKGNvbXAsIGZyYW1lKSB7XG4gICAgICAgIGlmIChDQ19URVNUKSByZXR1cm47XG4gICAgICAgIFxuICAgICAgICBpZiAoIWZyYW1lLl9vcmlnaW5hbCAmJiBjYy5keW5hbWljQXRsYXNNYW5hZ2VyICYmIGZyYW1lLl90ZXh0dXJlLnBhY2thYmxlKSB7XG4gICAgICAgICAgICBsZXQgcGFja2VkRnJhbWUgPSBjYy5keW5hbWljQXRsYXNNYW5hZ2VyLmluc2VydFNwcml0ZUZyYW1lKGZyYW1lKTtcbiAgICAgICAgICAgIC8vQHRzLWlnbm9yZVxuICAgICAgICAgICAgaWYgKHBhY2tlZEZyYW1lKSB7XG4gICAgICAgICAgICAgICAgZnJhbWUuX3NldER5bmFtaWNBdGxhc0ZyYW1lKHBhY2tlZEZyYW1lKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBsZXQgbWF0ZXJpYWwgPSBjb21wLl9tYXRlcmlhbHNbMF07XG4gICAgICAgIGlmICghbWF0ZXJpYWwpIHJldHVybjtcbiAgICAgICAgXG4gICAgICAgIGlmIChtYXRlcmlhbC5nZXRQcm9wZXJ0eSgndGV4dHVyZScpICE9PSBmcmFtZS5fdGV4dHVyZSkge1xuICAgICAgICAgICAgLy8gdGV4dHVyZSB3YXMgcGFja2VkIHRvIGR5bmFtaWMgYXRsYXMsIHNob3VsZCB1cGRhdGUgdXZzXG4gICAgICAgICAgICBjb21wLl92ZXJ0c0RpcnR5ID0gdHJ1ZTtcbiAgICAgICAgICAgIGNvbXAuX3VwZGF0ZU1hdGVyaWFsKCk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgdXBkYXRlVVZzKGNvbXA6IGNjLlJlbmRlckNvbXBvbmVudCkge1xuICAgICAgICAvLyA05Liq6aG254K555qEdXblnZDmoIfvvIzlr7nlupTlt6bkuIvjgIHlj7PkuIvjgIHlt6bkuIrjgIHlj7PkuIpcbiAgICAgICAgLy8g5aaC5p6c5pivY2MuU3ByaXRl57uE5Lu277yM6L+Z6YeM5Y+Wc3ByaXRlLl9zcHJpdGVGcmFtZS51djtcbiAgICAgICAgbGV0IHV2ID0gWzAsIDAsIDEsIDAsIDAsIDEsIDEsIDFdO1xuICAgICAgICBsZXQgdXZPZmZzZXQgPSB0aGlzLnV2T2Zmc2V0O1xuICAgICAgICBsZXQgZmxvYXRzUGVyVmVydCA9IHRoaXMuZmxvYXRzUGVyVmVydDtcbiAgICAgICAgbGV0IHZlcnRzID0gdGhpcy5fcmVuZGVyRGF0YS52RGF0YXNbMF07XG5cbiAgICAgICAgLy8gcmVuZGVyIGRhdGEgPSB2ZXJ0cyA9IHh8eXx1fHZ8Y29sb3J8eHx5fHV8dnxjb2xvcnwuLi5cbiAgICAgICAgLy8g5aGr5YWFcmVuZGVyIGRhdGHkuK005Liq6aG254K555qEdXbpg6jliIZcbiAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCA0OyBpKyspIHtcbiAgICAgICAgICAgIGxldCBzcmNPZmZzZXQgPSBpICogMjtcbiAgICAgICAgICAgIGxldCBkc3RPZmZzZXQgPSBmbG9hdHNQZXJWZXJ0ICogaSArIHV2T2Zmc2V0O1xuICAgICAgICAgICAgdmVydHNbZHN0T2Zmc2V0XSA9IHV2W3NyY09mZnNldF07XG4gICAgICAgICAgICB2ZXJ0c1tkc3RPZmZzZXQgKyAxXSA9IHV2W3NyY09mZnNldCArIDFdO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHVwZGF0ZVZlcnRzKGNvbXA6IGNjLlJlbmRlckNvbXBvbmVudCkge1xuICAgICAgICBsZXQgbm9kZTogY2MuTm9kZSA9IGNvbXAubm9kZSxcbiAgICAgICAgICAgIGN3OiBudW1iZXIgPSBub2RlLndpZHRoLFxuICAgICAgICAgICAgY2g6IG51bWJlciA9IG5vZGUuaGVpZ2h0LFxuICAgICAgICAgICAgYXBweDogbnVtYmVyID0gbm9kZS5hbmNob3JYICogY3csXG4gICAgICAgICAgICBhcHB5OiBudW1iZXIgPSBub2RlLmFuY2hvclkgKiBjaCxcbiAgICAgICAgICAgIGw6IG51bWJlcixcbiAgICAgICAgICAgIGI6IG51bWJlciwgXG4gICAgICAgICAgICByOiBudW1iZXIsXG4gICAgICAgICAgICB0OiBudW1iZXI7XG5cbiAgICAgICAgbCA9IC0gYXBweDtcbiAgICAgICAgYiA9IC0gYXBweTtcbiAgICAgICAgciA9IGN3IC0gYXBweDtcbiAgICAgICAgdCA9IGNoIC0gYXBweTtcblxuICAgICAgICBsZXQgbG9jYWwgPSB0aGlzLl9sb2NhbDtcbiAgICAgICAgbG9jYWxbMF0gPSBsO1xuICAgICAgICBsb2NhbFsxXSA9IGI7XG4gICAgICAgIGxvY2FsWzJdID0gcjtcbiAgICAgICAgbG9jYWxbM10gPSB0O1xuICAgICAgICB0aGlzLnVwZGF0ZVdvcmxkVmVydHMoY29tcCk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHVwZGF0ZVJlbmRlckRhdGEoY29tcDogY2MuUmVuZGVyQ29tcG9uZW50KSB7XG4gICAgICAgIGlmIChjb21wLl92ZXJ0c0RpcnR5KSB7XG4gICAgICAgICAgICB0aGlzLnVwZGF0ZVVWcyhjb21wKTtcbiAgICAgICAgICAgIHRoaXMudXBkYXRlVmVydHMoY29tcCk7XG4gICAgICAgICAgICBjb21wLl92ZXJ0c0RpcnR5ID0gZmFsc2U7XG4gICAgICAgIH1cbiAgICB9XG59XG4iXX0=