
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Shader/GTAutoFitSpriteAssembler2D.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1a39ak3NZdFtYMMs/stiMBC', 'GTAutoFitSpriteAssembler2D');
// shader/GTAutoFitSpriteAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-21 16:23:10
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:52
*/
var GTSimpleSpriteAssembler2D_1 = require("./GTSimpleSpriteAssembler2D");
var GTAutoFitSpriteAssembler2D = /** @class */ (function (_super) {
    __extends(GTAutoFitSpriteAssembler2D, _super);
    function GTAutoFitSpriteAssembler2D() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._uv = [];
        return _this;
    }
    GTAutoFitSpriteAssembler2D.prototype.updateUVs = function (sprite) {
        var rect = sprite._spriteFrame.getRect();
        var node = sprite.node;
        if (!rect.width || !rect.height || !node.width || !node.height) {
            _super.prototype.updateUVs.call(this, sprite);
            return;
        }
        Object.assign(this._uv, sprite._spriteFrame.uv);
        var uv = this._uv;
        var wscale = rect.width / node.width;
        var hscale = rect.height / node.height;
        var ratio = 1.0;
        var isRotated = sprite._spriteFrame.isRotated();
        var l = uv[0], r = uv[2], b = uv[1], t = uv[5];
        if (isRotated) {
            // cc图集里的旋转总是顺时针旋转90度，以原左下角为中心。（旋转后左下角变为左上角）
            l = uv[1];
            r = uv[3];
            b = uv[0];
            t = uv[4];
        }
        // 图片在等比缩放的前提下自适应容器大小
        if (wscale > hscale) {
            // fit height
            ratio = hscale / wscale;
            var ro = isRotated ? 1 : 0;
            var c = (l + r) * 0.5;
            var half = (r - l) * 0.5 * ratio;
            l = uv[0 + ro] = uv[4 + ro] = c - half;
            r = uv[2 + ro] = uv[6 + ro] = c + half;
        }
        else {
            // fit width
            ratio = wscale / hscale;
            var ro = isRotated ? -1 : 0;
            var c = (b + t) * 0.5;
            var half = (b - t) * 0.5 * ratio;
            b = uv[1 + ro] = uv[3 + ro] = c + half;
            t = uv[5 + ro] = uv[7 + ro] = c - half;
        }
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    return GTAutoFitSpriteAssembler2D;
}(GTSimpleSpriteAssembler2D_1.default));
exports.default = GTAutoFitSpriteAssembler2D;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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