
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/TypeScript2/PhysicsPolygonColliderEx.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '0e7bcbZcTlDpq0EVxPZXBR0', 'PhysicsPolygonColliderEx');
// TypeScript2/PhysicsPolygonColliderEx.ts

Object.defineProperty(exports, "__esModule", { value: true });
var THICK = 100;
var gfx = cc['gfx'];
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu, requireComponent = _a.requireComponent;
var PhysicsPolygonColliderEx = /** @class */ (function (_super) {
    __extends(PhysicsPolygonColliderEx, _super);
    function PhysicsPolygonColliderEx() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.meshRenderer = null;
        _this._polys = [];
        _this._physicsPolygonColliders = [];
        _this._commands = [];
        return _this;
    }
    Object.defineProperty(PhysicsPolygonColliderEx.prototype, "polys", {
        get: function () {
            var _this = this;
            return this._polys.map(function (v) { return _this._convertClipperPathToVecArray(v); });
        },
        enumerable: false,
        configurable: true
    });
    PhysicsPolygonColliderEx.prototype.init = function (polys) {
        var _this = this;
        this._polys = polys.map(function (v) { return _this._convertVecArrayToClipperPath(v); });
        this._commands = [];
    };
    PhysicsPolygonColliderEx.prototype.pushCommand = function (name, params) {
        this._commands.push({ name: name, params: params });
    };
    PhysicsPolygonColliderEx.prototype.polyDifference = function (poly, ctx) {
        // if (poly.length < 3) return;
        var _this = this;
        // 计算新的多边形
        var cpr = new ClipperLib.Clipper(ClipperLib.Clipper.ioStrictlySimple); //ClipperLib.Clipper.ioStrictlySimple | ClipperLib.Clipper.ioPreserveCollinear
        // cpr.PreserveCollinear = true;
        var subj_paths = this._polys;
        var clip_paths = [this._convertVecArrayToClipperPath(poly)];
        cpr.AddPaths(subj_paths, ClipperLib.PolyType.ptSubject, true);
        cpr.AddPaths(clip_paths, ClipperLib.PolyType.ptClip, true);
        var subject_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var clip_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var solution_polytree = new ClipperLib.PolyTree();
        cpr.Execute(ClipperLib.ClipType.ctDifference, solution_polytree, subject_fillType, clip_fillType);
        var solution_expolygons = ClipperLib.JS.PolyTreeToExPolygons(solution_polytree);
        this._polys = ClipperLib.Clipper.PolyTreeToPaths(solution_polytree);
        // cc.log(solution_expolygons);
        // 将多边形分割成三角形 并绘制出来
        ctx && ctx.clear(true);
        var _physicsPolygonColliders_count = 0;
        var _loop_1 = function (expolygon) {
            // const outers = ClipperLib.Clipper.SimplifyPolygon(expolygon.outer,ClipperLib.PolyFillType.pftEvenOdd);
            // cc.log(outer,"outer",expolygon.outer)
            var countor = this_1._convertClipperPathToPoly2triPoint(expolygon.outer);
            if (countor.length < 2)
                return "continue";
            var swctx = new poly2tri.SweepContext(countor, { cloneArrays: true });
            // const exclude = countor;
            var holes = expolygon.holes.map(function (h) { return _this._convertClipperPathToPoly2triPoint(h, countor); });
            try {
                // 防止 addhole 失败 使用try
                swctx.addHoles(holes);
                swctx.triangulate();
                var triangles = swctx.getTriangles();
                // cc.log('triangles', triangles);
                for (var _i = 0, triangles_1 = triangles; _i < triangles_1.length; _i++) {
                    var tri = triangles_1[_i];
                    // 逐一处理三角形
                    var c = this_1._physicsPolygonColliders[_physicsPolygonColliders_count];
                    if (!c) {
                        c = this_1.addComponent(cc.PhysicsPolygonCollider);
                        c.friction = 0;
                        c.restitution = 0;
                        this_1._physicsPolygonColliders[_physicsPolygonColliders_count] = c;
                    }
                    c.points = tri.getPoints().map(function (v, i) {
                        if (ctx) {
                            if (i === 0)
                                ctx.moveTo(v.x, v.y);
                            else
                                ctx.lineTo(v.x, v.y);
                        }
                        return cc.v2(v.x, v.y);
                    });
                    c.apply();
                    _physicsPolygonColliders_count++;
                    if (ctx) {
                        ctx.close();
                        ctx.fill();
                    }
                }
            }
            catch (e) {
                console.error('polyDifference poly2tri error', _physicsPolygonColliders_count, expolygon);
                console.error(e);
                return "continue";
            }
        };
        var this_1 = this;
        for (var _i = 0, solution_expolygons_1 = solution_expolygons; _i < solution_expolygons_1.length; _i++) {
            var expolygon = solution_expolygons_1[_i];
            _loop_1(expolygon);
        }
        this._physicsPolygonColliders.slice(_physicsPolygonColliders_count).forEach((function (v) {
            if (v.points.length) {
                v.points.length = 0;
                v.apply();
            }
        }));
        // 绘制底层 mesh
        var arr2 = this._polys.map(function (v) { return _this._convertClipperPathToVecArray(v); });
        var poly_tri_arr = [];
        var c_count = arr2.length;
        for (var k = 0; k < c_count; k++) {
            var tmpArr = arr2[k];
            var tmpArr2 = [];
            for (var k2 = 0; k2 < tmpArr.length; k2++) {
                var aa = tmpArr[k2];
                tmpArr2.push([aa.x, aa.y]);
            }
            poly_tri_arr.push(tmpArr2);
        }
        this.addMesh(poly_tri_arr);
    };
    PhysicsPolygonColliderEx.prototype.addMesh = function (tri) {
        var allPoints = [];
        var indexArr = [];
        var uvIndexArr = [];
        var uvType = 0;
        var uvupTypeArr = [cc.v2(0, 0), cc.v2(0, 1), cc.v2(1, 0), cc.v2(1, 1)];
        var uvDownTypeArr = [cc.v2(1, 1), cc.v2(0, 0), cc.v2(0, 1), cc.v2(1, 0)];
        var colorIndex = [];
        // console.log("****2this._regions.length:"+tri.length);
        for (var i = 0; i < tri.length; i++) {
            var singleParr = [].concat(tri[i]);
            indexArr[i] = [];
            var length = singleParr.length;
            for (var j = 0; j < length; j++) {
                if (singleParr[j]) {
                    allPoints.push(cc.v3(singleParr[j][0], singleParr[j][1], 0));
                    indexArr[i].push(allPoints.length - 1);
                    uvIndexArr.push(uvupTypeArr[uvType]);
                    uvType = uvType >= 3 ? 0 : uvType + 1;
                    colorIndex.push(cc.Color.WHITE);
                }
            }
        }
        uvType = 0;
        var iLength = allPoints.length;
        for (var i = 0; i < iLength; i++) {
            allPoints[i + iLength] = cc.v3(allPoints[i].x, allPoints[i].y, -THICK);
            uvIndexArr.push(uvDownTypeArr[uvType]);
            uvType = uvType >= 3 ? 0 : uvType + 1;
            colorIndex.push(cc.Color.WHITE);
        }
        var vfmtPosColor = new gfx.VertexFormat([
            { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 3 },
            { name: gfx.ATTR_UV0, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
            { name: gfx.ATTR_COLOR, type: gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
        ]);
        var mesh = new cc.Mesh();
        mesh.init(vfmtPosColor, allPoints.length, true);
        this.meshRenderer.mesh = mesh;
        mesh.setVertices(gfx.ATTR_POSITION, allPoints);
        mesh.setVertices(gfx.ATTR_COLOR, colorIndex);
        mesh.setVertices(gfx.ATTR_UV0, uvIndexArr);
        var indices = this.conmuteIndices(indexArr, iLength);
        mesh.setIndices(indices);
    };
    PhysicsPolygonColliderEx.prototype.conmuteIndices = function (indexArr, length) {
        var indicesarr = [];
        for (var i = 0; i < indexArr.length; i++) {
            var arr = indexArr[i];
            for (var j = 0; j < arr.length; j++) {
                var p1 = void 0, p2 = void 0, p3 = void 0, p4 = void 0;
                if (j < arr.length - 1) {
                    p1 = arr[j];
                    p2 = arr[j + 1];
                    p3 = arr[j] + length;
                    p4 = arr[j + 1] + length;
                }
                else {
                    p1 = arr[j];
                    p2 = arr[0];
                    p3 = arr[j] + length;
                    p4 = arr[0] + length;
                }
                indicesarr.push(p1, p2, p4, p3, p4, p1);
            }
        }
        return indicesarr;
    };
    PhysicsPolygonColliderEx.prototype.lateUpdate = function (dt) {
        if (this._commands.length) {
            // 每帧执行命令队列
            for (var index = 0; index < Math.ceil(this._commands.length / 2 + 0.5); index++) {
                var cmd = this._commands.shift();
                if (cmd)
                    this[cmd.name].apply(this, cmd.params);
                else
                    break;
            }
        }
    };
    PhysicsPolygonColliderEx.prototype._convertVecArrayToClipperPath = function (poly) {
        return poly.map(function (p) { return { X: p.x, Y: p.y }; });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToVecArray = function (poly) {
        return poly.map(function (p) { return cc.v2(p.X, p.Y); });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToPoly2triPoint = function (poly, exclude) {
        if (exclude === void 0) { exclude = []; }
        // return poly.map((p) => { return new poly2tri.Point(p.X, p.Y) });
        var newPos = [];
        poly.forEach(function (p, i) {
            var p_now = new poly2tri.Point(p.X, p.Y);
            var isIn = exclude.some(function (e_p) {
                if (e_p.equals(p_now)) {
                    return true;
                }
            });
            if (!isIn) {
                newPos.push(p_now);
                exclude.push(p_now);
            }
        });
        if (newPos.length > 2)
            return newPos;
        else
            return [];
    };
    __decorate([
        property(cc.MeshRenderer)
    ], PhysicsPolygonColliderEx.prototype, "meshRenderer", void 0);
    PhysicsPolygonColliderEx = __decorate([
        ccclass,
        menu("i18n:MAIN_MENU.component.physics/Collider/PolygonEX-lamyoung.com"),
        requireComponent(cc.RigidBody)
    ], PhysicsPolygonColliderEx);
    return PhysicsPolygonColliderEx;
}(cc.Component));
exports.default = PhysicsPolygonColliderEx;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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