
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/TypeScript2/test4.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '86805m1LvpOlJlxkovVgNuY', 'test4');
// TypeScript2/test4.ts

Object.defineProperty(exports, "__esModule", { value: true });
var PhysicsPolygonColliderEx_1 = require("./PhysicsPolygonColliderEx");
// 挖洞圆半径
var DIG_RADIUS = 50;
// 圆的边的数量
var DIG_FRAGMENT = 12;
// 归一到单位化
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main_poly = /** @class */ (function (_super) {
    __extends(Main_poly, _super);
    function Main_poly() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.node_dirty = null;
        _this.polyEx = null;
        _this.water = null;
        return _this;
    }
    Main_poly.prototype.onLoad = function () {
        cc.macro.SHOW_MESH_WIREFRAME = true;
        cc.macro.ENABLE_MULTI_TOUCH = false;
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().enabledAccumulator = true;
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        cc.PhysicsManager.POSITION_ITERATIONS = 8;
        this.node_dirty.on(cc.Node.EventType.TOUCH_START, this._touchStart, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_END, this._touchEnd, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_CANCEL, this._touchEnd, this);
        this.graphics = this.node_dirty.getComponent(cc.Mask)['_graphics'];
    };
    Main_poly.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            _this.reset();
        }, 0.01);
        this.schedule(this.creatWater, 0.5);
    };
    Main_poly.prototype.creatWater = function () {
        var water = cc.instantiate(this.water);
        water.y = cc.winSize.height / 2;
        cc.find("Canvas/waterLayer").addChild(water);
    };
    Main_poly.prototype._optimizePoint = function (point) {
        var x = Math.floor(point[0] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        var y = Math.floor(point[1] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        return cc.v2(x, y);
    };
    Main_poly.prototype._touchStart = function (touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    };
    Main_poly.prototype._touchMove = function (touch) {
        var regions = [];
        var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
        var count = DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (var index = 0; index < count; index++) {
                var r = 2 * Math.PI * index / count;
                var x = pos.x + DIG_RADIUS * Math.cos(r);
                var y = pos.y + DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        }
        else {
            var delta = pos.sub(this._touchStartPos);
            if (delta.lengthSqr() > 25) {
                var startPos = this._touchStartPos;
                for (var index = 0; index < count; index++) {
                    var r = 2 * Math.PI * index / count;
                    var vec_x = DIG_RADIUS * Math.cos(r);
                    var vec_y = DIG_RADIUS * Math.sin(r);
                    var x = void 0, y = void 0;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    }
                    else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }
        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    };
    Main_poly.prototype._touchEnd = function (touch) {
        this._touchStartPos = undefined;
    };
    Main_poly.prototype.reset = function () {
        var ww = this.node_dirty.width;
        var hh = this.node_dirty.height;
        // this.polyEx.init([
        //     [cc.v2(-ww / 2, -hh / 2), cc.v2(-ww / 2, hh / 2), cc.v2(ww / 2, hh / 2), cc.v2(ww / 2, -hh / 2)]
        // ]);
        this.polyEx.init([
            [cc.v2(-200, 200), cc.v2(200, 200), cc.v2(200, 0), cc.v2(0, -100), cc.v2(-200, 0)]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    };
    Main_poly.prototype.debug = function () {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    };
    __decorate([
        property(cc.Node)
    ], Main_poly.prototype, "node_dirty", void 0);
    __decorate([
        property(PhysicsPolygonColliderEx_1.default)
    ], Main_poly.prototype, "polyEx", void 0);
    __decorate([
        property(cc.Prefab)
    ], Main_poly.prototype, "water", void 0);
    Main_poly = __decorate([
        ccclass
    ], Main_poly);
    return Main_poly;
}(cc.Component));
exports.default = Main_poly;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcVHlwZVNjcmlwdDJcXHRlc3Q0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSx1RUFBa0U7QUFFbEUsUUFBUTtBQUNSLElBQU0sVUFBVSxHQUFHLEVBQUUsQ0FBQztBQUN0QixTQUFTO0FBQ1QsSUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDO0FBQ3hCLFNBQVM7QUFDVCxJQUFNLGlCQUFpQixHQUFHLENBQUMsQ0FBQztBQUd0QixJQUFBLEtBQXdCLEVBQUUsQ0FBQyxVQUFVLEVBQW5DLE9BQU8sYUFBQSxFQUFFLFFBQVEsY0FBa0IsQ0FBQztBQUc1QztJQUF1Qyw2QkFBWTtJQUFuRDtRQUFBLHFFQW1IQztRQWpIRyxjQUFRLEdBQWdCLElBQUksQ0FBQztRQUc3QixnQkFBVSxHQUFZLElBQUksQ0FBQztRQUczQixZQUFNLEdBQTZCLElBQUksQ0FBQztRQUd4QyxXQUFLLEdBQWMsSUFBSSxDQUFDOztJQXdHNUIsQ0FBQztJQXRHRywwQkFBTSxHQUFOO1FBQ0ksRUFBRSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUM7UUFDcEMsRUFBRSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7UUFFcEMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7UUFDL0MsRUFBRSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUMxRCxFQUFFLENBQUMsY0FBYyxDQUFDLGVBQWUsR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBQzNDLEVBQUUsQ0FBQyxjQUFjLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxDQUFDO1FBQzFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxDQUFDO1FBRTFDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzFFLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3hFLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3RFLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBRXpFLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3ZFLENBQUM7SUFFRCx5QkFBSyxHQUFMO1FBQUEsaUJBS0M7UUFKRyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ2QsS0FBSSxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ2pCLENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNULElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBQ08sOEJBQVUsR0FBbEI7UUFDSSxJQUFJLEtBQUssR0FBRyxFQUFFLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN2QyxLQUFLLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxPQUFPLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztRQUNoQyxFQUFFLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDTyxrQ0FBYyxHQUF0QixVQUF1QixLQUFLO1FBQ3hCLElBQU0sQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxHQUFHLGlCQUFpQixDQUFDLEdBQUcsaUJBQWlCLENBQUM7UUFDdkUsSUFBTSxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEdBQUcsaUJBQWlCLENBQUMsR0FBRyxpQkFBaUIsQ0FBQztRQUN2RSxPQUFPLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ3ZCLENBQUM7SUFFTywrQkFBVyxHQUFuQixVQUFvQixLQUFlO1FBQy9CLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO1FBQ2hDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDM0IsQ0FBQztJQUdPLDhCQUFVLEdBQWxCLFVBQW1CLEtBQWU7UUFDOUIsSUFBTSxPQUFPLEdBQWMsRUFBRSxDQUFDO1FBQzlCLElBQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO1FBRXpFLElBQU0sS0FBSyxHQUFHLFlBQVksQ0FBQztRQUMzQixJQUFJLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRTtZQUN0QixLQUFLLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRSxLQUFLLEdBQUcsS0FBSyxFQUFFLEtBQUssRUFBRSxFQUFFO2dCQUN4QyxJQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLEVBQUUsR0FBRyxLQUFLLEdBQUcsS0FBSyxDQUFDO2dCQUN0QyxJQUFNLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxHQUFHLFVBQVUsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUMzQyxJQUFNLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQyxHQUFHLFVBQVUsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUMzQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2FBQzdDO1lBQ0QsSUFBSSxDQUFDLGNBQWMsR0FBRyxHQUFHLENBQUM7U0FDN0I7YUFBTTtZQUNILElBQU0sS0FBSyxHQUFHLEdBQUcsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1lBQzNDLElBQUksS0FBSyxDQUFDLFNBQVMsRUFBRSxHQUFHLEVBQUUsRUFBRTtnQkFFeEIsSUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztnQkFDckMsS0FBSyxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUUsS0FBSyxHQUFHLEtBQUssRUFBRSxLQUFLLEVBQUUsRUFBRTtvQkFDeEMsSUFBTSxDQUFDLEdBQUcsQ0FBQyxHQUFHLElBQUksQ0FBQyxFQUFFLEdBQUcsS0FBSyxHQUFHLEtBQUssQ0FBQztvQkFDdEMsSUFBSSxLQUFLLEdBQUcsVUFBVSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ3JDLElBQUksS0FBSyxHQUFHLFVBQVUsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNyQyxJQUFJLENBQUMsU0FBQSxFQUFFLENBQUMsU0FBQSxDQUFDO29CQUNULElBQUksS0FBSyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsRUFBRTt3QkFDcEMsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDO3dCQUNsQixDQUFDLEdBQUcsR0FBRyxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUM7cUJBQ3JCO3lCQUFNO3dCQUNILENBQUMsR0FBRyxRQUFRLENBQUMsQ0FBQyxHQUFHLEtBQUssQ0FBQzt3QkFDdkIsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDO3FCQUMxQjtvQkFDRCxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2lCQUM3QztnQkFDRCxJQUFJLENBQUMsY0FBYyxHQUFHLEdBQUcsQ0FBQzthQUM3QjtTQUNKO1FBRUQsSUFBSSxPQUFPLENBQUMsTUFBTTtZQUNkLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDLGdCQUFnQixFQUFFLENBQUMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzVFLENBQUM7SUFFTyw2QkFBUyxHQUFqQixVQUFrQixLQUFlO1FBQzdCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFFRCx5QkFBSyxHQUFMO1FBQ0ksSUFBTSxFQUFFLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7UUFDakMsSUFBTSxFQUFFLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDbEMscUJBQXFCO1FBQ3JCLHVHQUF1RztRQUN2RyxNQUFNO1FBQ04sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUM7WUFDYixDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsR0FBRyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQ3JGLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVPLHlCQUFLLEdBQWI7UUFDSSxFQUFFLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLENBQUMsQ0FBQztRQUNyRCxFQUFFLENBQUMsUUFBUSxDQUFDLGlCQUFpQixFQUFFLENBQUMsY0FBYyxHQUFHLEVBQUUsQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLENBQUM7SUE1R0Q7UUFEQyxRQUFRLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQztpREFDUztJQUczQjtRQURDLFFBQVEsQ0FBQyxrQ0FBd0IsQ0FBQzs2Q0FDSztJQUd4QztRQURDLFFBQVEsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDOzRDQUNJO0lBWFAsU0FBUztRQUQ3QixPQUFPO09BQ2EsU0FBUyxDQW1IN0I7SUFBRCxnQkFBQztDQW5IRCxBQW1IQyxDQW5Ic0MsRUFBRSxDQUFDLFNBQVMsR0FtSGxEO2tCQW5Ib0IsU0FBUyIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBQaHlzaWNzUG9seWdvbkNvbGxpZGVyRXggZnJvbSBcIi4vUGh5c2ljc1BvbHlnb25Db2xsaWRlckV4XCI7XHJcblxyXG4vLyDmjJbmtJ7lnIbljYrlvoRcclxuY29uc3QgRElHX1JBRElVUyA9IDUwO1xyXG4vLyDlnIbnmoTovrnnmoTmlbDph49cclxuY29uc3QgRElHX0ZSQUdNRU5UID0gMTI7XHJcbi8vIOW9kuS4gOWIsOWNleS9jeWMllxyXG5jb25zdCBESUdfT1BUSU1JWkVfU0laRSA9IDE7XHJcblxyXG5cclxuY29uc3QgeyBjY2NsYXNzLCBwcm9wZXJ0eSB9ID0gY2MuX2RlY29yYXRvcjtcclxuXHJcbkBjY2NsYXNzXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIE1haW5fcG9seSBleHRlbmRzIGNjLkNvbXBvbmVudCB7XHJcblxyXG4gICAgZ3JhcGhpY3M6IGNjLkdyYXBoaWNzID0gbnVsbDtcclxuXHJcbiAgICBAcHJvcGVydHkoY2MuTm9kZSlcclxuICAgIG5vZGVfZGlydHk6IGNjLk5vZGUgPSBudWxsO1xyXG5cclxuICAgIEBwcm9wZXJ0eShQaHlzaWNzUG9seWdvbkNvbGxpZGVyRXgpXHJcbiAgICBwb2x5RXg6IFBoeXNpY3NQb2x5Z29uQ29sbGlkZXJFeCA9IG51bGw7XHJcblxyXG4gICAgQHByb3BlcnR5KGNjLlByZWZhYilcclxuICAgIHdhdGVyOiBjYy5QcmVmYWIgPSBudWxsO1xyXG5cclxuICAgIG9uTG9hZCgpIHtcclxuICAgICAgICBjYy5tYWNyby5TSE9XX01FU0hfV0lSRUZSQU1FID0gdHJ1ZTtcclxuICAgICAgICBjYy5tYWNyby5FTkFCTEVfTVVMVElfVE9VQ0ggPSBmYWxzZTtcclxuXHJcbiAgICAgICAgY2MuZGlyZWN0b3IuZ2V0UGh5c2ljc01hbmFnZXIoKS5lbmFibGVkID0gdHJ1ZTtcclxuICAgICAgICBjYy5kaXJlY3Rvci5nZXRQaHlzaWNzTWFuYWdlcigpLmVuYWJsZWRBY2N1bXVsYXRvciA9IHRydWU7XHJcbiAgICAgICAgY2MuUGh5c2ljc01hbmFnZXIuRklYRURfVElNRV9TVEVQID0gMSAvIDMwO1xyXG4gICAgICAgIGNjLlBoeXNpY3NNYW5hZ2VyLlZFTE9DSVRZX0lURVJBVElPTlMgPSA4O1xyXG4gICAgICAgIGNjLlBoeXNpY3NNYW5hZ2VyLlBPU0lUSU9OX0lURVJBVElPTlMgPSA4O1xyXG5cclxuICAgICAgICB0aGlzLm5vZGVfZGlydHkub24oY2MuTm9kZS5FdmVudFR5cGUuVE9VQ0hfU1RBUlQsIHRoaXMuX3RvdWNoU3RhcnQsIHRoaXMpO1xyXG4gICAgICAgIHRoaXMubm9kZV9kaXJ0eS5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9NT1ZFLCB0aGlzLl90b3VjaE1vdmUsIHRoaXMpO1xyXG4gICAgICAgIHRoaXMubm9kZV9kaXJ0eS5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9FTkQsIHRoaXMuX3RvdWNoRW5kLCB0aGlzKTtcclxuICAgICAgICB0aGlzLm5vZGVfZGlydHkub24oY2MuTm9kZS5FdmVudFR5cGUuVE9VQ0hfQ0FOQ0VMLCB0aGlzLl90b3VjaEVuZCwgdGhpcyk7XHJcblxyXG4gICAgICAgIHRoaXMuZ3JhcGhpY3MgPSB0aGlzLm5vZGVfZGlydHkuZ2V0Q29tcG9uZW50KGNjLk1hc2spWydfZ3JhcGhpY3MnXTtcclxuICAgIH1cclxuXHJcbiAgICBzdGFydCgpIHtcclxuICAgICAgICB0aGlzLnNjaGVkdWxlT25jZSgoKSA9PiB7XHJcbiAgICAgICAgICAgIHRoaXMucmVzZXQoKTtcclxuICAgICAgICB9LCAwLjAxKTtcclxuICAgICAgICB0aGlzLnNjaGVkdWxlKHRoaXMuY3JlYXRXYXRlciwgMC41KTtcclxuICAgIH1cclxuICAgIHByaXZhdGUgY3JlYXRXYXRlcigpIHtcclxuICAgICAgICBsZXQgd2F0ZXIgPSBjYy5pbnN0YW50aWF0ZSh0aGlzLndhdGVyKTtcclxuICAgICAgICB3YXRlci55ID0gY2Mud2luU2l6ZS5oZWlnaHQgLyAyO1xyXG4gICAgICAgIGNjLmZpbmQoXCJDYW52YXMvd2F0ZXJMYXllclwiKS5hZGRDaGlsZCh3YXRlcik7XHJcbiAgICB9XHJcbiAgICBwcml2YXRlIF9vcHRpbWl6ZVBvaW50KHBvaW50KSB7XHJcbiAgICAgICAgY29uc3QgeCA9IE1hdGguZmxvb3IocG9pbnRbMF0gKiBESUdfT1BUSU1JWkVfU0laRSkgLyBESUdfT1BUSU1JWkVfU0laRTtcclxuICAgICAgICBjb25zdCB5ID0gTWF0aC5mbG9vcihwb2ludFsxXSAqIERJR19PUFRJTUlaRV9TSVpFKSAvIERJR19PUFRJTUlaRV9TSVpFO1xyXG4gICAgICAgIHJldHVybiBjYy52Mih4LCB5KTtcclxuICAgIH1cclxuXHJcbiAgICBwcml2YXRlIF90b3VjaFN0YXJ0KHRvdWNoOiBjYy5Ub3VjaCkge1xyXG4gICAgICAgIHRoaXMuX3RvdWNoU3RhcnRQb3MgPSB1bmRlZmluZWQ7XHJcbiAgICAgICAgdGhpcy5fdG91Y2hNb3ZlKHRvdWNoKTtcclxuICAgIH1cclxuXHJcbiAgICBwcml2YXRlIF90b3VjaFN0YXJ0UG9zOiBjYy5WZWMyO1xyXG4gICAgcHJpdmF0ZSBfdG91Y2hNb3ZlKHRvdWNoOiBjYy5Ub3VjaCkge1xyXG4gICAgICAgIGNvbnN0IHJlZ2lvbnM6IGNjLlZlYzJbXSA9IFtdO1xyXG4gICAgICAgIGNvbnN0IHBvcyA9IHRoaXMuZ3JhcGhpY3Mubm9kZS5jb252ZXJ0VG9Ob2RlU3BhY2VBUih0b3VjaC5nZXRMb2NhdGlvbigpKTtcclxuXHJcbiAgICAgICAgY29uc3QgY291bnQgPSBESUdfRlJBR01FTlQ7XHJcbiAgICAgICAgaWYgKCF0aGlzLl90b3VjaFN0YXJ0UG9zKSB7XHJcbiAgICAgICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCBjb3VudDsgaW5kZXgrKykge1xyXG4gICAgICAgICAgICAgICAgY29uc3QgciA9IDIgKiBNYXRoLlBJICogaW5kZXggLyBjb3VudDtcclxuICAgICAgICAgICAgICAgIGNvbnN0IHggPSBwb3MueCArIERJR19SQURJVVMgKiBNYXRoLmNvcyhyKTtcclxuICAgICAgICAgICAgICAgIGNvbnN0IHkgPSBwb3MueSArIERJR19SQURJVVMgKiBNYXRoLnNpbihyKTtcclxuICAgICAgICAgICAgICAgIHJlZ2lvbnMucHVzaCh0aGlzLl9vcHRpbWl6ZVBvaW50KFt4LCB5XSkpO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIHRoaXMuX3RvdWNoU3RhcnRQb3MgPSBwb3M7XHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgY29uc3QgZGVsdGEgPSBwb3Muc3ViKHRoaXMuX3RvdWNoU3RhcnRQb3MpO1xyXG4gICAgICAgICAgICBpZiAoZGVsdGEubGVuZ3RoU3FyKCkgPiAyNSkge1xyXG5cclxuICAgICAgICAgICAgICAgIGNvbnN0IHN0YXJ0UG9zID0gdGhpcy5fdG91Y2hTdGFydFBvcztcclxuICAgICAgICAgICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCBjb3VudDsgaW5kZXgrKykge1xyXG4gICAgICAgICAgICAgICAgICAgIGNvbnN0IHIgPSAyICogTWF0aC5QSSAqIGluZGV4IC8gY291bnQ7XHJcbiAgICAgICAgICAgICAgICAgICAgbGV0IHZlY194ID0gRElHX1JBRElVUyAqIE1hdGguY29zKHIpO1xyXG4gICAgICAgICAgICAgICAgICAgIGxldCB2ZWNfeSA9IERJR19SQURJVVMgKiBNYXRoLnNpbihyKTtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgeCwgeTtcclxuICAgICAgICAgICAgICAgICAgICBpZiAoZGVsdGEuZG90KGNjLnYyKHZlY194LCB2ZWNfeSkpID4gMCkge1xyXG4gICAgICAgICAgICAgICAgICAgICAgICB4ID0gcG9zLnggKyB2ZWNfeDtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeSA9IHBvcy55ICsgdmVjX3k7XHJcbiAgICAgICAgICAgICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeCA9IHN0YXJ0UG9zLnggKyB2ZWNfeDtcclxuICAgICAgICAgICAgICAgICAgICAgICAgeSA9IHN0YXJ0UG9zLnkgKyB2ZWNfeTtcclxuICAgICAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICAgICAgcmVnaW9ucy5wdXNoKHRoaXMuX29wdGltaXplUG9pbnQoW3gsIHldKSk7XHJcbiAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICB0aGlzLl90b3VjaFN0YXJ0UG9zID0gcG9zO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgfVxyXG5cclxuICAgICAgICBpZiAocmVnaW9ucy5sZW5ndGgpXHJcbiAgICAgICAgICAgIHRoaXMucG9seUV4LnB1c2hDb21tYW5kKCdwb2x5RGlmZmVyZW5jZScsIFtyZWdpb25zLCB0aGlzLmdyYXBoaWNzXSk7XHJcbiAgICB9XHJcblxyXG4gICAgcHJpdmF0ZSBfdG91Y2hFbmQodG91Y2g6IGNjLlRvdWNoKSB7XHJcbiAgICAgICAgdGhpcy5fdG91Y2hTdGFydFBvcyA9IHVuZGVmaW5lZDtcclxuICAgIH1cclxuXHJcbiAgICByZXNldCgpIHtcclxuICAgICAgICBjb25zdCB3dyA9IHRoaXMubm9kZV9kaXJ0eS53aWR0aDtcclxuICAgICAgICBjb25zdCBoaCA9IHRoaXMubm9kZV9kaXJ0eS5oZWlnaHQ7XHJcbiAgICAgICAgLy8gdGhpcy5wb2x5RXguaW5pdChbXHJcbiAgICAgICAgLy8gICAgIFtjYy52Migtd3cgLyAyLCAtaGggLyAyKSwgY2MudjIoLXd3IC8gMiwgaGggLyAyKSwgY2MudjIod3cgLyAyLCBoaCAvIDIpLCBjYy52Mih3dyAvIDIsIC1oaCAvIDIpXVxyXG4gICAgICAgIC8vIF0pO1xyXG4gICAgICAgIHRoaXMucG9seUV4LmluaXQoW1xyXG4gICAgICAgICAgICBbY2MudjIoLTIwMCwgMjAwKSwgY2MudjIoMjAwLCAyMDApLCBjYy52MigyMDAsIDApLCBjYy52MigwLCAtMTAwKSwgY2MudjIoLTIwMCwgMCldXHJcbiAgICAgICAgXSk7XHJcbiAgICAgICAgdGhpcy5wb2x5RXgucG9seURpZmZlcmVuY2UoW10sIHRoaXMuZ3JhcGhpY3MpO1xyXG4gICAgfVxyXG5cclxuICAgIHByaXZhdGUgZGVidWcoKSB7XHJcbiAgICAgICAgY2MuZGVidWcuc2V0RGlzcGxheVN0YXRzKCFjYy5kZWJ1Zy5pc0Rpc3BsYXlTdGF0cygpKTtcclxuICAgICAgICBjYy5kaXJlY3Rvci5nZXRQaHlzaWNzTWFuYWdlcigpLmRlYnVnRHJhd0ZsYWdzID0gY2MuZGVidWcuaXNEaXNwbGF5U3RhdHMoKSA/IDEgOiAwO1xyXG4gICAgfVxyXG5cclxufSJdfQ==