
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/extend/extend1/polybool.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '215c4mH5gxCwp9Osx4SrCDD', 'polybool');
// extend/extend1/polybool.js

"use strict";

(function e(t, n, r) {
  function s(o, u) {
    if (!n[o]) {
      if (!t[o]) {
        var a = typeof require == "function" && require;
        if (!u && a) return a(o, !0);
        if (i) return i(o, !0);
        var f = new Error("Cannot find module '" + o + "'");
        throw f.code = "MODULE_NOT_FOUND", f;
      }

      var l = n[o] = {
        exports: {}
      };
      t[o][0].call(l.exports, function (e) {
        var n = t[o][1][e];
        return s(n ? n : e);
      }, l, l.exports, e, t, n, r);
    }

    return n[o].exports;
  }

  var i = typeof require == "function" && require;

  for (var o = 0; o < r.length; o++) {
    s(r[o]);
  }

  return s;
})({
  1: [function (require, module, exports) {
    /*
     * @copyright 2016 Sean Connelly (@voidqk), http://syntheti.cc
     * @license MIT
     * @preserve Project Home: https://github.com/voidqk/polybooljs
     */
    var BuildLog = require('./lib/build-log');

    var Epsilon = require('./lib/epsilon');

    var Intersecter = require('./lib/intersecter');

    var SegmentChainer = require('./lib/segment-chainer');

    var SegmentSelector = require('./lib/segment-selector');

    var GeoJSON = require('./lib/geojson');

    var _buildLog = false;

    var _epsilon = Epsilon();

    var PolyBool;
    PolyBool = {
      // getter/setter for buildLog
      buildLog: function buildLog(bl) {
        if (bl === true) _buildLog = BuildLog();else if (bl === false) _buildLog = false;
        return _buildLog === false ? false : _buildLog.list;
      },
      // getter/setter for epsilon
      epsilon: function epsilon(v) {
        return _epsilon.epsilon(v);
      },
      // core API
      segments: function segments(poly) {
        var i = Intersecter(true, _epsilon, _buildLog);
        poly.regions.forEach(i.addRegion);
        return {
          segments: i.calculate(poly.inverted),
          inverted: poly.inverted
        };
      },
      combine: function combine(segments1, segments2) {
        var i3 = Intersecter(false, _epsilon, _buildLog);
        return {
          combined: i3.calculate(segments1.segments, segments1.inverted, segments2.segments, segments2.inverted),
          inverted1: segments1.inverted,
          inverted2: segments2.inverted
        };
      },
      selectUnion: function selectUnion(combined) {
        return {
          segments: SegmentSelector.union(combined.combined, _buildLog),
          inverted: combined.inverted1 || combined.inverted2
        };
      },
      selectIntersect: function selectIntersect(combined) {
        return {
          segments: SegmentSelector.intersect(combined.combined, _buildLog),
          inverted: combined.inverted1 && combined.inverted2
        };
      },
      selectDifference: function selectDifference(combined) {
        return {
          segments: SegmentSelector.difference(combined.combined, _buildLog),
          inverted: combined.inverted1 && !combined.inverted2
        };
      },
      selectDifferenceRev: function selectDifferenceRev(combined) {
        return {
          segments: SegmentSelector.differenceRev(combined.combined, _buildLog),
          inverted: !combined.inverted1 && combined.inverted2
        };
      },
      selectXor: function selectXor(combined) {
        return {
          segments: SegmentSelector.xor(combined.combined, _buildLog),
          inverted: combined.inverted1 !== combined.inverted2
        };
      },
      polygon: function polygon(segments) {
        return {
          regions: SegmentChainer(segments.segments, _epsilon, _buildLog),
          inverted: segments.inverted
        };
      },
      // GeoJSON converters
      polygonFromGeoJSON: function polygonFromGeoJSON(geojson) {
        return GeoJSON.toPolygon(PolyBool, geojson);
      },
      polygonToGeoJSON: function polygonToGeoJSON(poly) {
        return GeoJSON.fromPolygon(PolyBool, _epsilon, poly);
      },
      // helper functions for common operations
      union: function union(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectUnion);
      },
      intersect: function intersect(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectIntersect);
      },
      difference: function difference(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectDifference);
      },
      differenceRev: function differenceRev(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectDifferenceRev);
      },
      xor: function xor(poly1, poly2) {
        return operate(poly1, poly2, PolyBool.selectXor);
      }
    };

    function operate(poly1, poly2, selector) {
      var seg1 = PolyBool.segments(poly1);
      var seg2 = PolyBool.segments(poly2);
      var comb = PolyBool.combine(seg1, seg2);
      var seg3 = selector(comb);
      return PolyBool.polygon(seg3);
    }

    if (typeof window === 'object') window.PolyBool = PolyBool;
    module.exports = PolyBool;
  }, {
    "./lib/build-log": 2,
    "./lib/epsilon": 3,
    "./lib/geojson": 4,
    "./lib/intersecter": 5,
    "./lib/segment-chainer": 7,
    "./lib/segment-selector": 8
  }],
  2: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // used strictly for logging the processing of the algorithm... only useful if you intend on
    // looking under the covers (for pretty UI's or debugging)
    //
    function BuildLog() {
      var my;
      var nextSegmentId = 0;
      var curVert = false;

      function push(type, data) {
        my.list.push({
          type: type,
          data: data ? JSON.parse(JSON.stringify(data)) : void 0
        });
        return my;
      }

      my = {
        list: [],
        segmentId: function segmentId() {
          return nextSegmentId++;
        },
        checkIntersection: function checkIntersection(seg1, seg2) {
          return push('check', {
            seg1: seg1,
            seg2: seg2
          });
        },
        segmentChop: function segmentChop(seg, end) {
          push('div_seg', {
            seg: seg,
            pt: end
          });
          return push('chop', {
            seg: seg,
            pt: end
          });
        },
        statusRemove: function statusRemove(seg) {
          return push('pop_seg', {
            seg: seg
          });
        },
        segmentUpdate: function segmentUpdate(seg) {
          return push('seg_update', {
            seg: seg
          });
        },
        segmentNew: function segmentNew(seg, primary) {
          return push('new_seg', {
            seg: seg,
            primary: primary
          });
        },
        segmentRemove: function segmentRemove(seg) {
          return push('rem_seg', {
            seg: seg
          });
        },
        tempStatus: function tempStatus(seg, above, below) {
          return push('temp_status', {
            seg: seg,
            above: above,
            below: below
          });
        },
        rewind: function rewind(seg) {
          return push('rewind', {
            seg: seg
          });
        },
        status: function status(seg, above, below) {
          return push('status', {
            seg: seg,
            above: above,
            below: below
          });
        },
        vert: function vert(x) {
          if (x === curVert) return my;
          curVert = x;
          return push('vert', {
            x: x
          });
        },
        log: function log(data) {
          if (typeof data !== 'string') data = JSON.stringify(data, false, '  ');
          return push('log', {
            txt: data
          });
        },
        reset: function reset() {
          return push('reset');
        },
        selected: function selected(segs) {
          return push('selected', {
            segs: segs
          });
        },
        chainStart: function chainStart(seg) {
          return push('chain_start', {
            seg: seg
          });
        },
        chainRemoveHead: function chainRemoveHead(index, pt) {
          return push('chain_rem_head', {
            index: index,
            pt: pt
          });
        },
        chainRemoveTail: function chainRemoveTail(index, pt) {
          return push('chain_rem_tail', {
            index: index,
            pt: pt
          });
        },
        chainNew: function chainNew(pt1, pt2) {
          return push('chain_new', {
            pt1: pt1,
            pt2: pt2
          });
        },
        chainMatch: function chainMatch(index) {
          return push('chain_match', {
            index: index
          });
        },
        chainClose: function chainClose(index) {
          return push('chain_close', {
            index: index
          });
        },
        chainAddHead: function chainAddHead(index, pt) {
          return push('chain_add_head', {
            index: index,
            pt: pt
          });
        },
        chainAddTail: function chainAddTail(index, pt) {
          return push('chain_add_tail', {
            index: index,
            pt: pt
          });
        },
        chainConnect: function chainConnect(index1, index2) {
          return push('chain_con', {
            index1: index1,
            index2: index2
          });
        },
        chainReverse: function chainReverse(index) {
          return push('chain_rev', {
            index: index
          });
        },
        chainJoin: function chainJoin(index1, index2) {
          return push('chain_join', {
            index1: index1,
            index2: index2
          });
        },
        done: function done() {
          return push('done');
        }
      };
      return my;
    }

    module.exports = BuildLog;
  }, {}],
  3: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // provides the raw computation functions that takes epsilon into account
    //
    // zero is defined to be between (-epsilon, epsilon) exclusive
    //
    function Epsilon(eps) {
      if (typeof eps !== 'number') eps = 0.0000000001; // sane default? sure why not

      var my = {
        epsilon: function epsilon(v) {
          if (typeof v === 'number') eps = v;
          return eps;
        },
        pointAboveOrOnLine: function pointAboveOrOnLine(pt, left, right) {
          var Ax = left[0];
          var Ay = left[1];
          var Bx = right[0];
          var By = right[1];
          var Cx = pt[0];
          var Cy = pt[1];
          return (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) >= -eps;
        },
        pointBetween: function pointBetween(p, left, right) {
          // p must be collinear with left->right
          // returns false if p == left, p == right, or left == right
          var d_py_ly = p[1] - left[1];
          var d_rx_lx = right[0] - left[0];
          var d_px_lx = p[0] - left[0];
          var d_ry_ly = right[1] - left[1];
          var dot = d_px_lx * d_rx_lx + d_py_ly * d_ry_ly; // if `dot` is 0, then `p` == `left` or `left` == `right` (reject)
          // if `dot` is less than 0, then `p` is to the left of `left` (reject)

          if (dot < eps) return false;
          var sqlen = d_rx_lx * d_rx_lx + d_ry_ly * d_ry_ly; // if `dot` > `sqlen`, then `p` is to the right of `right` (reject)
          // therefore, if `dot - sqlen` is greater than 0, then `p` is to the right of `right` (reject)

          if (dot - sqlen > -eps) return false;
          return true;
        },
        pointsSameX: function pointsSameX(p1, p2) {
          return Math.abs(p1[0] - p2[0]) < eps;
        },
        pointsSameY: function pointsSameY(p1, p2) {
          return Math.abs(p1[1] - p2[1]) < eps;
        },
        pointsSame: function pointsSame(p1, p2) {
          return my.pointsSameX(p1, p2) && my.pointsSameY(p1, p2);
        },
        pointsCompare: function pointsCompare(p1, p2) {
          // returns -1 if p1 is smaller, 1 if p2 is smaller, 0 if equal
          if (my.pointsSameX(p1, p2)) return my.pointsSameY(p1, p2) ? 0 : p1[1] < p2[1] ? -1 : 1;
          return p1[0] < p2[0] ? -1 : 1;
        },
        pointsCollinear: function pointsCollinear(pt1, pt2, pt3) {
          // does pt1->pt2->pt3 make a straight line?
          // essentially this is just checking to see if the slope(pt1->pt2) === slope(pt2->pt3)
          // if slopes are equal, then they must be collinear, because they share pt2
          var dx1 = pt1[0] - pt2[0];
          var dy1 = pt1[1] - pt2[1];
          var dx2 = pt2[0] - pt3[0];
          var dy2 = pt2[1] - pt3[1];
          return Math.abs(dx1 * dy2 - dx2 * dy1) < eps;
        },
        linesIntersect: function linesIntersect(a0, a1, b0, b1) {
          // returns false if the lines are coincident (e.g., parallel or on top of each other)
          //
          // returns an object if the lines intersect:
          //   {
          //     pt: [x, y],    where the intersection point is at
          //     alongA: where intersection point is along A,
          //     alongB: where intersection point is along B
          //   }
          //
          //  alongA and alongB will each be one of: -2, -1, 0, 1, 2
          //
          //  with the following meaning:
          //
          //    -2   intersection point is before segment's first point
          //    -1   intersection point is directly on segment's first point
          //     0   intersection point is between segment's first and second points (exclusive)
          //     1   intersection point is directly on segment's second point
          //     2   intersection point is after segment's second point
          var adx = a1[0] - a0[0];
          var ady = a1[1] - a0[1];
          var bdx = b1[0] - b0[0];
          var bdy = b1[1] - b0[1];
          var axb = adx * bdy - ady * bdx;
          if (Math.abs(axb) < eps) return false; // lines are coincident

          var dx = a0[0] - b0[0];
          var dy = a0[1] - b0[1];
          var A = (bdx * dy - bdy * dx) / axb;
          var B = (adx * dy - ady * dx) / axb;
          var ret = {
            alongA: 0,
            alongB: 0,
            pt: [a0[0] + A * adx, a0[1] + A * ady]
          }; // categorize where intersection point is along A and B

          if (A <= -eps) ret.alongA = -2;else if (A < eps) ret.alongA = -1;else if (A - 1 <= -eps) ret.alongA = 0;else if (A - 1 < eps) ret.alongA = 1;else ret.alongA = 2;
          if (B <= -eps) ret.alongB = -2;else if (B < eps) ret.alongB = -1;else if (B - 1 <= -eps) ret.alongB = 0;else if (B - 1 < eps) ret.alongB = 1;else ret.alongB = 2;
          return ret;
        },
        pointInsideRegion: function pointInsideRegion(pt, region) {
          var x = pt[0];
          var y = pt[1];
          var last_x = region[region.length - 1][0];
          var last_y = region[region.length - 1][1];
          var inside = false;

          for (var i = 0; i < region.length; i++) {
            var curr_x = region[i][0];
            var curr_y = region[i][1]; // if y is between curr_y and last_y, and
            // x is to the right of the boundary created by the line

            if (curr_y - y > eps != last_y - y > eps && (last_x - curr_x) * (y - curr_y) / (last_y - curr_y) + curr_x - x > eps) inside = !inside;
            last_x = curr_x;
            last_y = curr_y;
          }

          return inside;
        }
      };
      return my;
    }

    module.exports = Epsilon;
  }, {}],
  4: [function (require, module, exports) {
    // (c) Copyright 2017, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // convert between PolyBool polygon format and GeoJSON formats (Polygon and MultiPolygon)
    //
    var GeoJSON = {
      // convert a GeoJSON object to a PolyBool polygon
      toPolygon: function toPolygon(PolyBool, geojson) {
        // converts list of LineString's to segments
        function GeoPoly(coords) {
          // check for empty coords
          if (coords.length <= 0) return PolyBool.segments({
            inverted: false,
            regions: []
          }); // convert LineString to segments

          function LineString(ls) {
            // remove tail which should be the same as head
            var reg = ls.slice(0, ls.length - 1);
            return PolyBool.segments({
              inverted: false,
              regions: [reg]
            });
          } // the first LineString is considered the outside


          var out = LineString(coords[0]); // the rest of the LineStrings are considered interior holes, so subtract them from the
          // current result

          for (var i = 1; i < coords.length; i++) {
            out = PolyBool.selectDifference(PolyBool.combine(out, LineString(coords[i])));
          }

          return out;
        }

        if (geojson.type === 'Polygon') {
          // single polygon, so just convert it and we're done
          return PolyBool.polygon(GeoPoly(geojson.coordinates));
        } else if (geojson.type === 'MultiPolygon') {
          // multiple polygons, so union all the polygons together
          var out = PolyBool.segments({
            inverted: false,
            regions: []
          });

          for (var i = 0; i < geojson.coordinates.length; i++) {
            out = PolyBool.selectUnion(PolyBool.combine(out, GeoPoly(geojson.coordinates[i])));
          }

          return PolyBool.polygon(out);
        }

        throw new Error('PolyBool: Cannot convert GeoJSON object to PolyBool polygon');
      },
      // convert a PolyBool polygon to a GeoJSON object
      fromPolygon: function fromPolygon(PolyBool, eps, poly) {
        // make sure out polygon is clean
        poly = PolyBool.polygon(PolyBool.segments(poly)); // test if r1 is inside r2

        function regionInsideRegion(r1, r2) {
          // we're guaranteed no lines intersect (because the polygon is clean), but a vertex
          // could be on the edge -- so we just average pt[0] and pt[1] to produce a point on the
          // edge of the first line, which cannot be on an edge
          return eps.pointInsideRegion([(r1[0][0] + r1[1][0]) * 0.5, (r1[0][1] + r1[1][1]) * 0.5], r2);
        } // calculate inside heirarchy
        //
        //  _____________________   _______    roots -> A       -> F
        // |          A          | |   F   |            |          |
        // |  _______   _______  | |  ___  |            +-- B      +-- G
        // | |   B   | |   C   | | | |   | |            |   |
        // | |  ___  | |  ___  | | | |   | |            |   +-- D
        // | | | D | | | | E | | | | | G | |            |
        // | | |___| | | |___| | | | |   | |            +-- C
        // | |_______| |_______| | | |___| |                |
        // |_____________________| |_______|                +-- E


        function newNode(region) {
          return {
            region: region,
            children: []
          };
        }

        var roots = newNode(null);

        function addChild(root, region) {
          // first check if we're inside any children
          for (var i = 0; i < root.children.length; i++) {
            var child = root.children[i];

            if (regionInsideRegion(region, child.region)) {
              // we are, so insert inside them instead
              addChild(child, region);
              return;
            }
          } // not inside any children, so check to see if any children are inside us


          var node = newNode(region);

          for (var i = 0; i < root.children.length; i++) {
            var child = root.children[i];

            if (regionInsideRegion(child.region, region)) {
              // oops... move the child beneath us, and remove them from root
              node.children.push(child);
              root.children.splice(i, 1);
              i--;
            }
          } // now we can add ourselves


          root.children.push(node);
        } // add all regions to the root


        for (var i = 0; i < poly.regions.length; i++) {
          var region = poly.regions[i];
          if (region.length < 3) // regions must have at least 3 points (sanity check)
            continue;
          addChild(roots, region);
        } // with our heirarchy, we can distinguish between exterior borders, and interior holes
        // the root nodes are exterior, children are interior, children's children are exterior,
        // children's children's children are interior, etc
        // while we're at it, exteriors are counter-clockwise, and interiors are clockwise


        function forceWinding(region, clockwise) {
          // first, see if we're clockwise or counter-clockwise
          // https://en.wikipedia.org/wiki/Shoelace_formula
          var winding = 0;
          var last_x = region[region.length - 1][0];
          var last_y = region[region.length - 1][1];
          var copy = [];

          for (var i = 0; i < region.length; i++) {
            var curr_x = region[i][0];
            var curr_y = region[i][1];
            copy.push([curr_x, curr_y]); // create a copy while we're at it

            winding += curr_y * last_x - curr_x * last_y;
            last_x = curr_x;
            last_y = curr_y;
          } // this assumes Cartesian coordinates (Y is positive going up)


          var isclockwise = winding < 0;
          if (isclockwise !== clockwise) copy.reverse(); // while we're here, the last point must be the first point...

          copy.push([copy[0][0], copy[0][1]]);
          return copy;
        }

        var geopolys = [];

        function addExterior(node) {
          var poly = [forceWinding(node.region, false)];
          geopolys.push(poly); // children of exteriors are interior

          for (var i = 0; i < node.children.length; i++) {
            poly.push(getInterior(node.children[i]));
          }
        }

        function getInterior(node) {
          // children of interiors are exterior
          for (var i = 0; i < node.children.length; i++) {
            addExterior(node.children[i]);
          } // return the clockwise interior


          return forceWinding(node.region, true);
        } // root nodes are exterior


        for (var i = 0; i < roots.children.length; i++) {
          addExterior(roots.children[i]);
        } // lastly, construct the approrpriate GeoJSON object


        if (geopolys.length <= 0) // empty GeoJSON Polygon
          return {
            type: 'Polygon',
            coordinates: []
          };
        if (geopolys.length == 1) // use a GeoJSON Polygon
          return {
            type: 'Polygon',
            coordinates: geopolys[0]
          };
        return {
          // otherwise, use a GeoJSON MultiPolygon
          type: 'MultiPolygon',
          coordinates: geopolys
        };
      }
    };
    module.exports = GeoJSON;
  }, {}],
  5: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // this is the core work-horse
    //
    var LinkedList = require('./linked-list');

    function Intersecter(selfIntersection, eps, buildLog) {
      // selfIntersection is true/false depending on the phase of the overall algorithm
      //
      // segment creation
      //
      function segmentNew(start, end) {
        return {
          id: buildLog ? buildLog.segmentId() : -1,
          start: start,
          end: end,
          myFill: {
            above: null,
            // is there fill above us?
            below: null // is there fill below us?

          },
          otherFill: null
        };
      }

      function segmentCopy(start, end, seg) {
        return {
          id: buildLog ? buildLog.segmentId() : -1,
          start: start,
          end: end,
          myFill: {
            above: seg.myFill.above,
            below: seg.myFill.below
          },
          otherFill: null
        };
      } //
      // event logic
      //


      var event_root = LinkedList.create();

      function eventCompare(p1_isStart, p1_1, p1_2, p2_isStart, p2_1, p2_2) {
        // compare the selected points first
        var comp = eps.pointsCompare(p1_1, p2_1);
        if (comp !== 0) return comp; // the selected points are the same

        if (eps.pointsSame(p1_2, p2_2)) // if the non-selected points are the same too...
          return 0; // then the segments are equal

        if (p1_isStart !== p2_isStart) // if one is a start and the other isn't...
          return p1_isStart ? 1 : -1; // favor the one that isn't the start
        // otherwise, we'll have to calculate which one is below the other manually

        return eps.pointAboveOrOnLine(p1_2, p2_isStart ? p2_1 : p2_2, // order matters
        p2_isStart ? p2_2 : p2_1) ? 1 : -1;
      }

      function eventAdd(ev, other_pt) {
        event_root.insertBefore(ev, function (here) {
          // should ev be inserted before here?
          var comp = eventCompare(ev.isStart, ev.pt, other_pt, here.isStart, here.pt, here.other.pt);
          return comp < 0;
        });
      }

      function eventAddSegmentStart(seg, primary) {
        var ev_start = LinkedList.node({
          isStart: true,
          pt: seg.start,
          seg: seg,
          primary: primary,
          other: null,
          status: null
        });
        eventAdd(ev_start, seg.end);
        return ev_start;
      }

      function eventAddSegmentEnd(ev_start, seg, primary) {
        var ev_end = LinkedList.node({
          isStart: false,
          pt: seg.end,
          seg: seg,
          primary: primary,
          other: ev_start,
          status: null
        });
        ev_start.other = ev_end;
        eventAdd(ev_end, ev_start.pt);
      }

      function eventAddSegment(seg, primary) {
        var ev_start = eventAddSegmentStart(seg, primary);
        eventAddSegmentEnd(ev_start, seg, primary);
        return ev_start;
      }

      function eventUpdateEnd(ev, end) {
        // slides an end backwards
        //   (start)------------(end)    to:
        //   (start)---(end)
        if (buildLog) buildLog.segmentChop(ev.seg, end);
        ev.other.remove();
        ev.seg.end = end;
        ev.other.pt = end;
        eventAdd(ev.other, ev.pt);
      }

      function eventDivide(ev, pt) {
        var ns = segmentCopy(pt, ev.seg.end, ev.seg);
        eventUpdateEnd(ev, pt);
        return eventAddSegment(ns, ev.primary);
      }

      function _calculate(primaryPolyInverted, secondaryPolyInverted) {
        // if selfIntersection is true then there is no secondary polygon, so that isn't used
        //
        // status logic
        //
        var status_root = LinkedList.create();

        function statusCompare(ev1, ev2) {
          var a1 = ev1.seg.start;
          var a2 = ev1.seg.end;
          var b1 = ev2.seg.start;
          var b2 = ev2.seg.end;

          if (eps.pointsCollinear(a1, b1, b2)) {
            if (eps.pointsCollinear(a2, b1, b2)) return 1; //eventCompare(true, a1, a2, true, b1, b2);

            return eps.pointAboveOrOnLine(a2, b1, b2) ? 1 : -1;
          }

          return eps.pointAboveOrOnLine(a1, b1, b2) ? 1 : -1;
        }

        function statusFindSurrounding(ev) {
          return status_root.findTransition(function (here) {
            var comp = statusCompare(ev, here.ev);
            return comp > 0;
          });
        }

        function checkIntersection(ev1, ev2) {
          // returns the segment equal to ev1, or false if nothing equal
          var seg1 = ev1.seg;
          var seg2 = ev2.seg;
          var a1 = seg1.start;
          var a2 = seg1.end;
          var b1 = seg2.start;
          var b2 = seg2.end;
          if (buildLog) buildLog.checkIntersection(seg1, seg2);
          var i = eps.linesIntersect(a1, a2, b1, b2);

          if (i === false) {
            // segments are parallel or coincident
            // if points aren't collinear, then the segments are parallel, so no intersections
            if (!eps.pointsCollinear(a1, a2, b1)) return false; // otherwise, segments are on top of each other somehow (aka coincident)

            if (eps.pointsSame(a1, b2) || eps.pointsSame(a2, b1)) return false; // segments touch at endpoints... no intersection

            var a1_equ_b1 = eps.pointsSame(a1, b1);
            var a2_equ_b2 = eps.pointsSame(a2, b2);
            if (a1_equ_b1 && a2_equ_b2) return ev2; // segments are exactly equal

            var a1_between = !a1_equ_b1 && eps.pointBetween(a1, b1, b2);
            var a2_between = !a2_equ_b2 && eps.pointBetween(a2, b1, b2); // handy for debugging:
            // buildLog.log({
            //	a1_equ_b1: a1_equ_b1,
            //	a2_equ_b2: a2_equ_b2,
            //	a1_between: a1_between,
            //	a2_between: a2_between
            // });

            if (a1_equ_b1) {
              if (a2_between) {
                //  (a1)---(a2)
                //  (b1)----------(b2)
                eventDivide(ev2, a2);
              } else {
                //  (a1)----------(a2)
                //  (b1)---(b2)
                eventDivide(ev1, b2);
              }

              return ev2;
            } else if (a1_between) {
              if (!a2_equ_b2) {
                // make a2 equal to b2
                if (a2_between) {
                  //         (a1)---(a2)
                  //  (b1)-----------------(b2)
                  eventDivide(ev2, a2);
                } else {
                  //         (a1)----------(a2)
                  //  (b1)----------(b2)
                  eventDivide(ev1, b2);
                }
              } //         (a1)---(a2)
              //  (b1)----------(b2)


              eventDivide(ev2, a1);
            }
          } else {
            // otherwise, lines intersect at i.pt, which may or may not be between the endpoints
            // is A divided between its endpoints? (exclusive)
            if (i.alongA === 0) {
              if (i.alongB === -1) // yes, at exactly b1
                eventDivide(ev1, b1);else if (i.alongB === 0) // yes, somewhere between B's endpoints
                eventDivide(ev1, i.pt);else if (i.alongB === 1) // yes, at exactly b2
                eventDivide(ev1, b2);
            } // is B divided between its endpoints? (exclusive)


            if (i.alongB === 0) {
              if (i.alongA === -1) // yes, at exactly a1
                eventDivide(ev2, a1);else if (i.alongA === 0) // yes, somewhere between A's endpoints (exclusive)
                eventDivide(ev2, i.pt);else if (i.alongA === 1) // yes, at exactly a2
                eventDivide(ev2, a2);
            }
          }

          return false;
        } //
        // main event loop
        //


        var segments = [];

        while (!event_root.isEmpty()) {
          var ev = event_root.getHead();
          if (buildLog) buildLog.vert(ev.pt[0]);

          if (ev.isStart) {
            var checkBothIntersections = function checkBothIntersections() {
              if (above) {
                var eve = checkIntersection(ev, above);
                if (eve) return eve;
              }

              if (below) return checkIntersection(ev, below);
              return false;
            };

            if (buildLog) buildLog.segmentNew(ev.seg, ev.primary);
            var surrounding = statusFindSurrounding(ev);
            var above = surrounding.before ? surrounding.before.ev : null;
            var below = surrounding.after ? surrounding.after.ev : null;

            if (buildLog) {
              buildLog.tempStatus(ev.seg, above ? above.seg : false, below ? below.seg : false);
            }

            var eve = checkBothIntersections();

            if (eve) {
              // ev and eve are equal
              // we'll keep eve and throw away ev
              // merge ev.seg's fill information into eve.seg
              if (selfIntersection) {
                var toggle; // are we a toggling edge?

                if (ev.seg.myFill.below === null) toggle = true;else toggle = ev.seg.myFill.above !== ev.seg.myFill.below; // merge two segments that belong to the same polygon
                // think of this as sandwiching two segments together, where `eve.seg` is
                // the bottom -- this will cause the above fill flag to toggle

                if (toggle) eve.seg.myFill.above = !eve.seg.myFill.above;
              } else {
                // merge two segments that belong to different polygons
                // each segment has distinct knowledge, so no special logic is needed
                // note that this can only happen once per segment in this phase, because we
                // are guaranteed that all self-intersections are gone
                eve.seg.otherFill = ev.seg.myFill;
              }

              if (buildLog) buildLog.segmentUpdate(eve.seg);
              ev.other.remove();
              ev.remove();
            }

            if (event_root.getHead() !== ev) {
              // something was inserted before us in the event queue, so loop back around and
              // process it before continuing
              if (buildLog) buildLog.rewind(ev.seg);
              continue;
            } //
            // calculate fill flags
            //


            if (selfIntersection) {
              var toggle; // are we a toggling edge?

              if (ev.seg.myFill.below === null) // if we are a new segment...
                toggle = true; // then we toggle
              else // we are a segment that has previous knowledge from a division
                toggle = ev.seg.myFill.above !== ev.seg.myFill.below; // calculate toggle
              // next, calculate whether we are filled below us

              if (!below) {
                // if nothing is below us...
                // we are filled below us if the polygon is inverted
                ev.seg.myFill.below = primaryPolyInverted;
              } else {
                // otherwise, we know the answer -- it's the same if whatever is below
                // us is filled above it
                ev.seg.myFill.below = below.seg.myFill.above;
              } // since now we know if we're filled below us, we can calculate whether
              // we're filled above us by applying toggle to whatever is below us


              if (toggle) ev.seg.myFill.above = !ev.seg.myFill.below;else ev.seg.myFill.above = ev.seg.myFill.below;
            } else {
              // now we fill in any missing transition information, since we are all-knowing
              // at this point
              if (ev.seg.otherFill === null) {
                // if we don't have other information, then we need to figure out if we're
                // inside the other polygon
                var inside;

                if (!below) {
                  // if nothing is below us, then we're inside if the other polygon is
                  // inverted
                  inside = ev.primary ? secondaryPolyInverted : primaryPolyInverted;
                } else {
                  // otherwise, something is below us
                  // so copy the below segment's other polygon's above
                  if (ev.primary === below.primary) inside = below.seg.otherFill.above;else inside = below.seg.myFill.above;
                }

                ev.seg.otherFill = {
                  above: inside,
                  below: inside
                };
              }
            }

            if (buildLog) {
              buildLog.status(ev.seg, above ? above.seg : false, below ? below.seg : false);
            } // insert the status and remember it for later removal


            ev.other.status = surrounding.insert(LinkedList.node({
              ev: ev
            }));
          } else {
            var st = ev.status;

            if (st === null) {
              throw new Error('PolyBool: Zero-length segment detected; your epsilon is ' + 'probably too small or too large');
            } // removing the status will create two new adjacent edges, so we'll need to check
            // for those


            if (status_root.exists(st.prev) && status_root.exists(st.next)) checkIntersection(st.prev.ev, st.next.ev);
            if (buildLog) buildLog.statusRemove(st.ev.seg); // remove the status

            st.remove(); // if we've reached this point, we've calculated everything there is to know, so
            // save the segment for reporting

            if (!ev.primary) {
              // make sure `seg.myFill` actually points to the primary polygon though
              var s = ev.seg.myFill;
              ev.seg.myFill = ev.seg.otherFill;
              ev.seg.otherFill = s;
            }

            segments.push(ev.seg);
          } // remove the event and continue


          event_root.getHead().remove();
        }

        if (buildLog) buildLog.done();
        return segments;
      } // return the appropriate API depending on what we're doing


      if (!selfIntersection) {
        // performing combination of polygons, so only deal with already-processed segments
        return {
          calculate: function calculate(segments1, inverted1, segments2, inverted2) {
            // segmentsX come from the self-intersection API, or this API
            // invertedX is whether we treat that list of segments as an inverted polygon or not
            // returns segments that can be used for further operations
            segments1.forEach(function (seg) {
              eventAddSegment(segmentCopy(seg.start, seg.end, seg), true);
            });
            segments2.forEach(function (seg) {
              eventAddSegment(segmentCopy(seg.start, seg.end, seg), false);
            });
            return _calculate(inverted1, inverted2);
          }
        };
      } // otherwise, performing self-intersection, so deal with regions


      return {
        addRegion: function addRegion(region) {
          // regions are a list of points:
          //  [ [0, 0], [100, 0], [50, 100] ]
          // you can add multiple regions before running calculate
          var pt1;
          var pt2 = region[region.length - 1];

          for (var i = 0; i < region.length; i++) {
            pt1 = pt2;
            pt2 = region[i];
            var forward = eps.pointsCompare(pt1, pt2);
            if (forward === 0) // points are equal, so we have a zero-length segment
              continue; // just skip it

            eventAddSegment(segmentNew(forward < 0 ? pt1 : pt2, forward < 0 ? pt2 : pt1), true);
          }
        },
        calculate: function calculate(inverted) {
          // is the polygon inverted?
          // returns segments
          return _calculate(inverted, false);
        }
      };
    }

    module.exports = Intersecter;
  }, {
    "./linked-list": 6
  }],
  6: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // simple linked list implementation that allows you to traverse down nodes and save positions
    //
    var LinkedList = {
      create: function create() {
        var my = {
          root: {
            root: true,
            next: null
          },
          exists: function exists(node) {
            if (node === null || node === my.root) return false;
            return true;
          },
          isEmpty: function isEmpty() {
            return my.root.next === null;
          },
          getHead: function getHead() {
            return my.root.next;
          },
          insertBefore: function insertBefore(node, check) {
            var last = my.root;
            var here = my.root.next;

            while (here !== null) {
              if (check(here)) {
                node.prev = here.prev;
                node.next = here;
                here.prev.next = node;
                here.prev = node;
                return;
              }

              last = here;
              here = here.next;
            }

            last.next = node;
            node.prev = last;
            node.next = null;
          },
          findTransition: function findTransition(check) {
            var prev = my.root;
            var here = my.root.next;

            while (here !== null) {
              if (check(here)) break;
              prev = here;
              here = here.next;
            }

            return {
              before: prev === my.root ? null : prev,
              after: here,
              insert: function insert(node) {
                node.prev = prev;
                node.next = here;
                prev.next = node;
                if (here !== null) here.prev = node;
                return node;
              }
            };
          }
        };
        return my;
      },
      node: function node(data) {
        data.prev = null;
        data.next = null;

        data.remove = function () {
          data.prev.next = data.next;
          if (data.next) data.next.prev = data.prev;
          data.prev = null;
          data.next = null;
        };

        return data;
      }
    };
    module.exports = LinkedList;
  }, {}],
  7: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // converts a list of segments into a list of regions, while also removing unnecessary verticies
    //
    function SegmentChainer(segments, eps, buildLog) {
      var chains = [];
      var regions = [];
      segments.forEach(function (seg) {
        var pt1 = seg.start;
        var pt2 = seg.end;

        if (eps.pointsSame(pt1, pt2)) {
          console.warn('PolyBool: Warning: Zero-length segment detected; your epsilon is ' + 'probably too small or too large');
          return;
        }

        if (buildLog) buildLog.chainStart(seg); // search for two chains that this segment matches

        var first_match = {
          index: 0,
          matches_head: false,
          matches_pt1: false
        };
        var second_match = {
          index: 0,
          matches_head: false,
          matches_pt1: false
        };
        var next_match = first_match;

        function setMatch(index, matches_head, matches_pt1) {
          // return true if we've matched twice
          next_match.index = index;
          next_match.matches_head = matches_head;
          next_match.matches_pt1 = matches_pt1;

          if (next_match === first_match) {
            next_match = second_match;
            return false;
          }

          next_match = null;
          return true; // we've matched twice, we're done here
        }

        for (var i = 0; i < chains.length; i++) {
          var chain = chains[i];
          var head = chain[0];
          var head2 = chain[1];
          var tail = chain[chain.length - 1];
          var tail2 = chain[chain.length - 2];

          if (eps.pointsSame(head, pt1)) {
            if (setMatch(i, true, true)) break;
          } else if (eps.pointsSame(head, pt2)) {
            if (setMatch(i, true, false)) break;
          } else if (eps.pointsSame(tail, pt1)) {
            if (setMatch(i, false, true)) break;
          } else if (eps.pointsSame(tail, pt2)) {
            if (setMatch(i, false, false)) break;
          }
        }

        if (next_match === first_match) {
          // we didn't match anything, so create a new chain
          chains.push([pt1, pt2]);
          if (buildLog) buildLog.chainNew(pt1, pt2);
          return;
        }

        if (next_match === second_match) {
          // we matched a single chain
          if (buildLog) buildLog.chainMatch(first_match.index); // add the other point to the apporpriate end, and check to see if we've closed the
          // chain into a loop

          var index = first_match.index;
          var pt = first_match.matches_pt1 ? pt2 : pt1; // if we matched pt1, then we add pt2, etc

          var addToHead = first_match.matches_head; // if we matched at head, then add to the head

          var chain = chains[index];
          var grow = addToHead ? chain[0] : chain[chain.length - 1];
          var grow2 = addToHead ? chain[1] : chain[chain.length - 2];
          var oppo = addToHead ? chain[chain.length - 1] : chain[0];
          var oppo2 = addToHead ? chain[chain.length - 2] : chain[1];

          if (eps.pointsCollinear(grow2, grow, pt)) {
            // grow isn't needed because it's directly between grow2 and pt:
            // grow2 ---grow---> pt
            if (addToHead) {
              if (buildLog) buildLog.chainRemoveHead(first_match.index, pt);
              chain.shift();
            } else {
              if (buildLog) buildLog.chainRemoveTail(first_match.index, pt);
              chain.pop();
            }

            grow = grow2; // old grow is gone... new grow is what grow2 was
          }

          if (eps.pointsSame(oppo, pt)) {
            // we're closing the loop, so remove chain from chains
            chains.splice(index, 1);

            if (eps.pointsCollinear(oppo2, oppo, grow)) {
              // oppo isn't needed because it's directly between oppo2 and grow:
              // oppo2 ---oppo--->grow
              if (addToHead) {
                if (buildLog) buildLog.chainRemoveTail(first_match.index, grow);
                chain.pop();
              } else {
                if (buildLog) buildLog.chainRemoveHead(first_match.index, grow);
                chain.shift();
              }
            }

            if (buildLog) buildLog.chainClose(first_match.index); // we have a closed chain!

            regions.push(chain);
            return;
          } // not closing a loop, so just add it to the apporpriate side


          if (addToHead) {
            if (buildLog) buildLog.chainAddHead(first_match.index, pt);
            chain.unshift(pt);
          } else {
            if (buildLog) buildLog.chainAddTail(first_match.index, pt);
            chain.push(pt);
          }

          return;
        } // otherwise, we matched two chains, so we need to combine those chains together


        function reverseChain(index) {
          if (buildLog) buildLog.chainReverse(index);
          chains[index].reverse(); // gee, that's easy
        }

        function appendChain(index1, index2) {
          // index1 gets index2 appended to it, and index2 is removed
          var chain1 = chains[index1];
          var chain2 = chains[index2];
          var tail = chain1[chain1.length - 1];
          var tail2 = chain1[chain1.length - 2];
          var head = chain2[0];
          var head2 = chain2[1];

          if (eps.pointsCollinear(tail2, tail, head)) {
            // tail isn't needed because it's directly between tail2 and head
            // tail2 ---tail---> head
            if (buildLog) buildLog.chainRemoveTail(index1, tail);
            chain1.pop();
            tail = tail2; // old tail is gone... new tail is what tail2 was
          }

          if (eps.pointsCollinear(tail, head, head2)) {
            // head isn't needed because it's directly between tail and head2
            // tail ---head---> head2
            if (buildLog) buildLog.chainRemoveHead(index2, head);
            chain2.shift();
          }

          if (buildLog) buildLog.chainJoin(index1, index2);
          chains[index1] = chain1.concat(chain2);
          chains.splice(index2, 1);
        }

        var F = first_match.index;
        var S = second_match.index;
        if (buildLog) buildLog.chainConnect(F, S);
        var reverseF = chains[F].length < chains[S].length; // reverse the shorter chain, if needed

        if (first_match.matches_head) {
          if (second_match.matches_head) {
            if (reverseF) {
              // <<<< F <<<< --- >>>> S >>>>
              reverseChain(F); // >>>> F >>>> --- >>>> S >>>>

              appendChain(F, S);
            } else {
              // <<<< F <<<< --- >>>> S >>>>
              reverseChain(S); // <<<< F <<<< --- <<<< S <<<<   logically same as:
              // >>>> S >>>> --- >>>> F >>>>

              appendChain(S, F);
            }
          } else {
            // <<<< F <<<< --- <<<< S <<<<   logically same as:
            // >>>> S >>>> --- >>>> F >>>>
            appendChain(S, F);
          }
        } else {
          if (second_match.matches_head) {
            // >>>> F >>>> --- >>>> S >>>>
            appendChain(F, S);
          } else {
            if (reverseF) {
              // >>>> F >>>> --- <<<< S <<<<
              reverseChain(F); // <<<< F <<<< --- <<<< S <<<<   logically same as:
              // >>>> S >>>> --- >>>> F >>>>

              appendChain(S, F);
            } else {
              // >>>> F >>>> --- <<<< S <<<<
              reverseChain(S); // >>>> F >>>> --- >>>> S >>>>

              appendChain(F, S);
            }
          }
        }
      });
      return regions;
    }

    module.exports = SegmentChainer;
  }, {}],
  8: [function (require, module, exports) {
    // (c) Copyright 2016, Sean Connelly (@voidqk), http://syntheti.cc
    // MIT License
    // Project Home: https://github.com/voidqk/polybooljs
    //
    // filter a list of segments based on boolean operations
    //
    function select(segments, selection, buildLog) {
      var result = [];
      segments.forEach(function (seg) {
        var index = (seg.myFill.above ? 8 : 0) + (seg.myFill.below ? 4 : 0) + (seg.otherFill && seg.otherFill.above ? 2 : 0) + (seg.otherFill && seg.otherFill.below ? 1 : 0);

        if (selection[index] !== 0) {
          // copy the segment to the results, while also calculating the fill status
          result.push({
            id: buildLog ? buildLog.segmentId() : -1,
            start: seg.start,
            end: seg.end,
            myFill: {
              above: selection[index] === 1,
              // 1 if filled above
              below: selection[index] === 2 // 2 if filled below

            },
            otherFill: null
          });
        }
      });
      if (buildLog) buildLog.selected(result);
      return result;
    }

    var SegmentSelector = {
      union: function union(segments, buildLog) {
        // primary | secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   yes filled below    2
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   no                  0
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   yes filled above    1
        //    1      0      1      1   =>   no                  0
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   no                  0
        //    1      1      1      0   =>   no                  0
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 2, 2, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0], buildLog);
      },
      intersect: function intersect(segments, buildLog) {
        // primary & secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   no                  0
        //    0      0      1      0   =>   no                  0
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   no                  0
        //    0      1      0      1   =>   yes filled below    2
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   yes filled below    2
        //    1      0      0      0   =>   no                  0
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   yes filled above    1
        //    1      0      1      1   =>   yes filled above    1
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled below    2
        //    1      1      1      0   =>   yes filled above    1
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 1, 1, 0, 2, 1, 0], buildLog);
      },
      difference: function difference(segments, buildLog) {
        // primary - secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   no                  0
        //    0      0      1      0   =>   no                  0
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   yes filled below    2
        //    0      1      1      1   =>   no                  0
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   yes filled above    1
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   no                  0
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled above    1
        //    1      1      1      0   =>   yes filled below    2
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 0, 0, 0, 2, 0, 2, 0, 1, 1, 0, 0, 0, 1, 2, 0], buildLog);
      },
      differenceRev: function differenceRev(segments, buildLog) {
        // secondary - primary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   no                  0
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   yes filled above    1
        //    0      1      1      1   =>   yes filled above    1
        //    1      0      0      0   =>   no                  0
        //    1      0      0      1   =>   yes filled below    2
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   yes filled below    2
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   no                  0
        //    1      1      1      0   =>   no                  0
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 0, 0, 1, 1, 0, 2, 0, 2, 0, 0, 0, 0], buildLog);
      },
      xor: function xor(segments, buildLog) {
        // primary ^ secondary
        // above1 below1 above2 below2    Keep?               Value
        //    0      0      0      0   =>   no                  0
        //    0      0      0      1   =>   yes filled below    2
        //    0      0      1      0   =>   yes filled above    1
        //    0      0      1      1   =>   no                  0
        //    0      1      0      0   =>   yes filled below    2
        //    0      1      0      1   =>   no                  0
        //    0      1      1      0   =>   no                  0
        //    0      1      1      1   =>   yes filled above    1
        //    1      0      0      0   =>   yes filled above    1
        //    1      0      0      1   =>   no                  0
        //    1      0      1      0   =>   no                  0
        //    1      0      1      1   =>   yes filled below    2
        //    1      1      0      0   =>   no                  0
        //    1      1      0      1   =>   yes filled above    1
        //    1      1      1      0   =>   yes filled below    2
        //    1      1      1      1   =>   no                  0
        return select(segments, [0, 2, 1, 0, 2, 0, 0, 1, 1, 0, 0, 2, 0, 1, 2, 0], buildLog);
      }
    };
    module.exports = SegmentSelector;
  }, {}]
}, {}, [1]);

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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