
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/PhysicsCollider.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'eab4fE4ObRBBYbAUGehBobl', 'PhysicsCollider');
// script/PhysicsCollider.js

"use strict";

function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

cc.Class({
  "extends": cc.Component,
  properties: {// polys: {
    //     get: () => {
    //         return this._polys.map((v) => { return this._convertClipperPathToVecArray(v) });
    //     }
    // }
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this.DIG_OPTIMIZE_SIZE = 1; //

    this._commands = [];
    this._physicsPolygonColliders = [];
    this._polys = [[]];
  },
  // get polys() {
  //     return this._polys.map((v) => { return this._convertClipperPathToVecArray(v) });
  // },
  start: function start() {},
  _convertClipperPathToVecArray: function _convertClipperPathToVecArray(poly) {
    return poly.map(function (p) {
      return cc.v2(p.X, p.Y);
    });
  },
  _convertVecArrayToClipperPath: function _convertVecArrayToClipperPath(poly) {
    return poly.map(function (p) {
      return {
        X: p.x,
        Y: p.y
      };
    });
  },
  _convertClipperPathToPoly2triPoint: function _convertClipperPathToPoly2triPoint(poly, exclude) {
    // return poly.map((p) => { return new poly2tri.Point(p.X, p.Y) });
    var newPos = [];
    poly.forEach(function (p, i) {
      var p_now = new poly2tri.Point(p.X, p.Y);
      var isIn = exclude.some(function (e_p) {
        if (e_p.equals(p_now)) {
          return true;
        }
      });

      if (!isIn) {
        newPos.push(p_now);
        exclude.push(p_now);
      }
    });
    if (newPos.length > 2) return newPos;else return [];
  },
  init: function init(polys) {
    var _this = this;

    this._polys = polys.map(function (v) {
      return _this._convertVecArrayToClipperPath(v);
    });
    this._commands = [];
  },
  polyDifference: function polyDifference(poly, ctx) {
    var _this2 = this;

    if (!ctx) {
      cc.error("no ctx");
    }

    var cpr = new ClipperLib.Clipper();
    var subj_paths = this._polys;
    var clip_paths = [this._convertVecArrayToClipperPath(poly)];
    cpr.AddPaths(subj_paths, ClipperLib.PolyType.ptSubject, true);
    cpr.AddPaths(clip_paths, ClipperLib.PolyType.ptClip, true);
    var subject_fillType = ClipperLib.PolyFillType.pftEvenOdd;
    var clip_fillType = ClipperLib.PolyFillType.pftEvenOdd;
    var solution_polytree = new ClipperLib.PolyTree();
    cpr.Execute(ClipperLib.ClipType.ctDifference, solution_polytree, subject_fillType, clip_fillType);
    var solution_expolygons = ClipperLib.JS.PolyTreeToExPolygons(solution_polytree);
    this._polys = ClipperLib.Clipper.PolyTreeToPaths(solution_polytree); //

    ctx && ctx.clear(true);
    var _physicsPolygonColliders_count = 0;

    var _loop = function _loop() {
      var expolygon = _step.value;

      // let outers = ClipperLib.Clipper.SimplifyPolygon(expolygon.outer,ClipperLib.PolyFillType.pftEvenOdd);
      // cc.log(outer,"outer",expolygon.outer)
      var countor = _this2._convertClipperPathToPoly2triPoint(expolygon.outer);

      if (countor.length < 2) return "continue";
      var swctx = new poly2tri.SweepContext(countor, {
        cloneArrays: true
      }); // let exclude = countor;

      var holes = expolygon.holes.map(function (h) {
        return _this2._convertClipperPathToPoly2triPoint(h, countor);
      });

      try {
        // 防止 addhole 失败 使用try
        swctx.addHoles(holes);
        swctx.triangulate();
        var triangles = swctx.getTriangles();

        for (var _iterator2 = _createForOfIteratorHelperLoose(triangles), _step2; !(_step2 = _iterator2()).done;) {
          var tri = _step2.value;
          // 逐一处理三角形
          var c = _this2._physicsPolygonColliders[_physicsPolygonColliders_count];

          if (!c) {
            c = _this2.addComponent(cc.PhysicsPolygonCollider);
            c.friction = 0;
            c.restitution = 0;
            _this2._physicsPolygonColliders[_physicsPolygonColliders_count] = c;
          }

          c.points = tri.getPoints().map(function (v, i) {
            if (ctx) {
              if (i === 0) ctx.moveTo(v.x, v.y);else ctx.lineTo(v.x, v.y);
            }

            return cc.v2(v.x, v.y);
          });
          c.apply();
          _physicsPolygonColliders_count++;

          if (ctx) {
            ctx.close();
            ctx.fill();
          }
        }
      } catch (e) {
        console.error('polyDifference poly2tri error', _physicsPolygonColliders_count, expolygon);
        console.error(e);
        return "continue";
      }
    };

    for (var _iterator = _createForOfIteratorHelperLoose(solution_expolygons), _step; !(_step = _iterator()).done;) {
      var _ret = _loop();

      if (_ret === "continue") continue;
    }

    this._physicsPolygonColliders.slice(_physicsPolygonColliders_count).forEach(function (v) {
      if (v.points.length) {
        v.points.length = 0;
        v.apply();
      }
    });
  },
  pushCommand: function pushCommand(name, params) {
    this._commands.push({
      name: name,
      params: params
    });
  },
  lateUpdate: function lateUpdate(dt) {
    if (this._commands.length) {
      // 每帧执行命令队列
      for (var index = 0; index < 2; index++) {
        var cmd = this._commands.shift();

        if (cmd) this[cmd.name].apply(this, cmd.params);else break;
      }
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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