
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/test.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b966cllGNNEA7loFRhDfuaQ', 'test');
// script/test.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    water: cc.Prefab,
    waterLayer: cc.Node,
    ground: cc.Node,
    graphics: cc.Graphics
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this.DIG_RADIUS = 50;
    this.DIG_FRAGMENT = 12; //

    this.DIG_OPTIMIZE_SIZE = 1; //

    cc.macro.ENABLE_MULTI_TOUCH = false;
    var manager = cc.director.getPhysicsManager();
    manager.enabled = true; // cc.director.getPhysicsManager().debugDrawFlags = true;

    manager.enabledAccumulator = true;
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
    manager.VELOCITY_ITERATIONS = 8;
    manager.POSITION_ITERATIONS = 8; //

    for (var index = 0; index < 100; index++) {
      c = this.ground.addComponent(cc.PhysicsChainCollider);
      c.loop = true;
      c.enabled = false;
    } // this.node.on("touchstart", this.creatWater, this);

  },
  start: function start() {
    //
    this.ground.on(cc.Node.EventType.TOUCH_START, this._touchMove, this);
    this.ground.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this); //

    this.reset(); //

    this.schedule(this.creatWater, 0.5);
  },
  _optimizePoint: function _optimizePoint(point) {
    return [Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE];
  },
  _optimizeRegions: function _optimizeRegions() {
    var _this = this;

    var regions = [];

    var _loop = function _loop(index) {
      var pos = _this._regions[index];
      var newPos = [];
      pos.forEach(function (p, i) {
        p = _this._optimizePoint(p);

        var p_pre = _this._optimizePoint(pos[(i - 1 + pos.length) % pos.length]);

        var p_next = _this._optimizePoint(pos[(i + 1) % pos.length]);

        var vec1 = cc.v2(p[0] - p_pre[0], p[1] - p_pre[1]);
        var vec2 = cc.v2(p_next[0] - p[0], p_next[1] - p[1]);

        if (vec1.lengthSqr() != 0 && vec2.lengthSqr() != 0 && vec1.cross(vec2) != 0) {
          newPos.push(p);
        }
      });

      if (newPos.length > 2) {
        regions.push(newPos);
      }
    };

    for (var index = 0; index < this._regions.length; index++) {
      _loop(index);
    }

    this._regions = regions;
  },
  reset: function reset() {
    this._regions = [[[-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]]];
    this.draw();
  },
  draw: function draw() {
    var _this2 = this;

    var chains = this.ground.getComponents(cc.PhysicsChainCollider);
    chains.forEach(function (c) {
      c.enabled = false;
    });
    var enabled_chains_points = [[]];

    for (var index = 0; index < this._regions.length; index++) {
      var pos = this._regions[index];
      var poly = chains[index];

      if (!poly) {
        poly = this.ground.addComponent(cc.PhysicsChainCollider);
        poly.loop = true;
      }

      poly.points.length = 0;
      poly.points = pos.map(function (v, i) {
        var v2 = cc.v2(v[0], v[1]);
        return v2;
      });
      poly.enabled = true;
      enabled_chains_points[index] = poly.points;
    } //


    this.graphics.clear(true);
    var enabled_chains_points_sort = enabled_chains_points.map(function (curPoly, curPoly_i) {
      var count = enabled_chains_points.reduce(function (pre, nextPoly, nextPoly_i) {
        if (curPoly_i != nextPoly_i) {
          var length = curPoly.length;

          for (var i = 0; i < length; ++i) {
            var p0 = curPoly[i];
            if (!cc.Intersection.pointInPolygon(p0, nextPoly)) return pre;
          }

          return pre + 1;
        }

        return pre;
      }, 0);
      return {
        curPoly: curPoly,
        count: count
      };
    }).sort(function (a, b) {
      return a.count - b.count;
    });
    enabled_chains_points_sort.forEach(function (_ref) {
      var curPoly = _ref.curPoly,
          count = _ref.count;
      _this2.graphics.fillColor = count % 2 === 0 ? cc.Color.ORANGE : cc.Color.BLACK;

      _this2._drawPoly(_this2.graphics, curPoly);

      _this2.graphics.fill();
    });
  },
  _touchMove: function _touchMove(touch) {
    // let regions = [[]];
    // let pos = this.ground.convertToNodeSpaceAR(touch.getLocation());
    // let count = this.DIG_FRAGMENT;
    // for (let index = 0; index < count; index++) {
    //     let r = 2 * Math.PI * index / count;
    //     let x = pos.x + this.DIG_RADIUS * Math.cos(r);
    //     let y = pos.y + this.DIG_RADIUS * Math.sin(r);
    //     regions[0].push([x, y]);
    // }
    var regions = [[]];
    var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
    var delta = touch.getDelta();
    var count = this.DIG_FRAGMENT;

    if (delta.lengthSqr() < 5) {
      for (var index = 0; index < count; index++) {
        var r = 2 * Math.PI * index / count;
        var x = pos.x + this.DIG_RADIUS * Math.cos(r);
        var y = pos.y + this.DIG_RADIUS * Math.sin(r);
        regions[0].push(this._optimizePoint([x, y]));
      }
    } else {
      var startPos = pos.sub(delta);

      for (var _index = 0; _index < count; _index++) {
        var _r = 2 * Math.PI * _index / count;

        var vec_x = this.DIG_RADIUS * Math.cos(_r);
        var vec_y = this.DIG_RADIUS * Math.sin(_r);

        var _x = void 0,
            _y = void 0;

        if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
          _x = pos.x + vec_x;
          _y = pos.y + vec_y;
        } else {
          _x = startPos.x + vec_x;
          _y = startPos.y + vec_y;
        }

        regions[0].push(this._optimizePoint([_x, _y]));
      }
    } // let result = PolyBool.difference({
    //     regions: this._regions,
    //     inverted: false
    // }, {
    //     regions,
    //     inverted: false
    // });


    var seg1 = PolyBool.segments({
      regions: this._regions,
      inverted: false
    });
    var seg2 = PolyBool.segments({
      regions: regions,
      inverted: false
    });
    var comb = PolyBool.combine(seg1, seg2);
    var result = PolyBool.polygon(PolyBool.selectDifference(comb)); //

    this._regions = result.regions;

    this._optimizeRegions();

    this.draw();
  },
  _drawPoly: function _drawPoly(ctx, poly) {
    poly.forEach(function (pos, i) {
      if (i === 0) ctx.moveTo(pos.x, pos.y);else ctx.lineTo(pos.x, pos.y);
      ctx.close();
    });
  },
  creatWater: function creatWater() {
    var waterNum = 1;

    for (var i = 0; i < waterNum; i++) {
      var waterPre = cc.instantiate(this.water);
      waterPre.x = 0;
      waterPre.y = cc.winSize.height;
      this.waterLayer.addChild(waterPre);
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0XFx0ZXN0LmpzIl0sIm5hbWVzIjpbImNjIiwiQ2xhc3MiLCJDb21wb25lbnQiLCJwcm9wZXJ0aWVzIiwid2F0ZXIiLCJQcmVmYWIiLCJ3YXRlckxheWVyIiwiTm9kZSIsImdyb3VuZCIsImdyYXBoaWNzIiwiR3JhcGhpY3MiLCJvbkxvYWQiLCJESUdfUkFESVVTIiwiRElHX0ZSQUdNRU5UIiwiRElHX09QVElNSVpFX1NJWkUiLCJtYWNybyIsIkVOQUJMRV9NVUxUSV9UT1VDSCIsIm1hbmFnZXIiLCJkaXJlY3RvciIsImdldFBoeXNpY3NNYW5hZ2VyIiwiZW5hYmxlZCIsImVuYWJsZWRBY2N1bXVsYXRvciIsIlBoeXNpY3NNYW5hZ2VyIiwiRklYRURfVElNRV9TVEVQIiwiVkVMT0NJVFlfSVRFUkFUSU9OUyIsIlBPU0lUSU9OX0lURVJBVElPTlMiLCJpbmRleCIsImMiLCJhZGRDb21wb25lbnQiLCJQaHlzaWNzQ2hhaW5Db2xsaWRlciIsImxvb3AiLCJzdGFydCIsIm9uIiwiRXZlbnRUeXBlIiwiVE9VQ0hfU1RBUlQiLCJfdG91Y2hNb3ZlIiwiVE9VQ0hfTU9WRSIsInJlc2V0Iiwic2NoZWR1bGUiLCJjcmVhdFdhdGVyIiwiX29wdGltaXplUG9pbnQiLCJwb2ludCIsIk1hdGgiLCJmbG9vciIsIl9vcHRpbWl6ZVJlZ2lvbnMiLCJyZWdpb25zIiwicG9zIiwiX3JlZ2lvbnMiLCJuZXdQb3MiLCJmb3JFYWNoIiwicCIsImkiLCJwX3ByZSIsImxlbmd0aCIsInBfbmV4dCIsInZlYzEiLCJ2MiIsInZlYzIiLCJsZW5ndGhTcXIiLCJjcm9zcyIsInB1c2giLCJ3aW5TaXplIiwid2lkdGgiLCJkcmF3IiwiY2hhaW5zIiwiZ2V0Q29tcG9uZW50cyIsImVuYWJsZWRfY2hhaW5zX3BvaW50cyIsInBvbHkiLCJwb2ludHMiLCJtYXAiLCJ2IiwiY2xlYXIiLCJlbmFibGVkX2NoYWluc19wb2ludHNfc29ydCIsImN1clBvbHkiLCJjdXJQb2x5X2kiLCJjb3VudCIsInJlZHVjZSIsInByZSIsIm5leHRQb2x5IiwibmV4dFBvbHlfaSIsInAwIiwiSW50ZXJzZWN0aW9uIiwicG9pbnRJblBvbHlnb24iLCJzb3J0IiwiYSIsImIiLCJmaWxsQ29sb3IiLCJDb2xvciIsIk9SQU5HRSIsIkJMQUNLIiwiX2RyYXdQb2x5IiwiZmlsbCIsInRvdWNoIiwibm9kZSIsImNvbnZlcnRUb05vZGVTcGFjZUFSIiwiZ2V0TG9jYXRpb24iLCJkZWx0YSIsImdldERlbHRhIiwiciIsIlBJIiwieCIsImNvcyIsInkiLCJzaW4iLCJzdGFydFBvcyIsInN1YiIsInZlY194IiwidmVjX3kiLCJkb3QiLCJzZWcxIiwiUG9seUJvb2wiLCJzZWdtZW50cyIsImludmVydGVkIiwic2VnMiIsImNvbWIiLCJjb21iaW5lIiwicmVzdWx0IiwicG9seWdvbiIsInNlbGVjdERpZmZlcmVuY2UiLCJjdHgiLCJtb3ZlVG8iLCJsaW5lVG8iLCJjbG9zZSIsIndhdGVyTnVtIiwid2F0ZXJQcmUiLCJpbnN0YW50aWF0ZSIsImhlaWdodCIsImFkZENoaWxkIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7OztBQUNBQSxFQUFFLENBQUNDLEtBQUgsQ0FBUztBQUNMLGFBQVNELEVBQUUsQ0FBQ0UsU0FEUDtBQUdMQyxFQUFBQSxVQUFVLEVBQUU7QUFDUkMsSUFBQUEsS0FBSyxFQUFFSixFQUFFLENBQUNLLE1BREY7QUFFUkMsSUFBQUEsVUFBVSxFQUFFTixFQUFFLENBQUNPLElBRlA7QUFHUkMsSUFBQUEsTUFBTSxFQUFFUixFQUFFLENBQUNPLElBSEg7QUFJUkUsSUFBQUEsUUFBUSxFQUFFVCxFQUFFLENBQUNVO0FBSkwsR0FIUDtBQVVMO0FBRUFDLEVBQUFBLE1BWkssb0JBWUk7QUFDTDtBQUNBLFNBQUtDLFVBQUwsR0FBa0IsRUFBbEI7QUFDQSxTQUFLQyxZQUFMLEdBQW9CLEVBQXBCLENBSEssQ0FJTDs7QUFDQSxTQUFLQyxpQkFBTCxHQUF5QixDQUF6QixDQUxLLENBTUw7O0FBQ0FkLElBQUFBLEVBQUUsQ0FBQ2UsS0FBSCxDQUFTQyxrQkFBVCxHQUE4QixLQUE5QjtBQUNBLFFBQUlDLE9BQU8sR0FBR2pCLEVBQUUsQ0FBQ2tCLFFBQUgsQ0FBWUMsaUJBQVosRUFBZDtBQUNBRixJQUFBQSxPQUFPLENBQUNHLE9BQVIsR0FBa0IsSUFBbEIsQ0FUSyxDQVVMOztBQUNBSCxJQUFBQSxPQUFPLENBQUNJLGtCQUFSLEdBQTZCLElBQTdCO0FBQ0FyQixJQUFBQSxFQUFFLENBQUNzQixjQUFILENBQWtCQyxlQUFsQixHQUFvQyxJQUFJLEVBQXhDO0FBQ0FOLElBQUFBLE9BQU8sQ0FBQ08sbUJBQVIsR0FBOEIsQ0FBOUI7QUFDQVAsSUFBQUEsT0FBTyxDQUFDUSxtQkFBUixHQUE4QixDQUE5QixDQWRLLENBZUw7O0FBQ0EsU0FBSyxJQUFJQyxLQUFLLEdBQUcsQ0FBakIsRUFBb0JBLEtBQUssR0FBRyxHQUE1QixFQUFpQ0EsS0FBSyxFQUF0QyxFQUEwQztBQUN0Q0MsTUFBQUEsQ0FBQyxHQUFHLEtBQUtuQixNQUFMLENBQVlvQixZQUFaLENBQXlCNUIsRUFBRSxDQUFDNkIsb0JBQTVCLENBQUo7QUFDQUYsTUFBQUEsQ0FBQyxDQUFDRyxJQUFGLEdBQVMsSUFBVDtBQUNBSCxNQUFBQSxDQUFDLENBQUNQLE9BQUYsR0FBWSxLQUFaO0FBQ0gsS0FwQkksQ0FxQkw7O0FBQ0gsR0FsQ0k7QUFtQ0xXLEVBQUFBLEtBbkNLLG1CQW1DRztBQUNKO0FBQ0EsU0FBS3ZCLE1BQUwsQ0FBWXdCLEVBQVosQ0FBZWhDLEVBQUUsQ0FBQ08sSUFBSCxDQUFRMEIsU0FBUixDQUFrQkMsV0FBakMsRUFBOEMsS0FBS0MsVUFBbkQsRUFBK0QsSUFBL0Q7QUFDQSxTQUFLM0IsTUFBTCxDQUFZd0IsRUFBWixDQUFlaEMsRUFBRSxDQUFDTyxJQUFILENBQVEwQixTQUFSLENBQWtCRyxVQUFqQyxFQUE2QyxLQUFLRCxVQUFsRCxFQUE4RCxJQUE5RCxFQUhJLENBSUo7O0FBQ0EsU0FBS0UsS0FBTCxHQUxJLENBTUo7O0FBQ0EsU0FBS0MsUUFBTCxDQUFjLEtBQUtDLFVBQW5CLEVBQStCLEdBQS9CO0FBQ0gsR0EzQ0k7QUE0Q0xDLEVBQUFBLGNBNUNLLDBCQTRDVUMsS0E1Q1YsRUE0Q2lCO0FBQ2xCLFdBQU8sQ0FBQ0MsSUFBSSxDQUFDQyxLQUFMLENBQVdGLEtBQUssQ0FBQyxDQUFELENBQUwsR0FBVyxLQUFLM0IsaUJBQTNCLElBQWdELEtBQUtBLGlCQUF0RCxFQUF5RTRCLElBQUksQ0FBQ0MsS0FBTCxDQUFXRixLQUFLLENBQUMsQ0FBRCxDQUFMLEdBQVcsS0FBSzNCLGlCQUEzQixJQUFnRCxLQUFLQSxpQkFBOUgsQ0FBUDtBQUNILEdBOUNJO0FBK0NMOEIsRUFBQUEsZ0JBL0NLLDhCQStDYztBQUFBOztBQUNmLFFBQUlDLE9BQU8sR0FBRyxFQUFkOztBQURlLCtCQUVObkIsS0FGTTtBQUdYLFVBQUlvQixHQUFHLEdBQUcsS0FBSSxDQUFDQyxRQUFMLENBQWNyQixLQUFkLENBQVY7QUFDQSxVQUFJc0IsTUFBTSxHQUFHLEVBQWI7QUFDQUYsTUFBQUEsR0FBRyxDQUFDRyxPQUFKLENBQVksVUFBQ0MsQ0FBRCxFQUFJQyxDQUFKLEVBQVU7QUFDbEJELFFBQUFBLENBQUMsR0FBRyxLQUFJLENBQUNWLGNBQUwsQ0FBb0JVLENBQXBCLENBQUo7O0FBQ0EsWUFBSUUsS0FBSyxHQUFHLEtBQUksQ0FBQ1osY0FBTCxDQUFvQk0sR0FBRyxDQUFDLENBQUNLLENBQUMsR0FBRyxDQUFKLEdBQVFMLEdBQUcsQ0FBQ08sTUFBYixJQUF1QlAsR0FBRyxDQUFDTyxNQUE1QixDQUF2QixDQUFaOztBQUNBLFlBQUlDLE1BQU0sR0FBRyxLQUFJLENBQUNkLGNBQUwsQ0FBb0JNLEdBQUcsQ0FBQyxDQUFDSyxDQUFDLEdBQUcsQ0FBTCxJQUFVTCxHQUFHLENBQUNPLE1BQWYsQ0FBdkIsQ0FBYjs7QUFDQSxZQUFJRSxJQUFJLEdBQUd2RCxFQUFFLENBQUN3RCxFQUFILENBQU1OLENBQUMsQ0FBQyxDQUFELENBQUQsR0FBT0UsS0FBSyxDQUFDLENBQUQsQ0FBbEIsRUFBdUJGLENBQUMsQ0FBQyxDQUFELENBQUQsR0FBT0UsS0FBSyxDQUFDLENBQUQsQ0FBbkMsQ0FBWDtBQUNBLFlBQUlLLElBQUksR0FBR3pELEVBQUUsQ0FBQ3dELEVBQUgsQ0FBTUYsTUFBTSxDQUFDLENBQUQsQ0FBTixHQUFZSixDQUFDLENBQUMsQ0FBRCxDQUFuQixFQUF3QkksTUFBTSxDQUFDLENBQUQsQ0FBTixHQUFZSixDQUFDLENBQUMsQ0FBRCxDQUFyQyxDQUFYOztBQUNBLFlBQUlLLElBQUksQ0FBQ0csU0FBTCxNQUFvQixDQUFwQixJQUF5QkQsSUFBSSxDQUFDQyxTQUFMLE1BQW9CLENBQTdDLElBQWtESCxJQUFJLENBQUNJLEtBQUwsQ0FBV0YsSUFBWCxLQUFvQixDQUExRSxFQUE2RTtBQUN6RVQsVUFBQUEsTUFBTSxDQUFDWSxJQUFQLENBQVlWLENBQVo7QUFDSDtBQUNKLE9BVEQ7O0FBVUEsVUFBSUYsTUFBTSxDQUFDSyxNQUFQLEdBQWdCLENBQXBCLEVBQXVCO0FBQ25CUixRQUFBQSxPQUFPLENBQUNlLElBQVIsQ0FBYVosTUFBYjtBQUNIO0FBakJVOztBQUVmLFNBQUssSUFBSXRCLEtBQUssR0FBRyxDQUFqQixFQUFvQkEsS0FBSyxHQUFHLEtBQUtxQixRQUFMLENBQWNNLE1BQTFDLEVBQWtEM0IsS0FBSyxFQUF2RCxFQUEyRDtBQUFBLFlBQWxEQSxLQUFrRDtBQWdCMUQ7O0FBQ0QsU0FBS3FCLFFBQUwsR0FBZ0JGLE9BQWhCO0FBQ0gsR0FuRUk7QUFvRUxSLEVBQUFBLEtBcEVLLG1CQW9FRztBQUNKLFNBQUtVLFFBQUwsR0FBZ0IsQ0FDWixDQUFDLENBQUMsQ0FBQy9DLEVBQUUsQ0FBQzZELE9BQUgsQ0FBV0MsS0FBWixHQUFvQixDQUFyQixFQUF3QixDQUFDLEdBQXpCLENBQUQsRUFBZ0MsQ0FBQyxDQUFDOUQsRUFBRSxDQUFDNkQsT0FBSCxDQUFXQyxLQUFaLEdBQW9CLENBQXJCLEVBQXdCLEdBQXhCLENBQWhDLEVBQThELENBQUM5RCxFQUFFLENBQUM2RCxPQUFILENBQVdDLEtBQVgsR0FBbUIsQ0FBcEIsRUFBdUIsR0FBdkIsQ0FBOUQsRUFBMkYsQ0FBQzlELEVBQUUsQ0FBQzZELE9BQUgsQ0FBV0MsS0FBWCxHQUFtQixDQUFwQixFQUF1QixDQUFDLEdBQXhCLENBQTNGLENBRFksQ0FBaEI7QUFHQSxTQUFLQyxJQUFMO0FBQ0gsR0F6RUk7QUEwRUxBLEVBQUFBLElBMUVLLGtCQTBFRTtBQUFBOztBQUNILFFBQUlDLE1BQU0sR0FBRyxLQUFLeEQsTUFBTCxDQUFZeUQsYUFBWixDQUEwQmpFLEVBQUUsQ0FBQzZCLG9CQUE3QixDQUFiO0FBQ0FtQyxJQUFBQSxNQUFNLENBQUNmLE9BQVAsQ0FBZSxVQUFDdEIsQ0FBRCxFQUFPO0FBQ2xCQSxNQUFBQSxDQUFDLENBQUNQLE9BQUYsR0FBWSxLQUFaO0FBQ0gsS0FGRDtBQUlBLFFBQUk4QyxxQkFBcUIsR0FBRyxDQUFDLEVBQUQsQ0FBNUI7O0FBRUEsU0FBSyxJQUFJeEMsS0FBSyxHQUFHLENBQWpCLEVBQW9CQSxLQUFLLEdBQUcsS0FBS3FCLFFBQUwsQ0FBY00sTUFBMUMsRUFBa0QzQixLQUFLLEVBQXZELEVBQTJEO0FBQ3ZELFVBQUlvQixHQUFHLEdBQUcsS0FBS0MsUUFBTCxDQUFjckIsS0FBZCxDQUFWO0FBQ0EsVUFBSXlDLElBQUksR0FBR0gsTUFBTSxDQUFDdEMsS0FBRCxDQUFqQjs7QUFDQSxVQUFJLENBQUN5QyxJQUFMLEVBQVc7QUFDUEEsUUFBQUEsSUFBSSxHQUFHLEtBQUszRCxNQUFMLENBQVlvQixZQUFaLENBQXlCNUIsRUFBRSxDQUFDNkIsb0JBQTVCLENBQVA7QUFDQXNDLFFBQUFBLElBQUksQ0FBQ3JDLElBQUwsR0FBWSxJQUFaO0FBQ0g7O0FBQ0RxQyxNQUFBQSxJQUFJLENBQUNDLE1BQUwsQ0FBWWYsTUFBWixHQUFxQixDQUFyQjtBQUNBYyxNQUFBQSxJQUFJLENBQUNDLE1BQUwsR0FBY3RCLEdBQUcsQ0FBQ3VCLEdBQUosQ0FBUSxVQUFDQyxDQUFELEVBQUluQixDQUFKLEVBQVU7QUFDNUIsWUFBSUssRUFBRSxHQUFHeEQsRUFBRSxDQUFDd0QsRUFBSCxDQUFNYyxDQUFDLENBQUMsQ0FBRCxDQUFQLEVBQVlBLENBQUMsQ0FBQyxDQUFELENBQWIsQ0FBVDtBQUNBLGVBQU9kLEVBQVA7QUFDSCxPQUhhLENBQWQ7QUFJQVcsTUFBQUEsSUFBSSxDQUFDL0MsT0FBTCxHQUFlLElBQWY7QUFDQThDLE1BQUFBLHFCQUFxQixDQUFDeEMsS0FBRCxDQUFyQixHQUErQnlDLElBQUksQ0FBQ0MsTUFBcEM7QUFDSCxLQXRCRSxDQXVCSDs7O0FBRUEsU0FBSzNELFFBQUwsQ0FBYzhELEtBQWQsQ0FBb0IsSUFBcEI7QUFDQSxRQUFJQywwQkFBMEIsR0FBR04scUJBQXFCLENBQUNHLEdBQXRCLENBQTBCLFVBQUNJLE9BQUQsRUFBVUMsU0FBVixFQUF3QjtBQUMvRSxVQUFJQyxLQUFLLEdBQUdULHFCQUFxQixDQUFDVSxNQUF0QixDQUE2QixVQUFDQyxHQUFELEVBQU1DLFFBQU4sRUFBZ0JDLFVBQWhCLEVBQStCO0FBQ3BFLFlBQUtMLFNBQVMsSUFBSUssVUFBbEIsRUFBK0I7QUFDM0IsY0FBSTFCLE1BQU0sR0FBR29CLE9BQU8sQ0FBQ3BCLE1BQXJCOztBQUNBLGVBQUssSUFBSUYsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBR0UsTUFBcEIsRUFBNEIsRUFBRUYsQ0FBOUIsRUFBaUM7QUFDN0IsZ0JBQUk2QixFQUFFLEdBQUdQLE9BQU8sQ0FBQ3RCLENBQUQsQ0FBaEI7QUFDQSxnQkFBSSxDQUFDbkQsRUFBRSxDQUFDaUYsWUFBSCxDQUFnQkMsY0FBaEIsQ0FBK0JGLEVBQS9CLEVBQW1DRixRQUFuQyxDQUFMLEVBQ0ksT0FBT0QsR0FBUDtBQUNQOztBQUNELGlCQUFPQSxHQUFHLEdBQUcsQ0FBYjtBQUNIOztBQUNELGVBQU9BLEdBQVA7QUFDSCxPQVhXLEVBV1QsQ0FYUyxDQUFaO0FBYUEsYUFBTztBQUFFSixRQUFBQSxPQUFPLEVBQVBBLE9BQUY7QUFBV0UsUUFBQUEsS0FBSyxFQUFMQTtBQUFYLE9BQVA7QUFDSCxLQWZnQyxFQWU5QlEsSUFmOEIsQ0FlekIsVUFBQ0MsQ0FBRCxFQUFJQyxDQUFKLEVBQVU7QUFDZCxhQUFPRCxDQUFDLENBQUNULEtBQUYsR0FBVVUsQ0FBQyxDQUFDVixLQUFuQjtBQUNILEtBakJnQyxDQUFqQztBQWtCQUgsSUFBQUEsMEJBQTBCLENBQUN2QixPQUEzQixDQUFtQyxnQkFBd0I7QUFBQSxVQUFyQndCLE9BQXFCLFFBQXJCQSxPQUFxQjtBQUFBLFVBQVpFLEtBQVksUUFBWkEsS0FBWTtBQUN2RCxNQUFBLE1BQUksQ0FBQ2xFLFFBQUwsQ0FBYzZFLFNBQWQsR0FBMEJYLEtBQUssR0FBRyxDQUFSLEtBQWMsQ0FBZCxHQUFrQjNFLEVBQUUsQ0FBQ3VGLEtBQUgsQ0FBU0MsTUFBM0IsR0FBb0N4RixFQUFFLENBQUN1RixLQUFILENBQVNFLEtBQXZFOztBQUNBLE1BQUEsTUFBSSxDQUFDQyxTQUFMLENBQWUsTUFBSSxDQUFDakYsUUFBcEIsRUFBOEJnRSxPQUE5Qjs7QUFDQSxNQUFBLE1BQUksQ0FBQ2hFLFFBQUwsQ0FBY2tGLElBQWQ7QUFDSCxLQUpEO0FBS0gsR0EzSEk7QUE0SEx4RCxFQUFBQSxVQTVISyxzQkE0SE15RCxLQTVITixFQTRIYTtBQUNkO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBLFFBQUkvQyxPQUFPLEdBQUcsQ0FBQyxFQUFELENBQWQ7QUFDQSxRQUFJQyxHQUFHLEdBQUcsS0FBS3JDLFFBQUwsQ0FBY29GLElBQWQsQ0FBbUJDLG9CQUFuQixDQUF3Q0YsS0FBSyxDQUFDRyxXQUFOLEVBQXhDLENBQVY7QUFDQSxRQUFJQyxLQUFLLEdBQUdKLEtBQUssQ0FBQ0ssUUFBTixFQUFaO0FBQ0EsUUFBSXRCLEtBQUssR0FBRyxLQUFLOUQsWUFBakI7O0FBQ0EsUUFBSW1GLEtBQUssQ0FBQ3RDLFNBQU4sS0FBb0IsQ0FBeEIsRUFBMkI7QUFDdkIsV0FBSyxJQUFJaEMsS0FBSyxHQUFHLENBQWpCLEVBQW9CQSxLQUFLLEdBQUdpRCxLQUE1QixFQUFtQ2pELEtBQUssRUFBeEMsRUFBNEM7QUFDeEMsWUFBSXdFLENBQUMsR0FBRyxJQUFJeEQsSUFBSSxDQUFDeUQsRUFBVCxHQUFjekUsS0FBZCxHQUFzQmlELEtBQTlCO0FBQ0EsWUFBSXlCLENBQUMsR0FBR3RELEdBQUcsQ0FBQ3NELENBQUosR0FBUSxLQUFLeEYsVUFBTCxHQUFrQjhCLElBQUksQ0FBQzJELEdBQUwsQ0FBU0gsQ0FBVCxDQUFsQztBQUNBLFlBQUlJLENBQUMsR0FBR3hELEdBQUcsQ0FBQ3dELENBQUosR0FBUSxLQUFLMUYsVUFBTCxHQUFrQjhCLElBQUksQ0FBQzZELEdBQUwsQ0FBU0wsQ0FBVCxDQUFsQztBQUNBckQsUUFBQUEsT0FBTyxDQUFDLENBQUQsQ0FBUCxDQUFXZSxJQUFYLENBQWdCLEtBQUtwQixjQUFMLENBQW9CLENBQUM0RCxDQUFELEVBQUlFLENBQUosQ0FBcEIsQ0FBaEI7QUFDSDtBQUNKLEtBUEQsTUFPTztBQUNILFVBQUlFLFFBQVEsR0FBRzFELEdBQUcsQ0FBQzJELEdBQUosQ0FBUVQsS0FBUixDQUFmOztBQUNBLFdBQUssSUFBSXRFLE1BQUssR0FBRyxDQUFqQixFQUFvQkEsTUFBSyxHQUFHaUQsS0FBNUIsRUFBbUNqRCxNQUFLLEVBQXhDLEVBQTRDO0FBQ3hDLFlBQUl3RSxFQUFDLEdBQUcsSUFBSXhELElBQUksQ0FBQ3lELEVBQVQsR0FBY3pFLE1BQWQsR0FBc0JpRCxLQUE5Qjs7QUFDQSxZQUFJK0IsS0FBSyxHQUFHLEtBQUs5RixVQUFMLEdBQWtCOEIsSUFBSSxDQUFDMkQsR0FBTCxDQUFTSCxFQUFULENBQTlCO0FBQ0EsWUFBSVMsS0FBSyxHQUFHLEtBQUsvRixVQUFMLEdBQWtCOEIsSUFBSSxDQUFDNkQsR0FBTCxDQUFTTCxFQUFULENBQTlCOztBQUNBLFlBQUlFLEVBQUMsU0FBTDtBQUFBLFlBQU9FLEVBQUMsU0FBUjs7QUFDQSxZQUFJTixLQUFLLENBQUNZLEdBQU4sQ0FBVTVHLEVBQUUsQ0FBQ3dELEVBQUgsQ0FBTWtELEtBQU4sRUFBYUMsS0FBYixDQUFWLElBQWlDLENBQXJDLEVBQXdDO0FBQ3BDUCxVQUFBQSxFQUFDLEdBQUd0RCxHQUFHLENBQUNzRCxDQUFKLEdBQVFNLEtBQVo7QUFDQUosVUFBQUEsRUFBQyxHQUFHeEQsR0FBRyxDQUFDd0QsQ0FBSixHQUFRSyxLQUFaO0FBQ0gsU0FIRCxNQUdPO0FBQ0hQLFVBQUFBLEVBQUMsR0FBR0ksUUFBUSxDQUFDSixDQUFULEdBQWFNLEtBQWpCO0FBQ0FKLFVBQUFBLEVBQUMsR0FBR0UsUUFBUSxDQUFDRixDQUFULEdBQWFLLEtBQWpCO0FBQ0g7O0FBQ0Q5RCxRQUFBQSxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVdlLElBQVgsQ0FBZ0IsS0FBS3BCLGNBQUwsQ0FBb0IsQ0FBQzRELEVBQUQsRUFBSUUsRUFBSixDQUFwQixDQUFoQjtBQUNIO0FBQ0osS0F0Q2EsQ0F3Q2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7OztBQUVBLFFBQUlPLElBQUksR0FBR0MsUUFBUSxDQUFDQyxRQUFULENBQWtCO0FBQ3pCbEUsTUFBQUEsT0FBTyxFQUFFLEtBQUtFLFFBRFc7QUFFekJpRSxNQUFBQSxRQUFRLEVBQUU7QUFGZSxLQUFsQixDQUFYO0FBSUEsUUFBSUMsSUFBSSxHQUFHSCxRQUFRLENBQUNDLFFBQVQsQ0FBa0I7QUFDekJsRSxNQUFBQSxPQUFPLEVBQVBBLE9BRHlCO0FBRXpCbUUsTUFBQUEsUUFBUSxFQUFFO0FBRmUsS0FBbEIsQ0FBWDtBQUlBLFFBQUlFLElBQUksR0FBR0osUUFBUSxDQUFDSyxPQUFULENBQWlCTixJQUFqQixFQUF1QkksSUFBdkIsQ0FBWDtBQUNBLFFBQUlHLE1BQU0sR0FBR04sUUFBUSxDQUFDTyxPQUFULENBQWlCUCxRQUFRLENBQUNRLGdCQUFULENBQTBCSixJQUExQixDQUFqQixDQUFiLENBekRjLENBMERkOztBQUNBLFNBQUtuRSxRQUFMLEdBQWdCcUUsTUFBTSxDQUFDdkUsT0FBdkI7O0FBQ0EsU0FBS0QsZ0JBQUw7O0FBQ0EsU0FBS21CLElBQUw7QUFDSCxHQTFMSTtBQTJMTDJCLEVBQUFBLFNBM0xLLHFCQTJMSzZCLEdBM0xMLEVBMkxVcEQsSUEzTFYsRUEyTGdCO0FBQ2pCQSxJQUFBQSxJQUFJLENBQUNsQixPQUFMLENBQWEsVUFBQ0gsR0FBRCxFQUFNSyxDQUFOLEVBQVk7QUFDckIsVUFBSUEsQ0FBQyxLQUFLLENBQVYsRUFDSW9FLEdBQUcsQ0FBQ0MsTUFBSixDQUFXMUUsR0FBRyxDQUFDc0QsQ0FBZixFQUFrQnRELEdBQUcsQ0FBQ3dELENBQXRCLEVBREosS0FHSWlCLEdBQUcsQ0FBQ0UsTUFBSixDQUFXM0UsR0FBRyxDQUFDc0QsQ0FBZixFQUFrQnRELEdBQUcsQ0FBQ3dELENBQXRCO0FBQ0ppQixNQUFBQSxHQUFHLENBQUNHLEtBQUo7QUFDSCxLQU5EO0FBT0gsR0FuTUk7QUF1TUxuRixFQUFBQSxVQXZNSyx3QkF1TVE7QUFDVCxRQUFJb0YsUUFBUSxHQUFHLENBQWY7O0FBQ0EsU0FBSyxJQUFJeEUsQ0FBQyxHQUFHLENBQWIsRUFBZ0JBLENBQUMsR0FBR3dFLFFBQXBCLEVBQThCeEUsQ0FBQyxFQUEvQixFQUFtQztBQUMvQixVQUFJeUUsUUFBUSxHQUFHNUgsRUFBRSxDQUFDNkgsV0FBSCxDQUFlLEtBQUt6SCxLQUFwQixDQUFmO0FBQ0F3SCxNQUFBQSxRQUFRLENBQUN4QixDQUFULEdBQWEsQ0FBYjtBQUNBd0IsTUFBQUEsUUFBUSxDQUFDdEIsQ0FBVCxHQUFhdEcsRUFBRSxDQUFDNkQsT0FBSCxDQUFXaUUsTUFBeEI7QUFDQSxXQUFLeEgsVUFBTCxDQUFnQnlILFFBQWhCLENBQXlCSCxRQUF6QjtBQUNIO0FBQ0osR0EvTUksQ0FrTkw7O0FBbE5LLENBQVQiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIlxyXG5jYy5DbGFzcyh7XHJcbiAgICBleHRlbmRzOiBjYy5Db21wb25lbnQsXHJcblxyXG4gICAgcHJvcGVydGllczoge1xyXG4gICAgICAgIHdhdGVyOiBjYy5QcmVmYWIsXHJcbiAgICAgICAgd2F0ZXJMYXllcjogY2MuTm9kZSxcclxuICAgICAgICBncm91bmQ6IGNjLk5vZGUsXHJcbiAgICAgICAgZ3JhcGhpY3M6IGNjLkdyYXBoaWNzLFxyXG4gICAgfSxcclxuXHJcbiAgICAvLyBMSUZFLUNZQ0xFIENBTExCQUNLUzpcclxuXHJcbiAgICBvbkxvYWQoKSB7XHJcbiAgICAgICAgLy9cclxuICAgICAgICB0aGlzLkRJR19SQURJVVMgPSA1MDtcclxuICAgICAgICB0aGlzLkRJR19GUkFHTUVOVCA9IDEyO1xyXG4gICAgICAgIC8vXHJcbiAgICAgICAgdGhpcy5ESUdfT1BUSU1JWkVfU0laRSA9IDE7XHJcbiAgICAgICAgLy9cclxuICAgICAgICBjYy5tYWNyby5FTkFCTEVfTVVMVElfVE9VQ0ggPSBmYWxzZTtcclxuICAgICAgICBsZXQgbWFuYWdlciA9IGNjLmRpcmVjdG9yLmdldFBoeXNpY3NNYW5hZ2VyKCk7XHJcbiAgICAgICAgbWFuYWdlci5lbmFibGVkID0gdHJ1ZTtcclxuICAgICAgICAvLyBjYy5kaXJlY3Rvci5nZXRQaHlzaWNzTWFuYWdlcigpLmRlYnVnRHJhd0ZsYWdzID0gdHJ1ZTtcclxuICAgICAgICBtYW5hZ2VyLmVuYWJsZWRBY2N1bXVsYXRvciA9IHRydWU7XHJcbiAgICAgICAgY2MuUGh5c2ljc01hbmFnZXIuRklYRURfVElNRV9TVEVQID0gMSAvIDMwO1xyXG4gICAgICAgIG1hbmFnZXIuVkVMT0NJVFlfSVRFUkFUSU9OUyA9IDg7XHJcbiAgICAgICAgbWFuYWdlci5QT1NJVElPTl9JVEVSQVRJT05TID0gODtcclxuICAgICAgICAvL1xyXG4gICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCAxMDA7IGluZGV4KyspIHtcclxuICAgICAgICAgICAgYyA9IHRoaXMuZ3JvdW5kLmFkZENvbXBvbmVudChjYy5QaHlzaWNzQ2hhaW5Db2xsaWRlcik7XHJcbiAgICAgICAgICAgIGMubG9vcCA9IHRydWU7XHJcbiAgICAgICAgICAgIGMuZW5hYmxlZCA9IGZhbHNlO1xyXG4gICAgICAgIH1cclxuICAgICAgICAvLyB0aGlzLm5vZGUub24oXCJ0b3VjaHN0YXJ0XCIsIHRoaXMuY3JlYXRXYXRlciwgdGhpcyk7XHJcbiAgICB9LFxyXG4gICAgc3RhcnQoKSB7XHJcbiAgICAgICAgLy9cclxuICAgICAgICB0aGlzLmdyb3VuZC5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9TVEFSVCwgdGhpcy5fdG91Y2hNb3ZlLCB0aGlzKTtcclxuICAgICAgICB0aGlzLmdyb3VuZC5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9NT1ZFLCB0aGlzLl90b3VjaE1vdmUsIHRoaXMpO1xyXG4gICAgICAgIC8vXHJcbiAgICAgICAgdGhpcy5yZXNldCgpO1xyXG4gICAgICAgIC8vXHJcbiAgICAgICAgdGhpcy5zY2hlZHVsZSh0aGlzLmNyZWF0V2F0ZXIsIDAuNSk7XHJcbiAgICB9LFxyXG4gICAgX29wdGltaXplUG9pbnQocG9pbnQpIHtcclxuICAgICAgICByZXR1cm4gW01hdGguZmxvb3IocG9pbnRbMF0gKiB0aGlzLkRJR19PUFRJTUlaRV9TSVpFKSAvIHRoaXMuRElHX09QVElNSVpFX1NJWkUsIE1hdGguZmxvb3IocG9pbnRbMV0gKiB0aGlzLkRJR19PUFRJTUlaRV9TSVpFKSAvIHRoaXMuRElHX09QVElNSVpFX1NJWkVdO1xyXG4gICAgfSxcclxuICAgIF9vcHRpbWl6ZVJlZ2lvbnMoKSB7XHJcbiAgICAgICAgbGV0IHJlZ2lvbnMgPSBbXTtcclxuICAgICAgICBmb3IgKGxldCBpbmRleCA9IDA7IGluZGV4IDwgdGhpcy5fcmVnaW9ucy5sZW5ndGg7IGluZGV4KyspIHtcclxuICAgICAgICAgICAgbGV0IHBvcyA9IHRoaXMuX3JlZ2lvbnNbaW5kZXhdO1xyXG4gICAgICAgICAgICBsZXQgbmV3UG9zID0gW107XHJcbiAgICAgICAgICAgIHBvcy5mb3JFYWNoKChwLCBpKSA9PiB7XHJcbiAgICAgICAgICAgICAgICBwID0gdGhpcy5fb3B0aW1pemVQb2ludChwKTtcclxuICAgICAgICAgICAgICAgIGxldCBwX3ByZSA9IHRoaXMuX29wdGltaXplUG9pbnQocG9zWyhpIC0gMSArIHBvcy5sZW5ndGgpICUgcG9zLmxlbmd0aF0pO1xyXG4gICAgICAgICAgICAgICAgbGV0IHBfbmV4dCA9IHRoaXMuX29wdGltaXplUG9pbnQocG9zWyhpICsgMSkgJSBwb3MubGVuZ3RoXSk7XHJcbiAgICAgICAgICAgICAgICBsZXQgdmVjMSA9IGNjLnYyKHBbMF0gLSBwX3ByZVswXSwgcFsxXSAtIHBfcHJlWzFdKTtcclxuICAgICAgICAgICAgICAgIGxldCB2ZWMyID0gY2MudjIocF9uZXh0WzBdIC0gcFswXSwgcF9uZXh0WzFdIC0gcFsxXSk7XHJcbiAgICAgICAgICAgICAgICBpZiAodmVjMS5sZW5ndGhTcXIoKSAhPSAwICYmIHZlYzIubGVuZ3RoU3FyKCkgIT0gMCAmJiB2ZWMxLmNyb3NzKHZlYzIpICE9IDApIHtcclxuICAgICAgICAgICAgICAgICAgICBuZXdQb3MucHVzaChwKTtcclxuICAgICAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgfSlcclxuICAgICAgICAgICAgaWYgKG5ld1Bvcy5sZW5ndGggPiAyKSB7XHJcbiAgICAgICAgICAgICAgICByZWdpb25zLnB1c2gobmV3UG9zKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuICAgICAgICB0aGlzLl9yZWdpb25zID0gcmVnaW9ucztcclxuICAgIH0sXHJcbiAgICByZXNldCgpIHtcclxuICAgICAgICB0aGlzLl9yZWdpb25zID0gW1xyXG4gICAgICAgICAgICBbWy1jYy53aW5TaXplLndpZHRoIC8gMiwgLTMyMF0sIFstY2Mud2luU2l6ZS53aWR0aCAvIDIsIDI1MF0sIFtjYy53aW5TaXplLndpZHRoIC8gMiwgMjUwXSwgW2NjLndpblNpemUud2lkdGggLyAyLCAtMzIwXV1cclxuICAgICAgICBdO1xyXG4gICAgICAgIHRoaXMuZHJhdygpO1xyXG4gICAgfSxcclxuICAgIGRyYXcoKSB7XHJcbiAgICAgICAgbGV0IGNoYWlucyA9IHRoaXMuZ3JvdW5kLmdldENvbXBvbmVudHMoY2MuUGh5c2ljc0NoYWluQ29sbGlkZXIpO1xyXG4gICAgICAgIGNoYWlucy5mb3JFYWNoKChjKSA9PiB7XHJcbiAgICAgICAgICAgIGMuZW5hYmxlZCA9IGZhbHNlO1xyXG4gICAgICAgIH0pXHJcblxyXG4gICAgICAgIGxldCBlbmFibGVkX2NoYWluc19wb2ludHMgPSBbW11dO1xyXG5cclxuICAgICAgICBmb3IgKGxldCBpbmRleCA9IDA7IGluZGV4IDwgdGhpcy5fcmVnaW9ucy5sZW5ndGg7IGluZGV4KyspIHtcclxuICAgICAgICAgICAgbGV0IHBvcyA9IHRoaXMuX3JlZ2lvbnNbaW5kZXhdO1xyXG4gICAgICAgICAgICB2YXIgcG9seSA9IGNoYWluc1tpbmRleF07XHJcbiAgICAgICAgICAgIGlmICghcG9seSkge1xyXG4gICAgICAgICAgICAgICAgcG9seSA9IHRoaXMuZ3JvdW5kLmFkZENvbXBvbmVudChjYy5QaHlzaWNzQ2hhaW5Db2xsaWRlcik7XHJcbiAgICAgICAgICAgICAgICBwb2x5Lmxvb3AgPSB0cnVlO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIHBvbHkucG9pbnRzLmxlbmd0aCA9IDA7XHJcbiAgICAgICAgICAgIHBvbHkucG9pbnRzID0gcG9zLm1hcCgodiwgaSkgPT4ge1xyXG4gICAgICAgICAgICAgICAgbGV0IHYyID0gY2MudjIodlswXSwgdlsxXSlcclxuICAgICAgICAgICAgICAgIHJldHVybiB2MjtcclxuICAgICAgICAgICAgfSk7XHJcbiAgICAgICAgICAgIHBvbHkuZW5hYmxlZCA9IHRydWU7XHJcbiAgICAgICAgICAgIGVuYWJsZWRfY2hhaW5zX3BvaW50c1tpbmRleF0gPSBwb2x5LnBvaW50cztcclxuICAgICAgICB9XHJcbiAgICAgICAgLy9cclxuXHJcbiAgICAgICAgdGhpcy5ncmFwaGljcy5jbGVhcih0cnVlKTtcclxuICAgICAgICBsZXQgZW5hYmxlZF9jaGFpbnNfcG9pbnRzX3NvcnQgPSBlbmFibGVkX2NoYWluc19wb2ludHMubWFwKChjdXJQb2x5LCBjdXJQb2x5X2kpID0+IHtcclxuICAgICAgICAgICAgbGV0IGNvdW50ID0gZW5hYmxlZF9jaGFpbnNfcG9pbnRzLnJlZHVjZSgocHJlLCBuZXh0UG9seSwgbmV4dFBvbHlfaSkgPT4ge1xyXG4gICAgICAgICAgICAgICAgaWYgKChjdXJQb2x5X2kgIT0gbmV4dFBvbHlfaSkpIHtcclxuICAgICAgICAgICAgICAgICAgICBsZXQgbGVuZ3RoID0gY3VyUG9seS5sZW5ndGg7XHJcbiAgICAgICAgICAgICAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBsZW5ndGg7ICsraSkge1xyXG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgcDAgPSBjdXJQb2x5W2ldO1xyXG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoIWNjLkludGVyc2VjdGlvbi5wb2ludEluUG9seWdvbihwMCwgbmV4dFBvbHkpKVxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHByZTtcclxuICAgICAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHByZSArIDE7XHJcbiAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICByZXR1cm4gcHJlO1xyXG4gICAgICAgICAgICB9LCAwKTtcclxuXHJcbiAgICAgICAgICAgIHJldHVybiB7IGN1clBvbHksIGNvdW50IH07XHJcbiAgICAgICAgfSkuc29ydCgoYSwgYikgPT4ge1xyXG4gICAgICAgICAgICByZXR1cm4gYS5jb3VudCAtIGIuY291bnQ7XHJcbiAgICAgICAgfSlcclxuICAgICAgICBlbmFibGVkX2NoYWluc19wb2ludHNfc29ydC5mb3JFYWNoKCh7IGN1clBvbHksIGNvdW50IH0pID0+IHtcclxuICAgICAgICAgICAgdGhpcy5ncmFwaGljcy5maWxsQ29sb3IgPSBjb3VudCAlIDIgPT09IDAgPyBjYy5Db2xvci5PUkFOR0UgOiBjYy5Db2xvci5CTEFDSztcclxuICAgICAgICAgICAgdGhpcy5fZHJhd1BvbHkodGhpcy5ncmFwaGljcywgY3VyUG9seSk7XHJcbiAgICAgICAgICAgIHRoaXMuZ3JhcGhpY3MuZmlsbCgpO1xyXG4gICAgICAgIH0pXHJcbiAgICB9LFxyXG4gICAgX3RvdWNoTW92ZSh0b3VjaCkge1xyXG4gICAgICAgIC8vIGxldCByZWdpb25zID0gW1tdXTtcclxuICAgICAgICAvLyBsZXQgcG9zID0gdGhpcy5ncm91bmQuY29udmVydFRvTm9kZVNwYWNlQVIodG91Y2guZ2V0TG9jYXRpb24oKSk7XHJcbiAgICAgICAgLy8gbGV0IGNvdW50ID0gdGhpcy5ESUdfRlJBR01FTlQ7XHJcbiAgICAgICAgLy8gZm9yIChsZXQgaW5kZXggPSAwOyBpbmRleCA8IGNvdW50OyBpbmRleCsrKSB7XHJcbiAgICAgICAgLy8gICAgIGxldCByID0gMiAqIE1hdGguUEkgKiBpbmRleCAvIGNvdW50O1xyXG4gICAgICAgIC8vICAgICBsZXQgeCA9IHBvcy54ICsgdGhpcy5ESUdfUkFESVVTICogTWF0aC5jb3Mocik7XHJcbiAgICAgICAgLy8gICAgIGxldCB5ID0gcG9zLnkgKyB0aGlzLkRJR19SQURJVVMgKiBNYXRoLnNpbihyKTtcclxuICAgICAgICAvLyAgICAgcmVnaW9uc1swXS5wdXNoKFt4LCB5XSk7XHJcbiAgICAgICAgLy8gfVxyXG5cclxuICAgICAgICBsZXQgcmVnaW9ucyA9IFtbXV07XHJcbiAgICAgICAgbGV0IHBvcyA9IHRoaXMuZ3JhcGhpY3Mubm9kZS5jb252ZXJ0VG9Ob2RlU3BhY2VBUih0b3VjaC5nZXRMb2NhdGlvbigpKTtcclxuICAgICAgICBsZXQgZGVsdGEgPSB0b3VjaC5nZXREZWx0YSgpO1xyXG4gICAgICAgIGxldCBjb3VudCA9IHRoaXMuRElHX0ZSQUdNRU5UO1xyXG4gICAgICAgIGlmIChkZWx0YS5sZW5ndGhTcXIoKSA8IDUpIHtcclxuICAgICAgICAgICAgZm9yIChsZXQgaW5kZXggPSAwOyBpbmRleCA8IGNvdW50OyBpbmRleCsrKSB7XHJcbiAgICAgICAgICAgICAgICBsZXQgciA9IDIgKiBNYXRoLlBJICogaW5kZXggLyBjb3VudDtcclxuICAgICAgICAgICAgICAgIGxldCB4ID0gcG9zLnggKyB0aGlzLkRJR19SQURJVVMgKiBNYXRoLmNvcyhyKTtcclxuICAgICAgICAgICAgICAgIGxldCB5ID0gcG9zLnkgKyB0aGlzLkRJR19SQURJVVMgKiBNYXRoLnNpbihyKTtcclxuICAgICAgICAgICAgICAgIHJlZ2lvbnNbMF0ucHVzaCh0aGlzLl9vcHRpbWl6ZVBvaW50KFt4LCB5XSkpO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgbGV0IHN0YXJ0UG9zID0gcG9zLnN1YihkZWx0YSk7XHJcbiAgICAgICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCBjb3VudDsgaW5kZXgrKykge1xyXG4gICAgICAgICAgICAgICAgbGV0IHIgPSAyICogTWF0aC5QSSAqIGluZGV4IC8gY291bnQ7XHJcbiAgICAgICAgICAgICAgICBsZXQgdmVjX3ggPSB0aGlzLkRJR19SQURJVVMgKiBNYXRoLmNvcyhyKTtcclxuICAgICAgICAgICAgICAgIGxldCB2ZWNfeSA9IHRoaXMuRElHX1JBRElVUyAqIE1hdGguc2luKHIpO1xyXG4gICAgICAgICAgICAgICAgbGV0IHgsIHk7XHJcbiAgICAgICAgICAgICAgICBpZiAoZGVsdGEuZG90KGNjLnYyKHZlY194LCB2ZWNfeSkpID4gMCkge1xyXG4gICAgICAgICAgICAgICAgICAgIHggPSBwb3MueCArIHZlY194O1xyXG4gICAgICAgICAgICAgICAgICAgIHkgPSBwb3MueSArIHZlY195O1xyXG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgICAgICAgICB4ID0gc3RhcnRQb3MueCArIHZlY194O1xyXG4gICAgICAgICAgICAgICAgICAgIHkgPSBzdGFydFBvcy55ICsgdmVjX3k7XHJcbiAgICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgICAgICByZWdpb25zWzBdLnB1c2godGhpcy5fb3B0aW1pemVQb2ludChbeCwgeV0pKTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgLy8gbGV0IHJlc3VsdCA9IFBvbHlCb29sLmRpZmZlcmVuY2Uoe1xyXG4gICAgICAgIC8vICAgICByZWdpb25zOiB0aGlzLl9yZWdpb25zLFxyXG4gICAgICAgIC8vICAgICBpbnZlcnRlZDogZmFsc2VcclxuICAgICAgICAvLyB9LCB7XHJcbiAgICAgICAgLy8gICAgIHJlZ2lvbnMsXHJcbiAgICAgICAgLy8gICAgIGludmVydGVkOiBmYWxzZVxyXG4gICAgICAgIC8vIH0pO1xyXG5cclxuICAgICAgICBsZXQgc2VnMSA9IFBvbHlCb29sLnNlZ21lbnRzKHtcclxuICAgICAgICAgICAgcmVnaW9uczogdGhpcy5fcmVnaW9ucyxcclxuICAgICAgICAgICAgaW52ZXJ0ZWQ6IGZhbHNlXHJcbiAgICAgICAgfSk7XHJcbiAgICAgICAgbGV0IHNlZzIgPSBQb2x5Qm9vbC5zZWdtZW50cyh7XHJcbiAgICAgICAgICAgIHJlZ2lvbnMsXHJcbiAgICAgICAgICAgIGludmVydGVkOiBmYWxzZVxyXG4gICAgICAgIH0pO1xyXG4gICAgICAgIGxldCBjb21iID0gUG9seUJvb2wuY29tYmluZShzZWcxLCBzZWcyKTtcclxuICAgICAgICBsZXQgcmVzdWx0ID0gUG9seUJvb2wucG9seWdvbihQb2x5Qm9vbC5zZWxlY3REaWZmZXJlbmNlKGNvbWIpKTtcclxuICAgICAgICAvL1xyXG4gICAgICAgIHRoaXMuX3JlZ2lvbnMgPSByZXN1bHQucmVnaW9ucztcclxuICAgICAgICB0aGlzLl9vcHRpbWl6ZVJlZ2lvbnMoKTtcclxuICAgICAgICB0aGlzLmRyYXcoKTtcclxuICAgIH0sXHJcbiAgICBfZHJhd1BvbHkoY3R4LCBwb2x5KSB7XHJcbiAgICAgICAgcG9seS5mb3JFYWNoKChwb3MsIGkpID0+IHtcclxuICAgICAgICAgICAgaWYgKGkgPT09IDApXHJcbiAgICAgICAgICAgICAgICBjdHgubW92ZVRvKHBvcy54LCBwb3MueSk7XHJcbiAgICAgICAgICAgIGVsc2VcclxuICAgICAgICAgICAgICAgIGN0eC5saW5lVG8ocG9zLngsIHBvcy55KTtcclxuICAgICAgICAgICAgY3R4LmNsb3NlKCk7XHJcbiAgICAgICAgfSk7XHJcbiAgICB9LFxyXG5cclxuXHJcblxyXG4gICAgY3JlYXRXYXRlcigpIHtcclxuICAgICAgICBsZXQgd2F0ZXJOdW0gPSAxO1xyXG4gICAgICAgIGZvciAobGV0IGkgPSAwOyBpIDwgd2F0ZXJOdW07IGkrKykge1xyXG4gICAgICAgICAgICBsZXQgd2F0ZXJQcmUgPSBjYy5pbnN0YW50aWF0ZSh0aGlzLndhdGVyKTtcclxuICAgICAgICAgICAgd2F0ZXJQcmUueCA9IDA7XHJcbiAgICAgICAgICAgIHdhdGVyUHJlLnkgPSBjYy53aW5TaXplLmhlaWdodDtcclxuICAgICAgICAgICAgdGhpcy53YXRlckxheWVyLmFkZENoaWxkKHdhdGVyUHJlKTtcclxuICAgICAgICB9XHJcbiAgICB9LFxyXG5cclxuXHJcbiAgICAvLyB1cGRhdGUgKGR0KSB7fSxcclxufSk7XHJcbiJdfQ==