
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/test2.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '44caf0qqERN1Ko2SyGE8G5z', 'test2');
// script/test2.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    water: cc.Prefab,
    waterLayer: cc.Node,
    ground: cc.Node
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    //
    this._touchStartPos = cc.Vec2;
    this.polyEx = this.ground.getComponent("PhysicsCollider"); //

    this.DIG_RADIUS = 50;
    this.DIG_FRAGMENT = 12; //

    this.DIG_OPTIMIZE_SIZE = 1; //
    //调节物理系统

    cc.macro.ENABLE_MULTI_TOUCH = false;
    var manager = cc.director.getPhysicsManager();
    manager.enabled = true;
    cc.director.getPhysicsManager().debugDrawFlags = true;
    manager.enabledAccumulator = true;
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
    manager.VELOCITY_ITERATIONS = 8;
    manager.POSITION_ITERATIONS = 8; //

    this.registerEvent(); //

    this.graphics = this.ground.getComponent(cc.Mask)['_graphics']; //
    // this.node.on("touchstart", this.creatWater, this);
  },
  start: function start() {
    var _this = this;

    //
    this.scheduleOnce(function () {
      _this.reset();
    }, 0.01); // this.schedule(this.creatWater, 0.5);
    // this.reset();
  },
  registerEvent: function registerEvent() {
    this.ground.on("touchstart", this._touchStart, this);
    this.ground.on("touchmove", this._touchMove, this);
    this.ground.on("touchend", this._touchEnd, this);
    this.ground.on("touchcancel", this._touchEnd, this);
  },
  reset: function reset() {
    this.polyEx.init([[-cc.winSize.width / 2, -320], [-cc.winSize.width / 2, 250], [cc.winSize.width / 2, 250], [cc.winSize.width / 2, -320]]);
    this.polyEx.polyDifference([], this.graphics);
  },
  _touchMove: function _touchMove(touch) {
    var regions = [];
    var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
    var count = this.DIG_FRAGMENT;

    if (!this._touchStartPos) {
      for (var index = 0; index < count; index++) {
        var r = 2 * Math.PI * index / count;
        var x = pos.x + this.DIG_RADIUS * Math.cos(r);
        var y = pos.y + this.DIG_RADIUS * Math.sin(r);
        regions.push(this._optimizePoint([x, y]));
      }

      this._touchStartPos = pos;
    } else {
      var delta = pos.sub(this._touchStartPos); // 手指移动的距离太小的话忽略

      if (delta.lengthSqr() > 25) {
        var startPos = this._touchStartPos;

        for (var _index = 0; _index < count; _index++) {
          var _r = 2 * Math.PI * _index / count;

          var vec_x = this.DIG_RADIUS * Math.cos(_r);
          var vec_y = this.DIG_RADIUS * Math.sin(_r);

          var _x = void 0,
              _y = void 0;

          if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
            _x = pos.x + vec_x;
            _y = pos.y + vec_y;
          } else {
            _x = startPos.x + vec_x;
            _y = startPos.y + vec_y;
          }

          regions.push(this._optimizePoint([_x, _y]));
        }

        this._touchStartPos = pos;
      }
    }

    if (regions.length) this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
  },
  _touchStart: function _touchStart(touch) {
    this._touchStartPos = undefined;

    this._touchMove(touch);
  },
  _touchEnd: function _touchEnd() {
    this._touchStartPos = undefined;
  },
  _optimizePoint: function _optimizePoint(point) {
    return cc.v2(Math.floor(point[0] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE, Math.floor(point[1] * this.DIG_OPTIMIZE_SIZE) / this.DIG_OPTIMIZE_SIZE);
  },
  debug: function debug() {
    cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
    cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
  },
  creatWater: function creatWater(event) {
    var waterNum = 5;

    for (var i = 0; i < waterNum; i++) {
      var waterPre = cc.instantiate(this.water);
      waterPre.x = Math.random() * (cc.winSize.width - waterPre.width) + (-cc.winSize.width / 2 + waterPre.width / 2);
      waterPre.y = Math.random();
      this.waterLayer.addChild(waterPre);
    }
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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