
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/waterCube.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '95645q6J0VGBrNh+xu4ej+P', 'waterCube');
// script/waterCube.js

"use strict";

var _require = require("constants"),
    SSL_OP_NETSCAPE_CHALLENGE_BUG = _require.SSL_OP_NETSCAPE_CHALLENGE_BUG;

cc.Class({
  "extends": cc.Component,
  editor: CC_EDITOR && {
    executeInEditMode: true
  },
  properties: {
    spriteFrame: cc.SpriteFrame
  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    this.radius = 50;
    this.vertCount = 12; // this.openStreak = false;
    //

    var renderer = this.node.getComponent(cc.MeshRenderer);

    if (!renderer) {
      renderer = this.node.addComponent(cc.MeshRenderer);
    }

    renderer.mesh = null;
    this.renderer = renderer;

    this._updateMaterial();

    cc.log(1);

    this._updateMesh();

    cc.log(2);

    this._applySpriteFrame();

    cc.log(3);

    this._applyVertexes();

    cc.log(4); // this.node.on('size-changed', () => {
    //     this._updateMesh();
    //     this._applyVertexes();
    // }, this);
  },
  start: function start() {// this.schedule(this.streakShader, 0.1);
    // this.schedule(this.streak, 0.1);
  },
  streakShader: function streakShader() {
    var material = this.getMaterial(0);
    var velocity = this.node.getComponent(cc.RigidBody).velocity;
    material.setProperty("velocity", velocity);
  },
  _updateMesh: function _updateMesh() {
    //确定顶点坐标
    this._vertexes = [];
    var pos = this.node.position; //放入原点

    this._vertexes.push(pos); //画圆放点


    var rotateVec2 = cc.v2(0, this.radius);
    var angle = 2 * Math.PI / this.vertCount;

    for (var i = 0; i < this.vertCount; i++) {
      this._vertexes.push(cc.v2(pos.add(rotateVec2)));

      rotateVec2.rotateSelf(angle);
    }

    ; //绑定

    var gfx = cc.gfx;
    var mesh = new cc.Mesh();
    mesh.init(new gfx.VertexFormat([{
      name: gfx.ATTR_POSITION,
      type: gfx.ATTR_TYPE_FLOAT32,
      num: 2
    }, {
      name: gfx.ATTR_UV0,
      type: gfx.ATTR_TYPE_FLOAT32,
      num: 2
    }]), this._vertexes.length, true);
    this.mesh = mesh;

    this._updateMaterial();
  },
  _applySpriteFrame: function _applySpriteFrame() {
    if (this.spriteFrame) {
      var texture = this.spriteFrame.getTexture();
      this.texture = texture;

      this._updateMaterial();
    }
  },
  _updateMaterial: function _updateMaterial() {
    var material = this.renderer._materials[0];

    if (material) {
      if (this.texture) {// material.define("USE_TEXTURE", true);
        // material.setProperty('texture', this.texture);
      }
    } //设置uniform参数
    // material.setProperty()

  },
  _applyVertexes: function _applyVertexes() {
    var _this = this;

    var mesh = this.mesh;
    var gfx = cc.gfx;
    mesh.setVertices(gfx.ATTR_POSITION, this._vertexes);

    if (this.texture) {
      var uvs = [];

      this._vertexes.forEach(function (element) {
        var u = element.x / _this.texture.width; //+ this.offset.x

        var v = 1.0 - element.y / _this.texture.height; // + this.offset.y

        uvs.push(cc.v2(u, v));
      });

      mesh.setVertices(gfx.ATTR_UV0, uvs); //计算顶点索引

      if (this._vertexes.length >= 3) {
        var ids = [];

        for (var i = 0; i, this.vertCount; i++) {
          ids.push(this.vertCount[i], this.vertCount[i + 1], this.vertCount[0]);
        }

        ;
        mesh.setIndices(ids);

        if (this.renderer.mesh != mesh) {
          this.renderer.mesh = mesh;
        }
      }
    }
  } // onBeginContact(contact, selfCollider, otherCollider) {
  //     if (otherCollider.node.group == "water") {
  //         // this.node.children[0].active = false;
  //     }
  // },
  // streak() {
  //     // cc.log(this.node.getComponent(cc.RigidBody).linearVelocity.mag())
  //     if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() > 600 && !this.openStreak) {
  //         this.openStreak = true;
  //         this.node.children[0].active = true;
  //         cc.log(true)
  //     }
  //     else if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() <= 200 && this.openStreak) {
  //         this.node.children[0].getComponent(cc.MotionStreak).fadeTime *= 0.95;
  //         if (this.node.getComponent(cc.RigidBody).linearVelocity.mag() < 10) {
  //             this.openStreak = false;
  //             this.node.children[0].active = false;
  //         }
  //     }
  // },
  // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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