
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/typeScript/PhysicsPolygonColliderEx.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'd63fdxrGJJFo7qLK6MOB0Qy', 'PhysicsPolygonColliderEx');
// typeScript/PhysicsPolygonColliderEx.ts

Object.defineProperty(exports, "__esModule", { value: true });
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu, requireComponent = _a.requireComponent;
var PhysicsPolygonColliderEx = /** @class */ (function (_super) {
    __extends(PhysicsPolygonColliderEx, _super);
    function PhysicsPolygonColliderEx() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._polys = [];
        _this._physicsPolygonColliders = [];
        _this._commands = [];
        return _this;
    }
    Object.defineProperty(PhysicsPolygonColliderEx.prototype, "polys", {
        get: function () {
            var _this = this;
            return this._polys.map(function (v) { return _this._convertClipperPathToVecArray(v); });
        },
        enumerable: false,
        configurable: true
    });
    PhysicsPolygonColliderEx.prototype.init = function (polys) {
        var _this = this;
        this._polys = polys.map(function (v) { return _this._convertVecArrayToClipperPath(v); });
        this._commands = [];
    };
    PhysicsPolygonColliderEx.prototype.pushCommand = function (name, params) {
        this._commands.push({ name: name, params: params });
    };
    PhysicsPolygonColliderEx.prototype.polyDifference = function (poly, ctx) {
        // if (poly.length < 3) return;
        var _this = this;
        // 计算新的多边形
        var cpr = new ClipperLib.Clipper(ClipperLib.Clipper.ioStrictlySimple); //ClipperLib.Clipper.ioStrictlySimple | ClipperLib.Clipper.ioPreserveCollinear
        // cpr.PreserveCollinear = true;
        var subj_paths = this._polys;
        var clip_paths = [this._convertVecArrayToClipperPath(poly)];
        cpr.AddPaths(subj_paths, ClipperLib.PolyType.ptSubject, true);
        cpr.AddPaths(clip_paths, ClipperLib.PolyType.ptClip, true);
        var subject_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var clip_fillType = ClipperLib.PolyFillType.pftEvenOdd;
        var solution_polytree = new ClipperLib.PolyTree();
        cpr.Execute(ClipperLib.ClipType.ctDifference, solution_polytree, subject_fillType, clip_fillType);
        var solution_expolygons = ClipperLib.JS.PolyTreeToExPolygons(solution_polytree);
        this._polys = ClipperLib.Clipper.PolyTreeToPaths(solution_polytree);
        // cc.log(solution_expolygons);
        // 将多边形分割成三角形 并绘制出来
        ctx && ctx.clear(true);
        var _physicsPolygonColliders_count = 0;
        var _loop_1 = function (expolygon) {
            // const outers = ClipperLib.Clipper.SimplifyPolygon(expolygon.outer,ClipperLib.PolyFillType.pftEvenOdd);
            // cc.log(outer,"outer",expolygon.outer)
            var countor = this_1._convertClipperPathToPoly2triPoint(expolygon.outer);
            if (countor.length < 2)
                return "continue";
            var swctx = new poly2tri.SweepContext(countor, { cloneArrays: true });
            // const exclude = countor;
            var holes = expolygon.holes.map(function (h) { return _this._convertClipperPathToPoly2triPoint(h, countor); });
            try {
                // 防止 addhole 失败 使用try
                swctx.addHoles(holes);
                swctx.triangulate();
                var triangles = swctx.getTriangles();
                // cc.log('triangles', triangles);
                for (var _i = 0, triangles_1 = triangles; _i < triangles_1.length; _i++) {
                    var tri = triangles_1[_i];
                    // 逐一处理三角形
                    var c = this_1._physicsPolygonColliders[_physicsPolygonColliders_count];
                    if (!c) {
                        c = this_1.addComponent(cc.PhysicsPolygonCollider);
                        c.friction = 0;
                        c.restitution = 0;
                        this_1._physicsPolygonColliders[_physicsPolygonColliders_count] = c;
                    }
                    c.points = tri.getPoints().map(function (v, i) {
                        if (ctx) {
                            if (i === 0)
                                ctx.moveTo(v.x, v.y);
                            else
                                ctx.lineTo(v.x, v.y);
                        }
                        return cc.v2(v.x, v.y);
                    });
                    c.apply();
                    _physicsPolygonColliders_count++;
                    if (ctx) {
                        ctx.close();
                        ctx.fill();
                    }
                }
            }
            catch (e) {
                console.error('polyDifference poly2tri error', _physicsPolygonColliders_count, expolygon);
                console.error(e);
                return "continue";
            }
        };
        var this_1 = this;
        for (var _i = 0, solution_expolygons_1 = solution_expolygons; _i < solution_expolygons_1.length; _i++) {
            var expolygon = solution_expolygons_1[_i];
            _loop_1(expolygon);
        }
        this._physicsPolygonColliders.slice(_physicsPolygonColliders_count).forEach((function (v) {
            if (v.points.length) {
                v.points.length = 0;
                v.apply();
            }
        }));
    };
    PhysicsPolygonColliderEx.prototype.lateUpdate = function (dt) {
        if (this._commands.length) {
            // 每帧执行命令队列
            for (var index = 0; index < 2; index++) {
                var cmd = this._commands.shift();
                if (cmd)
                    this[cmd.name].apply(this, cmd.params);
                else
                    break;
            }
        }
    };
    PhysicsPolygonColliderEx.prototype._convertVecArrayToClipperPath = function (poly) {
        return poly.map(function (p) { return { X: p.x, Y: p.y }; });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToVecArray = function (poly) {
        return poly.map(function (p) { return cc.v2(p.X, p.Y); });
    };
    PhysicsPolygonColliderEx.prototype._convertClipperPathToPoly2triPoint = function (poly, exclude) {
        if (exclude === void 0) { exclude = []; }
        // return poly.map((p) => { return new poly2tri.Point(p.X, p.Y) });
        var newPos = [];
        poly.forEach(function (p, i) {
            var p_now = new poly2tri.Point(p.X, p.Y);
            var isIn = exclude.some(function (e_p) {
                if (e_p.equals(p_now)) {
                    return true;
                }
            });
            if (!isIn) {
                newPos.push(p_now);
                exclude.push(p_now);
            }
        });
        if (newPos.length > 2)
            return newPos;
        else
            return [];
    };
    PhysicsPolygonColliderEx = __decorate([
        ccclass,
        menu("i18n:MAIN_MENU.component.physics/Collider/PolygonEX-lamyoung.com"),
        requireComponent(cc.RigidBody)
    ], PhysicsPolygonColliderEx);
    return PhysicsPolygonColliderEx;
}(cc.Component));
exports.default = PhysicsPolygonColliderEx;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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