
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/typeScript/test3.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '34256qXtQ9G9pM+kDrN/ylS', 'test3');
// typeScript/test3.ts

Object.defineProperty(exports, "__esModule", { value: true });
var PhysicsPolygonColliderEx_1 = require("./PhysicsPolygonColliderEx");
// 挖洞圆半径
var DIG_RADIUS = 50;
// 圆的边的数量
var DIG_FRAGMENT = 12;
// 归一到单位化
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main_poly = /** @class */ (function (_super) {
    __extends(Main_poly, _super);
    function Main_poly() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.node_dirty = null;
        _this.polyEx = null;
        return _this;
    }
    Main_poly.prototype.onLoad = function () {
        cc.macro.ENABLE_MULTI_TOUCH = false;
        cc.director.getPhysicsManager().enabled = true;
        // 开启物理步长的设置
        cc.director.getPhysicsManager().enabledAccumulator = true;
        // 物理步长，默认 FIXED_TIME_STEP 是 1/60
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        // 每次更新物理系统处理速度的迭代次数，默认为 10
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        // 每次更新物理系统处理位置的迭代次数，默认为 10
        cc.PhysicsManager.POSITION_ITERATIONS = 8;
        this.node_dirty.on(cc.Node.EventType.TOUCH_START, this._touchStart, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_END, this._touchEnd, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_CANCEL, this._touchEnd, this);
        this.graphics = this.node_dirty.getComponent(cc.Mask)['_graphics'];
    };
    Main_poly.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            _this.reset();
        }, 0.01);
    };
    Main_poly.prototype._optimizePoint = function (point) {
        var x = Math.floor(point[0] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        var y = Math.floor(point[1] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        return cc.v2(x, y);
    };
    Main_poly.prototype._touchStart = function (touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    };
    Main_poly.prototype._touchMove = function (touch) {
        var regions = [];
        var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
        var count = DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (var index = 0; index < count; index++) {
                var r = 2 * Math.PI * index / count;
                var x = pos.x + DIG_RADIUS * Math.cos(r);
                var y = pos.y + DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        }
        else {
            var delta = pos.sub(this._touchStartPos);
            if (delta.lengthSqr() > 25) {
                var startPos = this._touchStartPos;
                for (var index = 0; index < count; index++) {
                    var r = 2 * Math.PI * index / count;
                    var vec_x = DIG_RADIUS * Math.cos(r);
                    var vec_y = DIG_RADIUS * Math.sin(r);
                    var x = void 0, y = void 0;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    }
                    else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }
        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    };
    Main_poly.prototype._touchEnd = function (touch) {
        this._touchStartPos = undefined;
    };
    Main_poly.prototype.reset = function () {
        this.polyEx.init([
            [cc.v2(-375, -667), cc.v2(-375, 500), cc.v2(375, 500), cc.v2(375, -667)]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    };
    Main_poly.prototype.debug = function () {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    };
    __decorate([
        property(cc.Graphics)
    ], Main_poly.prototype, "graphics", void 0);
    __decorate([
        property(cc.Node)
    ], Main_poly.prototype, "node_dirty", void 0);
    __decorate([
        property(PhysicsPolygonColliderEx_1.default)
    ], Main_poly.prototype, "polyEx", void 0);
    Main_poly = __decorate([
        ccclass
    ], Main_poly);
    return Main_poly;
}(cc.Component));
exports.default = Main_poly;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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