"use strict";
cc._RF.push(module, '2de294hRf5H146xfV0OKHOA', 'MetaBallsAssembler');
// MetaBalls/Shader/MetaBalls/MetaBallsAssembler.ts

/****************************************************************************
 Author: GT <caogtaa@gmail.com>
 https://caogtaa.github.io
****************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
//@ts-ignore
var gfx = cc.gfx;
var vfmtPosCenterWeb = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var vfmtPosCenterNative = new gfx.VertexFormat([
    { name: gfx.ATTR_POSITION, type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_corner", type: gfx.ATTR_TYPE_FLOAT32, num: 2 },
    { name: "a_center", type: gfx.ATTR_TYPE_FLOAT32, num: 2 } // 原粒子中心（每个顶点相同数据）
]);
var MetaBallsAssembler = /** @class */ (function (_super) {
    __extends(MetaBallsAssembler, _super);
    function MetaBallsAssembler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.verticesCount = 0;
        _this.indicesCount = 0;
        _this.floatsPerVert = CC_NATIVERENDERER ? 6 : 4;
        _this._renderData = null;
        _this._prevVerticesCount = 0;
        return _this;
    }
    MetaBallsAssembler.prototype.init = function (comp) {
        _super.prototype.init.call(this, comp);
        this._renderData = new cc.RenderData();
        this._renderData.init(this);
    };
    // initData() {
    //     // do nothing
    // }
    MetaBallsAssembler.prototype.updateColor = function (comp, color) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateUVs = function (comp) {
        // do nothing
    };
    MetaBallsAssembler.prototype.updateVerts = function (comp) {
        if (!CC_NATIVERENDERER) {
            // web模式直接在fillbuffer里做所有操作，不经过RenderData缓存
            return;
        }
        var particles = this.particles;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        var particleCount = this.particles.GetParticleCount();
        var verts = this._renderData.vDatas[0];
        var xoffset = comp.node.width * comp.node.anchorX;
        var yoffset = comp.node.height * comp.node.anchorY;
        // fill vertices
        // 暂时不考虑buffer满的情况
        var vertexOffset = 0;
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO - xoffset;
            var y = posBuff[i].y * PTM_RATIO - yoffset;
            // left-bottom
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-bottom
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y + r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // left-top
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x - r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
            // right-top
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x + r;
            verts[vertexOffset++] = y - r;
            verts[vertexOffset++] = x;
            verts[vertexOffset++] = y;
        }
    };
    MetaBallsAssembler.prototype.updateRenderData = function (comp) {
        var _a;
        if (!CC_NATIVERENDERER) {
            return;
        }
        var particleCount = (_a = this.particles) === null || _a === void 0 ? void 0 : _a.GetParticleCount();
        if (!particleCount)
            return;
        if (this._prevVerticesCount != particleCount) {
            this._prevVerticesCount = particleCount;
            // rebuild render data
            this.verticesCount = particleCount * 4;
            this.indicesCount = particleCount * 6;
            var data = this._renderData;
            data.createFlexData(0, this.verticesCount, this.indicesCount, this.getVfmt());
            var indices = data.iDatas[0];
            var count = indices.length / 6;
            for (var i = 0, idx = 0; i < count; i++) {
                var vertextID = i * 4;
                indices[idx++] = vertextID;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 2;
                indices[idx++] = vertextID + 1;
                indices[idx++] = vertextID + 3;
                indices[idx++] = vertextID + 2;
            }
        }
        if (comp._vertsDirty) {
            this.updateVerts(comp);
            comp._vertsDirty = false;
        }
    };
    MetaBallsAssembler.prototype.getVfmt = function () {
        if (CC_NATIVERENDERER)
            return vfmtPosCenterNative;
        return vfmtPosCenterWeb;
    };
    MetaBallsAssembler.prototype.getBuffer = function () {
        //@ts-ignore
        return cc.renderer._handle.getBuffer("mesh", this.getVfmt());
    };
    MetaBallsAssembler.prototype.fillBuffers = function (comp, renderer) {
        if (CC_NATIVERENDERER) {
            // 仅对web实现
            // native由于fillBuffer实现在了C++层，需要使用RenderData做缓存
            return;
        }
        var particles = this.particles;
        var particleCount = particles === null || particles === void 0 ? void 0 : particles.GetParticleCount();
        if (!particleCount)
            return;
        // TODO: 简化为按照三角形渲染
        var verticesCount = particleCount * 4;
        var indicesCount = particleCount * 6;
        var PTM_RATIO = cc.PhysicsManager.PTM_RATIO;
        var posBuff = particles.GetPositionBuffer();
        var r = particles.GetRadius() * PTM_RATIO * 3; // 倍数扩大渲染距离，超出r的范围颜色衰减
        //@ts-ignore
        var buffer = this.getBuffer( /*renderer*/);
        var offsetInfo = buffer.request(verticesCount, indicesCount);
        var vertexOffset = offsetInfo.byteOffset >> 2, vbuf = buffer._vData;
        // fill vertices
        // 暂时不考虑buffer满的情况
        for (var i = 0; i < particleCount; ++i) {
            var x = posBuff[i].x * PTM_RATIO;
            var y = posBuff[i].y * PTM_RATIO;
            // left-bottom
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-bottom
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y + r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // left-top
            vbuf[vertexOffset++] = x - r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
            // right-top
            vbuf[vertexOffset++] = x + r;
            vbuf[vertexOffset++] = y - r;
            vbuf[vertexOffset++] = x;
            vbuf[vertexOffset++] = y;
        }
        // 仅当顶点索引发生变化时计算? 
        // vertexOffset是动态的，每一帧都有可能有差异，无法批量拷贝
        var ibuf = buffer._iData, indiceOffset = offsetInfo.indiceOffset, vertexId = offsetInfo.vertexOffset; // vertexId是已经在buffer里的顶点数，也是当前顶点序号的基数
        for (var i = 0; i < particleCount; ++i) {
            ibuf[indiceOffset++] = vertexId;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 2;
            ibuf[indiceOffset++] = vertexId + 1;
            ibuf[indiceOffset++] = vertexId + 3;
            ibuf[indiceOffset++] = vertexId + 2;
            vertexId += 4;
        }
    };
    return MetaBallsAssembler;
}(cc.Assembler));
exports.default = MetaBallsAssembler;

cc._RF.pop();