"use strict";
cc._RF.push(module, '1a39ak3NZdFtYMMs/stiMBC', 'GTAutoFitSpriteAssembler2D');
// shader/GTAutoFitSpriteAssembler2D.ts

// Copyright 2020 Cao Gaoting<caogtaa@gmail.com>
// https://caogtaa.github.io
// This file is licensed under the MIT License.
// License text available at https://opensource.org/licenses/MIT
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Date: 2020-07-21 16:23:10
 * LastEditors: GT<caogtaa@gmail.com>
 * LastEditTime: 2020-07-22 14:04:52
*/
var GTSimpleSpriteAssembler2D_1 = require("./GTSimpleSpriteAssembler2D");
var GTAutoFitSpriteAssembler2D = /** @class */ (function (_super) {
    __extends(GTAutoFitSpriteAssembler2D, _super);
    function GTAutoFitSpriteAssembler2D() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._uv = [];
        return _this;
    }
    GTAutoFitSpriteAssembler2D.prototype.updateUVs = function (sprite) {
        var rect = sprite._spriteFrame.getRect();
        var node = sprite.node;
        if (!rect.width || !rect.height || !node.width || !node.height) {
            _super.prototype.updateUVs.call(this, sprite);
            return;
        }
        Object.assign(this._uv, sprite._spriteFrame.uv);
        var uv = this._uv;
        var wscale = rect.width / node.width;
        var hscale = rect.height / node.height;
        var ratio = 1.0;
        var isRotated = sprite._spriteFrame.isRotated();
        var l = uv[0], r = uv[2], b = uv[1], t = uv[5];
        if (isRotated) {
            // cc图集里的旋转总是顺时针旋转90度，以原左下角为中心。（旋转后左下角变为左上角）
            l = uv[1];
            r = uv[3];
            b = uv[0];
            t = uv[4];
        }
        // 图片在等比缩放的前提下自适应容器大小
        if (wscale > hscale) {
            // fit height
            ratio = hscale / wscale;
            var ro = isRotated ? 1 : 0;
            var c = (l + r) * 0.5;
            var half = (r - l) * 0.5 * ratio;
            l = uv[0 + ro] = uv[4 + ro] = c - half;
            r = uv[2 + ro] = uv[6 + ro] = c + half;
        }
        else {
            // fit width
            ratio = wscale / hscale;
            var ro = isRotated ? -1 : 0;
            var c = (b + t) * 0.5;
            var half = (b - t) * 0.5 * ratio;
            b = uv[1 + ro] = uv[3 + ro] = c + half;
            t = uv[5 + ro] = uv[7 + ro] = c - half;
        }
        var uvOffset = this.uvOffset;
        var floatsPerVert = this.floatsPerVert;
        var verts = this._renderData.vDatas[0];
        for (var i = 0; i < 4; i++) {
            var srcOffset = i * 2;
            var dstOffset = floatsPerVert * i + uvOffset;
            verts[dstOffset] = uv[srcOffset];
            verts[dstOffset + 1] = uv[srcOffset + 1];
        }
    };
    return GTAutoFitSpriteAssembler2D;
}(GTSimpleSpriteAssembler2D_1.default));
exports.default = GTAutoFitSpriteAssembler2D;

cc._RF.pop();