"use strict";
cc._RF.push(module, '86805m1LvpOlJlxkovVgNuY', 'test4');
// TypeScript2/test4.ts

Object.defineProperty(exports, "__esModule", { value: true });
var PhysicsPolygonColliderEx_1 = require("./PhysicsPolygonColliderEx");
// 挖洞圆半径
var DIG_RADIUS = 50;
// 圆的边的数量
var DIG_FRAGMENT = 12;
// 归一到单位化
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main_poly = /** @class */ (function (_super) {
    __extends(Main_poly, _super);
    function Main_poly() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.node_dirty = null;
        _this.polyEx = null;
        _this.water = null;
        return _this;
    }
    Main_poly.prototype.onLoad = function () {
        cc.macro.SHOW_MESH_WIREFRAME = true;
        cc.macro.ENABLE_MULTI_TOUCH = false;
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().enabledAccumulator = true;
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        cc.PhysicsManager.POSITION_ITERATIONS = 8;
        this.node_dirty.on(cc.Node.EventType.TOUCH_START, this._touchStart, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_END, this._touchEnd, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_CANCEL, this._touchEnd, this);
        this.graphics = this.node_dirty.getComponent(cc.Mask)['_graphics'];
    };
    Main_poly.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            _this.reset();
        }, 0.01);
        this.schedule(this.creatWater, 0.5);
    };
    Main_poly.prototype.creatWater = function () {
        var water = cc.instantiate(this.water);
        water.y = cc.winSize.height / 2;
        cc.find("Canvas/waterLayer").addChild(water);
    };
    Main_poly.prototype._optimizePoint = function (point) {
        var x = Math.floor(point[0] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        var y = Math.floor(point[1] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        return cc.v2(x, y);
    };
    Main_poly.prototype._touchStart = function (touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    };
    Main_poly.prototype._touchMove = function (touch) {
        var regions = [];
        var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
        var count = DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (var index = 0; index < count; index++) {
                var r = 2 * Math.PI * index / count;
                var x = pos.x + DIG_RADIUS * Math.cos(r);
                var y = pos.y + DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        }
        else {
            var delta = pos.sub(this._touchStartPos);
            if (delta.lengthSqr() > 25) {
                var startPos = this._touchStartPos;
                for (var index = 0; index < count; index++) {
                    var r = 2 * Math.PI * index / count;
                    var vec_x = DIG_RADIUS * Math.cos(r);
                    var vec_y = DIG_RADIUS * Math.sin(r);
                    var x = void 0, y = void 0;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    }
                    else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }
        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    };
    Main_poly.prototype._touchEnd = function (touch) {
        this._touchStartPos = undefined;
    };
    Main_poly.prototype.reset = function () {
        var ww = this.node_dirty.width;
        var hh = this.node_dirty.height;
        // this.polyEx.init([
        //     [cc.v2(-ww / 2, -hh / 2), cc.v2(-ww / 2, hh / 2), cc.v2(ww / 2, hh / 2), cc.v2(ww / 2, -hh / 2)]
        // ]);
        this.polyEx.init([
            [cc.v2(-200, 200), cc.v2(200, 200), cc.v2(200, 0), cc.v2(0, -100), cc.v2(-200, 0)]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    };
    Main_poly.prototype.debug = function () {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    };
    __decorate([
        property(cc.Node)
    ], Main_poly.prototype, "node_dirty", void 0);
    __decorate([
        property(PhysicsPolygonColliderEx_1.default)
    ], Main_poly.prototype, "polyEx", void 0);
    __decorate([
        property(cc.Prefab)
    ], Main_poly.prototype, "water", void 0);
    Main_poly = __decorate([
        ccclass
    ], Main_poly);
    return Main_poly;
}(cc.Component));
exports.default = Main_poly;

cc._RF.pop();