"use strict";
cc._RF.push(module, '34256qXtQ9G9pM+kDrN/ylS', 'test3');
// typeScript/test3.ts

Object.defineProperty(exports, "__esModule", { value: true });
var PhysicsPolygonColliderEx_1 = require("./PhysicsPolygonColliderEx");
// 挖洞圆半径
var DIG_RADIUS = 50;
// 圆的边的数量
var DIG_FRAGMENT = 12;
// 归一到单位化
var DIG_OPTIMIZE_SIZE = 1;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main_poly = /** @class */ (function (_super) {
    __extends(Main_poly, _super);
    function Main_poly() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.node_dirty = null;
        _this.polyEx = null;
        return _this;
    }
    Main_poly.prototype.onLoad = function () {
        cc.macro.ENABLE_MULTI_TOUCH = false;
        cc.director.getPhysicsManager().enabled = true;
        // 开启物理步长的设置
        cc.director.getPhysicsManager().enabledAccumulator = true;
        // 物理步长，默认 FIXED_TIME_STEP 是 1/60
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;
        // 每次更新物理系统处理速度的迭代次数，默认为 10
        cc.PhysicsManager.VELOCITY_ITERATIONS = 8;
        // 每次更新物理系统处理位置的迭代次数，默认为 10
        cc.PhysicsManager.POSITION_ITERATIONS = 8;
        this.node_dirty.on(cc.Node.EventType.TOUCH_START, this._touchStart, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_MOVE, this._touchMove, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_END, this._touchEnd, this);
        this.node_dirty.on(cc.Node.EventType.TOUCH_CANCEL, this._touchEnd, this);
        this.graphics = this.node_dirty.getComponent(cc.Mask)['_graphics'];
    };
    Main_poly.prototype.start = function () {
        var _this = this;
        this.scheduleOnce(function () {
            _this.reset();
        }, 0.01);
    };
    Main_poly.prototype._optimizePoint = function (point) {
        var x = Math.floor(point[0] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        var y = Math.floor(point[1] * DIG_OPTIMIZE_SIZE) / DIG_OPTIMIZE_SIZE;
        return cc.v2(x, y);
    };
    Main_poly.prototype._touchStart = function (touch) {
        this._touchStartPos = undefined;
        this._touchMove(touch);
    };
    Main_poly.prototype._touchMove = function (touch) {
        var regions = [];
        var pos = this.graphics.node.convertToNodeSpaceAR(touch.getLocation());
        var count = DIG_FRAGMENT;
        if (!this._touchStartPos) {
            for (var index = 0; index < count; index++) {
                var r = 2 * Math.PI * index / count;
                var x = pos.x + DIG_RADIUS * Math.cos(r);
                var y = pos.y + DIG_RADIUS * Math.sin(r);
                regions.push(this._optimizePoint([x, y]));
            }
            this._touchStartPos = pos;
        }
        else {
            var delta = pos.sub(this._touchStartPos);
            if (delta.lengthSqr() > 25) {
                var startPos = this._touchStartPos;
                for (var index = 0; index < count; index++) {
                    var r = 2 * Math.PI * index / count;
                    var vec_x = DIG_RADIUS * Math.cos(r);
                    var vec_y = DIG_RADIUS * Math.sin(r);
                    var x = void 0, y = void 0;
                    if (delta.dot(cc.v2(vec_x, vec_y)) > 0) {
                        x = pos.x + vec_x;
                        y = pos.y + vec_y;
                    }
                    else {
                        x = startPos.x + vec_x;
                        y = startPos.y + vec_y;
                    }
                    regions.push(this._optimizePoint([x, y]));
                }
                this._touchStartPos = pos;
            }
        }
        if (regions.length)
            this.polyEx.pushCommand('polyDifference', [regions, this.graphics]);
    };
    Main_poly.prototype._touchEnd = function (touch) {
        this._touchStartPos = undefined;
    };
    Main_poly.prototype.reset = function () {
        this.polyEx.init([
            [cc.v2(-375, -667), cc.v2(-375, 500), cc.v2(375, 500), cc.v2(375, -667)]
        ]);
        this.polyEx.polyDifference([], this.graphics);
    };
    Main_poly.prototype.debug = function () {
        cc.debug.setDisplayStats(!cc.debug.isDisplayStats());
        cc.director.getPhysicsManager().debugDrawFlags = cc.debug.isDisplayStats() ? 1 : 0;
    };
    __decorate([
        property(cc.Graphics)
    ], Main_poly.prototype, "graphics", void 0);
    __decorate([
        property(cc.Node)
    ], Main_poly.prototype, "node_dirty", void 0);
    __decorate([
        property(PhysicsPolygonColliderEx_1.default)
    ], Main_poly.prototype, "polyEx", void 0);
    Main_poly = __decorate([
        ccclass
    ], Main_poly);
    return Main_poly;
}(cc.Component));
exports.default = Main_poly;

cc._RF.pop();