const { ccclass } = cc._decorator;

@ccclass
export default class CameraBug extends cc.Component {
    start() {
        this.node.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
    }
    private onTouchEnd(event: cc.Event.EventTouch) {
        this.camera(this.node);
        this.camera(this.node.children[0]);
    }
    camera(node) {
        node.scale = 0.5;
        let cameraNode = new cc.Node();
        cc.director.getScene().addChild(cameraNode);
        let captureCamera = cameraNode.addComponent(cc.Camera);
        captureCamera.render(node);
        cameraNode.destroy();
        node.scale = 1;
        // setTimeout(() => {
        //     node.setLocalDirty(cc.Node._LocalDirtyFlag.ALL_SCALE);
        // }, 0);
    }
}