
import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('TestScene')
export class TestScene extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    @property({type:Node})
    spine:Node = null!;

    start () {
        // [3]
        this.scheduleOnce(()=>{
            this.spine!.active = false;
            this.scheduleOnce(()=>{
                this.spine!.active = true;
            }, 1)
        }, 1)
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
