
import { _decorator, Component, Node, systemEvent, SystemEventType, EventKeyboard, loader, Prefab, instantiate } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    
    start()
    {   
        //mac 谷歌浏览器无法触发按键 bug
        systemEvent.on(SystemEventType.KEY_DOWN,this.onKeyUp,this);
    }

    onKeyUp(event:EventKeyboard)
    {
        console.log(event);
    }

    async onBtnShopClick()
    {
        console.log('展示商店 并在UIShop脚本里 设置层级为11')
        let prefab = await Test._loadRes('prefabs/UIShop',Prefab);
        let node = instantiate(prefab)
        this.node.parent.addChild(node);
    }
    async onBtnRewardClick()
    {
        console.log('展示恭喜获得 不设置层级')
        let prefab = await Test._loadRes('prefabs/UIReward',Prefab);
        let node = instantiate(prefab)
        this.node.parent.addChild(node);
    }

    private static async _loadRes(url:string,type:any)
    {
        return new Promise((res,rej)=>
        {
            loader.loadRes(url,type,(err,assets)=>
            {
                if (err)
                {
                    rej(null)
                }
                else
                {
                    res(assets)
                }
            });
        });
    }
}

