import { CCBoolean, CCFloat, CCInteger, Sprite, Vec2, _decorator } from "cc";

const { ccclass, menu, executeInEditMode, property } = _decorator;

@ccclass()
@menu('GUI/ClearEllipse')
@executeInEditMode
export class GUIClearEllipseComponent extends Sprite {

    @property(CCBoolean)
    private _bClearEllipse: boolean = true;
    @property(CCBoolean)
    public get bClearEllipse() {
        return this._bClearEllipse;
    }
    public set bClearEllipse(value) {
        // if (this._bClearEllipse === value) {
        //     return;
        // }
        this._bClearEllipse = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    @property(Vec2)
    private _ellipseCentetPos: Vec2 = new Vec2(0, 0);
    @property(Vec2)
    public get ellipseCentetPos() {
        return this._ellipseCentetPos;
    }
    public set ellipseCentetPos(value) {
        this._ellipseCentetPos = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    @property(CCFloat)
    private _ellipseLength: number = 0;
    @property(CCFloat)
    public get ellipseLength() {
        return this._ellipseLength;
    }
    public set ellipseLength(value) {
        if (this._ellipseLength === value) {
            return;
        }
        this._ellipseLength = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    @property(CCFloat)
    private _ellipseWidth: number = 0.2;
    @property(CCFloat)
    public get ellipseWidth() {
        return this._ellipseWidth;
    }
    public set ellipseWidth(value) {
        if (this._ellipseWidth === value) {
            return;
        }
        this._ellipseWidth = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    @property(CCFloat)
    private _ellipseHeight: number = 0.2;
    @property(CCFloat)
    public get ellipseHeight() {
        return this._ellipseHeight;
    }
    public set ellipseHeight(value) {
        if (this._ellipseHeight === value) {
            return;
        }
        this._ellipseHeight = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    @property(CCFloat)
    private _ellipseFuzzyL: number = 0;
    @property(CCFloat)
    public get ellipseFuzzyL() {
        return this._ellipseFuzzyL;
    }
    public set ellipseFuzzyL(value) {
        if (this._ellipseFuzzyL === value) {
            return;
        }
        this._ellipseFuzzyL = value;
        // this.setVertsDirty();
        this._updateMaterial();
    }

    public onLoad(): void {
        this._updateMaterial();    
    }

    public _updateMaterial() {
        if (!this.spriteFrame && this.spriteFrame.texture) return;

        let material = this.getMaterialInstance(0);
        if (!material) return;

        material.recompileShaders({USE_CLEAR_ELLIPSE: this._bClearEllipse, USE_ALPHA_TEST: true, USE_TEXTURE: true});
        material.setProperty('centerPos', this._ellipseCentetPos);
        material.setProperty('length', this._ellipseLength);
        material.setProperty('width', this._ellipseWidth);
        material.setProperty('height', this._ellipseHeight);
        material.setProperty('fuzzyL', this._ellipseFuzzyL);
        
        this.markForUpdateRenderData(true);
        // this._updateBlendFunc();
    }
}