"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assetMenu = exports.dbMenu = void 0;
const path_1 = require("path");
async function DialogOpenImportZip() {
    const result = await Editor.Dialog.select({
        title: Editor.I18n.t('package-asset.import.title'),
        path: await Editor.Profile.getConfig('package-asset', 'import-path') || Editor.Project.path,
        filters: [{ name: 'Package', extensions: ['zip'] }],
    });
    if (result.canceled) {
        return;
    }
    const path = result.filePaths && result.filePaths[0];
    // if (isPath(path)) {
    await Editor.Profile.setConfig('package-asset', 'import-path', (0, path_1.dirname)(path));
    return path;
    // }
}
function getImportMenu(assetInfo) {
    const enabled = assetInfo ? !assetInfo.url.startsWith('db://internal') : true;
    return {
        label: 'i18n:package-asset.menu.import',
        enabled: enabled,
        async click() {
            if (await Editor.Panel.has('package-asset.import')) {
                return;
            }
            const path = await DialogOpenImportZip();
            if (path) {
                Editor.Panel.open('package-asset.import', path);
            }
        },
    };
}
function getExportMenu(assetInfo) {
    const enabled = assetInfo ? !assetInfo.url.startsWith('db://internal') : true;
    return {
        label: 'i18n:package-asset.menu.export',
        enabled: enabled,
        async click() {
            if (await Editor.Panel.has('package-asset.export')) {
                return;
            }
            // 将右键的资源节点信息传给导出面板
            Editor.Panel.open('package-asset.export', assetInfo);
        },
    };
}
function dbMenu(assetInfo) {
    //右键面板添加 导入资源包选项
    return [
        getImportMenu(assetInfo),
    ];
}
exports.dbMenu = dbMenu;
/**
 * assets 扩展普通资源节点的右键菜单，能够拿到右键资源节点的信息 assetInfo 作为参数
 * @param assetInfo
 */
function assetMenu(assetInfo) {
    //右键面板添加 导入资源包，导出资源包选项选项
    return [
        getImportMenu(assetInfo),
        getExportMenu(assetInfo),
    ];
}
exports.assetMenu = assetMenu;
