import { dirname } from 'path';

export interface MenuAssetInfo {
    // 资源名字
    name: string;
    // 资源用于显示的名字
    displayName: string;
    // loader 加载的层级地址
    url: string;
    // 绝对路径
    file: string;
    // 资源的唯一 ID
    uuid: string;
    // 使用的导入器名字
    importer: string;
    // 类型
    type: string;
    // 是否是文件夹
    isDirectory: boolean;
    // 是否只读
    readonly: boolean;
    // 虚拟资源可以实例化成实体的话，会带上这个扩展名
    instantiation?: string;
    // 跳转指向资源
    redirect?: any;
    // 继承类型
    extends?: string[];
    // 是否导入完成
    imported: boolean;
    // 是否导入失败
    invalid: boolean;
}
async function DialogOpenImportZip() {
    const result = await Editor.Dialog.select({
        title: Editor.I18n.t('package-asset.import.title'),
        path: await Editor.Profile.getConfig('package-asset', 'import-path') || Editor.Project.path,
        filters: [{ name: 'Package', extensions: ['zip'] }],
    });

    if (result.canceled){
        return;
    }

    const path = result.filePaths && result.filePaths[0];
    // if (isPath(path)) {
        await Editor.Profile.setConfig('package-asset', 'import-path', dirname(path));
        return path;
    // }
}
function getImportMenu(assetInfo: MenuAssetInfo) {
    const enabled = assetInfo ? !assetInfo.url.startsWith('db://internal') : true;
    return {
        label: 'i18n:package-asset.menu.import',
        enabled: enabled,
        async click() {
            if (await Editor.Panel.has('package-asset.import')) {
                return;
            }
            const path = await DialogOpenImportZip();
            if (path) {
                Editor.Panel.open('package-asset.import', path);
            }
        },
    };
}

function getExportMenu(assetInfo: MenuAssetInfo) {
    const enabled = assetInfo ? !assetInfo.url.startsWith('db://internal') : true;
    return {
        label: 'i18n:package-asset.menu.export',
        enabled: enabled,
        async click() {
            if (await Editor.Panel.has('package-asset.export')) {
                return;
            }
            // 将右键的资源节点信息传给导出面板
            Editor.Panel.open('package-asset.export', assetInfo);
        },
    };
}

export function dbMenu(assetInfo: MenuAssetInfo) {
    //右键面板添加 导入资源包选项
    return [
        getImportMenu(assetInfo),
    ];
}

/**
 * assets 扩展普通资源节点的右键菜单，能够拿到右键资源节点的信息 assetInfo 作为参数
 * @param assetInfo 
 */
export function assetMenu(assetInfo: MenuAssetInfo) {
    //右键面板添加 导入资源包，导出资源包选项选项
    return [
        getImportMenu(assetInfo),
        getExportMenu(assetInfo),
    ];
}
