const { ccclass, property } = cc._decorator;

const FPS = 60;
const PER_TIME = 1 / FPS;
@ccclass
export default class Helloworld extends cc.Component {
    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = "hello";
    @property(cc.Node)
    moveNode: cc.Node = null;

    private _time: number = 0;

    onLoad() {
        let t = this;
        // init logic
        t.label.string = t.text;
        //设置帧率
        cc.game.setFrameRate(FPS);
        //物理
        let phy = cc.director.getPhysicsManager();
        phy.enabled = true;
        phy.enabled = true;
        phy.enabledAccumulator = true;
        cc.PhysicsManager.FIXED_TIME_STEP = 1 / FPS; //物理步长
        phy.enabled = false;
        //绘制碰撞区域
        // phy.debugDrawFlags =
        //     cc.PhysicsManager.DrawBits.e_aabbBit |
        //     cc.PhysicsManager.DrawBits.e_jointBit |
        //     cc.PhysicsManager.DrawBits.e_shapeBit;
    }
    update(dt) {
        let t = this;
        t._time -= dt;
        if (t._time <= 0) {
            t._time += PER_TIME;
            //物理
            let phy = cc.director.getPhysicsManager();
            phy.enabled = true;
            phy.update(PER_TIME);
            phy.enabled = false;
        }
    }
    moveL() {
        cc.tween(this.moveNode).delay(0.02).by(0.5, { x: -100 }).start();
    }
    moveR() {
        cc.tween(this.moveNode).delay(0.02).by(0.5, { x: 100 }).start();
    }
}
