"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.unload = exports.load = exports.methods = void 0;
/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
exports.methods = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    showLog() {
        console.log('Hello World');
    },
    onAssetAdd(uuid, assetInfo) {
        if (assetInfo.type == "cc.ImageAsset" && assetInfo.name.endsWith("skeleton.png")) {
            console.log(`[fix-spine-import]spine added: ${uuid}, name: ${assetInfo.name}`);
            Editor.Message.request("asset-db", "reimport-asset", uuid).then((result) => {
                console.log(`[fix-spine-import]reimported: ${uuid}, name: ${assetInfo.name}`);
            }).catch((error) => {
                console.error(`[fix-spine-import]Reimport error: ${error}`);
            });
        }
    }
};
/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
function load() {
}
exports.load = load;
/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
function unload() { }
exports.unload = unload;
//# sourceMappingURL=data:application/json;base64,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