import { AssetInfo } from "@cocos/creator-types/editor/packages/asset-db/@types/public";

/**
 * @en Registration method for the main process of Extension
 * @zh 为扩展的主进程的注册方法
 */
export const methods: { [key: string]: (...any: any) => any } = {
    /**
     * @en A method that can be triggered by message
     * @zh 通过 message 触发的方法
     */
    showLog() {
        console.log('Hello World');
    },
    onAssetAdd(uuid: string, assetInfo: AssetInfo){
        if(assetInfo.type == "cc.ImageAsset" && assetInfo.name.endsWith("skeleton.png")){
            console.log(`[fix-spine-import]spine added: ${uuid}, name: ${assetInfo.name}`);
            Editor.Message.request("asset-db","reimport-asset", uuid).then((result)=>{
                console.log(`[fix-spine-import]reimported: ${uuid}, name: ${assetInfo.name}`);
            }).catch((error)=>{
                console.error(`[fix-spine-import]Reimport error: ${error}`);
            })
        }
    }
};

/**
 * @en Method Triggered on Extension Startup
 * @zh 扩展启动时触发的方法
 */
export function load() {
 }

/**
 * @en Method triggered when uninstalling the extension
 * @zh 卸载扩展时触发的方法
 */
export function unload() { }
