System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, CCFloat, Component, Enum, Layout, Node, Prefab, rect, ScrollView, Size, UITransform, v3, _decorator, _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _temp, _crd, ccclass, property, requireComponent, MOVE_TIME, OFFSET_TYPE, SCALE_TYPE, ScrollOption;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  _export({
    _dec: void 0,
    _dec2: void 0,
    _dec3: void 0,
    _dec4: void 0,
    _dec5: void 0,
    _dec6: void 0,
    _dec7: void 0,
    _dec8: void 0,
    _class: void 0,
    _class2: void 0,
    _descriptor: void 0,
    _descriptor2: void 0,
    _descriptor3: void 0,
    _descriptor4: void 0,
    _descriptor5: void 0,
    _descriptor6: void 0,
    _temp: void 0,
    OFFSET_TYPE: void 0,
    SCALE_TYPE: void 0
  });

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      CCFloat = _cc.CCFloat;
      Component = _cc.Component;
      Enum = _cc.Enum;
      Layout = _cc.Layout;
      Node = _cc.Node;
      Prefab = _cc.Prefab;
      rect = _cc.rect;
      ScrollView = _cc.ScrollView;
      Size = _cc.Size;
      UITransform = _cc.UITransform;
      v3 = _cc.v3;
      _decorator = _cc._decorator;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "c7accL2RxVEl5O64AhbPgFn", "ScrollOption", _context.meta);

      ({
        ccclass,
        property,
        requireComponent
      } = _decorator);
      /**
       * 移动到selectAera内所需时间
       */

      MOVE_TIME = 0.15;
      /**
       * 偏移类型
       * NONE: 无偏移
       * EQUAL: 统一偏移
       * GRADUALLY: 逐级偏移
       */

      (function (OFFSET_TYPE) {
        OFFSET_TYPE[OFFSET_TYPE["NONE"] = 1] = "NONE";
        OFFSET_TYPE[OFFSET_TYPE["EQUAL"] = 2] = "EQUAL";
        OFFSET_TYPE[OFFSET_TYPE["GRADUALLY"] = 3] = "GRADUALLY";
      })(OFFSET_TYPE || (OFFSET_TYPE = {}));

      Enum(OFFSET_TYPE);
      /**
       * 缩放类型
       * NONE: 无缩放
       * EQUAL: 统一缩放
       * GRADUALLY: 逐级缩放
       */

      (function (SCALE_TYPE) {
        SCALE_TYPE[SCALE_TYPE["NONE"] = 1] = "NONE";
        SCALE_TYPE[SCALE_TYPE["EQUAL"] = 2] = "EQUAL";
        SCALE_TYPE[SCALE_TYPE["GRADUALLY"] = 3] = "GRADUALLY";
      })(SCALE_TYPE || (SCALE_TYPE = {}));

      Enum(SCALE_TYPE);

      _export("ScrollOption", ScrollOption = (_dec = ccclass('ScrollOption'), _dec2 = requireComponent(ScrollView), _dec3 = property({
        type: Node,
        tooltip: '可滚动展示内容的节点，在该节点上需添加Layout组件，且瞄点都需要设为0.5'
      }), _dec4 = property({
        type: Prefab,
        tooltip: '滚动列表'
      }), _dec5 = property({
        type: OFFSET_TYPE,
        tooltip: '滚动列表偏移类型 NONE表示无偏移，EQUAL表示统一偏移，GRADUALLY表示逐级偏移'
      }), _dec6 = property({
        type: CCFloat,
        tooltip: '滚动列表偏移量，正数表示往上或者往右偏移，负数相反',
        visible: function () {
          return this.offsetType !== OFFSET_TYPE.NONE;
        }
      }), _dec7 = property({
        type: SCALE_TYPE,
        tooltip: '滚动列表缩放类型 NONE表示无缩放，EQUAL表示统一缩放，GRADUALLY表示逐级缩放'
      }), _dec8 = property({
        type: CCFloat,
        range: [0, 1],
        tooltip: '滚动列表缩放量，范围为[0, 1]',
        visible: function () {
          return this.scaleType !== SCALE_TYPE.NONE;
        }
      }), _dec(_class = _dec2(_class = (_class2 = (_temp = class ScrollOption extends Component {
        constructor(...args) {
          super(...args);

          _initializerDefineProperty(this, "content", _descriptor, this);

          _initializerDefineProperty(this, "scrollItem", _descriptor2, this);

          _initializerDefineProperty(this, "offsetType", _descriptor3, this);

          _initializerDefineProperty(this, "offsetValue", _descriptor4, this);

          _initializerDefineProperty(this, "scaleType", _descriptor5, this);

          _initializerDefineProperty(this, "scaleValue", _descriptor6, this);

          _defineProperty(this, "_inited", false);

          _defineProperty(this, "_scrollView", null);

          _defineProperty(this, "_itemSize", new Size(0, 0));

          _defineProperty(this, "_midBoundingBox", rect(0, 0, 0, 0));

          _defineProperty(this, "_itemOffsetArr", []);

          _defineProperty(this, "_isScrolling", false);

          _defineProperty(this, "_delayCount", 0);
        }

        /**
         * @description: 初始化该组件，请选择合适的时间点去触发，如果不手动调用，则默认在该组件onLoad阶段去初始化
         */
        init() {
          this._inited = true; // 获取该节点上的scrollView组件

          this._scrollView = this.getComponent(ScrollView); // 获取item节点的size

          this._itemSize = new Size(this.scrollItem.data.getComponent(UITransform).width, this.scrollItem.data.getComponent(UITransform).height); // 设置content节点上的layout属性，并且计算包围盒的大小及位置
          // paddingTop等参数为留白部分，大小为该节点的一半高减去item的一半高，如此可以使得滑到第一个item时正好在正中间显示

          const layout = this.content.getComponent(Layout);
          const uiTransform = this.getComponent(UITransform);

          if (this._scrollView.vertical) {
            layout.type = Layout.Type.VERTICAL;
            layout.paddingTop = (uiTransform.contentSize.height - this._itemSize.height) / 2;
            layout.paddingBottom = layout.paddingTop;
            this._midBoundingBox = rect(-uiTransform.contentSize.width / 2, -this._itemSize.height / 2, uiTransform.contentSize.width, this._itemSize.height);
          } else {
            layout.type = Layout.Type.HORIZONTAL;
            layout.paddingLeft = (uiTransform.contentSize.width - this._itemSize.width) / 2;
            layout.paddingRight = layout.paddingLeft;
            this._midBoundingBox = rect(-this._itemSize.width / 2, -uiTransform.height / 2, this._itemSize.width, uiTransform.height);
          } // 更新每个item离scrollView左上角原点的偏移位置，如果是垂直排列则取y坐标，如果是横列则去x坐标


          this.updateItemOffset(); // 稍稍延迟一会，等待layout生效后更新视图

          this._delayCount++;
          this.scheduleOnce(() => {
            this._delayCount--;
            this.selectNearlyItem(true);
            this.updateScrollingView();
          }, 0.05); // 注册事件

          this.regEvents();
        }

        onLoad() {
          if (!this._inited) {
            this.init();
          }
        }

        onDestroy() {
          // 注销事件
          this.unregEvents();
        }

        updateItemOffset() {
          this._itemOffsetArr = [];
          const layout = this.content.getComponent(Layout);
          const spacing = layout.type === Layout.Type.VERTICAL ? layout.spacingY : layout.spacingX;
          const size = this._scrollView.vertical ? this._itemSize.height : this._itemSize.width;
          let offset = 0;

          for (let i = 0, len = this.content.children.length; i < len; i++) {
            offset += i === 0 ? 0 : spacing + size;

            this._itemOffsetArr.push(offset);
          } // console.log('itemOffsetArr: ', this._itemOffsetArr);

        }

        updateScrollingView() {
          for (let i = 0, len = this.content.children.length; i < len; i++) {
            const itemNode = this.content.children[i];
            const itemPos = itemNode.getPosition();
            let offset = this.getOffset(itemNode);
            let scale = this.getScale(itemNode);

            if (this._scrollView.vertical) {
              itemPos.x = offset;
              itemNode.setPosition(itemPos);
            } else {
              itemPos.y = offset;
              itemNode.setPosition(itemPos);
            }

            itemNode.setScale(v3(scale, scale, 1));
          }
        }

        getOffset(itemNode) {
          const layout = this.content.getComponent(Layout);
          const viewPos = this.getPositionInView(itemNode);
          let mag = 0; // item距离中心位置处的距离倍率，中间的为0，以此类推

          if (this._scrollView.vertical) {
            const spacing = layout.spacingY;
            const size = this._itemSize.height;
            mag = Math.abs(viewPos.y / (spacing + size));
          } else {
            const spacing = layout.spacingX;
            const size = this._itemSize.width;
            mag = Math.abs(viewPos.x / (spacing + size));
          }

          if (this.offsetType === OFFSET_TYPE.NONE) {
            return 0;
          } else if (this.offsetType === OFFSET_TYPE.EQUAL) {
            // 这里用绝对值是因为存在负数的情况，不用绝对值会引起大小判断错误
            let offset = Math.abs(mag * this.offsetValue) >= Math.abs(this.offsetValue) ? this.offsetValue : mag * this.offsetValue;
            return offset;
          } else if (this.offsetType === OFFSET_TYPE.GRADUALLY) {
            let offset = mag * this.offsetValue;
            return offset;
          }
        }

        getPositionInView(item) {
          const itemPos = item.getPosition();
          const worldPos = item.parent.getComponent(UITransform).convertToWorldSpaceAR(itemPos);
          return this.node.getComponent(UITransform).convertToNodeSpaceAR(worldPos);
        }

        getScale(itemNode) {
          const layout = this.content.getComponent(Layout);
          const viewPos = this.getPositionInView(itemNode);
          let mag = 0; // item距离中心位置处的距离倍率，中间的为0，以此类推

          if (this._scrollView.vertical) {
            const spacing = layout.spacingY;
            const size = this._itemSize.height;
            mag = Math.abs(viewPos.y / (spacing + size));
          } else {
            const spacing = layout.spacingX;
            const size = this._itemSize.width;
            mag = Math.abs(viewPos.x / (spacing + size));
          }

          if (this.scaleType === SCALE_TYPE.NONE) {
            return 1;
          } else if (this.scaleType === SCALE_TYPE.EQUAL) {
            let scale = 1 - mag * this.scaleValue <= 1 - this.scaleValue ? 1 - this.scaleValue : 1 - mag * this.scaleValue;
            return scale;
          } else if (this.scaleType === SCALE_TYPE.GRADUALLY) {
            let scale = 1 - mag * this.scaleValue <= 0.1 ? 0.1 : 1 - mag * this.scaleValue;
            return scale;
          }
        }

        regEvents() {
          this.node.on("scroll-began", this.scrollBegan, this);
          this.node.on("scrolling", this.updateScrollingView, this);
          this.node.on("scroll-ended", this.scrollEnded, this);
          this.content.on("child-added", this.childAdded, this);
          this.content.on("child-removed", this.childRemoved, this);
        }

        unregEvents() {
          this.node.off("scroll-began", this.scrollBegan, this);
          this.node.off("scrolling", this.updateScrollingView, this);
          this.node.off("scroll-ended", this.scrollEnded, this);
          this.content.off("child-added", this.childAdded, this);
          this.content.off("child-removed", this.childRemoved, this);
        }

        scrollBegan() {
          if (this._isScrolling) {
            return;
          }

          this._isScrolling = true;
        }

        scrollEnded() {
          // 如果不是玩家操作的，那么就不能进入该回调，以免引起死循环
          if (!this._isScrolling) {
            return;
          }

          this._isScrolling = false;
          this.selectNearlyItem();
        }

        selectNearlyItem(immediately = false) {
          const moveTime = immediately ? 0 : MOVE_TIME;

          if (this._scrollView.vertical) {
            const layout = this.content.getComponent(Layout);
            const spacing = layout.spacingY;
            const size = this._itemSize.height;
            const scrollOffsetY = Math.abs(this._scrollView.getScrollOffset().y);
            let offset = (spacing + size) / 2;

            for (let i = 0, len = this.content.children.length; i < len; i++) {
              if (scrollOffsetY < offset) {
                let p = v3(0, this._itemOffsetArr[i], 0);

                this._scrollView.scrollToOffset(p, moveTime);

                return;
              }

              offset += spacing + size;
            }
          } else {
            const layout = this.content.getComponent(Layout);
            const spacing = layout.spacingX;
            const size = this._itemSize.width;
            const scrollOffsetX = Math.abs(this._scrollView.getScrollOffset().x);
            let offset = (spacing + size) / 2;

            for (let i = 0, len = this.content.children.length; i < len; i++) {
              if (scrollOffsetX < offset) {
                let p = v3(this._itemOffsetArr[i], 0, 0);

                this._scrollView.scrollToOffset(p, moveTime);

                return;
              }

              offset += spacing + size;
            }
          }
        }

        childAdded() {
          this._delayCount++;
          this.updateItemOffset();
          this.scheduleOnce(() => {
            this._delayCount--;
            this.selectNearlyItem(true);
            this.updateScrollingView();
          }, 0.05);
        }

        childRemoved() {
          this._delayCount++;
          this.updateItemOffset();
          this.scheduleOnce(() => {
            this._delayCount--;
            this.selectNearlyItem(true);
            this.updateScrollingView();
          }, 0.05);
        }
        /**
         * @description: 移动到指定的item
         * @param {number} index
         */


        scrollTo(index) {
          if (index < 0 || index >= this.content.children.length) {
            return;
          } // 如果正好在动态增删节点，那么需要等待节点增删完毕，等待0.5s使得layout生效后再去移动


          if (this._delayCount > 0) {
            this.scheduleOnce(() => {
              if (this._scrollView.vertical) {
                let p = v3(0, this._itemOffsetArr[index], 0);

                this._scrollView.scrollToOffset(p, MOVE_TIME);
              } else {
                let p = v3(this._itemOffsetArr[index], 0, 0);

                this._scrollView.scrollToOffset(p, MOVE_TIME);
              }
            }, 0.05);
          } else {
            if (this._scrollView.vertical) {
              let p = v3(0, this._itemOffsetArr[index], 0);

              this._scrollView.scrollToOffset(p, MOVE_TIME);
            } else {
              let p = v3(this._itemOffsetArr[index], 0, 0);

              this._scrollView.scrollToOffset(p, MOVE_TIME);
            }
          }
        }

      }, _temp), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "content", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "scrollItem", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "offsetType", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return OFFSET_TYPE.NONE;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "offsetValue", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return 0.0;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "scaleType", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return SCALE_TYPE.NONE;
        }
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "scaleValue", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function () {
          return 0.0;
        }
      })), _class2)) || _class) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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