import * as cc from "cc";

const {
    ccclass,
    property
} = cc._decorator;
@ccclass
export default class extends cc.Component {

    @property(cc.ProgressBar)
    loadingBar = null;

    @property(cc.Label)
    loadingProgress_lb = null;

    @property(cc.Label)
    status_lb = null;

    _loadkey = 0;
    _progress = 0;

    currentProgress = 0;
    maxProgress = 0;

    onLoad() {
        this._loadingList = ['Test_1', 'Test_2', 'Test_3', 'Test_4', 'Test_5', 'Test_6'];
    }

    start() {
        this.onLoadNext();
    }

    update(dt) {
        //缓动动画
        if (this.maxProgress > this.currentProgress) {
            this.currentProgress += this.maxProgress / 50;
            if (this.currentProgress > 1) this.currentProgress = 1;
            this.loadingBar.progress = this.currentProgress;
            let newText = Math.floor(this.currentProgress * 100) + '%';
            if (newText != this.loadingProgress_lb.string)
                this.loadingProgress_lb.string = newText;
        }
    }

    //开始缓冲资源
    startPreloading(dir) {
        let self = this;
        if (dir instanceof Array) {
            cc.resources.load(dir, cc.SpriteAtlas, function (completedCount, totalCount, item) {
                if (self._isLoading) {
                    self._progress = completedCount / totalCount;
                    if (isNaN(self._progress)) {
                        self._progress = 1;
                    }
                }
            }, function (err, assets, urls) {
                for (let i = 0; i < assets.length; i++) {
                    let as = assets[i];
                    if (as instanceof cc.SpriteFrame) {
                        // gameData.addImageframeToImagesMap(as);
                    }
                    if (as instanceof cc.SpriteAtlas) {
                        // gameData.addAtlasToImagesMap(as);
                    }
                }
                self.onLoadNext();
            });
            return;
        }

        cc.resources.loadDir(dir, function (completedCount, totalCount, item) {
            if (self._isLoading) {
                self._progress = completedCount / totalCount;
                if (isNaN(self._progress)) {
                    self._progress = 1;
                }
            }
        }, function (err, assets, urls) {
            for (let i = 0; i < assets.length; i++) {
                let as = assets[i];
                if (as instanceof cc.SpriteFrame) {
                    // gameData.addImageframeToImagesMap(as);
                }
                if (as instanceof cc.SpriteAtlas) {
                    // gameData.addAtlasToImagesMap(as);
                }
            }
            self.onLoadNext();
        });
    }

    onLoadNext() {
        if (this._loadkey >= this._loadingList.length) {
            this.onLoadComplete();
        } else {
            let dir = this._loadingList[this._loadkey];
            this.status_lb.string = dir;
            console.log('current->' + dir)

            this.startPreloading(dir);
        }

        this.maxProgress = this._loadkey / this._loadingList.length;
        this._loadkey++;
        if (Math.random() < 0.15) {
            this.loadingProgress_lb.string += '.';
        }
    }

    //全部完成
    onLoadComplete() {
        this.status_lb.string = 'done';
    }
}