/*
 * @Author       :
 * @Date         : 2025-06-19 14:22:07
 * @LastEditors  :
 * @LastEditTime : 2025-06-19 16:22:32
 * @Description  : file content
 */
const { ccclass, property } = cc._decorator;

@ccclass
export default class ArcProgress extends cc.Component {
    @property(cc.Color)
    public startColor: cc.Color = cc.Color.RED;

    @property(cc.Color)
    public endColor: cc.Color = cc.Color.GREEN;

    @property(cc.Float)
    public radius: number = 100;

    @property({
        type: cc.Float,
        displayName: "笔触宽度",
    })
    public thickness: number = 20;

    @property({ range: [0, 1], tooltip: "进度" })
    get progress() {
        return this._progress;
    }
    set progress(value: number) {
        this._progress = value;
        this.draw();
    }
    @property({ serializable: true })
    private _progress = 0.75;

    @property({ type: cc.Integer, displayName: "圆周总步进" })
    get totalSteps() {
        return this._totalSteps;
    }
    set totalSteps(value: number) {
        this._totalSteps = value;
    }
    @property({ serializable: true })
    private _totalSteps: number = 200;

    private _curStep: number = 0;
    private _isDrawing: boolean = false;
    private _innerGraphics: cc.Graphics = null;
    private _actualSteps: number = 0;

    public draw() {
        this._isDrawing = true;
        if (this.progress === 0) {
            this._isDrawing = false;
            return;
        }

        this._curStep = 0;

        if (!this._innerGraphics) {
            this._innerGraphics = this.getComponent(cc.Graphics);
        }
        this._innerGraphics.clear();

        // 实际步进
        this._actualSteps = Math.max(1, Math.ceil(this._totalSteps * this.progress));
    }

    protected onLoad(): void {
        this._innerGraphics = this.getComponent(cc.Graphics);
        this.draw();
    }

    protected update(dt: number): void {
        if (!this._isDrawing) {
            return;
        }

        if (this._curStep >= this._actualSteps) {
            this._isDrawing = false;
            return;
        }

        // 修正弧度
        const gapFix = this._innerGraphics.lineCap === cc.Graphics.LineCap.ROUND ? 0.0 : 0.01;

        const totalAngle = this.progress * 2 * Math.PI;

        const offset = Math.PI / 2;

        // 开始弧度
        const startRad = offset - (this._curStep / this._actualSteps) * totalAngle;

        // 结束弧度
        const endRad = offset - ((this._curStep + 1) / this._actualSteps) * totalAngle - gapFix;

        // 颜色插值
        const t = this._curStep / this._actualSteps;
        const color = cc.Color.lerp(new cc.Color(), this.startColor, this.endColor, t);

        // 绘制
        this._innerGraphics.strokeColor = color;
        this._innerGraphics.lineWidth = this.thickness;
        this._innerGraphics.arc(0, 0, this.radius, startRad, endRad, false);
        this._innerGraphics.stroke();

        ++this._curStep;
        cc.director.emit("event_arc_progress_change", this._curStep / this._totalSteps);
        // cc.log(this._curStep / this._totalSteps);
    }
}
