
import { _decorator, Component, Node, Mat4, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Tes')
export class Tes extends Component {
  @property(Node)
  public node2!: Node;

  start() {

    let worldPosition = this.node2.worldPosition;

    let _worldMatrix = new Mat4();
    let _mat4_temp = new Mat4();

    this.node.getWorldMatrix(_worldMatrix);
    Mat4.invert(_mat4_temp, _worldMatrix);

    let out = new Vec3();
    Vec3.transformMat4(out, worldPosition, _mat4_temp);

    console.log(out);
  }

}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
