import { SpriteFrame } from "cc";
import { gfx } from "cc";
import { director } from "cc";

export class GameTool{
        //获取SprieFrame像素
        public static readPixelsOffset(offsetX: number, offsetY: number, width: number, height: number, sp: SpriteFrame): Uint8Array {
            const texture = sp.texture;
            const gfxTexture = texture.getGFXTexture();
            const bufferViews = [];
            const region = new gfx.BufferTextureCopy();
            const buffer = new Uint8Array(width * height * 4);
            region.texOffset.x = offsetX;
            region.texOffset.y = offsetY;
            region.texExtent.width = width;
            region.texExtent.height = height;
            bufferViews.push(buffer);
            director.root.device.copyTextureToBuffers(gfxTexture, bufferViews, [region]);
            return bufferViews[0];
        }
}