import { _decorator, Component, ImageAsset, instantiate, Node, Sprite, Texture2D } from 'cc';
const { ccclass, property } = _decorator;
import { SpriteFrame } from "cc";
import { gfx } from "cc";
import { director } from "cc";

@ccclass('test')
export class test extends Component {

    @property(Sprite)
    srcSprite:Sprite = null;

    @property(Node)
    checkRoot:Node = null;

    //获取SprieFrame像素
    public readPixelsOffset(offsetX: number, offsetY: number, width: number, height: number, sp: SpriteFrame): Uint8Array {
        const texture = sp.texture;
        const gfxTexture = texture.getGFXTexture();
        const bufferViews = [];
        const region = new gfx.BufferTextureCopy();
        const buffer = new Uint8Array(width * height * 4);
        region.texOffset.x = offsetX;
        region.texOffset.y = offsetY;
        region.texExtent.width = width;
        region.texExtent.height = height;
        bufferViews.push(buffer);
        director.root.device.copyTextureToBuffers(gfxTexture, bufferViews, [region]);
        return bufferViews[0];
    }

    start() {
        for (let index = 0; index < this.checkRoot.children.length; index++) {
            let item = this.checkRoot.children[index];
            let d = this.readPixelsOffset(200,200, 100, 100, this.srcSprite.spriteFrame);
            let imgData = {
                _data: d,
                width: 100,
                height: 100,
                format: Texture2D.PixelFormat.RGBA8888,
                _compressed: false
            }
            let tx: Texture2D = new Texture2D();
            let imageAsset: ImageAsset = new ImageAsset();
            imageAsset.reset(imgData);
            tx.image = imageAsset;
            tx.setWrapMode(Texture2D.WrapMode.CLAMP_TO_EDGE, Texture2D.WrapMode.CLAMP_TO_EDGE, Texture2D.WrapMode.CLAMP_TO_EDGE);
            const sf = new SpriteFrame();
            sf.texture = tx;
            sf.packable = false;
            let _sprite = item.children[1].getComponent(Sprite);
            _sprite.spriteFrame = sf;
        }

    }

}

