// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Node)
    tiledMapNode: cc.Node = null;

    @property(cc.Node)
    roleNodes: cc.Node[] = [];
    private _tiledMap: cc.TiledMap;
    zawLayer: cc.TiledLayer;

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this._tiledMap = this.tiledMapNode!.getComponent(cc.TiledMap)
        //地图地块
        this.zawLayer = this._tiledMap!.getLayer('zaw')

        for (let index = 0; index < this.roleNodes.length; index++) {
            let role = this.roleNodes[index];
            role.removeFromParent()
            this.zawLayer.addUserNode(role)
        }
    }

    start () {

    }

    // update (dt) {}
}
