package plugin.ola.flutter_cc

import android.app.Activity
import android.app.Application
import android.content.ComponentCallbacks
import android.content.Context
import android.content.res.Configuration
import android.os.Bundle
import android.view.View
import com.cocos.lib.CocosActivityDelegate
import com.cocos.service.SDKWrapper
import io.flutter.plugin.common.BinaryMessenger
import io.flutter.plugin.common.MethodCall
import io.flutter.plugin.common.MethodChannel
import io.flutter.plugin.platform.PlatformView

class FlutterCcView(
    private val context: Context,
    private val id: Int,
    args: Any?,
    messenger: BinaryMessenger,
    activityProvider: ActivityProvider
) : PlatformView, MethodChannel.MethodCallHandler, Application.ActivityLifecycleCallbacks,
    ComponentCallbacks {
    private val methodChannel: MethodChannel =
        MethodChannel(messenger, "com.chenenyu/flutter_cc_$id")
    private var cocosDelegate: CocosActivityDelegate = CocosActivityDelegate(activityProvider.getActivity(),"aaa")

    companion object {
        private const val TAG: String = "FlutterCcView"
    }

    init {
        methodChannel.setMethodCallHandler(this)
        (context.applicationContext as Application).registerActivityLifecycleCallbacks(this)
        (context.applicationContext as Application).registerComponentCallbacks(this)
        cocosDelegate.onCreate(null)
    }

    override fun getView(): View {
        return cocosDelegate.rootView
    }

    override fun dispose() {
        methodChannel.setMethodCallHandler(null)
        (context.applicationContext as Application).unregisterActivityLifecycleCallbacks(this)
        (context.applicationContext as Application).unregisterComponentCallbacks(this)
        cocosDelegate.onDestroy() // todo
    }

    override fun onMethodCall(call: MethodCall, result: MethodChannel.Result) {
        TODO("Not yet implemented")
    }

    override fun onActivityCreated(activity: Activity, savedInstanceState: Bundle?) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onCreate(savedInstanceState)
        }
    }

    override fun onActivityStarted(activity: Activity) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onStart()
            SDKWrapper.shared().onStart()
        }
    }

    override fun onActivityResumed(activity: Activity) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onResume()
            SDKWrapper.shared().onResume()
        }
    }

    override fun onActivityPaused(activity: Activity) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onPause()
            SDKWrapper.shared().onPause()
        }
    }

    override fun onActivityStopped(activity: Activity) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onStop()
            SDKWrapper.shared().onStop()
        }
    }

    override fun onActivitySaveInstanceState(activity: Activity, outState: Bundle) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onResume()
            SDKWrapper.shared().onResume()
        }
    }

    override fun onActivityDestroyed(activity: Activity) {
        if (activity == cocosDelegate.activity) {
            cocosDelegate.onDestroy()
            SDKWrapper.shared().onDestroy()
        }
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        SDKWrapper.shared().onConfigurationChanged(newConfig)
    }

    override fun onLowMemory() {
        //cocosDelegate.onLowMemory()
        SDKWrapper.shared().onLowMemory()
    }

}