"use strict";
cc._RF.push(module, '7efb6eTKYFPsJL/BEsLOnBT', 'main');
// main.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    huabu: cc.Node,
    last: cc.Node,
    next: cc.Node,
    huabi: cc.Node,
    xiangpi: cc.Node,
    par: cc.Node,
    mask: cc.Node,
    graphics: cc.Graphics
  },
  onLoad: function onLoad() {
    this.xian = this.graphics;
    this.curmask = this.mask;
    this.xianNode = this.mask.getChildByName("graphics");
    this.maskArr = [];
    this.maskArr.push(this.mask);
    this.allxianArr = [];
    this.curxianArr = [];
    this.hyArr = [];
  },
  start: function start() {
    var _this = this;

    this.huabi.on("touchstart", this.huabiClick, this);
    this.xiangpi.on("touchstart", this.xiangpiClick, this);
    this.next.on("touchstart", this.recoverClick, this);
    this.last.on("touchstart", this.backspaceClick, this);
    this.node.getChildByName("color1").on("touchstart", function () {
      _this.xian.strokeColor = "#FFE600";
    }, this);
    this.node.getChildByName("color2").on("touchstart", function () {
      _this.xian.strokeColor = "#0FFF00";
    }, this);
  },
  huabiClick: function huabiClick() {
    this.drawType = "hua";
    this.huabu.on("mousedown", this.onMouseDown, this);
    this.huabu.on("mouseup", this.onMouseUp, this);
    this.xian.strokeColor = "#000000";

    if (this.isca) {
      var mask = cc.instantiate(this.mask);
      this.par.addChild(mask);
      this.xian = mask.getChildByName("graphics").getComponent(cc.Graphics);
      this.maskArr.push(mask);
      this.curmask = mask;
      this.isca = false;
    }
  },
  xiangpiClick: function xiangpiClick() {
    this.drawType = "ca";
    this.huabu.on("mousedown", this.onMouseDown, this);
    this.huabu.on("mouseup", this.onMouseUp, this);
  },
  onMouseDown: function onMouseDown(event) {
    console.log("按下");
    this.isDrawing = true;
    var pos = event.getLocation();

    if (this.drawType == "hua") {
      pos = this.xianNode.convertToNodeSpaceAR(pos);
    }

    this.huabu.on("mousemove", this.onMouseMove, this);
    this.curxianArr = [];
    this.curDrowdata = {};
    this.curDrowdata.start = {};
    this.curDrowdata.end = {};
    this.curDrowdata.start.x = pos.x;
    this.curDrowdata.start.y = pos.y;

    if (this.drawType == "ca") {
      this.caFun(pos);
    }
  },
  onMouseMove: function onMouseMove(event) {
    console.log("移动");

    if (this.isDrawing) {
      var pos = event.getLocation();

      if (this.drawType == "hua") {
        pos = this.xianNode.convertToNodeSpaceAR(pos); //画当前的线

        this.xian.lineWidth = 100;
        this.xian.moveTo(this.curDrowdata.start.x, this.curDrowdata.start.y);
        this.xian.lineTo(pos.x, pos.y);
        this.xian.stroke(); //记录当前终点

        this.curDrowdata.end.x = pos.x;
        this.curDrowdata.end.y = pos.y;
        this.curDrowdata.color = this.xian.strokeColor;
        this.curDrowdata.xian = this.xian; //存储此次画线

        this.curxianArr.push(this.curDrowdata); //重置，记录下次的起点

        this.curDrowdata = {};
        this.curDrowdata.start = {};
        this.curDrowdata.end = {};
        this.curDrowdata.start.x = pos.x;
        this.curDrowdata.start.y = pos.y;
      }

      if (this.drawType == "ca") {
        this.caFun(pos);
      }
    }
  },
  onMouseUp: function onMouseUp(event) {
    console.log("松手");
    this.isDrawing = false;
    this.huabu.off("mousemove", this.onMouseMove, this);
    this.allxianArr.push(this.curxianArr);
    console.log(this.allxianArr);
  },
  caFun: function caFun(pos) {
    this.isca = true;
    pos = this.mask.convertToNodeSpaceAR(pos);

    for (var i = 0; i < this.maskArr.length; i++) {
      this.maskArr[i].getComponent(cc.Mask)['_graphics'].circle(pos.x, pos.y, 50);
      this.maskArr[i].getComponent(cc.Mask)['_graphics'].fill();
    }

    this.curDrowdata = {};
    this.curDrowdata.pos = pos;
    this.curDrowdata.xpc = true;
    this.curDrowdata.mask = this.curmask;
    this.curxianArr.push(this.curDrowdata);
  },
  backspaceClick: function backspaceClick() {
    var _this2 = this;

    console.log("回退");
    if (this.allxianArr.length == 0) return;
    this.hyArr.push(this.allxianArr.pop());
    var color = this.xian.strokeColor; //清除所有绘画

    this.maskArr.forEach(function (mask) {
      mask.getComponent(cc.Mask)['_graphics'].clear();
      mask.children[0].getComponent(cc.Graphics).clear();
    }); //重新绘制剩下的

    this.allxianArr.forEach(function (arr1) {
      if (arr1) {
        arr1.forEach(function (data) {
          if (!data.xpc) {
            _this2.xian.strokeColor = data.color;
            data.xian.moveTo(data.start.x, data.start.y);
            data.xian.lineTo(data.end.x, data.end.y);
            data.xian.stroke();
          } else {
            data.mask.getComponent(cc.Mask)['_graphics'].circle(data.pos.x, data.pos.y, 50);
            data.mask.getComponent(cc.Mask)['_graphics'].fill();
          }
        });
      }
    });
    this.xian.strokeColor = color;
  },
  recoverClick: function recoverClick() {
    var _this3 = this;

    console.log("还原");
    if (this.hyArr.length == 0) return;
    var needdrawData = this.hyArr.pop();
    this.allxianArr.push(needdrawData);
    var color = this.xian.strokeColor;
    needdrawData.forEach(function (data) {
      if (data) {
        if (!data.xpc) {
          _this3.xian.strokeColor = data.color;

          _this3.xian.moveTo(data.start.x, data.start.y);

          _this3.xian.lineTo(data.end.x, data.end.y);

          _this3.xian.stroke();
        } else {
          data.mask.getComponent(cc.Mask)['_graphics'].circle(data.pos.x, data.pos.y, 50);
          data.mask.getComponent(cc.Mask)['_graphics'].fill();
        }
      }
    });
    this.xian.strokeColor = color;
  } // update (dt) {},

});

cc._RF.pop();