
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/main');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/main.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '7efb6eTKYFPsJL/BEsLOnBT', 'main');
// main.js

"use strict";

cc.Class({
  "extends": cc.Component,
  properties: {
    huabu: cc.Node,
    last: cc.Node,
    next: cc.Node,
    huabi: cc.Node,
    xiangpi: cc.Node,
    par: cc.Node,
    mask: cc.Node,
    graphics: cc.Graphics
  },
  onLoad: function onLoad() {
    this.xian = this.graphics;
    this.curmask = this.mask;
    this.xianNode = this.mask.getChildByName("graphics");
    this.maskArr = [];
    this.maskArr.push(this.mask);
    this.allxianArr = [];
    this.curxianArr = [];
    this.hyArr = [];
  },
  start: function start() {
    var _this = this;

    this.huabi.on("touchstart", this.huabiClick, this);
    this.xiangpi.on("touchstart", this.xiangpiClick, this);
    this.next.on("touchstart", this.recoverClick, this);
    this.last.on("touchstart", this.backspaceClick, this);
    this.node.getChildByName("color1").on("touchstart", function () {
      _this.xian.strokeColor = "#FFE600";
    }, this);
    this.node.getChildByName("color2").on("touchstart", function () {
      _this.xian.strokeColor = "#0FFF00";
    }, this);
  },
  huabiClick: function huabiClick() {
    this.drawType = "hua";
    this.huabu.on("mousedown", this.onMouseDown, this);
    this.huabu.on("mouseup", this.onMouseUp, this);
    this.xian.strokeColor = "#000000";

    if (this.isca) {
      var mask = cc.instantiate(this.mask);
      this.par.addChild(mask);
      this.xian = mask.getChildByName("graphics").getComponent(cc.Graphics);
      this.maskArr.push(mask);
      this.curmask = mask;
      this.isca = false;
    }
  },
  xiangpiClick: function xiangpiClick() {
    this.drawType = "ca";
    this.huabu.on("mousedown", this.onMouseDown, this);
    this.huabu.on("mouseup", this.onMouseUp, this);
  },
  onMouseDown: function onMouseDown(event) {
    console.log("按下");
    this.isDrawing = true;
    var pos = event.getLocation();

    if (this.drawType == "hua") {
      pos = this.xianNode.convertToNodeSpaceAR(pos);
    }

    this.huabu.on("mousemove", this.onMouseMove, this);
    this.curxianArr = [];
    this.curDrowdata = {};
    this.curDrowdata.start = {};
    this.curDrowdata.end = {};
    this.curDrowdata.start.x = pos.x;
    this.curDrowdata.start.y = pos.y;

    if (this.drawType == "ca") {
      this.caFun(pos);
    }
  },
  onMouseMove: function onMouseMove(event) {
    console.log("移动");

    if (this.isDrawing) {
      var pos = event.getLocation();

      if (this.drawType == "hua") {
        pos = this.xianNode.convertToNodeSpaceAR(pos); //画当前的线

        this.xian.lineWidth = 100;
        this.xian.moveTo(this.curDrowdata.start.x, this.curDrowdata.start.y);
        this.xian.lineTo(pos.x, pos.y);
        this.xian.stroke(); //记录当前终点

        this.curDrowdata.end.x = pos.x;
        this.curDrowdata.end.y = pos.y;
        this.curDrowdata.color = this.xian.strokeColor;
        this.curDrowdata.xian = this.xian; //存储此次画线

        this.curxianArr.push(this.curDrowdata); //重置，记录下次的起点

        this.curDrowdata = {};
        this.curDrowdata.start = {};
        this.curDrowdata.end = {};
        this.curDrowdata.start.x = pos.x;
        this.curDrowdata.start.y = pos.y;
      }

      if (this.drawType == "ca") {
        this.caFun(pos);
      }
    }
  },
  onMouseUp: function onMouseUp(event) {
    console.log("松手");
    this.isDrawing = false;
    this.huabu.off("mousemove", this.onMouseMove, this);
    this.allxianArr.push(this.curxianArr);
    console.log(this.allxianArr);
  },
  caFun: function caFun(pos) {
    this.isca = true;
    pos = this.mask.convertToNodeSpaceAR(pos);

    for (var i = 0; i < this.maskArr.length; i++) {
      this.maskArr[i].getComponent(cc.Mask)['_graphics'].circle(pos.x, pos.y, 50);
      this.maskArr[i].getComponent(cc.Mask)['_graphics'].fill();
    }

    this.curDrowdata = {};
    this.curDrowdata.pos = pos;
    this.curDrowdata.xpc = true;
    this.curDrowdata.mask = this.curmask;
    this.curxianArr.push(this.curDrowdata);
  },
  backspaceClick: function backspaceClick() {
    var _this2 = this;

    console.log("回退");
    if (this.allxianArr.length == 0) return;
    this.hyArr.push(this.allxianArr.pop());
    var color = this.xian.strokeColor; //清除所有绘画

    this.maskArr.forEach(function (mask) {
      mask.getComponent(cc.Mask)['_graphics'].clear();
      mask.children[0].getComponent(cc.Graphics).clear();
    }); //重新绘制剩下的

    this.allxianArr.forEach(function (arr1) {
      if (arr1) {
        arr1.forEach(function (data) {
          if (!data.xpc) {
            _this2.xian.strokeColor = data.color;
            data.xian.moveTo(data.start.x, data.start.y);
            data.xian.lineTo(data.end.x, data.end.y);
            data.xian.stroke();
          } else {
            data.mask.getComponent(cc.Mask)['_graphics'].circle(data.pos.x, data.pos.y, 50);
            data.mask.getComponent(cc.Mask)['_graphics'].fill();
          }
        });
      }
    });
    this.xian.strokeColor = color;
  },
  recoverClick: function recoverClick() {
    var _this3 = this;

    console.log("还原");
    if (this.hyArr.length == 0) return;
    var needdrawData = this.hyArr.pop();
    this.allxianArr.push(needdrawData);
    var color = this.xian.strokeColor;
    needdrawData.forEach(function (data) {
      if (data) {
        if (!data.xpc) {
          _this3.xian.strokeColor = data.color;

          _this3.xian.moveTo(data.start.x, data.start.y);

          _this3.xian.lineTo(data.end.x, data.end.y);

          _this3.xian.stroke();
        } else {
          data.mask.getComponent(cc.Mask)['_graphics'].circle(data.pos.x, data.pos.y, 50);
          data.mask.getComponent(cc.Mask)['_graphics'].fill();
        }
      }
    });
    this.xian.strokeColor = color;
  } // update (dt) {},

});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------
