
import { _decorator, Component, Node, CCObject, Slider, EditBox, Label, CCFloat } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = SilderScript
 * DateTime = Wed Aug 24 2022 13:33:24 GMT+0800 (中国标准时间)
 * Author = leehong
 * FileBasename = SilderScript.ts
 * FileBasenameNoExtension = SilderScript
 * URL = db://assets/Script/SilderScript.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('SilderScript')
export class SilderScript extends Component {

   

    @property(CCFloat)
    min:number = 0;

    @property(CCFloat)
    max:number = 1;

    @property(Label)
    lab:Label;
   
    @property(EditBox)
    box:EditBox;

    @property(Slider)
    silder:Slider;

    start()
    {
    }

    update()
    {
        this.box.string = (this.silder.progress * (this.max-this.min)+ this.min).toFixed(2);
    }

    public setTxt(str:string):void
    {
        this.lab.string = str;
    }

    public setMin(num:number):void
    {
        this.min = num;
    }

    public setMax(num:number):void
    {
        this.max = num;
    }

    public getValue():number
    {
        return Number.parseFloat(this.box.string)
    }

    public setValue(val:number)
    {
        this.silder.progress  = (val-this.min)/(this.max-this.min);
    }

}

