import { _decorator, Sprite, Component, macro, game, DynamicAtlasManager, EditBox, View, Game, director, profiler, AssetManager, assetManager, sys, setDisplayStats, native, Node, UIOpacity, tween, find } from 'cc';
import { ScreenShot } from './ScreenShot';

const { ccclass, property } = _decorator;

DynamicAtlasManager.instance.maxFrameSize = 1024;
macro.ENABLE_TRANSPARENT_CANVAS = false
macro.CLEANUP_IMAGE_CACHE = true;
DynamicAtlasManager.instance.enabled = false;

game.on(Game.EVENT_ENGINE_INITED, () => {
    EditBox.prototype.onDestroy = function () {
        if (this._impl) {
            View.instance.targetOff(this._impl);
            this._impl.clear();

        }
    }
})
@ccclass('Main')
export class Main extends Component {
    @property(Node)
    blend2: Node = null;
    @property(Node)
    blend: Node = null;
    @property(Node)
    blur: Node = null;
    @property(Node)
    water: Node = null;
    @property(Node)
    lab: Node = null;
    onEnable() {
        this.hideAll();
    }
    hideAll() {
        this.blend.active = false;
        this.blend2.active = false;

        this.blur.active = false;
        this.water.active = false;
        this.lab.active = false;
    }

    onBlend() {
        this.hideAll();
        this.blend.active = true;
    } 
    onBlend2() {
        this.hideAll();
        this.blend2.active = true;
    }
    onBlur() {
        this.hideAll();
        this.blur.active = true;
        const screenShot = find("Canvas").getComponent(ScreenShot);
        screenShot?.doShowBlur(this.blur);
    }
    onWater() {
        this.hideAll();
        this.water.active = true;
    }
    onLabel() {
        this.hideAll();
        this.lab.active = true;

    }
}
