
import {
    _decorator, Component, Node, Camera, RenderTexture, sys, UITransform,
    ImageAsset, Texture2D, SpriteFrame, Sprite, view, isValid, find, instantiate, Layers, UIRenderer, Material, builtinResMgr
} from 'cc';
import { PREVIEW } from 'cc/env';
// import { Canvas2Image } from './Canvas2Image';
const { ccclass, property } = _decorator;

@ccclass('ScreenShot')
export class ScreenShot extends Component {

    @property(Camera)
    mainCamera: Camera | null = null;
    @property(Node)
    copyCameraParent: Node | null = null;
    renderTex: RenderTexture;
    start() {
        this.renderTex = new RenderTexture();
        // find("Canvas").on("resize", () => {

        // })
        this.renderTex.reset({
            width: view.getVisibleSize().width,
            height: view.getVisibleSize().height
        });
        const copyCameraNode = instantiate(this.mainCamera.node);
        const copyCamera = copyCameraNode.getComponent(Camera);
        copyCamera.targetTexture = this.renderTex;
        copyCamera.priority = 0;
        //UNBLUR_LAYER 非虚化截屏层
        copyCamera.visibility = Layers.Enum.IGNORE_RAYCAST | Layers.Enum.UI_2D | Layers.Enum.DEFAULT;
        this.copyCameraParent.addChild(copyCameraNode);
    }
    doShowBlur(tagNode: Node) {
        this.capture(tagNode);
    }
    // 截图
    private capture(tagNode: Node) {
        if (PREVIEW && sys.isNative) {
            return;
        }
        if (!tagNode || !isValid(tagNode)) {
            return
        }
        const content = find("Canvas").getComponent(UITransform).contentSize;
        const width = content.width// view.getVisibleSize().width;
        const height = content.height// view.getVisibleSize().height;
        // const width = view.getVisibleSize().width;
        // const height = view.getVisibleSize().height;
        const buffer: Uint8Array = this.renderTex.readPixels(0, 0, width, height);
        const img = new ImageAsset();
        img.reset({
            _data: buffer,
            width: width,
            height: height,
            format: Texture2D.PixelFormat.RGBA8888,
            _compressed: false
        });
        const lastTexture2D = new Texture2D();
        lastTexture2D.image = img;
        this.setOneSprite(tagNode, lastTexture2D);

        lastTexture2D.addRef();
        lastTexture2D.decRef();
        img.addRef();
        img.decRef();

        // this.copyCamera.enabled = false;
    }


    private setOneSprite(tagNode: Node, texture: Texture2D) {
        if (!texture) {//顶号时会报错
            return;
        }
        const content = find("Canvas").getComponent(UITransform).contentSize;
        const width = content.width// view.getVisibleSize().width;
        const height = content.height// view.getVisibleSize().height;
        const sf = new SpriteFrame();
        sf.texture = texture;
        sf.packable = false;
        const tagNodeSp = tagNode.getComponent(Sprite);
        tagNodeSp.spriteFrame = sf;
        if (sys.isNative && sys.os === sys.OS.IOS) {
            tagNodeSp.spriteFrame.flipUVY = false;
        } else {
        tagNodeSp.spriteFrame.flipUVY = true;
        }
        tagNode.getComponent(UITransform).setContentSize(width, height);
        tagNode.layer = 33554432;

    }


}