
import { _decorator, Component, Node, sp, resources, TextAsset, Texture2D, ImageAsset, Event, UITransform, SpriteFrame, Sprite } from 'cc';
const { ccclass, type } = _decorator;

@ccclass('Begin')
export class Begin extends Component {
    @type(Node)
    container:Node = null!;

    skeletonData:sp.SkeletonData | null = null;
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start () {
        // resources.load('1149atk_atlas', TextAsset, (err, atlasAsset) => {
        //     resources.load('1149atk_json', TextAsset, (err, jsonStrAsset) => {
        //         resources.load('1149atk', ImageAsset, (err, texture) => {
        //             let atlas = atlasAsset.text;
        //             let json = JSON.parse(jsonStrAsset.text);
        //             let textures:ImageAsset[] = [texture];
        //             let textureNames:string[] = ['1149atk.png'];
        //             let sd = new sp.SkeletonData();
        //             sd.skeletonJson = json;
        //             sd.atlasText = atlas;
        //             sd.textures = textures;
        //             sd.textureNames = textureNames;
        //             this.skeleton.skeletonData = sd;
        //             this.skeleton.setAnimation(0, '1', true);
        //         });
        //     })
        // })

        // resources.load('1165atk', sp.SkeletonData, (err, skeletonData) => {
        //     this.skeleton.skeletonData = skeletonData;
        //     this.skeleton.setAnimation(0, '1', true);
        // });
    }

    onLoadClick(evt:Event, data:string) {
        resources.load('yutian', sp.SkeletonData, (err, skeletonData) => {
            this.skeletonData = skeletonData;
            let node = new Node();
            this.container.addChild(node);
            node.addComponent(UITransform);
            let skeleton = node.addComponent(sp.Skeleton);
            // skeleton.premultipliedAlpha = false;
            skeleton.skeletonData = skeletonData;
            skeleton.setAnimation(0, 'atk01', true);
        });
    }

    onReleaseClick(evt:Event, data:string) {
        resources.release('yutian', sp.SkeletonData);
        this.skeletonData = null;
        this.container.removeAllChildren();
    }

    onPicLoadClick(evt:Event, data:string) {
        resources.load('yutian/spriteFrame', SpriteFrame, (err, spriteFrame) => {
            let node = new Node();
            this.container.addChild(node);
            node.addComponent(UITransform);
            let sprite = node.addComponent(Sprite);
            // skeleton.premultipliedAlpha = false;
            sprite.spriteFrame = spriteFrame;
        });
    }

    onPicReleaseClick(evt:Event, data:string) {
        resources.release('yutian/spriteFrame', SpriteFrame);
        this.container.removeAllChildren();
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
