"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.onCreateNodeCreateMenu = onCreateNodeCreateMenu;
exports.onCreateNodeMenu = onCreateNodeMenu;
exports.onCreateRootMenu = onCreateRootMenu;
const fs_extra_1 = require("fs-extra");
const path_1 = __importStar(require("path"));
let selected_assetInfo;
async function onCreateNodeCreateMenu(assetInfo) {
    let menus = [];
    let config = await Editor.Profile.getConfig("node-library", "custom");
    if (config && config[0] && config[0].items?.length > 0) {
        let submenus = [];
        config[0].items.forEach(item => {
            submenus.push({
                label: item.name,
                click: async () => {
                    await Editor.Message.request('scene', 'create-node', {
                        parent: selected_assetInfo.uuid,
                        assetUuid: item.assetUuid,
                        unlinkPrefab: true,
                        type: "cc.Prefab"
                    });
                }
            });
        });
        menus.push({
            type: "submenu",
            label: '自定义预制体',
            submenu: submenus
        });
    }
    let prefabs = await Editor.Message.request('asset-db', 'query-assets', {
        ccType: 'cc.Prefab',
        pattern: `db://assets/templates/*`
    });
    if (prefabs.length > 0) {
        if (menus.length > 0)
            menus.push({ type: 'separator' });
        let prefabSubMenus = [];
        prefabs.forEach(prefab => {
            prefabSubMenus.push({
                label: prefab.name.replace(path_1.default.extname(prefab.name), ""),
                click: async () => {
                    if (selected_assetInfo.isPrefabRoot && prefab.uuid == selected_assetInfo.prefab.assetUuid) {
                        console.warn(`不可以在自身创建自己的预制体`);
                        return;
                    }
                    await Editor.Message.request('scene', 'create-node', {
                        parent: selected_assetInfo.uuid,
                        assetUuid: prefab.uuid,
                        unlinkPrefab: true,
                        type: "cc.Prefab"
                    });
                }
            });
        });
        menus.push(...prefabSubMenus);
    }

    return menus;
}
;
async function onCreateNodeMenu(assetInfo) {
    selected_assetInfo = assetInfo;
    let comp_menus = [];
    let prop_comp_menus = [];
    let hasButton = false;
    assetInfo.components.forEach(comp => {
        let type = comp.type.slice(0, 3) == "cc." ? comp.type.replace("cc.", "") : comp.type;
        comp.extends.forEach(subType => {
            if (subType.includes("Button")) {
                hasButton = true;
            }
        });
        if (type.includes("Button")) {
            hasButton = true;
        }

        prop_comp_menus.push({
            label: type,
            click: () => {
                Editor.Clipboard.write('text', `    @property({ type : ${type}, visible : true })
    protected _${lowerName} : ${type};
`);
                console.log(`已将组件 ${type} 绑定 ${assetInfo.name} 代码复制到剪切板。`);
            }
        });
    });
    let lowerName = assetInfo.name.charAt(0).toLowerCase() + assetInfo.name.slice(1);
    let prop_menus = [];

    prop_menus.push({
        label: '绑定节点',
        click: () => {
            Editor.Clipboard.write('text', `    @property({ type : Node, visible : true })
    protected _${lowerName}Node : Node;
`);
            console.log(`已将节点 ${assetInfo.name} 绑定代码复制到剪切板。`);
        }
    }, {
        type: 'submenu',
        label: '绑定组件',
        submenu: prop_comp_menus
    });

    let resultMenu = [
        {
            type: 'submenu',
            label: '🐧 属性绑定',
            submenu: prop_menus
        }];
    return resultMenu;
}
async function onCreateRootMenu(assetInfo) {
    selected_assetInfo = assetInfo;
    return [];
}
function camelCase(str, firstLowerCase = false) {
    let camelCaseRe = /_([a-z])/g;
    return (firstLowerCase ? str.substring(0, 1).toLowerCase() : str.substring(0, 1)) + str.substring(1).replace(camelCaseRe, function ($0, $1) { return $1.toUpperCase(); });
}
const allAssets = [];
const templateAssets = [];
function onEventAssetsUpdate() {
    allAssets.length = 0;
    Editor.Message.request('asset-db', 'query-assets', { ccType: ["cc.Prefab", "cc.SceneAsset"] }).then(assets => {
        allAssets.push(...assets);
        assets.forEach(assetInfo => {
            if (assetInfo.url.startsWith('db://assets/bundles/hall/assets/prefabs/common/templates/')) {
                templateAssets.push(assetInfo);
            }
        });
    });
}

function getNodeInfo(node, path) {
}
function findNodePath(assetObject, nodeId, result = "") {
    const nodeInfo = assetObject[nodeId];
    result = nodeInfo._name + (result.length > 0 ? ("/" + result) : "");
    if (nodeInfo['_parent']) {
        return findNodePath(assetObject, nodeInfo['_parent']['__id__']) + "/" + result;
    }
    return result;
}
function findNodePath2(assetObject, targetNodeInfo) {
    let result = targetNodeInfo['_name'];
    if (targetNodeInfo['_parent']) {
        return findNodePath(assetObject, targetNodeInfo['_parent']['__id__']) + "/" + result;
    }
    return result;
}
function checkObjectHasValue(object, value, cuuid) {
    const keys = Reflect.ownKeys(object);
    for (const key of keys) {
        if (object[key] instanceof Array)
            continue;
        if (object[key] instanceof Object) {
            const childObject = checkObjectHasValue(object[key], value, cuuid);
            if (childObject) {
                return {
                    obj: object,
                    key: key
                };
            }
        }
        else if (typeof (object[key]) == "string") {
            if (object[key] && (object[key].startsWith(value) || object[key].startsWith(cuuid))) {
                return {
                    obj: object,
                    key: key
                };
            }
        }
    }
}