import { resources } from "cc";
import { AudioChannel, ControllableAudioResource } from "./AudioChannel";


export class MixChannel<resource extends ControllableAudioResource> extends AudioChannel<resource>{
    protected audios: resource[] = [];
    protected _volume = 1;
    protected hangs: resource[] = [];
    
    get volume(){
        return this._volume;
    }
    set volume(n:number){
        let dr = (n - this._volume)/this._volume;
        for (let v of this.audios){
            let o = v.volume;
            //v.volume(o * dr, true);
            v.volume = o * dr;
        }
    }

    play(audio?: resource, volume?:number){
        if (!audio){
            if (this.hangs.length <= 0) return false;
            for (let v of this.hangs){
                v.play();
                this.audios.push(v);
            }
            this.hangs = [];
            return true;
        } 
        this.audios.push(audio);
        //audio.setVolume(volume ?? this._volume);
        audio.volume = volume ?? this._volume;
        audio.onEnded(this.onEnd.bind(this, audio));
        audio.play();
        return true;
    }

    playInstantly(audio: resource){
        this.clear();
        this.play(audio);
    }

    pause(){
        let r = this.audios.slice();
        for (let v of this.audios){
            v.pause();
            this.hangs.push(v);
        }
        this.audios = [];
        return r;
    }

    stop(){
        let r = this.audios.slice();
        for (let v of this.audios){
            v.stop();
            this.hangs.push(v);
        }
        this.audios = [];
        return r;
    }

    clear(){
        this.audios.forEach((v)=>{console.log('stop',v);v.stop()});
        this.hangs.forEach((v)=>{console.log('stop',v);v.stop()});
        let r = this.audios;
        this.audios = [];
        this.hangs = [];
        return r;
    }

    getCurrent(){
        return this.audios;
    }

    update(deltaTime:number){
    }

    onEnd(r:resource){
        let i = this.audios.indexOf(r);
        if (i>=0){
            this.audios.splice(i,1);
        }
    }
}