import { AudioController } from "../AudioController";
import { AudioChannel, ControllableAudioResource } from "./AudioChannel";



export class QueueChannel<resource extends ControllableAudioResource> extends AudioChannel<resource>{
    protected queue: resource[] = [];
    protected current: resource|null = null;
    protected _volume = 1;
    
    get volume(){
        return this._volume;
    }
    set volume(n:number){
        this._volume = n;
        // this.current?.setVolume(n, true);
        if (this.current) this.current.volume = n;
    }

    play(audio?: resource){
        if (audio){
            audio.onEnded(this.onEnd.bind(this));
            if (this.current){
                this.queue.push(audio);
                return false;
            }else{
                audio.volume = this._volume;
                audio.play();
                this.current = audio;
            }
        }else{
            if (this.current){
                this.current.play();
            }else{
                let a = this.queue.shift();
                if (a){
                    this.current = a;
                    // a.setVolume(this._volume);
                    a.volume = this._volume;
                    a.play();
                }
            }
        }
        return true;
    }

    playInstantly(audio: resource){
        // this.current?.stop();
        // this.queue = [];
        // audio.setVolume(this._volume);
        this.clear();
        // audio.volume = this._volume;
        // audio.onEnded(this.onEnd.bind(this));
        // audio.play();
        // this.current = audio;
        this.play(audio);
    }

    pause(){
        this.current?.pause();
        return this.current;
    }

    stop(){
        this.current?.stop();
        return this.current;
    }

    clear(){
        if (this.current){
            this.current.stop();
            this.queue.unshift(this.current);
        }
        let r = this.queue;
        this.queue = [];
        return r;
    }

    getCurrent(){
        return this.current;
    }

    update(deltaTime:number){
        return;
    //     if (this.current){
    //         if (this.current.currentTime >= this.current.duration){
    //             this.current = null;
    //             this.play();
    //         }
    //     }
    }

    onEnd(){
        if (this.current){
            this.current = null;
            this.play();
        }  
    }
}