
import { _decorator, Component, Node, Camera, RenderTexture, director, gfx, ImageAsset, renderer, view, Size, Texture2D, SpriteFrame, Sprite, UITransform, spriteAssembler, sys, Vec2, Canvas, warnID, log, error, Button, assetManager, instantiate, Vec3, Label } from 'cc';
import { Canvas2Image } from "./Canvas2Image";
const { ccclass, property } = _decorator;

@ccclass('Screenshot2D')
export class Screenshot2D extends Component {

    @property(Camera)
    copyCamera: Camera = null!;

    @property(Node)
    targetNode: Node = null!;
    @property(Node)
    copyNode: Node = null!;

    rt: RenderTexture = null;

    _canvas: HTMLCanvasElement = null!;

    _buffer: ArrayBufferView = null!;

    canvas2image: Canvas2Image = null!;

    start() {
        this.canvas2image = Canvas2Image.getInstance();
        this.rt = new RenderTexture();
        this.rt.reset({
            width: view.getVisibleSize().width,
            height: view.getVisibleSize().height,
        })
        this.copyCamera.targetTexture = this.rt;
        this.scheduleOnce(() => {
            // this.capture();
        }, 2)
    }

    capture(node: Node = null) {
        var width = (node ? node : this.targetNode).uiTransform.width;
        var height = (node ? node : this.targetNode).uiTransform.height;

        var worldPos = (node ? node : this.targetNode).position;
        this._buffer = this.rt.readPixels(Math.round(worldPos.x), Math.round(worldPos.y), width, height);
        this.showImage(width, height);
    }

    showImage(width, height) {
        let img = new ImageAsset();
        img.reset({
            _data: this._buffer,
            width: width,
            height: height,
            format: Texture2D.PixelFormat.RGBA8888,
            _compressed: false
        });
        let texture = new Texture2D();
        texture.image = img;
        let sf = new SpriteFrame();
        sf.texture = texture;
        sf.packable = false;
        this.copyNode!.getComponent(Sprite).spriteFrame = sf;
        this.copyNode!.getComponent(Sprite).spriteFrame.flipUVY = true;
        if (sys.isNative && (sys.os === sys.OS.IOS || sys.os === sys.OS.OSX)) {
            this.copyNode!.getComponent(Sprite).spriteFrame.flipUVY = false;
        }
        this.copyNode?.getComponent(UITransform)?.setContentSize(new Size(width, height));
    }
}