import { _decorator, Component, Prefab, instantiate, Node, CCInteger,Vec3,Label,log, Vec2,Sprite } from 'cc';
import { PlayerController } from './PlayerController'
import { platform } from './platform'
const { ccclass, property } = _decorator;


enum GameState{
    GS_INIT,
    GS_PLAYING,
    GS_END,
};
function randomNum(minNum:number, maxNum:number) {
    switch (arguments.length) {
        case 1:
            return parseInt(String(Math.random() * minNum + 1), 10)
            break
        case 2:
            return parseInt(String(Math.random() * (maxNum - minNum + 1)) + minNum, 10)
            break
        default:
            return 0
            break
    }
}
@ccclass("GameManager")
export class GameManager extends Component {

    // 赛道预制
    @property({type: Prefab})
    public platformPrfb: Prefab | null = null;
    // 相机
    @property({type: Node})
    public bg: Node | null = null;
    // 赛道长度
    @property
    public roadLength = 3;
    private _road = [];
    private initPos = 0

    @property({type: PlayerController})
    public playerCtrl: PlayerController | null = null;

    @property({type: Node})
    public startMenu: Node | null = null;

    @property({type: Label})
    public stepsLabel: Label | null = null;

    start () {
        this.generateRoad();
        this.playerCtrl?.node.on('JumpEnd', this.onPlayerJumpEnd, this);
        this.playerCtrl?.node.on('JumpFull', this.onPlayerJumpFull, this);
        this.playerCtrl.setInputActive(true);
        this.initPos = this.playerCtrl?.node.getPosition().y
    }
    generateRoad(){
        this._road = [];
        for (let i = 0; i < this.roadLength-1; i++) {
            let y = -200+370*i
            this._road.push(y)
        }
        for (let j = 0; j < this._road.length; j++) {
            let block: Node = this.spawnBlockByType();
            block.getComponent(platform).setSpeed(randomNum(10,20))
            if (block) {
                this.bg.addChild(block);
                block.setPosition(randomNum(-100,100), this._road[j], 0);
            }
            console.log(block.getPosition());
        }
    }
    spawnBlockByType() {
        let block = instantiate(this.platformPrfb);
        return block;
    }
    onPlayerJumpEnd(){
        console.log('跳跃结束');
    }
    onPlayerJumpFull(){
        console.log('掉落地面');
        // window.location.href = '../'
    }
    init() {

    }

    update (deltaTime: number) {
        let distance = Math.floor(this.playerCtrl?.node.getPosition().y-this.initPos)-500
        // console.log(this.bg.getPosition().y);
        if(distance>0)this.bg.setPosition(new Vec3(0,distance,0))

        // .updateRenderer()
        // this.node.children.forEach(item=>{
        //     if(item.getComponent(Sprite)?.updateRenderer){
        //         item.getComponent(Sprite)?.updateRenderer()
        //     }
        // })
        
        // if(distance>0){
        //     this.bg.setPosition(new Vec3(0,this.bg.getPosition().y+1,0))
        // }else if(distance<0){
        //     this.bg.setPosition(new Vec3(0,this.bg.getPosition().y-1,0))
        // }
        
    }
}