import { _decorator, Component, Node,RigidBody2D,Vec2,Collider2D,Contact2DType,IPhysics2DContact } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('platform')
export class platform extends Component {
    @property
    public initSpeed = 10

    start() {
        this.setSpeed(this.initSpeed)
        let collider = this.getComponent(Collider2D);
        if (collider) {
            collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
        }
    }
    onBeginContact (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体开始接触时被调用一次
        // console.log('onBeginContact');
        if(otherCollider.node.name==='wall2'){
            let rb = this.getComponent(RigidBody2D)
            rb.linearVelocity = new Vec2(-1*rb.linearVelocity.x,0)
        }
    }
    setSpeed(speed:number){
        let rb = this.getComponent(RigidBody2D)
        rb.enabledContactListener = true;
        rb.linearVelocity = new Vec2(speed,0)
    }

    update(deltaTime: number) {
        
    }
}

