System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, Collider2D, RigidBody2D, input, Input, log, Vec2, PhysicsSystem2D, PHYSICS_2D_PTM_RATIO, v2, _dec, _class, _crd, ccclass, property, jumpStatus, PlayerController;

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Collider2D = _cc.Collider2D;
      RigidBody2D = _cc.RigidBody2D;
      input = _cc.input;
      Input = _cc.Input;
      log = _cc.log;
      Vec2 = _cc.Vec2;
      PhysicsSystem2D = _cc.PhysicsSystem2D;
      PHYSICS_2D_PTM_RATIO = _cc.PHYSICS_2D_PTM_RATIO;
      v2 = _cc.v2;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "39486GYhLxMoIqs3xj5qsna", "PlayerController", undefined);

      __checkObsolete__(['_decorator', 'Component', 'Node', 'Collider2D', 'RigidBody2D', 'input', 'Input', 'EventMouse', 'log', 'Vec2', 'PhysicsSystem2D', 'PHYSICS_2D_PTM_RATIO', 'v2']);

      ({
        ccclass,
        property
      } = _decorator);
      PhysicsSystem2D.instance.gravity = v2(0, -60 * PHYSICS_2D_PTM_RATIO); // 跳跃状态

      (function (jumpStatus) {
        jumpStatus[jumpStatus["up"] = 0] = "up";
        jumpStatus[jumpStatus["down"] = 1] = "down";
        jumpStatus[jumpStatus["static"] = 2] = "static";
      })(jumpStatus || (jumpStatus = {}));

      ;

      _export("PlayerController", PlayerController = (_dec = ccclass('PlayerController'), _dec(_class = class PlayerController extends Component {
        constructor(...args) {
          super(...args);
          this._startJump = false;
        }

        start() {}

        update(deltaTime) {
          this.checkStatus();
        }

        setInputActive(active) {
          if (active) {
            input.on(Input.EventType.MOUSE_UP, this.onMouseUp, this);
          } else {
            input.off(Input.EventType.MOUSE_UP, this.onMouseUp, this);
          }
        }

        onMouseUp(event) {
          if (event.getButton() === 0) {
            this.jump();
          }
        }

        jump() {
          if (this._startJump) return;
          this._startJump = true;
          log('jump');
          let rb = this.getComponent(RigidBody2D);
          rb.applyForceToCenter(new Vec2(0, 900 * PHYSICS_2D_PTM_RATIO), true);
        }

        checkStatus() {
          let rb = this.getComponent(RigidBody2D);
          let lv = rb.linearVelocity;
          if (lv.y > 0) this._jumpStatus = jumpStatus.up;
          if (lv.y < 0) this._jumpStatus = jumpStatus.down;
          if (lv.y === 0) this._jumpStatus = jumpStatus.static;
        }

        set _jumpStatus(value) {
          switch (value) {
            case jumpStatus.up:
              // 更改穿透属性
              this.getComponent(Collider2D).sensor = true;
              this.getComponent(Collider2D).apply();
              break;

            case jumpStatus.down:
              // 更改穿透属性
              this.getComponent(Collider2D).sensor = false;
              this.getComponent(Collider2D).apply();
              break;

            case jumpStatus.static:
              this.node.emit('JumpEnd');
              break;
          }
        }

      }) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=6b333745d845f32f34352b2a78d55e982786e0df.js.map