System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, Collider2D, RigidBody2D, input, Input, log, Vec2, PhysicsSystem2D, PHYSICS_2D_PTM_RATIO, v2, Contact2DType, _dec, _class, _crd, ccclass, property, jumpStatus, PlayerController;

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Collider2D = _cc.Collider2D;
      RigidBody2D = _cc.RigidBody2D;
      input = _cc.input;
      Input = _cc.Input;
      log = _cc.log;
      Vec2 = _cc.Vec2;
      PhysicsSystem2D = _cc.PhysicsSystem2D;
      PHYSICS_2D_PTM_RATIO = _cc.PHYSICS_2D_PTM_RATIO;
      v2 = _cc.v2;
      Contact2DType = _cc.Contact2DType;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "39486GYhLxMoIqs3xj5qsna", "PlayerController", undefined);

      __checkObsolete__(['_decorator', 'Component', 'Node', 'Collider2D', 'RigidBody2D', 'input', 'Input', 'EventMouse', 'log', 'Vec2', 'PhysicsSystem2D', 'PHYSICS_2D_PTM_RATIO', 'v2', 'Contact2DType', 'IPhysics2DContact']);

      ({
        ccclass,
        property
      } = _decorator);
      PhysicsSystem2D.instance.gravity = v2(0, -60 * PHYSICS_2D_PTM_RATIO); // 跳跃状态

      (function (jumpStatus) {
        jumpStatus[jumpStatus["up"] = 0] = "up";
        jumpStatus[jumpStatus["down"] = 1] = "down";
        jumpStatus[jumpStatus["static"] = 2] = "static";
      })(jumpStatus || (jumpStatus = {}));

      ;

      _export("PlayerController", PlayerController = (_dec = ccclass('PlayerController'), _dec(_class = class PlayerController extends Component {
        constructor(...args) {
          super(...args);
          this._startJump = false;
        }

        start() {
          this.getComponent(RigidBody2D).enabledContactListener = true; // 注册单个碰撞体的回调函数

          let collider = this.getComponent(Collider2D);

          if (collider) {
            collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this); // collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
            // collider.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
            // collider.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
          } // 注册全局碰撞回调函数
          // if (PhysicsSystem2D.instance) {
          //     PhysicsSystem2D.instance.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
          //     PhysicsSystem2D.instance.on(Contact2DType.END_CONTACT, this.onEndContact, this);
          //     PhysicsSystem2D.instance.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
          //     PhysicsSystem2D.instance.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
          // }

        }

        onBeginContact(selfCollider, otherCollider, contact) {
          // 只在两个碰撞体开始接触时被调用一次
          console.log('onBeginContact');
        }

        onEndContact(selfCollider, otherCollider, contact) {
          // 只在两个碰撞体结束接触时被调用一次
          console.log('onEndContact');
        }

        onPreSolve(selfCollider, otherCollider, contact) {
          // 每次将要处理碰撞体接触逻辑时被调用
          console.log('onPreSolve');
        }

        onPostSolve(selfCollider, otherCollider, contact) {
          // 每次处理完碰撞体接触逻辑时被调用
          console.log('onPostSolve');
        }

        update(deltaTime) {
          this.checkStatus();
        }

        setInputActive(active) {
          if (active) {
            input.on(Input.EventType.MOUSE_UP, this.onMouseUp, this);
          } else {
            input.off(Input.EventType.MOUSE_UP, this.onMouseUp, this);
          }
        }

        onMouseUp(event) {
          if (event.getButton() === 0) {
            this.jump();
          }
        }

        jump() {
          if (this._startJump) return;
          this._startJump = true;
          log('jump');
          let rb = this.getComponent(RigidBody2D);
          rb.applyForceToCenter(new Vec2(0, 900 * PHYSICS_2D_PTM_RATIO), true);
        }

        checkStatus() {
          let rb = this.getComponent(RigidBody2D);
          let lv = rb.linearVelocity;

          if (Math.abs(lv.y) < 0.1) {
            this._jumpStatus = jumpStatus.static;
          } else if (lv.y > 0) {
            this._jumpStatus = jumpStatus.up;
          } else if (lv.y < 0) {
            this._jumpStatus = jumpStatus.down;
          } // this.node.emit('JumpEnd');

        }

        set _jumpStatus(value) {
          switch (value) {
            case jumpStatus.up:
              // 更改穿透属性
              this.getComponent(Collider2D).sensor = true;
              this.getComponent(Collider2D).apply();
              break;

            case jumpStatus.down:
              // 更改穿透属性
              this.getComponent(Collider2D).sensor = false;
              this.getComponent(Collider2D).apply();
              break;

            case jumpStatus.static:
              this._startJump = false;
              break;
          }
        }

      }) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=75cdc0e763ffe492eeb6806272a032fe7c716219.js.map